/*!
 * @TMBFedEx.m
 *
 * Execute Choreographies from the Temboo FedEx bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import "TMBFedEx.h"
#import "TMBChoreography_Protected.h"
#import "TMBChoreographyExecution.h"
#import "TMBTembooSession.h"
#import "TMBTembooUri.h"


/*!
 * Input object with appropriate setters for specifying arguments to the ServiceAvailability Choreo.
 */
@implementation TMBFedEx_Availability_ServiceAvailability_Inputs

	/*!
	 * Set the value of the AccountNumber input for this Choreo.
	*(required, string) Your FedEx Account Number or Test Account Number.
	 */
	-(void)setAccountNumber:(NSString*)AccountNumber {
		[super setInput:@"AccountNumber" toValue:AccountNumber];
	}

	/*!
	 * Set the value of the AuthenticationKey input for this Choreo.
	*(required, string) The Production Authentication Key or Development Test Key provided by FedEx Web Services.
	 */
	-(void)setAuthenticationKey:(NSString*)AuthenticationKey {
		[super setInput:@"AuthenticationKey" toValue:AuthenticationKey];
	}

	/*!
	 * Set the value of the DestinationCountryCode input for this Choreo.
	*(required, string) The destination country code to use for the service availability request (e.g., US).
	 */
	-(void)setDestinationCountryCode:(NSString*)DestinationCountryCode {
		[super setInput:@"DestinationCountryCode" toValue:DestinationCountryCode];
	}

	/*!
	 * Set the value of the DestinationPostalCode input for this Choreo.
	*(required, string) The destination postal code to use for  the service availability request.
	 */
	-(void)setDestinationPostalCode:(NSString*)DestinationPostalCode {
		[super setInput:@"DestinationPostalCode" toValue:DestinationPostalCode];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) Set to "test" to direct requests to the FedEx test environment. Defaults to "production" indicating that requests are sent to the production URL.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MeterNumber input for this Choreo.
	*(required, string) The Production or Test Meter Number provided by FedEx Web Services.
	 */
	-(void)setMeterNumber:(NSString*)MeterNumber {
		[super setInput:@"MeterNumber" toValue:MeterNumber];
	}

	/*!
	 * Set the value of the OriginCountryCode input for this Choreo.
	*(required, string) The origin country code to use for the service availability request (e.g., US).
	 */
	-(void)setOriginCountryCode:(NSString*)OriginCountryCode {
		[super setInput:@"OriginCountryCode" toValue:OriginCountryCode];
	}

	/*!
	 * Set the value of the OriginPostalCode input for this Choreo.
	*(required, string) The origin postal code to use for the service availability request.
	 */
	-(void)setOriginPostalCode:(NSString*)OriginPostalCode {
		[super setInput:@"OriginPostalCode" toValue:OriginPostalCode];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(required, password) The Production or Test Password provided by FedEx Web Services.
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the ShipDate input for this Choreo.
	*(optional, date) The date to use for the service availability request. Dates should be formatted as YYYY-MM-DD. Defautls to today's date.
	 */
	-(void)setShipDate:(NSString*)ShipDate {
		[super setInput:@"ShipDate" toValue:ShipDate];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ServiceAvailability Choreo.
 */
@implementation TMBFedEx_Availability_ServiceAvailability_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from FedEx.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves available shipping options and delivery dates for a specified origin and destination.
 */
@implementation TMBFedEx_Availability_ServiceAvailability

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBFedEx_Availability_ServiceAvailability Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/FedEx/Availability/ServiceAvailability"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBFedEx_Availability_ServiceAvailability_ResultSet *results = [[TMBFedEx_Availability_ServiceAvailability_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ServiceAvailability Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBFedEx_Availability_ServiceAvailability_Inputs*)newInputSet {
		return [[TMBFedEx_Availability_ServiceAvailability_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the PostalCodeInquiry Choreo.
 */
@implementation TMBFedEx_CountryService_PostalCodeInquiry_Inputs

	/*!
	 * Set the value of the AccountNumber input for this Choreo.
	*(required, string) Your FedEx Account Number or Test Account Number.
	 */
	-(void)setAccountNumber:(NSString*)AccountNumber {
		[super setInput:@"AccountNumber" toValue:AccountNumber];
	}

	/*!
	 * Set the value of the AuthenticationKey input for this Choreo.
	*(required, string) The Production Authentication Key or Development Test Key provided by FedEx Web Services.
	 */
	-(void)setAuthenticationKey:(NSString*)AuthenticationKey {
		[super setInput:@"AuthenticationKey" toValue:AuthenticationKey];
	}

	/*!
	 * Set the value of the CountryCode input for this Choreo.
	*(required, string) The country code to use in the inquiry request (e.g., US).
	 */
	-(void)setCountryCode:(NSString*)CountryCode {
		[super setInput:@"CountryCode" toValue:CountryCode];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) Set to "test" to direct requests to the FedEx test environment. Defaults to "production" indicating that requests are sent to the production URL.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MeterNumber input for this Choreo.
	*(required, string) The Production or Test Meter Number provided by FedEx Web Services.
	 */
	-(void)setMeterNumber:(NSString*)MeterNumber {
		[super setInput:@"MeterNumber" toValue:MeterNumber];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(required, password) The Production or Test Password provided by FedEx Web Services.
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the PostalCode input for this Choreo.
	*(required, string) The postal code to use in the inquiry request.
	 */
	-(void)setPostalCode:(NSString*)PostalCode {
		[super setInput:@"PostalCode" toValue:PostalCode];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the ShipDate input for this Choreo.
	*(optional, string) The ship date to use for the inquiry. Dates should be formatted as YYYY-MM-DD. Defautls to today's date.
	 */
	-(void)setShipDate:(NSString*)ShipDate {
		[super setInput:@"ShipDate" toValue:ShipDate];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the PostalCodeInquiry Choreo.
 */
@implementation TMBFedEx_CountryService_PostalCodeInquiry_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from FedEx.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves location information from FedEx Web Services for a specified postal code.
 */
@implementation TMBFedEx_CountryService_PostalCodeInquiry

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBFedEx_CountryService_PostalCodeInquiry Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/FedEx/CountryService/PostalCodeInquiry"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBFedEx_CountryService_PostalCodeInquiry_ResultSet *results = [[TMBFedEx_CountryService_PostalCodeInquiry_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the PostalCodeInquiry Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBFedEx_CountryService_PostalCodeInquiry_Inputs*)newInputSet {
		return [[TMBFedEx_CountryService_PostalCodeInquiry_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the SearchLocationsByAddress Choreo.
 */
@implementation TMBFedEx_Locations_SearchLocationsByAddress_Inputs

	/*!
	 * Set the value of the AccountNumber input for this Choreo.
	*(required, string) Your FedEx Account Number or Test Account Number.
	 */
	-(void)setAccountNumber:(NSString*)AccountNumber {
		[super setInput:@"AccountNumber" toValue:AccountNumber];
	}

	/*!
	 * Set the value of the AuthenticationKey input for this Choreo.
	*(required, string) The Production Authentication Key or Development Test Key provided by FedEx Web Services.
	 */
	-(void)setAuthenticationKey:(NSString*)AuthenticationKey {
		[super setInput:@"AuthenticationKey" toValue:AuthenticationKey];
	}

	/*!
	 * Set the value of the City input for this Choreo.
	*(required, string) The city associated with the location being searched.
	 */
	-(void)setCity:(NSString*)City {
		[super setInput:@"City" toValue:City];
	}

	/*!
	 * Set the value of the CountryCode input for this Choreo.
	*(required, string) The country code associated with the location being searched (e.g., US).
	 */
	-(void)setCountryCode:(NSString*)CountryCode {
		[super setInput:@"CountryCode" toValue:CountryCode];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) Set to "test" to direct requests to the FedEx test environment. Defaults to "production" indicating that requests are sent to the production URL.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MeterNumber input for this Choreo.
	*(required, string) The Production or Test Meter Number provided by FedEx Web Services.
	 */
	-(void)setMeterNumber:(NSString*)MeterNumber {
		[super setInput:@"MeterNumber" toValue:MeterNumber];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(required, password) The Production or Test Password provided by FedEx Web Services.
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the PostalCode input for this Choreo.
	*(required, string) The postal code associated with the location being searched.
	 */
	-(void)setPostalCode:(NSString*)PostalCode {
		[super setInput:@"PostalCode" toValue:PostalCode];
	}

	/*!
	 * Set the value of the RadiusDistance input for this Choreo.
	*(optional, decimal) Specifies value of the radius around the address to search for FedEx locations. Note that RadiusUnits applies to this value. Defaults to 10 miles.
	 */
	-(void)setRadiusDistance:(NSString*)RadiusDistance {
		[super setInput:@"RadiusDistance" toValue:RadiusDistance];
	}

	/*!
	 * Set the value of the RadiusUnits input for this Choreo.
	*(optional, string) Specifies the unit of measure for the RadiusDistance value. Valid values are mi (the default) and km.
	 */
	-(void)setRadiusUnits:(NSString*)RadiusUnits {
		[super setInput:@"RadiusUnits" toValue:RadiusUnits];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SortBy input for this Choreo.
	*(optional, string) Specifies the criterion to be used to sort the location details. Valid values are: distance (the default), latest_express_dropoff_time, latest_ground_dropoff_time, location_type.
	 */
	-(void)setSortBy:(NSString*)SortBy {
		[super setInput:@"SortBy" toValue:SortBy];
	}

	/*!
	 * Set the value of the SortOrder input for this Choreo.
	*(optional, string) Specifies sort order of the location details. Valid values are: lowest_to_highest (the default) and highest_to_lowest.
	 */
	-(void)setSortOrder:(NSString*)SortOrder {
		[super setInput:@"SortOrder" toValue:SortOrder];
	}

	/*!
	 * Set the value of the State input for this Choreo.
	*(required, string) Identifying abbreviation for US state, Canada province (e.g., NY).
	 */
	-(void)setState:(NSString*)State {
		[super setInput:@"State" toValue:State];
	}

	/*!
	 * Set the value of the Street input for this Choreo.
	*(required, string) The street number and street name (e.g., 350 5th Ave).
	 */
	-(void)setStreet:(NSString*)Street {
		[super setInput:@"Street" toValue:Street];
	}

	/*!
	 * Set the value of the SupportedServices input for this Choreo.
	*(optional, string) Specifies the types of services supported by a FedEx location for redirect to hold. Valid values are: fedex_express, fedex_ground, fedex_ground_home_delivery.
	 */
	-(void)setSupportedServices:(NSString*)SupportedServices {
		[super setInput:@"SupportedServices" toValue:SupportedServices];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SearchLocationsByAddress Choreo.
 */
@implementation TMBFedEx_Locations_SearchLocationsByAddress_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from FedEx.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Searches for FedEx locations near a given address.
 */
@implementation TMBFedEx_Locations_SearchLocationsByAddress

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBFedEx_Locations_SearchLocationsByAddress Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/FedEx/Locations/SearchLocationsByAddress"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBFedEx_Locations_SearchLocationsByAddress_ResultSet *results = [[TMBFedEx_Locations_SearchLocationsByAddress_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the SearchLocationsByAddress Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBFedEx_Locations_SearchLocationsByAddress_Inputs*)newInputSet {
		return [[TMBFedEx_Locations_SearchLocationsByAddress_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the TrackByNumber Choreo.
 */
@implementation TMBFedEx_TrackingAndVisibility_TrackByNumber_Inputs

	/*!
	 * Set the value of the AccountNumber input for this Choreo.
	*(required, string) Your FedEx Account Number or Test Account Number.
	 */
	-(void)setAccountNumber:(NSString*)AccountNumber {
		[super setInput:@"AccountNumber" toValue:AccountNumber];
	}

	/*!
	 * Set the value of the AuthenticationKey input for this Choreo.
	*(required, string) The Production Authentication Key or Development Test Key provided by FedEx Web Services.
	 */
	-(void)setAuthenticationKey:(NSString*)AuthenticationKey {
		[super setInput:@"AuthenticationKey" toValue:AuthenticationKey];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) Set to "test" to direct requests to the FedEx test environment. Defaults to "production" indicating that requests are sent to the production URL.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MeterNumber input for this Choreo.
	*(required, string) The Production or Test Meter Number provided by FedEx Web Services.
	 */
	-(void)setMeterNumber:(NSString*)MeterNumber {
		[super setInput:@"MeterNumber" toValue:MeterNumber];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(required, password) The Production or Test Password provided by FedEx Web Services.
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the TrackingNumber input for this Choreo.
	*(required, string) The tracking number for the shipment.
	 */
	-(void)setTrackingNumber:(NSString*)TrackingNumber {
		[super setInput:@"TrackingNumber" toValue:TrackingNumber];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the TrackByNumber Choreo.
 */
@implementation TMBFedEx_TrackingAndVisibility_TrackByNumber_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from FedEx.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves shipment information for a specified tracking number.
 */
@implementation TMBFedEx_TrackingAndVisibility_TrackByNumber

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBFedEx_TrackingAndVisibility_TrackByNumber Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/FedEx/TrackingAndVisibility/TrackByNumber"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBFedEx_TrackingAndVisibility_TrackByNumber_ResultSet *results = [[TMBFedEx_TrackingAndVisibility_TrackByNumber_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the TrackByNumber Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBFedEx_TrackingAndVisibility_TrackByNumber_Inputs*)newInputSet {
		return [[TMBFedEx_TrackingAndVisibility_TrackByNumber_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the TrackByReference Choreo.
 */
@implementation TMBFedEx_TrackingAndVisibility_TrackByReference_Inputs

	/*!
	 * Set the value of the AccountNumber input for this Choreo.
	*(required, string) Your FedEx Account Number or Test Account Number.
	 */
	-(void)setAccountNumber:(NSString*)AccountNumber {
		[super setInput:@"AccountNumber" toValue:AccountNumber];
	}

	/*!
	 * Set the value of the AuthenticationKey input for this Choreo.
	*(required, string) The Production Authentication Key or Development Test Key provided by FedEx Web Services.
	 */
	-(void)setAuthenticationKey:(NSString*)AuthenticationKey {
		[super setInput:@"AuthenticationKey" toValue:AuthenticationKey];
	}

	/*!
	 * Set the value of the City input for this Choreo.
	*(optional, string) The destination city.
	 */
	-(void)setCity:(NSString*)City {
		[super setInput:@"City" toValue:City];
	}

	/*!
	 * Set the value of the CountryCode input for this Choreo.
	*(conditional, string) The country code associated with the shipment destination (e.g., US). Required unless specifying the ShipmentAccountNumber.
	 */
	-(void)setCountryCode:(NSString*)CountryCode {
		[super setInput:@"CountryCode" toValue:CountryCode];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) Set to "test" to direct requests to the FedEx test environment. Defaults to "production" indicating that requests are sent to the production URL.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MeterNumber input for this Choreo.
	*(required, string) The Production or Test Meter Number provided by FedEx Web Services.
	 */
	-(void)setMeterNumber:(NSString*)MeterNumber {
		[super setInput:@"MeterNumber" toValue:MeterNumber];
	}

	/*!
	 * Set the value of the OperatingCompany input for this Choreo.
	*(required, string) Identification for a fedex operating company (e.g.,  fedex_express, fedex_freight, fedex_ground). See Choreo notes for allowed values.
	 */
	-(void)setOperatingCompany:(NSString*)OperatingCompany {
		[super setInput:@"OperatingCompany" toValue:OperatingCompany];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(required, password) The Production or Test Password provided by FedEx Web Services.
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the PostalCode input for this Choreo.
	*(conditional, string) The postal code associated with the shipment destination. Required unless specifying the ShipmentAccountNumber.
	 */
	-(void)setPostalCode:(NSString*)PostalCode {
		[super setInput:@"PostalCode" toValue:PostalCode];
	}

	/*!
	 * Set the value of the Reference input for this Choreo.
	*(required, string) A reference number for tracking the shipment.
	 */
	-(void)setReference:(NSString*)Reference {
		[super setInput:@"Reference" toValue:Reference];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the ShipDateRangeBegin input for this Choreo.
	*(optional, date) Specifies the beginning of a date range used to narrow the search to a period in time. Dates should be formatted as YYYY-MM-DD.
	 */
	-(void)setShipDateRangeBegin:(NSString*)ShipDateRangeBegin {
		[super setInput:@"ShipDateRangeBegin" toValue:ShipDateRangeBegin];
	}

	/*!
	 * Set the value of the ShipDateRangeEnd input for this Choreo.
	*(optional, date) Specifies the beginning of a date range used to narrow the search to a period in time. Dates should be formatted as YYYY-MM-DD.
	 */
	-(void)setShipDateRangeEnd:(NSString*)ShipDateRangeEnd {
		[super setInput:@"ShipDateRangeEnd" toValue:ShipDateRangeEnd];
	}

	/*!
	 * Set the value of the ShipmentAccountNumber input for this Choreo.
	*(conditional, string) The shipment account number. Required unless specifying the PostalCode and CountryCode.
	 */
	-(void)setShipmentAccountNumber:(NSString*)ShipmentAccountNumber {
		[super setInput:@"ShipmentAccountNumber" toValue:ShipmentAccountNumber];
	}

	/*!
	 * Set the value of the State input for this Choreo.
	*(optional, string) Identifying abbreviation for US state, Canada province of the shipment destination (e.g., NY).
	 */
	-(void)setState:(NSString*)State {
		[super setInput:@"State" toValue:State];
	}

	/*!
	 * Set the value of the Street input for this Choreo.
	*(optional, string) The street number and street name for the shipment destination (e.g., 350 5th Ave).
	 */
	-(void)setStreet:(NSString*)Street {
		[super setInput:@"Street" toValue:Street];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the TrackByReference Choreo.
 */
@implementation TMBFedEx_TrackingAndVisibility_TrackByReference_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from FedEx.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves shipment information for a specified reference number.
 */
@implementation TMBFedEx_TrackingAndVisibility_TrackByReference

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBFedEx_TrackingAndVisibility_TrackByReference Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/FedEx/TrackingAndVisibility/TrackByReference"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBFedEx_TrackingAndVisibility_TrackByReference_ResultSet *results = [[TMBFedEx_TrackingAndVisibility_TrackByReference_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the TrackByReference Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBFedEx_TrackingAndVisibility_TrackByReference_Inputs*)newInputSet {
		return [[TMBFedEx_TrackingAndVisibility_TrackByReference_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AddressValidation Choreo.
 */
@implementation TMBFedEx_Validation_AddressValidation_Inputs

	/*!
	 * Set the value of the AccountNumber input for this Choreo.
	*(required, string) Your FedEx Account Number or Test Account Number.
	 */
	-(void)setAccountNumber:(NSString*)AccountNumber {
		[super setInput:@"AccountNumber" toValue:AccountNumber];
	}

	/*!
	 * Set the value of the AuthenticationKey input for this Choreo.
	*(required, string) The Production Authentication Key or Development Test Key provided by FedEx Web Services.
	 */
	-(void)setAuthenticationKey:(NSString*)AuthenticationKey {
		[super setInput:@"AuthenticationKey" toValue:AuthenticationKey];
	}

	/*!
	 * Set the value of the City input for this Choreo.
	*(conditional, string) The name of the city or town.
	 */
	-(void)setCity:(NSString*)City {
		[super setInput:@"City" toValue:City];
	}

	/*!
	 * Set the value of the ClientReferenceID input for this Choreo.
	*(optional, string) A reference id provided by the client.
	 */
	-(void)setClientReferenceID:(NSString*)ClientReferenceID {
		[super setInput:@"ClientReferenceID" toValue:ClientReferenceID];
	}

	/*!
	 * Set the value of the CompanyName input for this Choreo.
	*(optional, string) Identifies the company associated with the location.
	 */
	-(void)setCompanyName:(NSString*)CompanyName {
		[super setInput:@"CompanyName" toValue:CompanyName];
	}

	/*!
	 * Set the value of the CountryCode input for this Choreo.
	*(conditional, string) The country code associated with the address being validated (e.g., US).
	 */
	-(void)setCountryCode:(NSString*)CountryCode {
		[super setInput:@"CountryCode" toValue:CountryCode];
	}

	/*!
	 * Set the value of the Endpoint input for this Choreo.
	*(conditional, string) Set to "test" to direct requests to the FedEx test environment. Defaults to "production" indicating that requests are sent to the production URL.
	 */
	-(void)setEndpoint:(NSString*)Endpoint {
		[super setInput:@"Endpoint" toValue:Endpoint];
	}

	/*!
	 * Set the value of the MeterNumber input for this Choreo.
	*(required, string) The Production or Test Meter Number provided by FedEx Web Services.
	 */
	-(void)setMeterNumber:(NSString*)MeterNumber {
		[super setInput:@"MeterNumber" toValue:MeterNumber];
	}

	/*!
	 * Set the value of the Password input for this Choreo.
	*(required, password) The Production or Test Password provided by FedEx Web Services.
	 */
	-(void)setPassword:(NSString*)Password {
		[super setInput:@"Password" toValue:Password];
	}

	/*!
	 * Set the value of the PhoneNumber input for this Choreo.
	*(optional, string) Identifies the phone number associated with the contact being validated.
	 */
	-(void)setPhoneNumber:(NSString*)PhoneNumber {
		[super setInput:@"PhoneNumber" toValue:PhoneNumber];
	}

	/*!
	 * Set the value of the PostalCode input for this Choreo.
	*(conditional, string) The postal code associated with the address being validated.
	 */
	-(void)setPostalCode:(NSString*)PostalCode {
		[super setInput:@"PostalCode" toValue:PostalCode];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the State input for this Choreo.
	*(conditional, string) Identifying abbreviation for US state, Canada province (e.g., NY).
	 */
	-(void)setState:(NSString*)State {
		[super setInput:@"State" toValue:State];
	}

	/*!
	 * Set the value of the Street input for this Choreo.
	*(conditional, string) The street number and street name (e.g., 350 5th Ave).
	 */
	-(void)setStreet:(NSString*)Street {
		[super setInput:@"Street" toValue:Street];
	}

	/*!
	 * Set the value of the UrbanizationCode input for this Choreo.
	*(optional, string) Relevant only to addresses in Puerto Rico.
	 */
	-(void)setUrbanizationCode:(NSString*)UrbanizationCode {
		[super setInput:@"UrbanizationCode" toValue:UrbanizationCode];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddressValidation Choreo.
 */
@implementation TMBFedEx_Validation_AddressValidation_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from FedEx.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Validates a given address.
 */
@implementation TMBFedEx_Validation_AddressValidation

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBFedEx_Validation_AddressValidation Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/FedEx/Validation/AddressValidation"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBFedEx_Validation_AddressValidation_ResultSet *results = [[TMBFedEx_Validation_AddressValidation_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AddressValidation Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBFedEx_Validation_AddressValidation_Inputs*)newInputSet {
		return [[TMBFedEx_Validation_AddressValidation_Inputs alloc] init];
	}
@end
	