/*!
 * @TMBDarkSky.m
 *
 * Execute Choreographies from the Temboo DarkSky bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import "TMBDarkSky.h"
#import "TMBChoreography_Protected.h"
#import "TMBChoreographyExecution.h"
#import "TMBTembooSession.h"
#import "TMBTembooUri.h"


/*!
 * Input object with appropriate setters for specifying arguments to the GetForecastByAddress Choreo.
 */
@implementation TMBDarkSky_GetForecastByAddress_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by Dark Sky.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the Address input for this Choreo.
	*(required, string) The address of the location.
	 */
	-(void)setAddress:(NSString*)Address {
		[super setInput:@"Address" toValue:Address];
	}

	/*!
	 * Set the value of the Exclude input for this Choreo.
	*(optional, string) Exclude some number of data blocks from the API response. Valid values are: currently, minutely, hourly, daily, alerts, and flags.
	 */
	-(void)setExclude:(NSString*)Exclude {
		[super setInput:@"Exclude" toValue:Exclude];
	}

	/*!
	 * Set the value of the Extend input for this Choreo.
	*(optional, string) When present, returns hour-by-hour data for the next 168 hours, instead of the next 48. Valid value: hourly.
	 */
	-(void)setExtend:(NSString*)Extend {
		[super setInput:@"Extend" toValue:Extend];
	}

	/*!
	 * Set the value of the GeocodingAPIKey input for this Choreo.
	*(required, string) Your Google Geocoding API Key.
	 */
	-(void)setGeocodingAPIKey:(NSString*)GeocodingAPIKey {
		[super setInput:@"GeocodingAPIKey" toValue:GeocodingAPIKey];
	}

	/*!
	 * Set the value of the Language input for this Choreo.
	*(optional, string) The language in which to return results e.g., es, fr, it, en (the default). See Choreo notes for a link to a full list of supported languages.
	 */
	-(void)setLanguage:(NSString*)Language {
		[super setInput:@"Language" toValue:Language];
	}

	/*!
	 * Set the value of the Units input for this Choreo.
	*(optional, string) Return weather conditions in the requested units. Valid values are: auto, ca, uk2, us (use for Farenheit), and si (use for Celsius).
	 */
	-(void)setUnits:(NSString*)Units {
		[super setInput:@"Units" toValue:Units];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetForecastByAddress Choreo.
 */
@implementation TMBDarkSky_GetForecastByAddress_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "HourlySummary" output from an execution of this Choreo.
	 * @return - NSString* (string) The hourly summary.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getHourlySummary {
		return [super getOutputByName:@"HourlySummary"];
	}

	/*!
	 * Retrieve the value of the "Humidity" output from an execution of this Choreo.
	 * @return - NSString* (decimal) The current humidity.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getHumidity {
		return [super getOutputByName:@"Humidity"];
	}

	/*!
	 * Retrieve the value of the "Pressure" output from an execution of this Choreo.
	 * @return - NSString* (decimal) The current pressure.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getPressure {
		return [super getOutputByName:@"Pressure"];
	}

	/*!
	 * Retrieve the value of the "Summary" output from an execution of this Choreo.
	 * @return - NSString* (string) The current weather summary.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getSummary {
		return [super getOutputByName:@"Summary"];
	}

	/*!
	 * Retrieve the value of the "Temperature" output from an execution of this Choreo.
	 * @return - NSString* (decimal) The current temperature.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getTemperature {
		return [super getOutputByName:@"Temperature"];
	}

	/*!
	 * Retrieve the value of the "UVIndex" output from an execution of this Choreo.
	 * @return - NSString* (integer) The current uv index.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getUVIndex {
		return [super getOutputByName:@"UVIndex"];
	}

	/*!
	 * Retrieve the value of the "Visibility" output from an execution of this Choreo.
	 * @return - NSString* (decimal) The current visibility.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getVisibility {
		return [super getOutputByName:@"Visibility"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Dark Sky.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns the current weather conditions for a specified location by address.
 */
@implementation TMBDarkSky_GetForecastByAddress

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBDarkSky_GetForecastByAddress Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/DarkSky/GetForecastByAddress"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBDarkSky_GetForecastByAddress_ResultSet *results = [[TMBDarkSky_GetForecastByAddress_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetForecastByAddress Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBDarkSky_GetForecastByAddress_Inputs*)newInputSet {
		return [[TMBDarkSky_GetForecastByAddress_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetForecastByCoordinates Choreo.
 */
@implementation TMBDarkSky_GetForecastByCoordinates_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by Dark Sky.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the Exclude input for this Choreo.
	*(optional, string) Exclude some number of data blocks from the API response. Valid values are: currently, minutely, hourly, daily, alerts, and flags.
	 */
	-(void)setExclude:(NSString*)Exclude {
		[super setInput:@"Exclude" toValue:Exclude];
	}

	/*!
	 * Set the value of the Extend input for this Choreo.
	*(optional, string) When present, returns hour-by-hour data for the next 168 hours, instead of the next 48. Valid value: hourly.
	 */
	-(void)setExtend:(NSString*)Extend {
		[super setInput:@"Extend" toValue:Extend];
	}

	/*!
	 * Set the value of the Language input for this Choreo.
	*(optional, string) The language in which to return results e.g., es, fr, it, en (the default). See Choreo notes for a link to a full list of supported languages.
	 */
	-(void)setLanguage:(NSString*)Language {
		[super setInput:@"Language" toValue:Language];
	}

	/*!
	 * Set the value of the Latitude input for this Choreo.
	*(required, decimal) The latitude of the location.
	 */
	-(void)setLatitude:(NSString*)Latitude {
		[super setInput:@"Latitude" toValue:Latitude];
	}

	/*!
	 * Set the value of the Longitude input for this Choreo.
	*(required, decimal) The longitude of the location.
	 */
	-(void)setLongitude:(NSString*)Longitude {
		[super setInput:@"Longitude" toValue:Longitude];
	}

	/*!
	 * Set the value of the Units input for this Choreo.
	*(optional, string) Return weather conditions in the requested units. Valid values are: auto, ca, uk2, us (use for Farenheit), and si (use for Celsius).
	 */
	-(void)setUnits:(NSString*)Units {
		[super setInput:@"Units" toValue:Units];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetForecastByCoordinates Choreo.
 */
@implementation TMBDarkSky_GetForecastByCoordinates_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "HourlySummary" output from an execution of this Choreo.
	 * @return - NSString* (string) The hourly summary.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getHourlySummary {
		return [super getOutputByName:@"HourlySummary"];
	}

	/*!
	 * Retrieve the value of the "Humidity" output from an execution of this Choreo.
	 * @return - NSString* (decimal) The current humidity.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getHumidity {
		return [super getOutputByName:@"Humidity"];
	}

	/*!
	 * Retrieve the value of the "Pressure" output from an execution of this Choreo.
	 * @return - NSString* (decimal) The current pressure.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getPressure {
		return [super getOutputByName:@"Pressure"];
	}

	/*!
	 * Retrieve the value of the "Summary" output from an execution of this Choreo.
	 * @return - NSString* (string) The current weather summary.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getSummary {
		return [super getOutputByName:@"Summary"];
	}

	/*!
	 * Retrieve the value of the "Temperature" output from an execution of this Choreo.
	 * @return - NSString* (decimal) The current temperature.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getTemperature {
		return [super getOutputByName:@"Temperature"];
	}

	/*!
	 * Retrieve the value of the "UVIndex" output from an execution of this Choreo.
	 * @return - NSString* (integer) The current uv index.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getUVIndex {
		return [super getOutputByName:@"UVIndex"];
	}

	/*!
	 * Retrieve the value of the "Visibility" output from an execution of this Choreo.
	 * @return - NSString* (decimal) The current visibility.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getVisibility {
		return [super getOutputByName:@"Visibility"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Dark Sky.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns the current weather conditions for a specified location by geo-coordinates.
 */
@implementation TMBDarkSky_GetForecastByCoordinates

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBDarkSky_GetForecastByCoordinates Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/DarkSky/GetForecastByCoordinates"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBDarkSky_GetForecastByCoordinates_ResultSet *results = [[TMBDarkSky_GetForecastByCoordinates_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetForecastByCoordinates Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBDarkSky_GetForecastByCoordinates_Inputs*)newInputSet {
		return [[TMBDarkSky_GetForecastByCoordinates_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the TimeMachineRequest Choreo.
 */
@implementation TMBDarkSky_TimeMachineRequest_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by Dark Sky.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the Exclude input for this Choreo.
	*(optional, string) Exclude some number of data blocks from the API response. Valid values are: currently, minutely, hourly, daily, alerts, and flags.
	 */
	-(void)setExclude:(NSString*)Exclude {
		[super setInput:@"Exclude" toValue:Exclude];
	}

	/*!
	 * Set the value of the Extend input for this Choreo.
	*(optional, string) When present, returns hour-by-hour data for the next 168 hours, instead of the next 48. Valid value: hourly.
	 */
	-(void)setExtend:(NSString*)Extend {
		[super setInput:@"Extend" toValue:Extend];
	}

	/*!
	 * Set the value of the Language input for this Choreo.
	*(optional, string) The language in which to return results e.g., es, fr, it, en (the default). See Choreo notes for a link to a full list of supported languages.
	 */
	-(void)setLanguage:(NSString*)Language {
		[super setInput:@"Language" toValue:Language];
	}

	/*!
	 * Set the value of the Latitude input for this Choreo.
	*(required, decimal) The latitude of the location.
	 */
	-(void)setLatitude:(NSString*)Latitude {
		[super setInput:@"Latitude" toValue:Latitude];
	}

	/*!
	 * Set the value of the Longitude input for this Choreo.
	*(required, decimal) The longitude of the location.
	 */
	-(void)setLongitude:(NSString*)Longitude {
		[super setInput:@"Longitude" toValue:Longitude];
	}

	/*!
	 * Set the value of the Time input for this Choreo.
	*(required, date) A UNIX timestamp (seconds since midnight GMT on 1 Jan 1970) or a string formatted date e.g., 2016-03-05T15:48:56Z.
	 */
	-(void)setTime:(NSString*)Time {
		[super setInput:@"Time" toValue:Time];
	}

	/*!
	 * Set the value of the Units input for this Choreo.
	*(optional, string) Return weather conditions in the requested units. Valid values are: auto, ca, uk2, us (use for Farenheit), and si (use for Celsius).
	 */
	-(void)setUnits:(NSString*)Units {
		[super setInput:@"Units" toValue:Units];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the TimeMachineRequest Choreo.
 */
@implementation TMBDarkSky_TimeMachineRequest_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "HourlySummary" output from an execution of this Choreo.
	 * @return - NSString* (string) The hourly summary.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getHourlySummary {
		return [super getOutputByName:@"HourlySummary"];
	}

	/*!
	 * Retrieve the value of the "Humidity" output from an execution of this Choreo.
	 * @return - NSString* (decimal) The current humidity.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getHumidity {
		return [super getOutputByName:@"Humidity"];
	}

	/*!
	 * Retrieve the value of the "Pressure" output from an execution of this Choreo.
	 * @return - NSString* (decimal) The current pressure.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getPressure {
		return [super getOutputByName:@"Pressure"];
	}

	/*!
	 * Retrieve the value of the "Summary" output from an execution of this Choreo.
	 * @return - NSString* (string) The current weather summary.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getSummary {
		return [super getOutputByName:@"Summary"];
	}

	/*!
	 * Retrieve the value of the "Temperature" output from an execution of this Choreo.
	 * @return - NSString* (decimal) The current temperature.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getTemperature {
		return [super getOutputByName:@"Temperature"];
	}

	/*!
	 * Retrieve the value of the "UVIndex" output from an execution of this Choreo.
	 * @return - NSString* (integer) The current uv index.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getUVIndex {
		return [super getOutputByName:@"UVIndex"];
	}

	/*!
	 * Retrieve the value of the "Visibility" output from an execution of this Choreo.
	 * @return - NSString* (decimal) The current visibility.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getVisibility {
		return [super getOutputByName:@"Visibility"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from Dark Sky.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns the observed (in the past) or forecasted (in the future) hour-by-hour weather and daily weather conditions for a particular date.
 */
@implementation TMBDarkSky_TimeMachineRequest

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBDarkSky_TimeMachineRequest Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/DarkSky/TimeMachineRequest"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBDarkSky_TimeMachineRequest_ResultSet *results = [[TMBDarkSky_TimeMachineRequest_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the TimeMachineRequest Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBDarkSky_TimeMachineRequest_Inputs*)newInputSet {
		return [[TMBDarkSky_TimeMachineRequest_Inputs alloc] init];
	}
@end
	