/*!
 * @TMBeBay.m
 *
 * Execute Choreographies from the Temboo eBay bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import "TMBeBay.h"
#import "TMBChoreography_Protected.h"
#import "TMBChoreographyExecution.h"
#import "TMBTembooSession.h"
#import "TMBTembooUri.h"


/*!
 * Input object with appropriate setters for specifying arguments to the FindCompletedItems Choreo.
 */
@implementation TMBeBay_Finding_FindCompletedItems_Inputs

	/*!
	 * Set the value of the FindCompletedItemsRequest input for this Choreo.
	*(optional, xml) The complete XML request body containing properties you wish to set. This can be used as an alternative to individual inputs that represent request properties.
	 */
	-(void)setFindCompletedItemsRequest:(NSString*)FindCompletedItemsRequest {
		[super setInput:@"FindCompletedItemsRequest" toValue:FindCompletedItemsRequest];
	}

	/*!
	 * Set the value of the AppID input for this Choreo.
	*(required, string) The unique identifier for the application.
	 */
	-(void)setAppID:(NSString*)AppID {
		[super setInput:@"AppID" toValue:AppID];
	}

	/*!
	 * Set the value of the AspectFilters input for this Choreo.
	*(optional, json) A dictionary of key/value pairs to use as aspect filters for the request.
	 */
	-(void)setAspectFilters:(NSString*)AspectFilters {
		[super setInput:@"AspectFilters" toValue:AspectFilters];
	}

	/*!
	 * Set the value of the CategoryID input for this Choreo.
	*(optional, string) Filters the results by category ID.
	 */
	-(void)setCategoryID:(NSString*)CategoryID {
		[super setInput:@"CategoryID" toValue:CategoryID];
	}

	/*!
	 * Set the value of the EntriesPerPage input for this Choreo.
	*(optional, integer) The maximum number of records to return in the result.
	 */
	-(void)setEntriesPerPage:(NSString*)EntriesPerPage {
		[super setInput:@"EntriesPerPage" toValue:EntriesPerPage];
	}

	/*!
	 * Set the value of the GlobalID input for this Choreo.
	*(optional, integer) The global ID of the eBay site to access (e.g., EBAY-US).
	 */
	-(void)setGlobalID:(NSString*)GlobalID {
		[super setInput:@"GlobalID" toValue:GlobalID];
	}

	/*!
	 * Set the value of the ItemFilters input for this Choreo.
	*(optional, json) A dictionary of key/value pairs to use as item filters for the request.
	 */
	-(void)setItemFilters:(NSString*)ItemFilters {
		[super setInput:@"ItemFilters" toValue:ItemFilters];
	}

	/*!
	 * Set the value of the Keywords input for this Choreo.
	*(conditional, string) Filters the results by one or more keywords.
	 */
	-(void)setKeywords:(NSString*)Keywords {
		[super setInput:@"Keywords" toValue:Keywords];
	}

	/*!
	 * Set the value of the OutputSelector input for this Choreo.
	*(optional, string) Controls the fields that are returned in the response (e.g., GalleryInfo).
	 */
	-(void)setOutputSelector:(NSString*)OutputSelector {
		[super setInput:@"OutputSelector" toValue:OutputSelector];
	}

	/*!
	 * Set the value of the PageNumber input for this Choreo.
	*(optional, integer) Specifies the page number of the results to return.
	 */
	-(void)setPageNumber:(NSString*)PageNumber {
		[super setInput:@"PageNumber" toValue:PageNumber];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SortOrder input for this Choreo.
	*(optional, string) Valid values: BestMatch, BidCountMost, CountryAscending, CountryDescending, DistanceNearest, CurrentPriceHighest, EndTimeSoonest, PricePlusShippingHighest, PricePlusShippingLowest, StartTimeNewest.
	 */
	-(void)setSortOrder:(NSString*)SortOrder {
		[super setInput:@"SortOrder" toValue:SortOrder];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FindCompletedItems Choreo.
 */
@implementation TMBeBay_Finding_FindCompletedItems_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves items whose listings are completed and are no longer available for sale on eBay.
 */
@implementation TMBeBay_Finding_FindCompletedItems

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Finding_FindCompletedItems Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Finding/FindCompletedItems"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Finding_FindCompletedItems_ResultSet *results = [[TMBeBay_Finding_FindCompletedItems_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the FindCompletedItems Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Finding_FindCompletedItems_Inputs*)newInputSet {
		return [[TMBeBay_Finding_FindCompletedItems_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the FindItemsAdvanced Choreo.
 */
@implementation TMBeBay_Finding_FindItemsAdvanced_Inputs

	/*!
	 * Set the value of the FindItemsAdvancedRequest input for this Choreo.
	*(optional, xml) The complete XML request body containing properties you wish to set. This can be used as an alternative to individual inputs that represent request properties.
	 */
	-(void)setFindItemsAdvancedRequest:(NSString*)FindItemsAdvancedRequest {
		[super setInput:@"FindItemsAdvancedRequest" toValue:FindItemsAdvancedRequest];
	}

	/*!
	 * Set the value of the AppID input for this Choreo.
	*(required, string) The unique identifier for the application.
	 */
	-(void)setAppID:(NSString*)AppID {
		[super setInput:@"AppID" toValue:AppID];
	}

	/*!
	 * Set the value of the AspectFilters input for this Choreo.
	*(optional, json) A dictionary of key/value pairs to use as aspect filters for the request.
	 */
	-(void)setAspectFilters:(NSString*)AspectFilters {
		[super setInput:@"AspectFilters" toValue:AspectFilters];
	}

	/*!
	 * Set the value of the CategoryID input for this Choreo.
	*(optional, string) Filters the results by category ID.
	 */
	-(void)setCategoryID:(NSString*)CategoryID {
		[super setInput:@"CategoryID" toValue:CategoryID];
	}

	/*!
	 * Set the value of the EntriesPerPage input for this Choreo.
	*(optional, integer) The maximum number of records to return in the result.
	 */
	-(void)setEntriesPerPage:(NSString*)EntriesPerPage {
		[super setInput:@"EntriesPerPage" toValue:EntriesPerPage];
	}

	/*!
	 * Set the value of the GlobalID input for this Choreo.
	*(optional, integer) The global ID of the eBay site to access (e.g., EBAY-US).
	 */
	-(void)setGlobalID:(NSString*)GlobalID {
		[super setInput:@"GlobalID" toValue:GlobalID];
	}

	/*!
	 * Set the value of the ItemFilters input for this Choreo.
	*(optional, json) A dictionary of key/value pairs to use as item filters for the request.
	 */
	-(void)setItemFilters:(NSString*)ItemFilters {
		[super setInput:@"ItemFilters" toValue:ItemFilters];
	}

	/*!
	 * Set the value of the Keywords input for this Choreo.
	*(conditional, string) Filters the results by one or more keywords.
	 */
	-(void)setKeywords:(NSString*)Keywords {
		[super setInput:@"Keywords" toValue:Keywords];
	}

	/*!
	 * Set the value of the OutputSelector input for this Choreo.
	*(optional, string) Controls the fields that are returned in the response (e.g., GalleryInfo).
	 */
	-(void)setOutputSelector:(NSString*)OutputSelector {
		[super setInput:@"OutputSelector" toValue:OutputSelector];
	}

	/*!
	 * Set the value of the PageNumber input for this Choreo.
	*(optional, integer) Specifies the page number of the results to return.
	 */
	-(void)setPageNumber:(NSString*)PageNumber {
		[super setInput:@"PageNumber" toValue:PageNumber];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SortOrder input for this Choreo.
	*(optional, string) Valid values: BestMatch, BidCountMost, CountryAscending, CountryDescending, DistanceNearest, CurrentPriceHighest, EndTimeSoonest, PricePlusShippingHighest, PricePlusShippingLowest, StartTimeNewest.
	 */
	-(void)setSortOrder:(NSString*)SortOrder {
		[super setInput:@"SortOrder" toValue:SortOrder];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FindItemsAdvanced Choreo.
 */
@implementation TMBeBay_Finding_FindItemsAdvanced_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Finds items by a keyword query and/or category and allows searching within item descriptions.
 */
@implementation TMBeBay_Finding_FindItemsAdvanced

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Finding_FindItemsAdvanced Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Finding/FindItemsAdvanced"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Finding_FindItemsAdvanced_ResultSet *results = [[TMBeBay_Finding_FindItemsAdvanced_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the FindItemsAdvanced Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Finding_FindItemsAdvanced_Inputs*)newInputSet {
		return [[TMBeBay_Finding_FindItemsAdvanced_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the FindItemsByImage Choreo.
 */
@implementation TMBeBay_Finding_FindItemsByImage_Inputs

	/*!
	 * Set the value of the FindItemsByImageRequest input for this Choreo.
	*(optional, xml) The complete XML request body containing properties you wish to set. This can be used as an alternative to individual inputs that represent request properties.
	 */
	-(void)setFindItemsByImageRequest:(NSString*)FindItemsByImageRequest {
		[super setInput:@"FindItemsByImageRequest" toValue:FindItemsByImageRequest];
	}

	/*!
	 * Set the value of the AppID input for this Choreo.
	*(required, string) The unique identifier for the application.
	 */
	-(void)setAppID:(NSString*)AppID {
		[super setInput:@"AppID" toValue:AppID];
	}

	/*!
	 * Set the value of the AspectFilters input for this Choreo.
	*(optional, json) A dictionary of key/value pairs to use as aspect filters for the request.
	 */
	-(void)setAspectFilters:(NSString*)AspectFilters {
		[super setInput:@"AspectFilters" toValue:AspectFilters];
	}

	/*!
	 * Set the value of the CategoryID input for this Choreo.
	*(optional, string) Filters the results by category ID.
	 */
	-(void)setCategoryID:(NSString*)CategoryID {
		[super setInput:@"CategoryID" toValue:CategoryID];
	}

	/*!
	 * Set the value of the EntriesPerPage input for this Choreo.
	*(optional, integer) The maximum number of records to return in the result.
	 */
	-(void)setEntriesPerPage:(NSString*)EntriesPerPage {
		[super setInput:@"EntriesPerPage" toValue:EntriesPerPage];
	}

	/*!
	 * Set the value of the GlobalID input for this Choreo.
	*(optional, integer) The global ID of the eBay site to access (e.g., EBAY-US).
	 */
	-(void)setGlobalID:(NSString*)GlobalID {
		[super setInput:@"GlobalID" toValue:GlobalID];
	}

	/*!
	 * Set the value of the ItemFilters input for this Choreo.
	*(optional, json) A dictionary of key/value pairs to use as item filters for the request.
	 */
	-(void)setItemFilters:(NSString*)ItemFilters {
		[super setInput:@"ItemFilters" toValue:ItemFilters];
	}

	/*!
	 * Set the value of the ItemID input for this Choreo.
	*(required, string) The ID of an item associated with the image you want to use for matching. The item must be active and listed in a Clothing, Shoes & Accessories category (parent category ID 11450 on the eBay US site).
	 */
	-(void)setItemID:(NSString*)ItemID {
		[super setInput:@"ItemID" toValue:ItemID];
	}

	/*!
	 * Set the value of the OutputSelector input for this Choreo.
	*(optional, string) Controls the fields that are returned in the response (e.g., GalleryInfo).
	 */
	-(void)setOutputSelector:(NSString*)OutputSelector {
		[super setInput:@"OutputSelector" toValue:OutputSelector];
	}

	/*!
	 * Set the value of the PageNumber input for this Choreo.
	*(optional, integer) Specifies the page number of the results to return.
	 */
	-(void)setPageNumber:(NSString*)PageNumber {
		[super setInput:@"PageNumber" toValue:PageNumber];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SortOrder input for this Choreo.
	*(optional, string) Valid values: BestMatch, BidCountMost, CountryAscending, CountryDescending, DistanceNearest, CurrentPriceHighest, EndTimeSoonest, PricePlusShippingHighest, PricePlusShippingLowest, StartTimeNewest.
	 */
	-(void)setSortOrder:(NSString*)SortOrder {
		[super setInput:@"SortOrder" toValue:SortOrder];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FindItemsByImage Choreo.
 */
@implementation TMBeBay_Finding_FindItemsByImage_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Finds items based on their image similarity to the specified item.
 */
@implementation TMBeBay_Finding_FindItemsByImage

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Finding_FindItemsByImage Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Finding/FindItemsByImage"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Finding_FindItemsByImage_ResultSet *results = [[TMBeBay_Finding_FindItemsByImage_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the FindItemsByImage Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Finding_FindItemsByImage_Inputs*)newInputSet {
		return [[TMBeBay_Finding_FindItemsByImage_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the FindItemsByProduct Choreo.
 */
@implementation TMBeBay_Finding_FindItemsByProduct_Inputs

	/*!
	 * Set the value of the FindItemsByProductRequest input for this Choreo.
	*(optional, xml) The complete XML request body containing properties you wish to set. This can be used as an alternative to individual inputs that represent request properties.
	 */
	-(void)setFindItemsByProductRequest:(NSString*)FindItemsByProductRequest {
		[super setInput:@"FindItemsByProductRequest" toValue:FindItemsByProductRequest];
	}

	/*!
	 * Set the value of the AppID input for this Choreo.
	*(required, string) The unique identifier for the application.
	 */
	-(void)setAppID:(NSString*)AppID {
		[super setInput:@"AppID" toValue:AppID];
	}

	/*!
	 * Set the value of the EntriesPerPage input for this Choreo.
	*(optional, integer) The maximum number of records to return in the result.
	 */
	-(void)setEntriesPerPage:(NSString*)EntriesPerPage {
		[super setInput:@"EntriesPerPage" toValue:EntriesPerPage];
	}

	/*!
	 * Set the value of the GlobalID input for this Choreo.
	*(optional, integer) The global ID of the eBay site to access (e.g., EBAY-US).
	 */
	-(void)setGlobalID:(NSString*)GlobalID {
		[super setInput:@"GlobalID" toValue:GlobalID];
	}

	/*!
	 * Set the value of the ItemFilters input for this Choreo.
	*(optional, json) A dictionary of key/value pairs to use as item filters for the request.
	 */
	-(void)setItemFilters:(NSString*)ItemFilters {
		[super setInput:@"ItemFilters" toValue:ItemFilters];
	}

	/*!
	 * Set the value of the OutputSelector input for this Choreo.
	*(optional, string) Controls the fields that are returned in the response (e.g., GalleryInfo).
	 */
	-(void)setOutputSelector:(NSString*)OutputSelector {
		[super setInput:@"OutputSelector" toValue:OutputSelector];
	}

	/*!
	 * Set the value of the PageNumber input for this Choreo.
	*(optional, integer) Specifies the page number of the results to return.
	 */
	-(void)setPageNumber:(NSString*)PageNumber {
		[super setInput:@"PageNumber" toValue:PageNumber];
	}

	/*!
	 * Set the value of the ProductID input for this Choreo.
	*(required, string) The ID of a product to find.
	 */
	-(void)setProductID:(NSString*)ProductID {
		[super setInput:@"ProductID" toValue:ProductID];
	}

	/*!
	 * Set the value of the ProductIDType input for this Choreo.
	*(required, string) The type of identifier being used to find a product. Valid values are: ReferenceID, ISBN, UPC, and EAN.
	 */
	-(void)setProductIDType:(NSString*)ProductIDType {
		[super setInput:@"ProductIDType" toValue:ProductIDType];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SortOrder input for this Choreo.
	*(optional, string) Valid values: BestMatch, BidCountMost, CountryAscending, CountryDescending, DistanceNearest, CurrentPriceHighest, EndTimeSoonest, PricePlusShippingHighest, PricePlusShippingLowest, StartTimeNewest.
	 */
	-(void)setSortOrder:(NSString*)SortOrder {
		[super setInput:@"SortOrder" toValue:SortOrder];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FindItemsByProduct Choreo.
 */
@implementation TMBeBay_Finding_FindItemsByProduct_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Finds items based upon a product ID, such as an ISBN, UPC, EAN, or ePID.
 */
@implementation TMBeBay_Finding_FindItemsByProduct

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Finding_FindItemsByProduct Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Finding/FindItemsByProduct"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Finding_FindItemsByProduct_ResultSet *results = [[TMBeBay_Finding_FindItemsByProduct_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the FindItemsByProduct Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Finding_FindItemsByProduct_Inputs*)newInputSet {
		return [[TMBeBay_Finding_FindItemsByProduct_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetHistograms Choreo.
 */
@implementation TMBeBay_Finding_GetHistograms_Inputs

	/*!
	 * Set the value of the AppID input for this Choreo.
	*(required, string) The unique identifier for the application.
	 */
	-(void)setAppID:(NSString*)AppID {
		[super setInput:@"AppID" toValue:AppID];
	}

	/*!
	 * Set the value of the CategoryID input for this Choreo.
	*(required, string) Specifies the category from which you want to retrieve histogram information.
	 */
	-(void)setCategoryID:(NSString*)CategoryID {
		[super setInput:@"CategoryID" toValue:CategoryID];
	}

	/*!
	 * Set the value of the GlobalID input for this Choreo.
	*(optional, integer) The global ID of the eBay site to access (e.g., EBAY-US).
	 */
	-(void)setGlobalID:(NSString*)GlobalID {
		[super setInput:@"GlobalID" toValue:GlobalID];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetHistograms Choreo.
 */
@implementation TMBeBay_Finding_GetHistograms_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns category and/or aspect histogram information for the eBay category ID you specify.
 */
@implementation TMBeBay_Finding_GetHistograms

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Finding_GetHistograms Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Finding/GetHistograms"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Finding_GetHistograms_ResultSet *results = [[TMBeBay_Finding_GetHistograms_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetHistograms Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Finding_GetHistograms_Inputs*)newInputSet {
		return [[TMBeBay_Finding_GetHistograms_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the FindPopularItems Choreo.
 */
@implementation TMBeBay_Shopping_FindPopularItems_Inputs

	/*!
	 * Set the value of the AppID input for this Choreo.
	*(required, string) The unique identifier for the application.
	 */
	-(void)setAppID:(NSString*)AppID {
		[super setInput:@"AppID" toValue:AppID];
	}

	/*!
	 * Set the value of the CategoryID input for this Choreo.
	*(optional, string) The ID of a category to filter by. Multiple category IDs can be separated by commas.
	 */
	-(void)setCategoryID:(NSString*)CategoryID {
		[super setInput:@"CategoryID" toValue:CategoryID];
	}

	/*!
	 * Set the value of the CategoryIDExclude input for this Choreo.
	*(conditional, integer) The ID of a category to exclude from the result set. Multiple category IDs can be separated by commas.
	 */
	-(void)setCategoryIDExclude:(NSString*)CategoryIDExclude {
		[super setInput:@"CategoryIDExclude" toValue:CategoryIDExclude];
	}

	/*!
	 * Set the value of the MaxEntries input for this Choreo.
	*(conditional, integer) The maxiumum number of entries to return in the response.
	 */
	-(void)setMaxEntries:(NSString*)MaxEntries {
		[super setInput:@"MaxEntries" toValue:MaxEntries];
	}

	/*!
	 * Set the value of the QueryKeywords input for this Choreo.
	*(conditional, string) The text for a keyword search.
	 */
	-(void)setQueryKeywords:(NSString*)QueryKeywords {
		[super setInput:@"QueryKeywords" toValue:QueryKeywords];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FindPopularItems Choreo.
 */
@implementation TMBeBay_Shopping_FindPopularItems_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Searches for popular items based on a category or keyword.
 */
@implementation TMBeBay_Shopping_FindPopularItems

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Shopping_FindPopularItems Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Shopping/FindPopularItems"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Shopping_FindPopularItems_ResultSet *results = [[TMBeBay_Shopping_FindPopularItems_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the FindPopularItems Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Shopping_FindPopularItems_Inputs*)newInputSet {
		return [[TMBeBay_Shopping_FindPopularItems_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the FindProducts Choreo.
 */
@implementation TMBeBay_Shopping_FindProducts_Inputs

	/*!
	 * Set the value of the AppID input for this Choreo.
	*(required, string) The unique identifier for the application.
	 */
	-(void)setAppID:(NSString*)AppID {
		[super setInput:@"AppID" toValue:AppID];
	}

	/*!
	 * Set the value of the AvailableItemsOnly input for this Choreo.
	*(optional, boolean) If set to true, only retrieve data for products that have been used to pre-fill active listings. If false, retrieve all products that match the query. Defaults to false.
	 */
	-(void)setAvailableItemsOnly:(NSString*)AvailableItemsOnly {
		[super setInput:@"AvailableItemsOnly" toValue:AvailableItemsOnly];
	}

	/*!
	 * Set the value of the CategoryID input for this Choreo.
	*(conditional, string) Restricts your query to a specific category. The request requires one of the following filter parameters: QueryKeywords, ProductID, or CategoryID. Only one of the filters should be provided.
	 */
	-(void)setCategoryID:(NSString*)CategoryID {
		[super setInput:@"CategoryID" toValue:CategoryID];
	}

	/*!
	 * Set the value of the DomainName input for this Choreo.
	*(optional, string) A domain to search in (e.g. Textbooks).
	 */
	-(void)setDomainName:(NSString*)DomainName {
		[super setInput:@"DomainName" toValue:DomainName];
	}

	/*!
	 * Set the value of the HideDuplicateItems input for this Choreo.
	*(optional, string) Specifies whether or not to remove duplicate items from search results.
	 */
	-(void)setHideDuplicateItems:(NSString*)HideDuplicateItems {
		[super setInput:@"HideDuplicateItems" toValue:HideDuplicateItems];
	}

	/*!
	 * Set the value of the IncludeSelector input for this Choreo.
	*(optional, string) Defines standard subsets of fields to return within the response. Valid values are: Details, DomainHistogram, and Items.
	 */
	-(void)setIncludeSelector:(NSString*)IncludeSelector {
		[super setInput:@"IncludeSelector" toValue:IncludeSelector];
	}

	/*!
	 * Set the value of the MaxEntries input for this Choreo.
	*(optional, integer) The maximum number of entries to return in the response.
	 */
	-(void)setMaxEntries:(NSString*)MaxEntries {
		[super setInput:@"MaxEntries" toValue:MaxEntries];
	}

	/*!
	 * Set the value of the PageNumber input for this Choreo.
	*(optional, string) The page number to retrieve.
	 */
	-(void)setPageNumber:(NSString*)PageNumber {
		[super setInput:@"PageNumber" toValue:PageNumber];
	}

	/*!
	 * Set the value of the ProductID input for this Choreo.
	*(conditional, string) Used to retrieve product details. The request requires one of the following filter parameters: QueryKeywords, ProductID, or CategoryID. Only one of the filters should be provided.
	 */
	-(void)setProductID:(NSString*)ProductID {
		[super setInput:@"ProductID" toValue:ProductID];
	}

	/*!
	 * Set the value of the ProductSort input for this Choreo.
	*(optional, string) Sorts the list of products returned. Valid values are: ItemCount, Popularity, Rating, ReviewCount, and Title.
	 */
	-(void)setProductSort:(NSString*)ProductSort {
		[super setInput:@"ProductSort" toValue:ProductSort];
	}

	/*!
	 * Set the value of the QueryKeywords input for this Choreo.
	*(conditional, string) The query keywords to use for the product search. The request requires one of the following filter parameters: QueryKeywords, ProductID, or CategoryID. Only one of the filters should be provided.
	 */
	-(void)setQueryKeywords:(NSString*)QueryKeywords {
		[super setInput:@"QueryKeywords" toValue:QueryKeywords];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the SortOrder input for this Choreo.
	*(optional, string) Sorts search results in ascending or descending order. Valid values are: Ascending and Descending.
	 */
	-(void)setSortOrder:(NSString*)SortOrder {
		[super setInput:@"SortOrder" toValue:SortOrder];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FindProducts Choreo.
 */
@implementation TMBeBay_Shopping_FindProducts_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves the listings for products that match the specified keywords.
 */
@implementation TMBeBay_Shopping_FindProducts

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Shopping_FindProducts Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Shopping/FindProducts"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Shopping_FindProducts_ResultSet *results = [[TMBeBay_Shopping_FindProducts_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the FindProducts Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Shopping_FindProducts_Inputs*)newInputSet {
		return [[TMBeBay_Shopping_FindProducts_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetCategoryInfo Choreo.
 */
@implementation TMBeBay_Shopping_GetCategoryInfo_Inputs

	/*!
	 * Set the value of the AppID input for this Choreo.
	*(required, string) The unique identifier for the application.
	 */
	-(void)setAppID:(NSString*)AppID {
		[super setInput:@"AppID" toValue:AppID];
	}

	/*!
	 * Set the value of the CategoryID input for this Choreo.
	*(required, string) The ID of a category to retrieve. Use an ID of -1 to retrieve the root category and the top-level (level 1) meta categories.
	 */
	-(void)setCategoryID:(NSString*)CategoryID {
		[super setInput:@"CategoryID" toValue:CategoryID];
	}

	/*!
	 * Set the value of the IncludeSelector input for this Choreo.
	*(optional, string) Defines standard subsets of fields to return within the response. Valid values are: ChildCategories.
	 */
	-(void)setIncludeSelector:(NSString*)IncludeSelector {
		[super setInput:@"IncludeSelector" toValue:IncludeSelector];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetCategoryInfo Choreo.
 */
@implementation TMBeBay_Shopping_GetCategoryInfo_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieve high-level category information for a specified category.
 */
@implementation TMBeBay_Shopping_GetCategoryInfo

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Shopping_GetCategoryInfo Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Shopping/GetCategoryInfo"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Shopping_GetCategoryInfo_ResultSet *results = [[TMBeBay_Shopping_GetCategoryInfo_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetCategoryInfo Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Shopping_GetCategoryInfo_Inputs*)newInputSet {
		return [[TMBeBay_Shopping_GetCategoryInfo_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetItemStatus Choreo.
 */
@implementation TMBeBay_Shopping_GetItemStatus_Inputs

	/*!
	 * Set the value of the AppID input for this Choreo.
	*(required, string) The unique identifier for the application.
	 */
	-(void)setAppID:(NSString*)AppID {
		[super setInput:@"AppID" toValue:AppID];
	}

	/*!
	 * Set the value of the ItemID input for this Choreo.
	*(required, string) The ID of an item to retrieve the status for. Multiple item IDs can be separated by commas.
	 */
	-(void)setItemID:(NSString*)ItemID {
		[super setInput:@"ItemID" toValue:ItemID];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetItemStatus Choreo.
 */
@implementation TMBeBay_Shopping_GetItemStatus_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Allows you to get the status for a group of items.
 */
@implementation TMBeBay_Shopping_GetItemStatus

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Shopping_GetItemStatus Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Shopping/GetItemStatus"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Shopping_GetItemStatus_ResultSet *results = [[TMBeBay_Shopping_GetItemStatus_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetItemStatus Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Shopping_GetItemStatus_Inputs*)newInputSet {
		return [[TMBeBay_Shopping_GetItemStatus_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetMultipleItems Choreo.
 */
@implementation TMBeBay_Shopping_GetMultipleItems_Inputs

	/*!
	 * Set the value of the AppID input for this Choreo.
	*(required, string) The unique identifier for the application.
	 */
	-(void)setAppID:(NSString*)AppID {
		[super setInput:@"AppID" toValue:AppID];
	}

	/*!
	 * Set the value of the ItemID input for this Choreo.
	*(required, string) The ID of an item to retrieve the status for. Multiple item IDs can be separated by commas.
	 */
	-(void)setItemID:(NSString*)ItemID {
		[super setInput:@"ItemID" toValue:ItemID];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetMultipleItems Choreo.
 */
@implementation TMBeBay_Shopping_GetMultipleItems_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves publicly available data for one or more listings.
 */
@implementation TMBeBay_Shopping_GetMultipleItems

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Shopping_GetMultipleItems Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Shopping/GetMultipleItems"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Shopping_GetMultipleItems_ResultSet *results = [[TMBeBay_Shopping_GetMultipleItems_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetMultipleItems Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Shopping_GetMultipleItems_Inputs*)newInputSet {
		return [[TMBeBay_Shopping_GetMultipleItems_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetShippingCosts Choreo.
 */
@implementation TMBeBay_Shopping_GetShippingCosts_Inputs

	/*!
	 * Set the value of the AppID input for this Choreo.
	*(required, string) The unique identifier for the application.
	 */
	-(void)setAppID:(NSString*)AppID {
		[super setInput:@"AppID" toValue:AppID];
	}

	/*!
	 * Set the value of the DestinationCountryCode input for this Choreo.
	*(conditional, string) The shipment destination country code.
	 */
	-(void)setDestinationCountryCode:(NSString*)DestinationCountryCode {
		[super setInput:@"DestinationCountryCode" toValue:DestinationCountryCode];
	}

	/*!
	 * Set the value of the DestinationPostalCode input for this Choreo.
	*(conditional, string) The shipment destination postal code.
	 */
	-(void)setDestinationPostalCode:(NSString*)DestinationPostalCode {
		[super setInput:@"DestinationPostalCode" toValue:DestinationPostalCode];
	}

	/*!
	 * Set the value of the IncludeDetails input for this Choreo.
	*(conditional, boolean) Indicates whether to return the ShippingDetails container in the response.
	 */
	-(void)setIncludeDetails:(NSString*)IncludeDetails {
		[super setInput:@"IncludeDetails" toValue:IncludeDetails];
	}

	/*!
	 * Set the value of the ItemID input for this Choreo.
	*(required, string) The ID of the item to get shipping costs for.
	 */
	-(void)setItemID:(NSString*)ItemID {
		[super setInput:@"ItemID" toValue:ItemID];
	}

	/*!
	 * Set the value of the QuantitySold input for this Choreo.
	*(optional, string) The quantity of items being shipped.
	 */
	-(void)setQuantitySold:(NSString*)QuantitySold {
		[super setInput:@"QuantitySold" toValue:QuantitySold];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetShippingCosts Choreo.
 */
@implementation TMBeBay_Shopping_GetShippingCosts_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves shipping costs for an item.
 */
@implementation TMBeBay_Shopping_GetShippingCosts

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Shopping_GetShippingCosts Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Shopping/GetShippingCosts"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Shopping_GetShippingCosts_ResultSet *results = [[TMBeBay_Shopping_GetShippingCosts_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetShippingCosts Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Shopping_GetShippingCosts_Inputs*)newInputSet {
		return [[TMBeBay_Shopping_GetShippingCosts_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetUserProfile Choreo.
 */
@implementation TMBeBay_Shopping_GetUserProfile_Inputs

	/*!
	 * Set the value of the AppID input for this Choreo.
	*(required, string) The unique identifier for the application.
	 */
	-(void)setAppID:(NSString*)AppID {
		[super setInput:@"AppID" toValue:AppID];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the UserID input for this Choreo.
	*(required, string) The ID of the user to return the profile for.
	 */
	-(void)setUserID:(NSString*)UserID {
		[super setInput:@"UserID" toValue:UserID];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetUserProfile Choreo.
 */
@implementation TMBeBay_Shopping_GetUserProfile_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves public user information based on the user ID you specify.
 */
@implementation TMBeBay_Shopping_GetUserProfile

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Shopping_GetUserProfile Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Shopping/GetUserProfile"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Shopping_GetUserProfile_ResultSet *results = [[TMBeBay_Shopping_GetUserProfile_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetUserProfile Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Shopping_GetUserProfile_Inputs*)newInputSet {
		return [[TMBeBay_Shopping_GetUserProfile_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AddBasicListing Choreo.
 */
@implementation TMBeBay_Trading_AddBasicListing_Inputs

	/*!
	 * Set the value of the BuyItNowPrice input for this Choreo.
	*(optional, decimal) Allows a user to purchase the item at a Buy It Now price and end the auction immediately.
	 */
	-(void)setBuyItNowPrice:(NSString*)BuyItNowPrice {
		[super setInput:@"BuyItNowPrice" toValue:BuyItNowPrice];
	}

	/*!
	 * Set the value of the CategoryID input for this Choreo.
	*(conditional, integer) The numeric ID for a category on eBay. Category IDs can be retrieved with the GetCategories Choreo.
	 */
	-(void)setCategoryID:(NSString*)CategoryID {
		[super setInput:@"CategoryID" toValue:CategoryID];
	}

	/*!
	 * Set the value of the ConditionID input for this Choreo.
	*(conditional, integer) The numeric ID (e.g., 1000) for the item condition.
	 */
	-(void)setConditionID:(NSString*)ConditionID {
		[super setInput:@"ConditionID" toValue:ConditionID];
	}

	/*!
	 * Set the value of the Country input for this Choreo.
	*(conditional, string) The country where the item is located in.
	 */
	-(void)setCountry:(NSString*)Country {
		[super setInput:@"Country" toValue:Country];
	}

	/*!
	 * Set the value of the Currency input for this Choreo.
	*(conditional, string) The currency associated with the item price.
	 */
	-(void)setCurrency:(NSString*)Currency {
		[super setInput:@"Currency" toValue:Currency];
	}

	/*!
	 * Set the value of the DispatchTimeMax input for this Choreo.
	*(conditional, integer) Specifies the maximum number of business days the seller commits to for preparing an item to be shipped after receiving a cleared payment.
	 */
	-(void)setDispatchTimeMax:(NSString*)DispatchTimeMax {
		[super setInput:@"DispatchTimeMax" toValue:DispatchTimeMax];
	}

	/*!
	 * Set the value of the ExpeditedService input for this Choreo.
	*(optional, boolean) Whether or not the seller is offering expedited shipping service options.
	 */
	-(void)setExpeditedService:(NSString*)ExpeditedService {
		[super setInput:@"ExpeditedService" toValue:ExpeditedService];
	}

	/*!
	 * Set the value of the ItemDescription input for this Choreo.
	*(conditional, string) The seller's description of the item.
	 */
	-(void)setItemDescription:(NSString*)ItemDescription {
		[super setInput:@"ItemDescription" toValue:ItemDescription];
	}

	/*!
	 * Set the value of the ListingDuration input for this Choreo.
	*(conditional, string) The number of days the seller wants the listing to be active (e.g., Days_7). A complete list of accepted values is returned when calling GetCategoryFeatures with DetailLevel set to ReturnAll.
	 */
	-(void)setListingDuration:(NSString*)ListingDuration {
		[super setInput:@"ListingDuration" toValue:ListingDuration];
	}

	/*!
	 * Set the value of the ListingType input for this Choreo.
	*(optional, string) The format of the listing the seller wants to use. Valid values are: AdType, Chinese, FixedPriceItem, Half, LeadGeneration.
	 */
	-(void)setListingType:(NSString*)ListingType {
		[super setInput:@"ListingType" toValue:ListingType];
	}

	/*!
	 * Set the value of the PayPalEmailAddress input for this Choreo.
	*(conditional, string) The seller's PayPal email address. Required when a PaymentMethod is PayPal.
	 */
	-(void)setPayPalEmailAddress:(NSString*)PayPalEmailAddress {
		[super setInput:@"PayPalEmailAddress" toValue:PayPalEmailAddress];
	}

	/*!
	 * Set the value of the PaymentMethods input for this Choreo.
	*(conditional, string) Identifies the payment method (such as PayPal) that the seller will accept when the buyer pays for the item. This can be a comma-separated list (e.g., VisaMC,PayPal).
	 */
	-(void)setPaymentMethods:(NSString*)PaymentMethods {
		[super setInput:@"PaymentMethods" toValue:PaymentMethods];
	}

	/*!
	 * Set the value of the PictureURL input for this Choreo.
	*(conditional, string) The URL for a picture associated with an item. Multiple URLs can be specified as a comma-separated list.
	 */
	-(void)setPictureURL:(NSString*)PictureURL {
		[super setInput:@"PictureURL" toValue:PictureURL];
	}

	/*!
	 * Set the value of the PostalCode input for this Choreo.
	*(conditional, string) The Postal code of the place where the item is located.
	 */
	-(void)setPostalCode:(NSString*)PostalCode {
		[super setInput:@"PostalCode" toValue:PostalCode];
	}

	/*!
	 * Set the value of the Quantity input for this Choreo.
	*(conditional, integer) Indicates the quantity of items available for purchase in the listing. Required for all auction listings and for non-variation, fixed-price listings. For auction listings, this value is always '1'.
	 */
	-(void)setQuantity:(NSString*)Quantity {
		[super setInput:@"Quantity" toValue:Quantity];
	}

	/*!
	 * Set the value of the RefundOption input for this Choreo.
	*(optional, string) Indicates how the seller will compensate the buyer for a returned item (e.g. MoneyBack).
	 */
	-(void)setRefundOption:(NSString*)RefundOption {
		[super setInput:@"RefundOption" toValue:RefundOption];
	}

	/*!
	 * Set the value of the ReservePrice input for this Choreo.
	*(optional, decimal) The lowest price at which the seller is willing to sell the item.
	 */
	-(void)setReservePrice:(NSString*)ReservePrice {
		[super setInput:@"ReservePrice" toValue:ReservePrice];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the ReturnPolicyDescription input for this Choreo.
	*(optional, string) The text description of return policy details.
	 */
	-(void)setReturnPolicyDescription:(NSString*)ReturnPolicyDescription {
		[super setInput:@"ReturnPolicyDescription" toValue:ReturnPolicyDescription];
	}

	/*!
	 * Set the value of the ReturnsAcceptedOption input for this Choreo.
	*(conditional, string) Indicates whether the seller allows the buyer to return the item (e.g., ReturnsAccepted).
	 */
	-(void)setReturnsAcceptedOption:(NSString*)ReturnsAcceptedOption {
		[super setInput:@"ReturnsAcceptedOption" toValue:ReturnsAcceptedOption];
	}

	/*!
	 * Set the value of the ReturnsWithinOption input for this Choreo.
	*(optional, string) The period of time the buyer has to return the item (e.g., Days_14). To accepted values for this field, call GeteBayDetails with DetailName set to ReturnPolicyDetails.
	 */
	-(void)setReturnsWithinOption:(NSString*)ReturnsWithinOption {
		[super setInput:@"ReturnsWithinOption" toValue:ReturnsWithinOption];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the ShippingService input for this Choreo.
	*(conditional, string) The name of the shipping service offered (e.g. UPSGround, USPSMedia).
	 */
	-(void)setShippingService:(NSString*)ShippingService {
		[super setInput:@"ShippingService" toValue:ShippingService];
	}

	/*!
	 * Set the value of the ShippingServiceAdditionalCost input for this Choreo.
	*(optional, decimal) Shipping costs in addition to the value specified for the ShippingServiceCost parameter.
	 */
	-(void)setShippingServiceAdditionalCost:(NSString*)ShippingServiceAdditionalCost {
		[super setInput:@"ShippingServiceAdditionalCost" toValue:ShippingServiceAdditionalCost];
	}

	/*!
	 * Set the value of the ShippingServiceCost input for this Choreo.
	*(conditional, decimal) The cost for shipping the item.
	 */
	-(void)setShippingServiceCost:(NSString*)ShippingServiceCost {
		[super setInput:@"ShippingServiceCost" toValue:ShippingServiceCost];
	}

	/*!
	 * Set the value of the ShippingType input for this Choreo.
	*(conditional, string) The shipping cost model offered by the seller. Valid values are: Calculated, CalculatedDomesticFlatInternational, Flat, FlatDomesticCalculatedInternational, FreightFlat, NotSpecified.
	 */
	-(void)setShippingType:(NSString*)ShippingType {
		[super setInput:@"ShippingType" toValue:ShippingType];
	}

	/*!
	 * Set the value of the Site input for this Choreo.
	*(optional, string) The name of the site on which the item is listed. This should corresponse to the SiteID. Default value is "US".
	 */
	-(void)setSite:(NSString*)Site {
		[super setInput:@"Site" toValue:Site];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the StartPrice input for this Choreo.
	*(conditional, decimal) This value indicates the starting price of the item when it is listed for the first time.
	 */
	-(void)setStartPrice:(NSString*)StartPrice {
		[super setInput:@"StartPrice" toValue:StartPrice];
	}

	/*!
	 * Set the value of the Title input for this Choreo.
	*(conditional, string) The title of the item as it appears in the listing or search results.
	 */
	-(void)setTitle:(NSString*)Title {
		[super setInput:@"Title" toValue:Title];
	}

	/*!
	 * Set the value of the UserToken input for this Choreo.
	*(required, string) A valid eBay Auth Token.
	 */
	-(void)setUserToken:(NSString*)UserToken {
		[super setInput:@"UserToken" toValue:UserToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddBasicListing Choreo.
 */
@implementation TMBeBay_Trading_AddBasicListing_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Allows you create a basic listing on eBay using scalar inputs rather than an XML request.
 */
@implementation TMBeBay_Trading_AddBasicListing

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_AddBasicListing Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/AddBasicListing"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_AddBasicListing_ResultSet *results = [[TMBeBay_Trading_AddBasicListing_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AddBasicListing Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_AddBasicListing_Inputs*)newInputSet {
		return [[TMBeBay_Trading_AddBasicListing_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AddItem Choreo.
 */
@implementation TMBeBay_Trading_AddItem_Inputs

	/*!
	 * Set the value of the AddItemRequest input for this Choreo.
	*(required, xml) The complete XML request body containing item properties you wish to set.
	 */
	-(void)setAddItemRequest:(NSString*)AddItemRequest {
		[super setInput:@"AddItemRequest" toValue:AddItemRequest];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the UserToken input for this Choreo.
	*(required, string) A valid eBay Auth Token.
	 */
	-(void)setUserToken:(NSString*)UserToken {
		[super setInput:@"UserToken" toValue:UserToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddItem Choreo.
 */
@implementation TMBeBay_Trading_AddItem_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Defines a single new item and lists it on a specified eBay site.
 */
@implementation TMBeBay_Trading_AddItem

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_AddItem Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/AddItem"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_AddItem_ResultSet *results = [[TMBeBay_Trading_AddItem_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AddItem Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_AddItem_Inputs*)newInputSet {
		return [[TMBeBay_Trading_AddItem_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AddMemberMessageAAQToPartner Choreo.
 */
@implementation TMBeBay_Trading_AddMemberMessageAAQToPartner_Inputs

	/*!
	 * Set the value of the Body input for this Choreo.
	*(required, string) The message body.
	 */
	-(void)setBody:(NSString*)Body {
		[super setInput:@"Body" toValue:Body];
	}

	/*!
	 * Set the value of the EmailCopyToSender input for this Choreo.
	*(optional, boolean) A flag used to indicate that a copy should be sent to the sender.
	 */
	-(void)setEmailCopyToSender:(NSString*)EmailCopyToSender {
		[super setInput:@"EmailCopyToSender" toValue:EmailCopyToSender];
	}

	/*!
	 * Set the value of the ItemID input for this Choreo.
	*(required, string) The unique ID of the item about which the question was asked.
	 */
	-(void)setItemID:(NSString*)ItemID {
		[super setInput:@"ItemID" toValue:ItemID];
	}

	/*!
	 * Set the value of the QuestionType input for this Choreo.
	*(required, string) The type of question. Valid values are: General, Shipping, Payment, MultipleItemShipping, CustomizedSubject, or None.
	 */
	-(void)setQuestionType:(NSString*)QuestionType {
		[super setInput:@"QuestionType" toValue:QuestionType];
	}

	/*!
	 * Set the value of the RecipientID input for this Choreo.
	*(required, string) The user ID of the message recipient.
	 */
	-(void)setRecipientID:(NSString*)RecipientID {
		[super setInput:@"RecipientID" toValue:RecipientID];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the Subject input for this Choreo.
	*(required, string) The message subject.
	 */
	-(void)setSubject:(NSString*)Subject {
		[super setInput:@"Subject" toValue:Subject];
	}

	/*!
	 * Set the value of the UserToken input for this Choreo.
	*(required, string) A valid eBay Auth Token.
	 */
	-(void)setUserToken:(NSString*)UserToken {
		[super setInput:@"UserToken" toValue:UserToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddMemberMessageAAQToPartner Choreo.
 */
@implementation TMBeBay_Trading_AddMemberMessageAAQToPartner_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Allows a buyer and seller in an order relationship to send messages to each other's My Messages Inboxes.
 */
@implementation TMBeBay_Trading_AddMemberMessageAAQToPartner

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_AddMemberMessageAAQToPartner Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/AddMemberMessageAAQToPartner"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_AddMemberMessageAAQToPartner_ResultSet *results = [[TMBeBay_Trading_AddMemberMessageAAQToPartner_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AddMemberMessageAAQToPartner Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_AddMemberMessageAAQToPartner_Inputs*)newInputSet {
		return [[TMBeBay_Trading_AddMemberMessageAAQToPartner_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AddMemberMessageRTQ Choreo.
 */
@implementation TMBeBay_Trading_AddMemberMessageRTQ_Inputs

	/*!
	 * Set the value of the Body input for this Choreo.
	*(required, string) The message body which should answer the question that an eBay user ask the seller. HTML is not allowed.
	 */
	-(void)setBody:(NSString*)Body {
		[super setInput:@"Body" toValue:Body];
	}

	/*!
	 * Set the value of the DisplayToPublic input for this Choreo.
	*(optional, string) When set to true, this indicates that the member message is viewable in the item listing.
	 */
	-(void)setDisplayToPublic:(NSString*)DisplayToPublic {
		[super setInput:@"DisplayToPublic" toValue:DisplayToPublic];
	}

	/*!
	 * Set the value of the EmailCopyToSender input for this Choreo.
	*(optional, boolean) A flag used to indicate that a copy should be sent to the sender.
	 */
	-(void)setEmailCopyToSender:(NSString*)EmailCopyToSender {
		[super setInput:@"EmailCopyToSender" toValue:EmailCopyToSender];
	}

	/*!
	 * Set the value of the ItemID input for this Choreo.
	*(optional, string) The unique ID of the item about which the question was asked.
	 */
	-(void)setItemID:(NSString*)ItemID {
		[super setInput:@"ItemID" toValue:ItemID];
	}

	/*!
	 * Set the value of the ParentMessageID input for this Choreo.
	*(required, string) The ID number of the question to which this message is responding.
	 */
	-(void)setParentMessageID:(NSString*)ParentMessageID {
		[super setInput:@"ParentMessageID" toValue:ParentMessageID];
	}

	/*!
	 * Set the value of the RecipientID input for this Choreo.
	*(required, string) The recipient's eBay user ID.
	 */
	-(void)setRecipientID:(NSString*)RecipientID {
		[super setInput:@"RecipientID" toValue:RecipientID];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the UserToken input for this Choreo.
	*(required, string) A valid eBay Auth Token.
	 */
	-(void)setUserToken:(NSString*)UserToken {
		[super setInput:@"UserToken" toValue:UserToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddMemberMessageRTQ Choreo.
 */
@implementation TMBeBay_Trading_AddMemberMessageRTQ_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Allows a seller to reply to a question about an active item listing.
 */
@implementation TMBeBay_Trading_AddMemberMessageRTQ

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_AddMemberMessageRTQ Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/AddMemberMessageRTQ"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_AddMemberMessageRTQ_ResultSet *results = [[TMBeBay_Trading_AddMemberMessageRTQ_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AddMemberMessageRTQ Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_AddMemberMessageRTQ_Inputs*)newInputSet {
		return [[TMBeBay_Trading_AddMemberMessageRTQ_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AddToWatchList Choreo.
 */
@implementation TMBeBay_Trading_AddToWatchList_Inputs

	/*!
	 * Set the value of the ItemID input for this Choreo.
	*(required, string) The ID of an item to add to a user's watch list. This can be a comma-separated list of item IDs.
	 */
	-(void)setItemID:(NSString*)ItemID {
		[super setInput:@"ItemID" toValue:ItemID];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the UserToken input for this Choreo.
	*(required, string) A valid eBay Auth Token.
	 */
	-(void)setUserToken:(NSString*)UserToken {
		[super setInput:@"UserToken" toValue:UserToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddToWatchList Choreo.
 */
@implementation TMBeBay_Trading_AddToWatchList_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Adds one or more items to the user's My eBay watch list.
 */
@implementation TMBeBay_Trading_AddToWatchList

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_AddToWatchList Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/AddToWatchList"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_AddToWatchList_ResultSet *results = [[TMBeBay_Trading_AddToWatchList_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AddToWatchList Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_AddToWatchList_Inputs*)newInputSet {
		return [[TMBeBay_Trading_AddToWatchList_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CompleteSale Choreo.
 */
@implementation TMBeBay_Trading_CompleteSale_Inputs

	/*!
	 * Set the value of the CompleteSaleRequest input for this Choreo.
	*(optional, xml) The complete XML request body containing properties you wish to set. This can be used as an alternative to individual inputs that represent request properties.
	 */
	-(void)setCompleteSaleRequest:(NSString*)CompleteSaleRequest {
		[super setInput:@"CompleteSaleRequest" toValue:CompleteSaleRequest];
	}

	/*!
	 * Set the value of the CommentText input for this Choreo.
	*(optional, string) The comment text to leave Feedback about the buyer.
	 */
	-(void)setCommentText:(NSString*)CommentText {
		[super setInput:@"CommentText" toValue:CommentText];
	}

	/*!
	 * Set the value of the CommentType input for this Choreo.
	*(optional, string) The type of comment. Valid values are: Positive.
	 */
	-(void)setCommentType:(NSString*)CommentType {
		[super setInput:@"CommentType" toValue:CommentType];
	}

	/*!
	 * Set the value of the ItemID input for this Choreo.
	*(conditional, string) The unique identifier for an eBay item listing that was sold. Either ItemID or TransactionID should be provided.
	 */
	-(void)setItemID:(NSString*)ItemID {
		[super setInput:@"ItemID" toValue:ItemID];
	}

	/*!
	 * Set the value of the Notes input for this Choreo.
	*(optional, string) A text field for shipping related notes.
	 */
	-(void)setNotes:(NSString*)Notes {
		[super setInput:@"Notes" toValue:Notes];
	}

	/*!
	 * Set the value of the OrderID input for this Choreo.
	*(optional, string) A unique identifier that identifies a single line item or multiple line item order.
	 */
	-(void)setOrderID:(NSString*)OrderID {
		[super setInput:@"OrderID" toValue:OrderID];
	}

	/*!
	 * Set the value of the OrderLineItemID input for this Choreo.
	*(optional, string) This is a unique identifier for an eBay order line item and is based upon the concatenation of ItemID and TransactionID, with a hyphen in between these two IDs.
	 */
	-(void)setOrderLineItemID:(NSString*)OrderLineItemID {
		[super setInput:@"OrderLineItemID" toValue:OrderLineItemID];
	}

	/*!
	 * Set the value of the Paid input for this Choreo.
	*(conditional, boolean) Set to true to indicate that the item has been paid for. One of Feedback info, Shipped status or Paid status is required.
	 */
	-(void)setPaid:(NSString*)Paid {
		[super setInput:@"Paid" toValue:Paid];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the ShipmentTrackingNumber input for this Choreo.
	*(optional, string) The tracking number for the package.
	 */
	-(void)setShipmentTrackingNumber:(NSString*)ShipmentTrackingNumber {
		[super setInput:@"ShipmentTrackingNumber" toValue:ShipmentTrackingNumber];
	}

	/*!
	 * Set the value of the Shipped input for this Choreo.
	*(conditional, boolean) Set to true to indicate that the item has been shipped. One of Feedback info, Shipped status or Paid status is required.
	 */
	-(void)setShipped:(NSString*)Shipped {
		[super setInput:@"Shipped" toValue:Shipped];
	}

	/*!
	 * Set the value of the ShippedTime input for this Choreo.
	*(optional, date) The date and time that the item was shipped.
	 */
	-(void)setShippedTime:(NSString*)ShippedTime {
		[super setInput:@"ShippedTime" toValue:ShippedTime];
	}

	/*!
	 * Set the value of the ShippingCarrierUsed input for this Choreo.
	*(optional, string) The carrier used to ship the item.
	 */
	-(void)setShippingCarrierUsed:(NSString*)ShippingCarrierUsed {
		[super setInput:@"ShippingCarrierUsed" toValue:ShippingCarrierUsed];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the TargetUser input for this Choreo.
	*(optional, string) The user ID of the buyer who you want to leave feedback for.
	 */
	-(void)setTargetUser:(NSString*)TargetUser {
		[super setInput:@"TargetUser" toValue:TargetUser];
	}

	/*!
	 * Set the value of the TransactionID input for this Choreo.
	*(conditional, string) The unique identifier for an eBay order line item (transaction). Either ItemID or TransactionID should be provided.
	 */
	-(void)setTransactionID:(NSString*)TransactionID {
		[super setInput:@"TransactionID" toValue:TransactionID];
	}

	/*!
	 * Set the value of the UserToken input for this Choreo.
	*(required, string) A valid eBay Auth Token.
	 */
	-(void)setUserToken:(NSString*)UserToken {
		[super setInput:@"UserToken" toValue:UserToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CompleteSale Choreo.
 */
@implementation TMBeBay_Trading_CompleteSale_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Allows the seller to perform the final steps for completing an order.
 */
@implementation TMBeBay_Trading_CompleteSale

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_CompleteSale Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/CompleteSale"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_CompleteSale_ResultSet *results = [[TMBeBay_Trading_CompleteSale_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CompleteSale Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_CompleteSale_Inputs*)newInputSet {
		return [[TMBeBay_Trading_CompleteSale_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the EndItem Choreo.
 */
@implementation TMBeBay_Trading_EndItem_Inputs

	/*!
	 * Set the value of the EndingReason input for this Choreo.
	*(required, string) The reason the listing is ending early. Valid values are: LostOrBroken, NotAvailable, Incorrect, OtherListingError, CustomCode, SellToHighBidder, or Sold.
	 */
	-(void)setEndingReason:(NSString*)EndingReason {
		[super setInput:@"EndingReason" toValue:EndingReason];
	}

	/*!
	 * Set the value of the ItemID input for this Choreo.
	*(required, string) The ID of the item to end.
	 */
	-(void)setItemID:(NSString*)ItemID {
		[super setInput:@"ItemID" toValue:ItemID];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SellerInventoryID input for this Choreo.
	*(optional, string) Unique identifier that the seller specified when they listed the Half.com item. This paramater only applies to Half.com.
	 */
	-(void)setSellerInventoryID:(NSString*)SellerInventoryID {
		[super setInput:@"SellerInventoryID" toValue:SellerInventoryID];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the UserToken input for this Choreo.
	*(required, string) A valid eBay Auth Token.
	 */
	-(void)setUserToken:(NSString*)UserToken {
		[super setInput:@"UserToken" toValue:UserToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the EndItem Choreo.
 */
@implementation TMBeBay_Trading_EndItem_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Ends the specified item listing before the date and time that it is scheduled to end per the listing duration.
 */
@implementation TMBeBay_Trading_EndItem

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_EndItem Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/EndItem"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_EndItem_ResultSet *results = [[TMBeBay_Trading_EndItem_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the EndItem Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_EndItem_Inputs*)newInputSet {
		return [[TMBeBay_Trading_EndItem_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the FetchToken Choreo.
 */
@implementation TMBeBay_Trading_FetchToken_Inputs

	/*!
	 * Set the value of the AppID input for this Choreo.
	*(required, string) The unique identifier for the application.
	 */
	-(void)setAppID:(NSString*)AppID {
		[super setInput:@"AppID" toValue:AppID];
	}

	/*!
	 * Set the value of the CertID input for this Choreo.
	*(required, string) The certificate that authenticates the application when making API calls.
	 */
	-(void)setCertID:(NSString*)CertID {
		[super setInput:@"CertID" toValue:CertID];
	}

	/*!
	 * Set the value of the DevID input for this Choreo.
	*(required, string) The unique identifier for the developer's account.
	 */
	-(void)setDevID:(NSString*)DevID {
		[super setInput:@"DevID" toValue:DevID];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SessionID input for this Choreo.
	*(required, string) The SessionID returned from PayPal. This gets passed to the FetchToken Choreo after the user authorizes the request.
	 */
	-(void)setSessionID:(NSString*)SessionID {
		[super setInput:@"SessionID" toValue:SessionID];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the Timeout input for this Choreo.
	*(optional, integer) The amount of time (in seconds) to poll eBay to see if your app's user has allowed or denied the request for access. Defaults to 20. Max is 60.
	 */
	-(void)setTimeout:(NSString*)Timeout {
		[super setInput:@"Timeout" toValue:Timeout];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FetchToken Choreo.
 */
@implementation TMBeBay_Trading_FetchToken_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "UserToken" output from an execution of this Choreo.
	 * @return - NSString* (string) An eBay Auth Token which can be used to make requests the user's behalf.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getUserToken {
		return [super getOutputByName:@"UserToken"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Completes the authentication process by retrieving an eBay user token after they have visited the authorization URL returned by the GetSessionID Choreo and clicked "I agree".
 */
@implementation TMBeBay_Trading_FetchToken

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_FetchToken Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/FetchToken"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_FetchToken_ResultSet *results = [[TMBeBay_Trading_FetchToken_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the FetchToken Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_FetchToken_Inputs*)newInputSet {
		return [[TMBeBay_Trading_FetchToken_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetCategories Choreo.
 */
@implementation TMBeBay_Trading_GetCategories_Inputs

	/*!
	 * Set the value of the CategoryParent input for this Choreo.
	*(optional, string) Indicates the ID of the highest-level category to return. Multiple CategoryParent IDs can be specified in a comma-separated list.
	 */
	-(void)setCategoryParent:(NSString*)CategoryParent {
		[super setInput:@"CategoryParent" toValue:CategoryParent];
	}

	/*!
	 * Set the value of the CategorySiteID input for this Choreo.
	*(optional, string) The ID for the site for which to retrieve the category hierarchy. Use the numeric site code (e.g., 0 for US, 77 for eBay Germany, etc).
	 */
	-(void)setCategorySiteID:(NSString*)CategorySiteID {
		[super setInput:@"CategorySiteID" toValue:CategorySiteID];
	}

	/*!
	 * Set the value of the DetailLevel input for this Choreo.
	*(optional, string) The level of detail to return in the response. Valid values are: ReturnAll.
	 */
	-(void)setDetailLevel:(NSString*)DetailLevel {
		[super setInput:@"DetailLevel" toValue:DetailLevel];
	}

	/*!
	 * Set the value of the LevelLimit input for this Choreo.
	*(optional, string) Indicates the maximum depth of the category hierarchy to retrieve, where the top-level categories (meta-categories) are at level 1. Default is 0.
	 */
	-(void)setLevelLimit:(NSString*)LevelLimit {
		[super setInput:@"LevelLimit" toValue:LevelLimit];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the UserToken input for this Choreo.
	*(required, string) A valid eBay Auth Token.
	 */
	-(void)setUserToken:(NSString*)UserToken {
		[super setInput:@"UserToken" toValue:UserToken];
	}

	/*!
	 * Set the value of the ViewAllNodes input for this Choreo.
	*(optional, boolean) A flag that controls whether all eBay categories are returned, or only leaf categories are returned. To retrieve leaf categories, set this parameter to 'false'.
	 */
	-(void)setViewAllNodes:(NSString*)ViewAllNodes {
		[super setInput:@"ViewAllNodes" toValue:ViewAllNodes];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetCategories Choreo.
 */
@implementation TMBeBay_Trading_GetCategories_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns the latest category hierarchy for the eBay site.
 */
@implementation TMBeBay_Trading_GetCategories

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_GetCategories Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/GetCategories"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_GetCategories_ResultSet *results = [[TMBeBay_Trading_GetCategories_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetCategories Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_GetCategories_Inputs*)newInputSet {
		return [[TMBeBay_Trading_GetCategories_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetCategoryFeatures Choreo.
 */
@implementation TMBeBay_Trading_GetCategoryFeatures_Inputs

	/*!
	 * Set the value of the AllFeaturesForCategory input for this Choreo.
	*(optional, boolean) A flag used to view all of the feature settings for a specific category.
	 */
	-(void)setAllFeaturesForCategory:(NSString*)AllFeaturesForCategory {
		[super setInput:@"AllFeaturesForCategory" toValue:AllFeaturesForCategory];
	}

	/*!
	 * Set the value of the CategoryID input for this Choreo.
	*(optional, string) The ID of the category for which you want to retrieve the feature settings.
	 */
	-(void)setCategoryID:(NSString*)CategoryID {
		[super setInput:@"CategoryID" toValue:CategoryID];
	}

	/*!
	 * Set the value of the DetailLevel input for this Choreo.
	*(optional, string) The level of detail to return in the response. Valid values are: ReturnAll and ReturnSummary.
	 */
	-(void)setDetailLevel:(NSString*)DetailLevel {
		[super setInput:@"DetailLevel" toValue:DetailLevel];
	}

	/*!
	 * Set the value of the FeatureID input for this Choreo.
	*(optional, string) Use this field if you want to know if specific features are enabled at the site or root category level. Multiple FeatureIDs can be specified in a comma-separated list.
	 */
	-(void)setFeatureID:(NSString*)FeatureID {
		[super setInput:@"FeatureID" toValue:FeatureID];
	}

	/*!
	 * Set the value of the LevelLimit input for this Choreo.
	*(optional, string) Indicates the maximum depth of the category hierarchy to retrieve, where the top-level categories (meta-categories) are at level 1. Default is 0.
	 */
	-(void)setLevelLimit:(NSString*)LevelLimit {
		[super setInput:@"LevelLimit" toValue:LevelLimit];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the UserToken input for this Choreo.
	*(required, string) A valid eBay Auth Token.
	 */
	-(void)setUserToken:(NSString*)UserToken {
		[super setInput:@"UserToken" toValue:UserToken];
	}

	/*!
	 * Set the value of the ViewAllNodes input for this Choreo.
	*(optional, boolean) Indicates that eBay should return the site defaults along with all the categories that override the feature settings they inherit. DetailLevel must be 'ReturnAll' when setting this parameter to true.
	 */
	-(void)setViewAllNodes:(NSString*)ViewAllNodes {
		[super setInput:@"ViewAllNodes" toValue:ViewAllNodes];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetCategoryFeatures Choreo.
 */
@implementation TMBeBay_Trading_GetCategoryFeatures_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns information that describes the feature and value settings that apply to the set of eBay categories.
 */
@implementation TMBeBay_Trading_GetCategoryFeatures

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_GetCategoryFeatures Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/GetCategoryFeatures"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_GetCategoryFeatures_ResultSet *results = [[TMBeBay_Trading_GetCategoryFeatures_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetCategoryFeatures Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_GetCategoryFeatures_Inputs*)newInputSet {
		return [[TMBeBay_Trading_GetCategoryFeatures_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetEbayDetails Choreo.
 */
@implementation TMBeBay_Trading_GetEbayDetails_Inputs

	/*!
	 * Set the value of the DetailName input for this Choreo.
	*(optional, string) An enumeration value used to filter the result by Detail Name (e.g., PaymentOptionDetails, RegionDetail, ShippingLocationDetails, ShippingServiceDetails, SiteDetails, etc).
	 */
	-(void)setDetailName:(NSString*)DetailName {
		[super setInput:@"DetailName" toValue:DetailName];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the UserToken input for this Choreo.
	*(required, string) A valid eBay Auth Token.
	 */
	-(void)setUserToken:(NSString*)UserToken {
		[super setInput:@"UserToken" toValue:UserToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetEbayDetails Choreo.
 */
@implementation TMBeBay_Trading_GetEbayDetails_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves the available meta-data for the specified eBay site.
 */
@implementation TMBeBay_Trading_GetEbayDetails

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_GetEbayDetails Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/GetEbayDetails"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_GetEbayDetails_ResultSet *results = [[TMBeBay_Trading_GetEbayDetails_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetEbayDetails Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_GetEbayDetails_Inputs*)newInputSet {
		return [[TMBeBay_Trading_GetEbayDetails_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetEbayOfficialTime Choreo.
 */
@implementation TMBeBay_Trading_GetEbayOfficialTime_Inputs

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the UserToken input for this Choreo.
	*(required, string) A valid eBay Auth Token.
	 */
	-(void)setUserToken:(NSString*)UserToken {
		[super setInput:@"UserToken" toValue:UserToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetEbayOfficialTime Choreo.
 */
@implementation TMBeBay_Trading_GetEbayOfficialTime_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Gets the official eBay system time in GMT.
 */
@implementation TMBeBay_Trading_GetEbayOfficialTime

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_GetEbayOfficialTime Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/GetEbayOfficialTime"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_GetEbayOfficialTime_ResultSet *results = [[TMBeBay_Trading_GetEbayOfficialTime_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetEbayOfficialTime Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_GetEbayOfficialTime_Inputs*)newInputSet {
		return [[TMBeBay_Trading_GetEbayOfficialTime_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetFeedback Choreo.
 */
@implementation TMBeBay_Trading_GetFeedback_Inputs

	/*!
	 * Set the value of the CommentType input for this Choreo.
	*(optional, string) Returns feedback of a specified type. Valid values are: Positive, Neutral, Negative, Withdrawn, IndependentlyWithdrawn.
	 */
	-(void)setCommentType:(NSString*)CommentType {
		[super setInput:@"CommentType" toValue:CommentType];
	}

	/*!
	 * Set the value of the DetailLevel input for this Choreo.
	*(optional, string) The response detail level. Valid values are: ReturnAll.
	 */
	-(void)setDetailLevel:(NSString*)DetailLevel {
		[super setInput:@"DetailLevel" toValue:DetailLevel];
	}

	/*!
	 * Set the value of the EntriesPerPage input for this Choreo.
	*(optional, integer) The maximum number of records to return in the result.
	 */
	-(void)setEntriesPerPage:(NSString*)EntriesPerPage {
		[super setInput:@"EntriesPerPage" toValue:EntriesPerPage];
	}

	/*!
	 * Set the value of the FeedbackID input for this Choreo.
	*(optional, string) An ID that uniquely identifies a feedback record to be retrieved
	 */
	-(void)setFeedbackID:(NSString*)FeedbackID {
		[super setInput:@"FeedbackID" toValue:FeedbackID];
	}

	/*!
	 * Set the value of the FeedbackType input for this Choreo.
	*(optional, string) The type of feedback to return. Valid values are: FeedbackReceivedAsSeller, FeedbackReceivedAsBuyer, FeedbackReceived, FeedbackLeft, CustomCode.
	 */
	-(void)setFeedbackType:(NSString*)FeedbackType {
		[super setInput:@"FeedbackType" toValue:FeedbackType];
	}

	/*!
	 * Set the value of the ItemID input for this Choreo.
	*(optional, string) The unique identifier for an eBay item listing.
	 */
	-(void)setItemID:(NSString*)ItemID {
		[super setInput:@"ItemID" toValue:ItemID];
	}

	/*!
	 * Set the value of the OrderLineItemID input for this Choreo.
	*(optional, string) The unique identifier for an eBay order line item. This id generated by concatenating ItemID and TransactionID with a hyphen in between the IDs.
	 */
	-(void)setOrderLineItemID:(NSString*)OrderLineItemID {
		[super setInput:@"OrderLineItemID" toValue:OrderLineItemID];
	}

	/*!
	 * Set the value of the PageNumber input for this Choreo.
	*(optional, integer) Specifies the page number of the results to return.
	 */
	-(void)setPageNumber:(NSString*)PageNumber {
		[super setInput:@"PageNumber" toValue:PageNumber];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the TransactionID input for this Choreo.
	*(optional, string) The unique identifier for an eBay order line item (transaction).
	 */
	-(void)setTransactionID:(NSString*)TransactionID {
		[super setInput:@"TransactionID" toValue:TransactionID];
	}

	/*!
	 * Set the value of the UserID input for this Choreo.
	*(conditional, string) The seller's UserID.
	 */
	-(void)setUserID:(NSString*)UserID {
		[super setInput:@"UserID" toValue:UserID];
	}

	/*!
	 * Set the value of the UserToken input for this Choreo.
	*(required, string) A valid eBay Auth Token.
	 */
	-(void)setUserToken:(NSString*)UserToken {
		[super setInput:@"UserToken" toValue:UserToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetFeedback Choreo.
 */
@implementation TMBeBay_Trading_GetFeedback_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves the feedback left for a specified user or the summary feedback data for a specific order line item or item listing.
 */
@implementation TMBeBay_Trading_GetFeedback

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_GetFeedback Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/GetFeedback"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_GetFeedback_ResultSet *results = [[TMBeBay_Trading_GetFeedback_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetFeedback Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_GetFeedback_Inputs*)newInputSet {
		return [[TMBeBay_Trading_GetFeedback_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetItem Choreo.
 */
@implementation TMBeBay_Trading_GetItem_Inputs

	/*!
	 * Set the value of the DetailLevel input for this Choreo.
	*(optional, string) The response detail level. Valid values are: ItemReturnAttributes, ItemReturnDescription, and ReturnAll.
	 */
	-(void)setDetailLevel:(NSString*)DetailLevel {
		[super setInput:@"DetailLevel" toValue:DetailLevel];
	}

	/*!
	 * Set the value of the IncludeItemSpecifics input for this Choreo.
	*(optional, boolean) If set to true, the response returns the ItemSpecifics node (if the listing has custom Item Specifics).
	 */
	-(void)setIncludeItemSpecifics:(NSString*)IncludeItemSpecifics {
		[super setInput:@"IncludeItemSpecifics" toValue:IncludeItemSpecifics];
	}

	/*!
	 * Set the value of the IncludeTaxTable input for this Choreo.
	*(optional, boolean) If set to true, an associated tax table is returned in the response.
	 */
	-(void)setIncludeTaxTable:(NSString*)IncludeTaxTable {
		[super setInput:@"IncludeTaxTable" toValue:IncludeTaxTable];
	}

	/*!
	 * Set the value of the IncludeWatchCount input for this Choreo.
	*(optional, boolean) Indicates if the caller wants to include watch count for that item in the response when set to true. Only the seller is allowed to use this argument.
	 */
	-(void)setIncludeWatchCount:(NSString*)IncludeWatchCount {
		[super setInput:@"IncludeWatchCount" toValue:IncludeWatchCount];
	}

	/*!
	 * Set the value of the ItemID input for this Choreo.
	*(required, string) The ItemID that uniquely identifies the item listing to retrieve.
	 */
	-(void)setItemID:(NSString*)ItemID {
		[super setInput:@"ItemID" toValue:ItemID];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the TransactionID input for this Choreo.
	*(optional, string) A unique identifier for a transaction (i.e.  an order line item). An order line item is created when the buyer commits to purchasing an item.
	 */
	-(void)setTransactionID:(NSString*)TransactionID {
		[super setInput:@"TransactionID" toValue:TransactionID];
	}

	/*!
	 * Set the value of the UserToken input for this Choreo.
	*(required, string) A valid eBay Auth Token.
	 */
	-(void)setUserToken:(NSString*)UserToken {
		[super setInput:@"UserToken" toValue:UserToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetItem Choreo.
 */
@implementation TMBeBay_Trading_GetItem_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "CurrentPrice" output from an execution of this Choreo.
	 * @return - NSString* (decimal) The current price for the item.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getCurrentPrice {
		return [super getOutputByName:@"CurrentPrice"];
	}

	/*!
	 * Retrieve the value of the "DaysLeft" output from an execution of this Choreo.
	 * @return - NSString* (integer) The number of days until the auction ends.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getDaysLeft {
		return [super getOutputByName:@"DaysLeft"];
	}

	/*!
	 * Retrieve the value of the "HoursLeft" output from an execution of this Choreo.
	 * @return - NSString* (integer) The number of hours until the auction ends.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getHoursLeft {
		return [super getOutputByName:@"HoursLeft"];
	}

	/*!
	 * Retrieve the value of the "MinutesLeft" output from an execution of this Choreo.
	 * @return - NSString* (integer) The number of minutes until the auction ends.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getMinutesLeft {
		return [super getOutputByName:@"MinutesLeft"];
	}

	/*!
	 * Retrieve the value of the "SecondsLeft" output from an execution of this Choreo.
	 * @return - NSString* (integer) The number of seconds until the auction ends.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getSecondsLeft {
		return [super getOutputByName:@"SecondsLeft"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns item data such as title, description, price information, and seller information.
 */
@implementation TMBeBay_Trading_GetItem

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_GetItem Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/GetItem"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_GetItem_ResultSet *results = [[TMBeBay_Trading_GetItem_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetItem Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_GetItem_Inputs*)newInputSet {
		return [[TMBeBay_Trading_GetItem_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetItemTransactions Choreo.
 */
@implementation TMBeBay_Trading_GetItemTransactions_Inputs

	/*!
	 * Set the value of the DetailLevel input for this Choreo.
	*(optional, string) The detail level of the response. Valid values are: ItemReturnDescription and ReturnAll.
	 */
	-(void)setDetailLevel:(NSString*)DetailLevel {
		[super setInput:@"DetailLevel" toValue:DetailLevel];
	}

	/*!
	 * Set the value of the EntriesPerPage input for this Choreo.
	*(optional, integer) The maximum number of records to return in the result.
	 */
	-(void)setEntriesPerPage:(NSString*)EntriesPerPage {
		[super setInput:@"EntriesPerPage" toValue:EntriesPerPage];
	}

	/*!
	 * Set the value of the IncludeContainingOrder input for this Choreo.
	*(optional, boolean) When set to true, the ContainingOrder container is returned in the response for each transaction node.
	 */
	-(void)setIncludeContainingOrder:(NSString*)IncludeContainingOrder {
		[super setInput:@"IncludeContainingOrder" toValue:IncludeContainingOrder];
	}

	/*!
	 * Set the value of the IncludeFinalValueFee input for this Choreo.
	*(optional, boolean) When set to true, the Final Value Fee (FVF) for all order line items is returned in the response.
	 */
	-(void)setIncludeFinalValueFee:(NSString*)IncludeFinalValueFee {
		[super setInput:@"IncludeFinalValueFee" toValue:IncludeFinalValueFee];
	}

	/*!
	 * Set the value of the IncludeVariations input for this Choreo.
	*(optional, boolean) When set to true, all variations defined for the item are returned at the root level.
	 */
	-(void)setIncludeVariations:(NSString*)IncludeVariations {
		[super setInput:@"IncludeVariations" toValue:IncludeVariations];
	}

	/*!
	 * Set the value of the ItemID input for this Choreo.
	*(required, string) The unique identifier for an eBay item listing.
	 */
	-(void)setItemID:(NSString*)ItemID {
		[super setInput:@"ItemID" toValue:ItemID];
	}

	/*!
	 * Set the value of the ModTimeFrom input for this Choreo.
	*(optional, date) Used to filter by date range (e.g., 2013-02-08T00:00:00.000Z).
	 */
	-(void)setModTimeFrom:(NSString*)ModTimeFrom {
		[super setInput:@"ModTimeFrom" toValue:ModTimeFrom];
	}

	/*!
	 * Set the value of the ModTimeTo input for this Choreo.
	*(optional, date) Used to filter by date range (e.g., 2013-02-08T00:00:00.000Z).
	 */
	-(void)setModTimeTo:(NSString*)ModTimeTo {
		[super setInput:@"ModTimeTo" toValue:ModTimeTo];
	}

	/*!
	 * Set the value of the NumberOfDays input for this Choreo.
	*(optional, integer) The number of days in the past to search for order line items.
	 */
	-(void)setNumberOfDays:(NSString*)NumberOfDays {
		[super setInput:@"NumberOfDays" toValue:NumberOfDays];
	}

	/*!
	 * Set the value of the OrderLineItemID input for this Choreo.
	*(optional, string) A unique identifier for an eBay order line item.
	 */
	-(void)setOrderLineItemID:(NSString*)OrderLineItemID {
		[super setInput:@"OrderLineItemID" toValue:OrderLineItemID];
	}

	/*!
	 * Set the value of the PageNumber input for this Choreo.
	*(optional, integer) Specifies the page number of the results to return.
	 */
	-(void)setPageNumber:(NSString*)PageNumber {
		[super setInput:@"PageNumber" toValue:PageNumber];
	}

	/*!
	 * Set the value of the Platform input for this Choreo.
	*(optional, string) The name of the eBay co-branded site upon which the order line item was created. Valid values are: eBay, Express, Half, Shopping, or WorldOfGood.
	 */
	-(void)setPlatform:(NSString*)Platform {
		[super setInput:@"Platform" toValue:Platform];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the TransactionID input for this Choreo.
	*(optional, string) Include a TransactionID field in the request if you want to retrieve the data for a specific order line item (transaction).
	 */
	-(void)setTransactionID:(NSString*)TransactionID {
		[super setInput:@"TransactionID" toValue:TransactionID];
	}

	/*!
	 * Set the value of the UserToken input for this Choreo.
	*(required, string) A valid eBay Auth Token.
	 */
	-(void)setUserToken:(NSString*)UserToken {
		[super setInput:@"UserToken" toValue:UserToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetItemTransactions Choreo.
 */
@implementation TMBeBay_Trading_GetItemTransactions_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves order line item (transaction) information for a specified ItemID.
 */
@implementation TMBeBay_Trading_GetItemTransactions

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_GetItemTransactions Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/GetItemTransactions"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_GetItemTransactions_ResultSet *results = [[TMBeBay_Trading_GetItemTransactions_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetItemTransactions Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_GetItemTransactions_Inputs*)newInputSet {
		return [[TMBeBay_Trading_GetItemTransactions_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetMemberMessages Choreo.
 */
@implementation TMBeBay_Trading_GetMemberMessages_Inputs

	/*!
	 * Set the value of the DisplayToPublic input for this Choreo.
	*(optional, boolean) When set to true, only public messages (viewable in the Item listing) are returned.
	 */
	-(void)setDisplayToPublic:(NSString*)DisplayToPublic {
		[super setInput:@"DisplayToPublic" toValue:DisplayToPublic];
	}

	/*!
	 * Set the value of the EndCreationTime input for this Choreo.
	*(optional, date) Used to filter by date range (e.g., 2013-02-08T00:00:00.000Z).
	 */
	-(void)setEndCreationTime:(NSString*)EndCreationTime {
		[super setInput:@"EndCreationTime" toValue:EndCreationTime];
	}

	/*!
	 * Set the value of the EntriesPerPage input for this Choreo.
	*(optional, integer) The maximum number of records to return in the result.
	 */
	-(void)setEntriesPerPage:(NSString*)EntriesPerPage {
		[super setInput:@"EntriesPerPage" toValue:EntriesPerPage];
	}

	/*!
	 * Set the value of the ItemID input for this Choreo.
	*(optional, string) The ID of the item the message is about.
	 */
	-(void)setItemID:(NSString*)ItemID {
		[super setInput:@"ItemID" toValue:ItemID];
	}

	/*!
	 * Set the value of the MailMessageType input for this Choreo.
	*(required, string) The type of message to retrieve. Valid values are: All and AskSellerQuestion. When set to AskSellerQuestion, ItemID or a date range filter must be specified.
	 */
	-(void)setMailMessageType:(NSString*)MailMessageType {
		[super setInput:@"MailMessageType" toValue:MailMessageType];
	}

	/*!
	 * Set the value of the MemberMessageID input for this Choreo.
	*(optional, string) An ID that uniquely identifies the message for a given user to be retrieved.
	 */
	-(void)setMemberMessageID:(NSString*)MemberMessageID {
		[super setInput:@"MemberMessageID" toValue:MemberMessageID];
	}

	/*!
	 * Set the value of the MessageStatus input for this Choreo.
	*(optional, string) The status of the message. Valid values are: Answered and Unanswered.
	 */
	-(void)setMessageStatus:(NSString*)MessageStatus {
		[super setInput:@"MessageStatus" toValue:MessageStatus];
	}

	/*!
	 * Set the value of the PageNumber input for this Choreo.
	*(optional, integer) Specifies the page number of the results to return.
	 */
	-(void)setPageNumber:(NSString*)PageNumber {
		[super setInput:@"PageNumber" toValue:PageNumber];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SenderID input for this Choreo.
	*(optional, string) The seller's UserID.
	 */
	-(void)setSenderID:(NSString*)SenderID {
		[super setInput:@"SenderID" toValue:SenderID];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the StartCreationTime input for this Choreo.
	*(optional, date) Used to filter by date range (e.g., 2013-02-08T00:00:00.000Z).
	 */
	-(void)setStartCreationTime:(NSString*)StartCreationTime {
		[super setInput:@"StartCreationTime" toValue:StartCreationTime];
	}

	/*!
	 * Set the value of the UserToken input for this Choreo.
	*(required, string) A valid eBay Auth Token.
	 */
	-(void)setUserToken:(NSString*)UserToken {
		[super setInput:@"UserToken" toValue:UserToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetMemberMessages Choreo.
 */
@implementation TMBeBay_Trading_GetMemberMessages_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves a list of the messages that buyers have posted about your active item listings.
 */
@implementation TMBeBay_Trading_GetMemberMessages

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_GetMemberMessages Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/GetMemberMessages"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_GetMemberMessages_ResultSet *results = [[TMBeBay_Trading_GetMemberMessages_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetMemberMessages Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_GetMemberMessages_Inputs*)newInputSet {
		return [[TMBeBay_Trading_GetMemberMessages_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetSellerTransactions Choreo.
 */
@implementation TMBeBay_Trading_GetSellerTransactions_Inputs

	/*!
	 * Set the value of the DetailLevel input for this Choreo.
	*(optional, string) The detail level of the response. Valid values are: ItemReturnDescription and ReturnAll.
	 */
	-(void)setDetailLevel:(NSString*)DetailLevel {
		[super setInput:@"DetailLevel" toValue:DetailLevel];
	}

	/*!
	 * Set the value of the EntriesPerPage input for this Choreo.
	*(optional, integer) The maximum number of records to return in the result.
	 */
	-(void)setEntriesPerPage:(NSString*)EntriesPerPage {
		[super setInput:@"EntriesPerPage" toValue:EntriesPerPage];
	}

	/*!
	 * Set the value of the IncludeCodiceFiscale input for this Choreo.
	*(optional, string) When set to 'true', the buyer's Codice Fiscale number is returned in the response.
	 */
	-(void)setIncludeCodiceFiscale:(NSString*)IncludeCodiceFiscale {
		[super setInput:@"IncludeCodiceFiscale" toValue:IncludeCodiceFiscale];
	}

	/*!
	 * Set the value of the IncludeContainingOrder input for this Choreo.
	*(optional, boolean) When set to true, the ContainingOrder container is returned in the response for each transaction node.
	 */
	-(void)setIncludeContainingOrder:(NSString*)IncludeContainingOrder {
		[super setInput:@"IncludeContainingOrder" toValue:IncludeContainingOrder];
	}

	/*!
	 * Set the value of the IncludeFinalValueFee input for this Choreo.
	*(optional, boolean) When set to true, the Final Value Fee (FVF) for all order line items is returned in the response.
	 */
	-(void)setIncludeFinalValueFee:(NSString*)IncludeFinalValueFee {
		[super setInput:@"IncludeFinalValueFee" toValue:IncludeFinalValueFee];
	}

	/*!
	 * Set the value of the InventoryTrackingMethod input for this Choreo.
	*(optional, boolean) Filters the response to only include order line items for listings that match this InventoryTrackingMethod setting. Valid values are: ItemID and SKU.
	 */
	-(void)setInventoryTrackingMethod:(NSString*)InventoryTrackingMethod {
		[super setInput:@"InventoryTrackingMethod" toValue:InventoryTrackingMethod];
	}

	/*!
	 * Set the value of the ModTimeFrom input for this Choreo.
	*(optional, date) Used to filter by date range (e.g., 2013-02-08T00:00:00.000Z).
	 */
	-(void)setModTimeFrom:(NSString*)ModTimeFrom {
		[super setInput:@"ModTimeFrom" toValue:ModTimeFrom];
	}

	/*!
	 * Set the value of the ModTimeTo input for this Choreo.
	*(optional, date) Used to filter by date range (e.g., 2013-02-08T00:00:00.000Z).
	 */
	-(void)setModTimeTo:(NSString*)ModTimeTo {
		[super setInput:@"ModTimeTo" toValue:ModTimeTo];
	}

	/*!
	 * Set the value of the NumberOfDays input for this Choreo.
	*(optional, integer) The number of days in the past to search for order line items.
	 */
	-(void)setNumberOfDays:(NSString*)NumberOfDays {
		[super setInput:@"NumberOfDays" toValue:NumberOfDays];
	}

	/*!
	 * Set the value of the PageNumber input for this Choreo.
	*(optional, integer) Specifies the page number of the results to return.
	 */
	-(void)setPageNumber:(NSString*)PageNumber {
		[super setInput:@"PageNumber" toValue:PageNumber];
	}

	/*!
	 * Set the value of the Platform input for this Choreo.
	*(optional, string) The name of the eBay co-branded site upon which the order line item was created. Valid values are: eBay, Express, Half, Shopping, or WorldOfGood.
	 */
	-(void)setPlatform:(NSString*)Platform {
		[super setInput:@"Platform" toValue:Platform];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SKU input for this Choreo.
	*(optional, string) One or more seller SKUs to filter the result. Multiple SKUs can be provided in a comma-separated list.
	 */
	-(void)setSKU:(NSString*)SKU {
		[super setInput:@"SKU" toValue:SKU];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the UserToken input for this Choreo.
	*(required, string) A valid eBay Auth Token.
	 */
	-(void)setUserToken:(NSString*)UserToken {
		[super setInput:@"UserToken" toValue:UserToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetSellerTransactions Choreo.
 */
@implementation TMBeBay_Trading_GetSellerTransactions_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves order line item (transaction) information for the authenticated user only.
 */
@implementation TMBeBay_Trading_GetSellerTransactions

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_GetSellerTransactions Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/GetSellerTransactions"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_GetSellerTransactions_ResultSet *results = [[TMBeBay_Trading_GetSellerTransactions_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetSellerTransactions Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_GetSellerTransactions_Inputs*)newInputSet {
		return [[TMBeBay_Trading_GetSellerTransactions_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetSessionID Choreo.
 */
@implementation TMBeBay_Trading_GetSessionID_Inputs

	/*!
	 * Set the value of the AppID input for this Choreo.
	*(required, string) The unique identifier for the application.
	 */
	-(void)setAppID:(NSString*)AppID {
		[super setInput:@"AppID" toValue:AppID];
	}

	/*!
	 * Set the value of the CertID input for this Choreo.
	*(required, string) The certificate that authenticates the application when making API calls.
	 */
	-(void)setCertID:(NSString*)CertID {
		[super setInput:@"CertID" toValue:CertID];
	}

	/*!
	 * Set the value of the DevID input for this Choreo.
	*(required, string) The unique identifier for the developer's account.
	 */
	-(void)setDevID:(NSString*)DevID {
		[super setInput:@"DevID" toValue:DevID];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the RuName input for this Choreo.
	*(required, string) Your application's RuName which identifies your application to eBay.
	 */
	-(void)setRuName:(NSString*)RuName {
		[super setInput:@"RuName" toValue:RuName];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetSessionID Choreo.
 */
@implementation TMBeBay_Trading_GetSessionID_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "AuthorizationURL" output from an execution of this Choreo.
	 * @return - NSString* (string) The URL that you can send the user to so that they can sign-in and approve the user consent form.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getAuthorizationURL {
		return [super getOutputByName:@"AuthorizationURL"];
	}

	/*!
	 * Retrieve the value of the "SessionID" output from an execution of this Choreo.
	 * @return - NSString* (string) The SessionID returned from eBay. This gets passed to the FetchToken Choreo after the user authorizes the request.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getSessionID {
		return [super getOutputByName:@"SessionID"];
	}

	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Generates an authorization URL that an application can use to complete the first step in the authentication process.
 */
@implementation TMBeBay_Trading_GetSessionID

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_GetSessionID Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/GetSessionID"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_GetSessionID_ResultSet *results = [[TMBeBay_Trading_GetSessionID_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetSessionID Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_GetSessionID_Inputs*)newInputSet {
		return [[TMBeBay_Trading_GetSessionID_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetUser Choreo.
 */
@implementation TMBeBay_Trading_GetUser_Inputs

	/*!
	 * Set the value of the DetailLevel input for this Choreo.
	*(optional, string) The level of detail to return in the response. Valid values are: ReturnAll or ReturnSummary.
	 */
	-(void)setDetailLevel:(NSString*)DetailLevel {
		[super setInput:@"DetailLevel" toValue:DetailLevel];
	}

	/*!
	 * Set the value of the IncludeFeatureEligibility input for this Choreo.
	*(optional, boolean) Whether or not to include feature eligibility information in the response. Set to true or false.
	 */
	-(void)setIncludeFeatureEligibility:(NSString*)IncludeFeatureEligibility {
		[super setInput:@"IncludeFeatureEligibility" toValue:IncludeFeatureEligibility];
	}

	/*!
	 * Set the value of the ItemID input for this Choreo.
	*(optional, string) The ID of the item of a successfully concluded listing in which the requestor and target user were participants as buyer and seller.
	 */
	-(void)setItemID:(NSString*)ItemID {
		[super setInput:@"ItemID" toValue:ItemID];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the UserID input for this Choreo.
	*(optional, string) The eBay User ID for the user whose data you want to retrieve.
	 */
	-(void)setUserID:(NSString*)UserID {
		[super setInput:@"UserID" toValue:UserID];
	}

	/*!
	 * Set the value of the UserToken input for this Choreo.
	*(required, string) A valid eBay Auth Token.
	 */
	-(void)setUserToken:(NSString*)UserToken {
		[super setInput:@"UserToken" toValue:UserToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetUser Choreo.
 */
@implementation TMBeBay_Trading_GetUser_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Retrieves data pertaining to a single eBay user.
 */
@implementation TMBeBay_Trading_GetUser

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_GetUser Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/GetUser"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_GetUser_ResultSet *results = [[TMBeBay_Trading_GetUser_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetUser Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_GetUser_Inputs*)newInputSet {
		return [[TMBeBay_Trading_GetUser_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the LeaveFeedback Choreo.
 */
@implementation TMBeBay_Trading_LeaveFeedback_Inputs

	/*!
	 * Set the value of the LeaveFeedbackRequest input for this Choreo.
	*(optional, xml) The complete XML request body containing properties you wish to set. This can be used as an alternative to individual inputs that represent request properties.
	 */
	-(void)setLeaveFeedbackRequest:(NSString*)LeaveFeedbackRequest {
		[super setInput:@"LeaveFeedbackRequest" toValue:LeaveFeedbackRequest];
	}

	/*!
	 * Set the value of the CommentText input for this Choreo.
	*(conditional, string) The comment text to leave Feedback about the buyer.
	 */
	-(void)setCommentText:(NSString*)CommentText {
		[super setInput:@"CommentText" toValue:CommentText];
	}

	/*!
	 * Set the value of the CommentType input for this Choreo.
	*(conditional, string) The type of comment. Valid values are: Positive, Negative, and Neutral.
	 */
	-(void)setCommentType:(NSString*)CommentType {
		[super setInput:@"CommentType" toValue:CommentType];
	}

	/*!
	 * Set the value of the ItemID input for this Choreo.
	*(conditional, string) The unique identifier for an eBay item listing that was sold. Required unless OrderLineItemID is specified.
	 */
	-(void)setItemID:(NSString*)ItemID {
		[super setInput:@"ItemID" toValue:ItemID];
	}

	/*!
	 * Set the value of the OrderLineItemID input for this Choreo.
	*(optional, string) This is a unique identifier for an eBay order line item and is based upon the concatenation of ItemID and TransactionID, with a hyphen in between these two IDs.
	 */
	-(void)setOrderLineItemID:(NSString*)OrderLineItemID {
		[super setInput:@"OrderLineItemID" toValue:OrderLineItemID];
	}

	/*!
	 * Set the value of the Rating input for this Choreo.
	*(conditional, integer) A detailed numeric rating (1 through 5) for an order line item. This rating is applied to the subject provided for RatingDetail.
	 */
	-(void)setRating:(NSString*)Rating {
		[super setInput:@"Rating" toValue:Rating];
	}

	/*!
	 * Set the value of the RatingDetail input for this Choreo.
	*(conditional, string) The subject that is being rated. Valid values are: Communication, ItemAsDescribed, ShippingAndHandlingCharges, and ShippingTime.
	 */
	-(void)setRatingDetail:(NSString*)RatingDetail {
		[super setInput:@"RatingDetail" toValue:RatingDetail];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the TargetUser input for this Choreo.
	*(conditional, string) The user ID of the buyer who you want to leave feedback for.
	 */
	-(void)setTargetUser:(NSString*)TargetUser {
		[super setInput:@"TargetUser" toValue:TargetUser];
	}

	/*!
	 * Set the value of the TransactionID input for this Choreo.
	*(optional, string) The unique identifier for an eBay order line item (transaction). Required when there are multiple order ine items between the two order partners that require feedback.
	 */
	-(void)setTransactionID:(NSString*)TransactionID {
		[super setInput:@"TransactionID" toValue:TransactionID];
	}

	/*!
	 * Set the value of the UserToken input for this Choreo.
	*(required, string) A valid eBay Auth Token.
	 */
	-(void)setUserToken:(NSString*)UserToken {
		[super setInput:@"UserToken" toValue:UserToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the LeaveFeedback Choreo.
 */
@implementation TMBeBay_Trading_LeaveFeedback_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Enables a buyer and seller to leave feedback for their order partner at the conclusion of a successful order.
 */
@implementation TMBeBay_Trading_LeaveFeedback

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_LeaveFeedback Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/LeaveFeedback"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_LeaveFeedback_ResultSet *results = [[TMBeBay_Trading_LeaveFeedback_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the LeaveFeedback Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_LeaveFeedback_Inputs*)newInputSet {
		return [[TMBeBay_Trading_LeaveFeedback_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the PlaceOffer Choreo.
 */
@implementation TMBeBay_Trading_PlaceOffer_Inputs

	/*!
	 * Set the value of the PlaceOfferRequest input for this Choreo.
	*(optional, xml) The complete XML request body containing properties you wish to set. This can be used as an alternative to individual inputs that represent request properties.
	 */
	-(void)setPlaceOfferRequest:(NSString*)PlaceOfferRequest {
		[super setInput:@"PlaceOfferRequest" toValue:PlaceOfferRequest];
	}

	/*!
	 * Set the value of the Action input for this Choreo.
	*(conditional, string) Indicates the type of offer being made on the specified listing. Valid values are: Bid, Purchase, Accept, Counter, Decline, or Offer.
	 */
	-(void)setAction:(NSString*)Action {
		[super setInput:@"Action" toValue:Action];
	}

	/*!
	 * Set the value of the BestOfferID input for this Choreo.
	*(conditional, string) The ID of a Best Offer on an item. Required if Action is set to Accept or Decline.
	 */
	-(void)setBestOfferID:(NSString*)BestOfferID {
		[super setInput:@"BestOfferID" toValue:BestOfferID];
	}

	/*!
	 * Set the value of the DetailLevel input for this Choreo.
	*(optional, string) The response detail level. Valid values are: ItemReturnAttributes, ItemReturnDescription, and ReturnAll.
	 */
	-(void)setDetailLevel:(NSString*)DetailLevel {
		[super setInput:@"DetailLevel" toValue:DetailLevel];
	}

	/*!
	 * Set the value of the EndUserIP input for this Choreo.
	*(conditional, string) The public IP address of the machine from which the request is sent.
	 */
	-(void)setEndUserIP:(NSString*)EndUserIP {
		[super setInput:@"EndUserIP" toValue:EndUserIP];
	}

	/*!
	 * Set the value of the ItemID input for this Choreo.
	*(conditional, string) The ItemID that uniquely identifies the item listing to bid on.
	 */
	-(void)setItemID:(NSString*)ItemID {
		[super setInput:@"ItemID" toValue:ItemID];
	}

	/*!
	 * Set the value of the MaxBid input for this Choreo.
	*(conditional, decimal) The amount of the offer placed on the listing.
	 */
	-(void)setMaxBid:(NSString*)MaxBid {
		[super setInput:@"MaxBid" toValue:MaxBid];
	}

	/*!
	 * Set the value of the Message input for this Choreo.
	*(conditional, string) A message from the buyer to the seller.
	 */
	-(void)setMessage:(NSString*)Message {
		[super setInput:@"Message" toValue:Message];
	}

	/*!
	 * Set the value of the Quantity input for this Choreo.
	*(conditional, integer) Specifies the number of items from the specified listing that the user intends to purchase. For auctions, this must be set to 1.
	 */
	-(void)setQuantity:(NSString*)Quantity {
		[super setInput:@"Quantity" toValue:Quantity];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the UserConsent input for this Choreo.
	*(conditional, boolean) When set to true, confirms that the bidder read and agrees to eBay's privacy policy.
	 */
	-(void)setUserConsent:(NSString*)UserConsent {
		[super setInput:@"UserConsent" toValue:UserConsent];
	}

	/*!
	 * Set the value of the UserToken input for this Choreo.
	*(required, string) A valid eBay Auth Token.
	 */
	-(void)setUserToken:(NSString*)UserToken {
		[super setInput:@"UserToken" toValue:UserToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the PlaceOffer Choreo.
 */
@implementation TMBeBay_Trading_PlaceOffer_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Allows an authenticated user to to make a bid, a best offer, or a purchase on the item specified by the ItemID input field.
 */
@implementation TMBeBay_Trading_PlaceOffer

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_PlaceOffer Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/PlaceOffer"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_PlaceOffer_ResultSet *results = [[TMBeBay_Trading_PlaceOffer_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the PlaceOffer Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_PlaceOffer_Inputs*)newInputSet {
		return [[TMBeBay_Trading_PlaceOffer_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ReviseItem Choreo.
 */
@implementation TMBeBay_Trading_ReviseItem_Inputs

	/*!
	 * Set the value of the ReviseItemRequest input for this Choreo.
	*(optional, xml) The complete XML request body containing item properties you wish to set. This can be used as an alternative to individual inputs that represent item properties.
	 */
	-(void)setReviseItemRequest:(NSString*)ReviseItemRequest {
		[super setInput:@"ReviseItemRequest" toValue:ReviseItemRequest];
	}

	/*!
	 * Set the value of the BuyItNowPrice input for this Choreo.
	*(optional, decimal) Allows a user to purchase the item at a Buy It Now price and end the auction immediately.
	 */
	-(void)setBuyItNowPrice:(NSString*)BuyItNowPrice {
		[super setInput:@"BuyItNowPrice" toValue:BuyItNowPrice];
	}

	/*!
	 * Set the value of the CategoryID input for this Choreo.
	*(optional, integer) The numeric ID for a category on eBay. Category IDs can be retrieved with the GetCategories Choreo.
	 */
	-(void)setCategoryID:(NSString*)CategoryID {
		[super setInput:@"CategoryID" toValue:CategoryID];
	}

	/*!
	 * Set the value of the ConditionID input for this Choreo.
	*(optional, integer) The numeric ID (e.g., 1000) for the item condition.
	 */
	-(void)setConditionID:(NSString*)ConditionID {
		[super setInput:@"ConditionID" toValue:ConditionID];
	}

	/*!
	 * Set the value of the Country input for this Choreo.
	*(optional, string) The country that the item is located in.
	 */
	-(void)setCountry:(NSString*)Country {
		[super setInput:@"Country" toValue:Country];
	}

	/*!
	 * Set the value of the Currency input for this Choreo.
	*(optional, string) The currency associated with the item price.
	 */
	-(void)setCurrency:(NSString*)Currency {
		[super setInput:@"Currency" toValue:Currency];
	}

	/*!
	 * Set the value of the DispatchTimeMax input for this Choreo.
	*(optional, integer) Specifies the maximum number of business days the seller commits to for preparing an item to be shipped after receiving a cleared payment.
	 */
	-(void)setDispatchTimeMax:(NSString*)DispatchTimeMax {
		[super setInput:@"DispatchTimeMax" toValue:DispatchTimeMax];
	}

	/*!
	 * Set the value of the ExpeditedService input for this Choreo.
	*(optional, boolean) Whether or not the seller is offering expedited shipping service options.
	 */
	-(void)setExpeditedService:(NSString*)ExpeditedService {
		[super setInput:@"ExpeditedService" toValue:ExpeditedService];
	}

	/*!
	 * Set the value of the ItemDescription input for this Choreo.
	*(optional, string) The seller's description of the item.
	 */
	-(void)setItemDescription:(NSString*)ItemDescription {
		[super setInput:@"ItemDescription" toValue:ItemDescription];
	}

	/*!
	 * Set the value of the ItemID input for this Choreo.
	*(conditional, string) The ID of the item to revise.
	 */
	-(void)setItemID:(NSString*)ItemID {
		[super setInput:@"ItemID" toValue:ItemID];
	}

	/*!
	 * Set the value of the ListingDuration input for this Choreo.
	*(optional, string) The number of days the seller wants the listing to be active (e.g., Days_7). A complete list of accepted values is returned when calling GetCategoryFeatures with DetailLevel set to ReturnAll.
	 */
	-(void)setListingDuration:(NSString*)ListingDuration {
		[super setInput:@"ListingDuration" toValue:ListingDuration];
	}

	/*!
	 * Set the value of the ListingType input for this Choreo.
	*(optional, string) The format of the listing the seller wants to use. Valid values are: AdType, Chinese, FixedPriceItem, Half, LeadGeneration.
	 */
	-(void)setListingType:(NSString*)ListingType {
		[super setInput:@"ListingType" toValue:ListingType];
	}

	/*!
	 * Set the value of the PayPalEmailAddress input for this Choreo.
	*(optional, string) The seller's PayPal email address. Required when a PaymentMethod is PayPal.
	 */
	-(void)setPayPalEmailAddress:(NSString*)PayPalEmailAddress {
		[super setInput:@"PayPalEmailAddress" toValue:PayPalEmailAddress];
	}

	/*!
	 * Set the value of the PaymentMethods input for this Choreo.
	*(optional, string) Identifies the payment method (such as PayPal) that the seller will accept when the buyer pays for the item. This can be a comma-separated list (e.g., VisaMC,PayPal).
	 */
	-(void)setPaymentMethods:(NSString*)PaymentMethods {
		[super setInput:@"PaymentMethods" toValue:PaymentMethods];
	}

	/*!
	 * Set the value of the PictureURL input for this Choreo.
	*(optional, string) The URL for a picture associated with an item. Multiple URLs can be specified as a comma-separated list.
	 */
	-(void)setPictureURL:(NSString*)PictureURL {
		[super setInput:@"PictureURL" toValue:PictureURL];
	}

	/*!
	 * Set the value of the PostalCode input for this Choreo.
	*(optional, string) The Postal code of the place where the item is located.
	 */
	-(void)setPostalCode:(NSString*)PostalCode {
		[super setInput:@"PostalCode" toValue:PostalCode];
	}

	/*!
	 * Set the value of the Quantity input for this Choreo.
	*(optional, integer) Indicates the quantity of items available for purchase in the listing. Required for all auction listings and for non-variation, fixed-price listings. For auction listings, this value is always '1'.
	 */
	-(void)setQuantity:(NSString*)Quantity {
		[super setInput:@"Quantity" toValue:Quantity];
	}

	/*!
	 * Set the value of the RefundOption input for this Choreo.
	*(optional, string) Indicates how the seller will compensate the buyer for a returned item (e.g. MoneyBack).
	 */
	-(void)setRefundOption:(NSString*)RefundOption {
		[super setInput:@"RefundOption" toValue:RefundOption];
	}

	/*!
	 * Set the value of the ReservePrice input for this Choreo.
	*(optional, decimal) The lowest price at which the seller is willing to sell the item.
	 */
	-(void)setReservePrice:(NSString*)ReservePrice {
		[super setInput:@"ReservePrice" toValue:ReservePrice];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the ReturnPolicyDescription input for this Choreo.
	*(optional, string) The text description of return policy details.
	 */
	-(void)setReturnPolicyDescription:(NSString*)ReturnPolicyDescription {
		[super setInput:@"ReturnPolicyDescription" toValue:ReturnPolicyDescription];
	}

	/*!
	 * Set the value of the ReturnsAcceptedOption input for this Choreo.
	*(optional, string) Indicates whether the seller allows the buyer to return the item (e.g., ReturnsAccepted).
	 */
	-(void)setReturnsAcceptedOption:(NSString*)ReturnsAcceptedOption {
		[super setInput:@"ReturnsAcceptedOption" toValue:ReturnsAcceptedOption];
	}

	/*!
	 * Set the value of the ReturnsWithinOption input for this Choreo.
	*(optional, string) The period of time the buyer has to return the item (e.g., Days_14). To accepted values for this field, call GeteBayDetails with DetailName set to ReturnPolicyDetails.
	 */
	-(void)setReturnsWithinOption:(NSString*)ReturnsWithinOption {
		[super setInput:@"ReturnsWithinOption" toValue:ReturnsWithinOption];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the ShippingService input for this Choreo.
	*(optional, string) The name of the shipping service offered (e.g. UPSGround, USPSMedia).
	 */
	-(void)setShippingService:(NSString*)ShippingService {
		[super setInput:@"ShippingService" toValue:ShippingService];
	}

	/*!
	 * Set the value of the ShippingServiceAdditionalCost input for this Choreo.
	*(optional, decimal) Shipping costs in addition to the value specified for the ShippingServiceCost parameter.
	 */
	-(void)setShippingServiceAdditionalCost:(NSString*)ShippingServiceAdditionalCost {
		[super setInput:@"ShippingServiceAdditionalCost" toValue:ShippingServiceAdditionalCost];
	}

	/*!
	 * Set the value of the ShippingServiceCost input for this Choreo.
	*(optional, decimal) The cost for shipping the item.
	 */
	-(void)setShippingServiceCost:(NSString*)ShippingServiceCost {
		[super setInput:@"ShippingServiceCost" toValue:ShippingServiceCost];
	}

	/*!
	 * Set the value of the ShippingType input for this Choreo.
	*(optional, string) The shipping cost model offered by the seller. Valid values are: Calculated, CalculatedDomesticFlatInternational, Flat, FlatDomesticCalculatedInternational, FreightFlat, NotSpecified.
	 */
	-(void)setShippingType:(NSString*)ShippingType {
		[super setInput:@"ShippingType" toValue:ShippingType];
	}

	/*!
	 * Set the value of the Site input for this Choreo.
	*(optional, string) The name of the site on which the item is listed. This should corresponse to the SiteID. Default value is "US".
	 */
	-(void)setSite:(NSString*)Site {
		[super setInput:@"Site" toValue:Site];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the StartPrice input for this Choreo.
	*(optional, decimal) This value indicates the starting price of the item when it is listed for the first time.
	 */
	-(void)setStartPrice:(NSString*)StartPrice {
		[super setInput:@"StartPrice" toValue:StartPrice];
	}

	/*!
	 * Set the value of the Title input for this Choreo.
	*(optional, string) The title of the item as it appears in the listing or search results.
	 */
	-(void)setTitle:(NSString*)Title {
		[super setInput:@"Title" toValue:Title];
	}

	/*!
	 * Set the value of the UserToken input for this Choreo.
	*(required, string) A valid eBay Auth Token.
	 */
	-(void)setUserToken:(NSString*)UserToken {
		[super setInput:@"UserToken" toValue:UserToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ReviseItem Choreo.
 */
@implementation TMBeBay_Trading_ReviseItem_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Allows a seller to change the properties of a currently active listing.
 */
@implementation TMBeBay_Trading_ReviseItem

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_ReviseItem Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/ReviseItem"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_ReviseItem_ResultSet *results = [[TMBeBay_Trading_ReviseItem_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ReviseItem Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_ReviseItem_Inputs*)newInputSet {
		return [[TMBeBay_Trading_ReviseItem_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UploadSiteHostedPictures Choreo.
 */
@implementation TMBeBay_Trading_UploadSiteHostedPictures_Inputs

	/*!
	 * Set the value of the ExtensionInDays input for this Choreo.
	*(optional, integer) The number of days to extend the expiration date for the specified image, after a listing has ended.
	 */
	-(void)setExtensionInDays:(NSString*)ExtensionInDays {
		[super setInput:@"ExtensionInDays" toValue:ExtensionInDays];
	}

	/*!
	 * Set the value of the ExternalPictureURL input for this Choreo.
	*(conditional, string) The URL of an image to upload. Required unless providing PictureData. Max image size is 7 MB. Max URL length is 1024. Formats supported are: JPG, GIF, PNG, BMP, and TIF.
	 */
	-(void)setExternalPictureURL:(NSString*)ExternalPictureURL {
		[super setInput:@"ExternalPictureURL" toValue:ExternalPictureURL];
	}

	/*!
	 * Set the value of the PictureData input for this Choreo.
	*(conditional, string) The Base64 encoded string for an the image data. Required unless providing the ExternalPictureURL. Max image size is 7 MB. Formats supported are: JPG, GIF, PNG, BMP, and TIF.
	 */
	-(void)setPictureData:(NSString*)PictureData {
		[super setInput:@"PictureData" toValue:PictureData];
	}

	/*!
	 * Set the value of the PictureName input for this Choreo.
	*(optional, string) The name of the picture.
	 */
	-(void)setPictureName:(NSString*)PictureName {
		[super setInput:@"PictureName" toValue:PictureName];
	}

	/*!
	 * Set the value of the PictureSet input for this Choreo.
	*(optional, string) The image sizes that will be generated. Valid values are: Standard and Supersize.
	 */
	-(void)setPictureSet:(NSString*)PictureSet {
		[super setInput:@"PictureSet" toValue:PictureSet];
	}

	/*!
	 * Set the value of the PictureUploadPolicy input for this Choreo.
	*(optional, string) Indicates that an uploaded picture is available to a seller on the eBay site. Valid values are: Add and ClearAndAdd.
	 */
	-(void)setPictureUploadPolicy:(NSString*)PictureUploadPolicy {
		[super setInput:@"PictureUploadPolicy" toValue:PictureUploadPolicy];
	}

	/*!
	 * Set the value of the PictureWatermark input for this Choreo.
	*(optional, string) The type of watermark that should be applied to the pictures hosted by the eBay Picture Services. Valid values are: User and Icon.
	 */
	-(void)setPictureWatermark:(NSString*)PictureWatermark {
		[super setInput:@"PictureWatermark" toValue:PictureWatermark];
	}

	/*!
	 * Set the value of the ResponseFormat input for this Choreo.
	*(optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
	 */
	-(void)setResponseFormat:(NSString*)ResponseFormat {
		[super setInput:@"ResponseFormat" toValue:ResponseFormat];
	}

	/*!
	 * Set the value of the SandboxMode input for this Choreo.
	*(conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
	 */
	-(void)setSandboxMode:(NSString*)SandboxMode {
		[super setInput:@"SandboxMode" toValue:SandboxMode];
	}

	/*!
	 * Set the value of the SiteID input for this Choreo.
	*(optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
	 */
	-(void)setSiteID:(NSString*)SiteID {
		[super setInput:@"SiteID" toValue:SiteID];
	}

	/*!
	 * Set the value of the UserToken input for this Choreo.
	*(required, string) A valid eBay Auth Token.
	 */
	-(void)setUserToken:(NSString*)UserToken {
		[super setInput:@"UserToken" toValue:UserToken];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UploadSiteHostedPictures Choreo.
 */
@implementation TMBeBay_Trading_UploadSiteHostedPictures_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* The response from eBay.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Allows you to uploads a picture to eBay Picture Services by specifying a binary attachment or image URL.
 */
@implementation TMBeBay_Trading_UploadSiteHostedPictures

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBeBay_Trading_UploadSiteHostedPictures Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/eBay/Trading/UploadSiteHostedPictures"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBeBay_Trading_UploadSiteHostedPictures_ResultSet *results = [[TMBeBay_Trading_UploadSiteHostedPictures_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UploadSiteHostedPictures Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBeBay_Trading_UploadSiteHostedPictures_Inputs*)newInputSet {
		return [[TMBeBay_Trading_UploadSiteHostedPictures_Inputs alloc] init];
	}
@end
	