/*!
 * @header Temboo iOS SDK Plotly classes
 *
 * Execute Choreographies from the Temboo Plotly bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import <Foundation/Foundation.h>
#import "TMBChoreography.h"

@class TMBTembooSession;

/*! group TMBPlotly.ConfigureGraph Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ConfigureGraph Choreo.
 */
@interface TMBPlotly_ConfigureGraph_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setFileName:(NSString*)FileName;
	-(void)setFileOption:(NSString*)FileOption;
	-(void)setGraphArguments:(NSString*)GraphArguments;
	-(void)setLayout:(NSString*)Layout;
	-(void)setOrigin:(NSString*)Origin;
	-(void)setStyle:(NSString*)Style;
	-(void)setTraces:(NSString*)Traces;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorldReadable:(NSString*)WorldReadable;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ConfigureGraph Choreo.
 */
@interface TMBPlotly_ConfigureGraph_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getURL;
	-(NSString*)getResponse;	
@end

/*!
 * Creates, modifies, or styles a graph.
 */
@interface TMBPlotly_ConfigureGraph : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPlotly_ConfigureGraph_Inputs*)newInputSet;
@end

/*! group TMBPlotly_ConfigureGraph Choreo */


/*! group TMBPlotly.ExtendBarGraph Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ExtendBarGraph Choreo.
 */
@interface TMBPlotly_ExtendBarGraph_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setFileName:(NSString*)FileName;
	-(void)setTitle:(NSString*)Title;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorldReadable:(NSString*)WorldReadable;
	-(void)setXValue:(NSString*)XValue;
	-(void)setYValue:(NSString*)YValue;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ExtendBarGraph Choreo.
 */
@interface TMBPlotly_ExtendBarGraph_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getURL;
	-(NSString*)getResponse;	
@end

/*!
 * Extends the specified bar graph by plotting a single addition point.
 */
@interface TMBPlotly_ExtendBarGraph : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPlotly_ExtendBarGraph_Inputs*)newInputSet;
@end

/*! group TMBPlotly_ExtendBarGraph Choreo */


/*! group TMBPlotly.ExtendLineGraph Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ExtendLineGraph Choreo.
 */
@interface TMBPlotly_ExtendLineGraph_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setFileName:(NSString*)FileName;
	-(void)setTitle:(NSString*)Title;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorldReadable:(NSString*)WorldReadable;
	-(void)setXValue:(NSString*)XValue;
	-(void)setYValue:(NSString*)YValue;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ExtendLineGraph Choreo.
 */
@interface TMBPlotly_ExtendLineGraph_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getURL;
	-(NSString*)getResponse;	
@end

/*!
 * Extends the specified line graph by plotting a single addition point.
 */
@interface TMBPlotly_ExtendLineGraph : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPlotly_ExtendLineGraph_Inputs*)newInputSet;
@end

/*! group TMBPlotly_ExtendLineGraph Choreo */


/*! group TMBPlotly.ExtendTimeSeries Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ExtendTimeSeries Choreo.
 */
@interface TMBPlotly_ExtendTimeSeries_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setFileName:(NSString*)FileName;
	-(void)setTimeZone:(NSString*)TimeZone;
	-(void)setTitle:(NSString*)Title;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorldReadable:(NSString*)WorldReadable;
	-(void)setXValue:(NSString*)XValue;
	-(void)setYValue:(NSString*)YValue;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ExtendTimeSeries Choreo.
 */
@interface TMBPlotly_ExtendTimeSeries_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getURL;
	-(NSString*)getResponse;	
@end

/*!
 * Extends the specified time series graph by plotting a single addition point.
 */
@interface TMBPlotly_ExtendTimeSeries : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPlotly_ExtendTimeSeries_Inputs*)newInputSet;
@end

/*! group TMBPlotly_ExtendTimeSeries Choreo */


/*! group TMBPlotly.PlotBarGraph Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the PlotBarGraph Choreo.
 */
@interface TMBPlotly_PlotBarGraph_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setFileName:(NSString*)FileName;
	-(void)setFileOption:(NSString*)FileOption;
	-(void)setTitle:(NSString*)Title;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorldReadable:(NSString*)WorldReadable;
	-(void)setXValues:(NSString*)XValues;
	-(void)setYValues:(NSString*)YValues;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the PlotBarGraph Choreo.
 */
@interface TMBPlotly_PlotBarGraph_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getURL;
	-(NSString*)getResponse;	
@end

/*!
 * Plots an array of points on a bar graph.
 */
@interface TMBPlotly_PlotBarGraph : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPlotly_PlotBarGraph_Inputs*)newInputSet;
@end

/*! group TMBPlotly_PlotBarGraph Choreo */


/*! group TMBPlotly.PlotLineGraph Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the PlotLineGraph Choreo.
 */
@interface TMBPlotly_PlotLineGraph_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setFileName:(NSString*)FileName;
	-(void)setFileOption:(NSString*)FileOption;
	-(void)setTitle:(NSString*)Title;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorldReadable:(NSString*)WorldReadable;
	-(void)setXValues:(NSString*)XValues;
	-(void)setYValues:(NSString*)YValues;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the PlotLineGraph Choreo.
 */
@interface TMBPlotly_PlotLineGraph_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getURL;
	-(NSString*)getResponse;	
@end

/*!
 * Plots an array of points on a line graph.
 */
@interface TMBPlotly_PlotLineGraph : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPlotly_PlotLineGraph_Inputs*)newInputSet;
@end

/*! group TMBPlotly_PlotLineGraph Choreo */


/*! group TMBPlotly.PlotTimeSeries Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the PlotTimeSeries Choreo.
 */
@interface TMBPlotly_PlotTimeSeries_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setFileName:(NSString*)FileName;
	-(void)setFileOption:(NSString*)FileOption;
	-(void)setTitle:(NSString*)Title;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorldReadable:(NSString*)WorldReadable;
	-(void)setXValues:(NSString*)XValues;
	-(void)setYValues:(NSString*)YValues;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the PlotTimeSeries Choreo.
 */
@interface TMBPlotly_PlotTimeSeries_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getURL;
	-(NSString*)getResponse;	
@end

/*!
 * Plots an array of time series data on a graph.
 */
@interface TMBPlotly_PlotTimeSeries : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBPlotly_PlotTimeSeries_Inputs*)newInputSet;
@end

/*! group TMBPlotly_PlotTimeSeries Choreo */
