/*!
 * @TMBPagerDuty.m
 *
 * Execute Choreographies from the Temboo PagerDuty bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import "TMBPagerDuty.h"
#import "TMBChoreography_Protected.h"
#import "TMBChoreographyExecution.h"
#import "TMBTembooSession.h"
#import "TMBTembooUri.h"


/*!
 * Input object with appropriate setters for specifying arguments to the ListAlerts Choreo.
 */
@implementation TMBPagerDuty_Alerts_ListAlerts_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by PagerDuty.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the Filter input for this Choreo.
	*(optional, string) Returns only alerts of this type. Valid types are: SMS, Email, Phone, or Push.
	 */
	-(void)setFilter:(NSString*)Filter {
		[super setInput:@"Filter" toValue:Filter];
	}

	/*!
	 * Set the value of the Since input for this Choreo.
	*(required, date) The start of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
	 */
	-(void)setSince:(NSString*)Since {
		[super setInput:@"Since" toValue:Since];
	}

	/*!
	 * Set the value of the SubDomain input for this Choreo.
	*(required, string) The subdomain of your PagerDuty site address.
	 */
	-(void)setSubDomain:(NSString*)SubDomain {
		[super setInput:@"SubDomain" toValue:SubDomain];
	}

	/*!
	 * Set the value of the TimeZone input for this Choreo.
	*(optional, string) The time zone in which dates in the result will be rendered. Defaults to account time zone.
	 */
	-(void)setTimeZone:(NSString*)TimeZone {
		[super setInput:@"TimeZone" toValue:TimeZone];
	}

	/*!
	 * Set the value of the Until input for this Choreo.
	*(required, date) The end of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
	 */
	-(void)setUntil:(NSString*)Until {
		[super setInput:@"Until" toValue:Until];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListAlerts Choreo.
 */
@implementation TMBPagerDuty_Alerts_ListAlerts_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from PagerDuty.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * List alerts for a given time range and allows you to filter by type.
 */
@implementation TMBPagerDuty_Alerts_ListAlerts

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPagerDuty_Alerts_ListAlerts Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/PagerDuty/Alerts/ListAlerts"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPagerDuty_Alerts_ListAlerts_ResultSet *results = [[TMBPagerDuty_Alerts_ListAlerts_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListAlerts Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPagerDuty_Alerts_ListAlerts_Inputs*)newInputSet {
		return [[TMBPagerDuty_Alerts_ListAlerts_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AcknowledgeEvent Choreo.
 */
@implementation TMBPagerDuty_Events_AcknowledgeEvent_Inputs

	/*!
	 * Set the value of the Description input for this Choreo.
	*(optional, string) A short description that will appear in the incident's log associated with this event.
	 */
	-(void)setDescription:(NSString*)Description {
		[super setInput:@"Description" toValue:Description];
	}

	/*!
	 * Set the value of the Details input for this Choreo.
	*(optional, json) A JSON object containing any data you'd like included in the incident log.
	 */
	-(void)setDetails:(NSString*)Details {
		[super setInput:@"Details" toValue:Details];
	}

	/*!
	 * Set the value of the IncidentKey input for this Choreo.
	*(required, string) Identifies the incident to acknowledge.
	 */
	-(void)setIncidentKey:(NSString*)IncidentKey {
		[super setInput:@"IncidentKey" toValue:IncidentKey];
	}

	/*!
	 * Set the value of the ServiceKey input for this Choreo.
	*(required, string) The service key of one of your "Generic API" services. This is listed on a Generic API's service detail page.
	 */
	-(void)setServiceKey:(NSString*)ServiceKey {
		[super setInput:@"ServiceKey" toValue:ServiceKey];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AcknowledgeEvent Choreo.
 */
@implementation TMBPagerDuty_Events_AcknowledgeEvent_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from PagerDuty.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Updates the state of an incident to "acknowleged", and allows you to log data to an incident log.
 */
@implementation TMBPagerDuty_Events_AcknowledgeEvent

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPagerDuty_Events_AcknowledgeEvent Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/PagerDuty/Events/AcknowledgeEvent"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPagerDuty_Events_AcknowledgeEvent_ResultSet *results = [[TMBPagerDuty_Events_AcknowledgeEvent_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AcknowledgeEvent Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPagerDuty_Events_AcknowledgeEvent_Inputs*)newInputSet {
		return [[TMBPagerDuty_Events_AcknowledgeEvent_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ResolveEvent Choreo.
 */
@implementation TMBPagerDuty_Events_ResolveEvent_Inputs

	/*!
	 * Set the value of the Description input for this Choreo.
	*(optional, string) A short description that will appear in the incident's log associated with this event.
	 */
	-(void)setDescription:(NSString*)Description {
		[super setInput:@"Description" toValue:Description];
	}

	/*!
	 * Set the value of the Details input for this Choreo.
	*(optional, json) A JSON object containing any data you'd like included in the incident log.
	 */
	-(void)setDetails:(NSString*)Details {
		[super setInput:@"Details" toValue:Details];
	}

	/*!
	 * Set the value of the IncidentKey input for this Choreo.
	*(required, string) Identifies the incident to resolve.
	 */
	-(void)setIncidentKey:(NSString*)IncidentKey {
		[super setInput:@"IncidentKey" toValue:IncidentKey];
	}

	/*!
	 * Set the value of the ServiceKey input for this Choreo.
	*(required, string) The service key of one of your "Generic API" services. This is listed on a Generic API's service detail page.
	 */
	-(void)setServiceKey:(NSString*)ServiceKey {
		[super setInput:@"ServiceKey" toValue:ServiceKey];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ResolveEvent Choreo.
 */
@implementation TMBPagerDuty_Events_ResolveEvent_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from PagerDuty.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Updates the state of an incident to "resolved", and allows you to log data to an incident log.
 */
@implementation TMBPagerDuty_Events_ResolveEvent

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPagerDuty_Events_ResolveEvent Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/PagerDuty/Events/ResolveEvent"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPagerDuty_Events_ResolveEvent_ResultSet *results = [[TMBPagerDuty_Events_ResolveEvent_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ResolveEvent Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPagerDuty_Events_ResolveEvent_Inputs*)newInputSet {
		return [[TMBPagerDuty_Events_ResolveEvent_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the TriggerEvent Choreo.
 */
@implementation TMBPagerDuty_Events_TriggerEvent_Inputs

	/*!
	 * Set the value of the Description input for this Choreo.
	*(required, string) A short description of the problem that led to this trigger. The maximum length is 1024 characters.
	 */
	-(void)setDescription:(NSString*)Description {
		[super setInput:@"Description" toValue:Description];
	}

	/*!
	 * Set the value of the Details input for this Choreo.
	*(required, json) A JSON object containing the data you'd like included in the incident log.
	 */
	-(void)setDetails:(NSString*)Details {
		[super setInput:@"Details" toValue:Details];
	}

	/*!
	 * Set the value of the IncidentKey input for this Choreo.
	*(optional, string) Identifies the incident to which this trigger event should be applied. If there's no open incident with this key, a new one will be created.
	 */
	-(void)setIncidentKey:(NSString*)IncidentKey {
		[super setInput:@"IncidentKey" toValue:IncidentKey];
	}

	/*!
	 * Set the value of the ServiceKey input for this Choreo.
	*(required, string) The service key of one of your "Generic API" services. This is listed on a Generic API's service detail page.
	 */
	-(void)setServiceKey:(NSString*)ServiceKey {
		[super setInput:@"ServiceKey" toValue:ServiceKey];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the TriggerEvent Choreo.
 */
@implementation TMBPagerDuty_Events_TriggerEvent_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from PagerDuty.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Triggers an event that will open a new incident or log an entry to an existing incident.
 */
@implementation TMBPagerDuty_Events_TriggerEvent

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPagerDuty_Events_TriggerEvent Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/PagerDuty/Events/TriggerEvent"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPagerDuty_Events_TriggerEvent_ResultSet *results = [[TMBPagerDuty_Events_TriggerEvent_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the TriggerEvent Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPagerDuty_Events_TriggerEvent_Inputs*)newInputSet {
		return [[TMBPagerDuty_Events_TriggerEvent_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AcknowledgeIncident Choreo.
 */
@implementation TMBPagerDuty_Incidents_AcknowledgeIncident_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by PagerDuty.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the IncidentID input for this Choreo.
	*(required, string) The ID of the incident to acknowledge.
	 */
	-(void)setIncidentID:(NSString*)IncidentID {
		[super setInput:@"IncidentID" toValue:IncidentID];
	}

	/*!
	 * Set the value of the RequesterID input for this Choreo.
	*(required, string) The ID of the user making the request. This will be added to the incident log entry.
	 */
	-(void)setRequesterID:(NSString*)RequesterID {
		[super setInput:@"RequesterID" toValue:RequesterID];
	}

	/*!
	 * Set the value of the SubDomain input for this Choreo.
	*(required, string) The subdomain of your PagerDuty site address.
	 */
	-(void)setSubDomain:(NSString*)SubDomain {
		[super setInput:@"SubDomain" toValue:SubDomain];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AcknowledgeIncident Choreo.
 */
@implementation TMBPagerDuty_Incidents_AcknowledgeIncident_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from PagerDuty.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Acknowledges an incident.
 */
@implementation TMBPagerDuty_Incidents_AcknowledgeIncident

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPagerDuty_Incidents_AcknowledgeIncident Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/PagerDuty/Incidents/AcknowledgeIncident"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPagerDuty_Incidents_AcknowledgeIncident_ResultSet *results = [[TMBPagerDuty_Incidents_AcknowledgeIncident_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AcknowledgeIncident Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPagerDuty_Incidents_AcknowledgeIncident_Inputs*)newInputSet {
		return [[TMBPagerDuty_Incidents_AcknowledgeIncident_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the CountIncidents Choreo.
 */
@implementation TMBPagerDuty_Incidents_CountIncidents_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by PagerDuty.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the AssignedToUser input for this Choreo.
	*(optional, string) Returns the count of incidents assigned to the specified user.
	 */
	-(void)setAssignedToUser:(NSString*)AssignedToUser {
		[super setInput:@"AssignedToUser" toValue:AssignedToUser];
	}

	/*!
	 * Set the value of the DateRange input for this Choreo.
	*(optional, string) When set to "all", this allows you to retrieve the count of all incidents since the account was created.
	 */
	-(void)setDateRange:(NSString*)DateRange {
		[super setInput:@"DateRange" toValue:DateRange];
	}

	/*!
	 * Set the value of the IncidentKey input for this Choreo.
	*(optional, string) Returns the count of incidents with the specified key.
	 */
	-(void)setIncidentKey:(NSString*)IncidentKey {
		[super setInput:@"IncidentKey" toValue:IncidentKey];
	}

	/*!
	 * Set the value of the Service input for this Choreo.
	*(optional, string) Returns the count of incidents associated with the specified service.
	 */
	-(void)setService:(NSString*)Service {
		[super setInput:@"Service" toValue:Service];
	}

	/*!
	 * Set the value of the Since input for this Choreo.
	*(optional, date) The start of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
	 */
	-(void)setSince:(NSString*)Since {
		[super setInput:@"Since" toValue:Since];
	}

	/*!
	 * Set the value of the Status input for this Choreo.
	*(optional, string) Returns the count of incidents with this specified status. Valid values are: triggered, acknowledged, and resolved.
	 */
	-(void)setStatus:(NSString*)Status {
		[super setInput:@"Status" toValue:Status];
	}

	/*!
	 * Set the value of the SubDomain input for this Choreo.
	*(required, string) The subdomain of your PagerDuty site address.
	 */
	-(void)setSubDomain:(NSString*)SubDomain {
		[super setInput:@"SubDomain" toValue:SubDomain];
	}

	/*!
	 * Set the value of the Until input for this Choreo.
	*(optional, date) The end of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
	 */
	-(void)setUntil:(NSString*)Until {
		[super setInput:@"Until" toValue:Until];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CountIncidents Choreo.
 */
@implementation TMBPagerDuty_Incidents_CountIncidents_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from PagerDuty.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns a count of incidents that match a specified criteria.
 */
@implementation TMBPagerDuty_Incidents_CountIncidents

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPagerDuty_Incidents_CountIncidents Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/PagerDuty/Incidents/CountIncidents"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPagerDuty_Incidents_CountIncidents_ResultSet *results = [[TMBPagerDuty_Incidents_CountIncidents_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the CountIncidents Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPagerDuty_Incidents_CountIncidents_Inputs*)newInputSet {
		return [[TMBPagerDuty_Incidents_CountIncidents_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetIncident Choreo.
 */
@implementation TMBPagerDuty_Incidents_GetIncident_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by PagerDuty.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the IncidentID input for this Choreo.
	*(required, string) An incident ID, or an incident number.
	 */
	-(void)setIncidentID:(NSString*)IncidentID {
		[super setInput:@"IncidentID" toValue:IncidentID];
	}

	/*!
	 * Set the value of the SubDomain input for this Choreo.
	*(required, string) The subdomain of your PagerDuty site address.
	 */
	-(void)setSubDomain:(NSString*)SubDomain {
		[super setInput:@"SubDomain" toValue:SubDomain];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetIncident Choreo.
 */
@implementation TMBPagerDuty_Incidents_GetIncident_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from PagerDuty.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns detailed information about a specified incident.
 */
@implementation TMBPagerDuty_Incidents_GetIncident

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPagerDuty_Incidents_GetIncident Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/PagerDuty/Incidents/GetIncident"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPagerDuty_Incidents_GetIncident_ResultSet *results = [[TMBPagerDuty_Incidents_GetIncident_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetIncident Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPagerDuty_Incidents_GetIncident_Inputs*)newInputSet {
		return [[TMBPagerDuty_Incidents_GetIncident_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListIncidents Choreo.
 */
@implementation TMBPagerDuty_Incidents_ListIncidents_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by PagerDuty.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the AssignedToUser input for this Choreo.
	*(optional, string) Returns only incidents assigned to the specified user.
	 */
	-(void)setAssignedToUser:(NSString*)AssignedToUser {
		[super setInput:@"AssignedToUser" toValue:AssignedToUser];
	}

	/*!
	 * Set the value of the DateRange input for this Choreo.
	*(optional, string) When set to "all", this allows you to retrieve all incidents since the account was created.
	 */
	-(void)setDateRange:(NSString*)DateRange {
		[super setInput:@"DateRange" toValue:DateRange];
	}

	/*!
	 * Set the value of the Fields input for this Choreo.
	*(optional, string) Allows you to select specific incident properties to be returned in the response.
	 */
	-(void)setFields:(NSString*)Fields {
		[super setInput:@"Fields" toValue:Fields];
	}

	/*!
	 * Set the value of the IncidentKey input for this Choreo.
	*(optional, string) Returns only incidents with the specified key.
	 */
	-(void)setIncidentKey:(NSString*)IncidentKey {
		[super setInput:@"IncidentKey" toValue:IncidentKey];
	}

	/*!
	 * Set the value of the Limit input for this Choreo.
	*(optional, integer) The number of incidents returned. Default (and max limit) is 100.
	 */
	-(void)setLimit:(NSString*)Limit {
		[super setInput:@"Limit" toValue:Limit];
	}

	/*!
	 * Set the value of the Offset input for this Choreo.
	*(optional, integer) The offset of the first incident record returned. Default is 0.
	 */
	-(void)setOffset:(NSString*)Offset {
		[super setInput:@"Offset" toValue:Offset];
	}

	/*!
	 * Set the value of the Service input for this Choreo.
	*(optional, string) Returns only incidents associated with the specified service.
	 */
	-(void)setService:(NSString*)Service {
		[super setInput:@"Service" toValue:Service];
	}

	/*!
	 * Set the value of the Since input for this Choreo.
	*(optional, date) The start of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
	 */
	-(void)setSince:(NSString*)Since {
		[super setInput:@"Since" toValue:Since];
	}

	/*!
	 * Set the value of the SortBy input for this Choreo.
	*(optional, string) Used to specify both the field you wish to sort the results on (incident_number, created_on, or resolved_on), as well as the direction (asc/desc) of the results (e.g., created_on:desc).
	 */
	-(void)setSortBy:(NSString*)SortBy {
		[super setInput:@"SortBy" toValue:SortBy];
	}

	/*!
	 * Set the value of the Status input for this Choreo.
	*(optional, string) Returns only the incidents with this specified status. Valid values are: triggered, acknowledged, and resolved.
	 */
	-(void)setStatus:(NSString*)Status {
		[super setInput:@"Status" toValue:Status];
	}

	/*!
	 * Set the value of the SubDomain input for this Choreo.
	*(required, string) The subdomain of your PagerDuty site address.
	 */
	-(void)setSubDomain:(NSString*)SubDomain {
		[super setInput:@"SubDomain" toValue:SubDomain];
	}

	/*!
	 * Set the value of the TimeZone input for this Choreo.
	*(optional, string) The time zone in which dates in the result will be rendered. Defaults to account time zone.
	 */
	-(void)setTimeZone:(NSString*)TimeZone {
		[super setInput:@"TimeZone" toValue:TimeZone];
	}

	/*!
	 * Set the value of the Until input for this Choreo.
	*(optional, date) The end of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
	 */
	-(void)setUntil:(NSString*)Until {
		[super setInput:@"Until" toValue:Until];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListIncidents Choreo.
 */
@implementation TMBPagerDuty_Incidents_ListIncidents_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from PagerDuty.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Allows you to list or search PagerDuty incidents.
 */
@implementation TMBPagerDuty_Incidents_ListIncidents

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPagerDuty_Incidents_ListIncidents Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/PagerDuty/Incidents/ListIncidents"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPagerDuty_Incidents_ListIncidents_ResultSet *results = [[TMBPagerDuty_Incidents_ListIncidents_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListIncidents Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPagerDuty_Incidents_ListIncidents_Inputs*)newInputSet {
		return [[TMBPagerDuty_Incidents_ListIncidents_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ReassignIncident Choreo.
 */
@implementation TMBPagerDuty_Incidents_ReassignIncident_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by PagerDuty.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the AssignedToUser input for this Choreo.
	*(required, string) Assigns this incident to the specified user id.
	 */
	-(void)setAssignedToUser:(NSString*)AssignedToUser {
		[super setInput:@"AssignedToUser" toValue:AssignedToUser];
	}

	/*!
	 * Set the value of the EscalationLevel input for this Choreo.
	*(optional, integer) Escalates the incident to this level in the escalation policy.
	 */
	-(void)setEscalationLevel:(NSString*)EscalationLevel {
		[super setInput:@"EscalationLevel" toValue:EscalationLevel];
	}

	/*!
	 * Set the value of the IncidentID input for this Choreo.
	*(required, string) The ID of the incident to reassign.
	 */
	-(void)setIncidentID:(NSString*)IncidentID {
		[super setInput:@"IncidentID" toValue:IncidentID];
	}

	/*!
	 * Set the value of the RequesterID input for this Choreo.
	*(required, string) The ID of the user making the request. This will be added to the incident log entry.
	 */
	-(void)setRequesterID:(NSString*)RequesterID {
		[super setInput:@"RequesterID" toValue:RequesterID];
	}

	/*!
	 * Set the value of the SubDomain input for this Choreo.
	*(required, string) The subdomain of your PagerDuty site address.
	 */
	-(void)setSubDomain:(NSString*)SubDomain {
		[super setInput:@"SubDomain" toValue:SubDomain];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ReassignIncident Choreo.
 */
@implementation TMBPagerDuty_Incidents_ReassignIncident_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from PagerDuty.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Reassigns an incident.
 */
@implementation TMBPagerDuty_Incidents_ReassignIncident

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPagerDuty_Incidents_ReassignIncident Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/PagerDuty/Incidents/ReassignIncident"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPagerDuty_Incidents_ReassignIncident_ResultSet *results = [[TMBPagerDuty_Incidents_ReassignIncident_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ReassignIncident Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPagerDuty_Incidents_ReassignIncident_Inputs*)newInputSet {
		return [[TMBPagerDuty_Incidents_ReassignIncident_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ResolveIncident Choreo.
 */
@implementation TMBPagerDuty_Incidents_ResolveIncident_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by PagerDuty.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the IncidentID input for this Choreo.
	*(required, string) The ID of the incident to resolve.
	 */
	-(void)setIncidentID:(NSString*)IncidentID {
		[super setInput:@"IncidentID" toValue:IncidentID];
	}

	/*!
	 * Set the value of the RequesterID input for this Choreo.
	*(required, string) The ID of the user making the request. This will be added to the incident log entry.
	 */
	-(void)setRequesterID:(NSString*)RequesterID {
		[super setInput:@"RequesterID" toValue:RequesterID];
	}

	/*!
	 * Set the value of the SubDomain input for this Choreo.
	*(required, string) The subdomain of your PagerDuty site address.
	 */
	-(void)setSubDomain:(NSString*)SubDomain {
		[super setInput:@"SubDomain" toValue:SubDomain];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ResolveIncident Choreo.
 */
@implementation TMBPagerDuty_Incidents_ResolveIncident_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from PagerDuty.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Resolves an incident.
 */
@implementation TMBPagerDuty_Incidents_ResolveIncident

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPagerDuty_Incidents_ResolveIncident Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/PagerDuty/Incidents/ResolveIncident"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPagerDuty_Incidents_ResolveIncident_ResultSet *results = [[TMBPagerDuty_Incidents_ResolveIncident_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ResolveIncident Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPagerDuty_Incidents_ResolveIncident_Inputs*)newInputSet {
		return [[TMBPagerDuty_Incidents_ResolveIncident_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the UpdateIncidents Choreo.
 */
@implementation TMBPagerDuty_Incidents_UpdateIncidents_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by PagerDuty.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the Incidents input for this Choreo.
	*(required, json) An array of incident objects that each include an incident ID. Other optional incident properties that can be present include: status, escalation_level, assigned_to_user, and escalation_policy.
	 */
	-(void)setIncidents:(NSString*)Incidents {
		[super setInput:@"Incidents" toValue:Incidents];
	}

	/*!
	 * Set the value of the RequesterID input for this Choreo.
	*(required, string) The ID of the user making the request. This will be added to the incident log entry.
	 */
	-(void)setRequesterID:(NSString*)RequesterID {
		[super setInput:@"RequesterID" toValue:RequesterID];
	}

	/*!
	 * Set the value of the SubDomain input for this Choreo.
	*(required, string) The subdomain of your PagerDuty site address.
	 */
	-(void)setSubDomain:(NSString*)SubDomain {
		[super setInput:@"SubDomain" toValue:SubDomain];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateIncidents Choreo.
 */
@implementation TMBPagerDuty_Incidents_UpdateIncidents_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from PagerDuty.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Allows you to acknowledge, resolve, escalate or reassign one or more incidents.
 */
@implementation TMBPagerDuty_Incidents_UpdateIncidents

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPagerDuty_Incidents_UpdateIncidents Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/PagerDuty/Incidents/UpdateIncidents"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPagerDuty_Incidents_UpdateIncidents_ResultSet *results = [[TMBPagerDuty_Incidents_UpdateIncidents_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the UpdateIncidents Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPagerDuty_Incidents_UpdateIncidents_Inputs*)newInputSet {
		return [[TMBPagerDuty_Incidents_UpdateIncidents_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the GetLogEntry Choreo.
 */
@implementation TMBPagerDuty_LogEntries_GetLogEntry_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by PagerDuty.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the LogEntryID input for this Choreo.
	*(required, string) The ID of the log entry to return.
	 */
	-(void)setLogEntryID:(NSString*)LogEntryID {
		[super setInput:@"LogEntryID" toValue:LogEntryID];
	}

	/*!
	 * Set the value of the SubDomain input for this Choreo.
	*(required, string) The subdomain of your PagerDuty site address.
	 */
	-(void)setSubDomain:(NSString*)SubDomain {
		[super setInput:@"SubDomain" toValue:SubDomain];
	}

	/*!
	 * Set the value of the TimeZone input for this Choreo.
	*(optional, string) The time zone in which dates in the result will be rendered. Defaults to account time zone.
	 */
	-(void)setTimeZone:(NSString*)TimeZone {
		[super setInput:@"TimeZone" toValue:TimeZone];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLogEntry Choreo.
 */
@implementation TMBPagerDuty_LogEntries_GetLogEntry_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from PagerDuty.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns details for a specific incident log entry.
 */
@implementation TMBPagerDuty_LogEntries_GetLogEntry

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPagerDuty_LogEntries_GetLogEntry Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/PagerDuty/LogEntries/GetLogEntry"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPagerDuty_LogEntries_GetLogEntry_ResultSet *results = [[TMBPagerDuty_LogEntries_GetLogEntry_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the GetLogEntry Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPagerDuty_LogEntries_GetLogEntry_Inputs*)newInputSet {
		return [[TMBPagerDuty_LogEntries_GetLogEntry_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListLogEntries Choreo.
 */
@implementation TMBPagerDuty_LogEntries_ListLogEntries_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by PagerDuty.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the Include input for this Choreo.
	*(optional, string) A list of additional details to include in the response. Valid values are: channel, incident, and service.
	 */
	-(void)setInclude:(NSString*)Include {
		[super setInput:@"Include" toValue:Include];
	}

	/*!
	 * Set the value of the IsOverview input for this Choreo.
	*(optional, boolean) If set to true, only log entries of type trigger, acknowledge, or resolve are returned. Defaults to false.
	 */
	-(void)setIsOverview:(NSString*)IsOverview {
		[super setInput:@"IsOverview" toValue:IsOverview];
	}

	/*!
	 * Set the value of the Limit input for this Choreo.
	*(optional, integer) The number of log entries returned. Default (and max limit) is 100.
	 */
	-(void)setLimit:(NSString*)Limit {
		[super setInput:@"Limit" toValue:Limit];
	}

	/*!
	 * Set the value of the Offset input for this Choreo.
	*(optional, integer) The offset of the first log entry record returned. Default is 0.
	 */
	-(void)setOffset:(NSString*)Offset {
		[super setInput:@"Offset" toValue:Offset];
	}

	/*!
	 * Set the value of the Since input for this Choreo.
	*(optional, date) The start of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
	 */
	-(void)setSince:(NSString*)Since {
		[super setInput:@"Since" toValue:Since];
	}

	/*!
	 * Set the value of the SubDomain input for this Choreo.
	*(required, string) The subdomain of your PagerDuty site address.
	 */
	-(void)setSubDomain:(NSString*)SubDomain {
		[super setInput:@"SubDomain" toValue:SubDomain];
	}

	/*!
	 * Set the value of the TimeZone input for this Choreo.
	*(optional, string) The time zone in which dates in the result will be rendered. Defaults to account time zone.
	 */
	-(void)setTimeZone:(NSString*)TimeZone {
		[super setInput:@"TimeZone" toValue:TimeZone];
	}

	/*!
	 * Set the value of the Until input for this Choreo.
	*(optional, date) The end of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
	 */
	-(void)setUntil:(NSString*)Until {
		[super setInput:@"Until" toValue:Until];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListLogEntries Choreo.
 */
@implementation TMBPagerDuty_LogEntries_ListLogEntries_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from PagerDuty.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Lists all incident log entries across an entire account.
 */
@implementation TMBPagerDuty_LogEntries_ListLogEntries

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPagerDuty_LogEntries_ListLogEntries Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/PagerDuty/LogEntries/ListLogEntries"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPagerDuty_LogEntries_ListLogEntries_ResultSet *results = [[TMBPagerDuty_LogEntries_ListLogEntries_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListLogEntries Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPagerDuty_LogEntries_ListLogEntries_Inputs*)newInputSet {
		return [[TMBPagerDuty_LogEntries_ListLogEntries_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListLogEntriesByIncident Choreo.
 */
@implementation TMBPagerDuty_LogEntries_ListLogEntriesByIncident_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by PagerDuty.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the IncidentID input for this Choreo.
	*(required, string) The ID of the incident associated with the log entries to retrieve.
	 */
	-(void)setIncidentID:(NSString*)IncidentID {
		[super setInput:@"IncidentID" toValue:IncidentID];
	}

	/*!
	 * Set the value of the Include input for this Choreo.
	*(optional, string) A list of additional details to include in the response. Valid values are: channel, incident, and service.
	 */
	-(void)setInclude:(NSString*)Include {
		[super setInput:@"Include" toValue:Include];
	}

	/*!
	 * Set the value of the IsOverview input for this Choreo.
	*(optional, boolean) If set to true, only log entries of type trigger, acknowledge, or resolve are returned. Defaults to false.
	 */
	-(void)setIsOverview:(NSString*)IsOverview {
		[super setInput:@"IsOverview" toValue:IsOverview];
	}

	/*!
	 * Set the value of the Limit input for this Choreo.
	*(optional, integer) The number of log events returned. Default (and max limit) is 100.
	 */
	-(void)setLimit:(NSString*)Limit {
		[super setInput:@"Limit" toValue:Limit];
	}

	/*!
	 * Set the value of the Offset input for this Choreo.
	*(optional, integer) The offset of the first log event record returned. Default is 0.
	 */
	-(void)setOffset:(NSString*)Offset {
		[super setInput:@"Offset" toValue:Offset];
	}

	/*!
	 * Set the value of the Since input for this Choreo.
	*(optional, date) The start of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
	 */
	-(void)setSince:(NSString*)Since {
		[super setInput:@"Since" toValue:Since];
	}

	/*!
	 * Set the value of the SubDomain input for this Choreo.
	*(required, string) The subdomain of your PagerDuty site address.
	 */
	-(void)setSubDomain:(NSString*)SubDomain {
		[super setInput:@"SubDomain" toValue:SubDomain];
	}

	/*!
	 * Set the value of the TimeZone input for this Choreo.
	*(optional, string) The time zone in which dates in the result will be rendered. Defaults to account time zone.
	 */
	-(void)setTimeZone:(NSString*)TimeZone {
		[super setInput:@"TimeZone" toValue:TimeZone];
	}

	/*!
	 * Set the value of the Until input for this Choreo.
	*(optional, date) The end of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
	 */
	-(void)setUntil:(NSString*)Until {
		[super setInput:@"Until" toValue:Until];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListLogEntriesByIncident Choreo.
 */
@implementation TMBPagerDuty_LogEntries_ListLogEntriesByIncident_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from PagerDuty.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Lists all incident log entries associated with a specific incident.
 */
@implementation TMBPagerDuty_LogEntries_ListLogEntriesByIncident

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPagerDuty_LogEntries_ListLogEntriesByIncident Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/PagerDuty/LogEntries/ListLogEntriesByIncident"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPagerDuty_LogEntries_ListLogEntriesByIncident_ResultSet *results = [[TMBPagerDuty_LogEntries_ListLogEntriesByIncident_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListLogEntriesByIncident Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPagerDuty_LogEntries_ListLogEntriesByIncident_Inputs*)newInputSet {
		return [[TMBPagerDuty_LogEntries_ListLogEntriesByIncident_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the ListLogEntriesByUser Choreo.
 */
@implementation TMBPagerDuty_LogEntries_ListLogEntriesByUser_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by PagerDuty.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the Include input for this Choreo.
	*(optional, string) A list of additional details to include in the response. Valid values are: channel, incident, and service.
	 */
	-(void)setInclude:(NSString*)Include {
		[super setInput:@"Include" toValue:Include];
	}

	/*!
	 * Set the value of the IsOverview input for this Choreo.
	*(optional, boolean) If set to true, only log entries of type trigger, acknowledge, or resolve are returned. Defaults to false.
	 */
	-(void)setIsOverview:(NSString*)IsOverview {
		[super setInput:@"IsOverview" toValue:IsOverview];
	}

	/*!
	 * Set the value of the Limit input for this Choreo.
	*(optional, integer) The number of log events returned. Default (and max limit) is 100.
	 */
	-(void)setLimit:(NSString*)Limit {
		[super setInput:@"Limit" toValue:Limit];
	}

	/*!
	 * Set the value of the Offset input for this Choreo.
	*(optional, integer) The offset of the first log event record returned. Default is 0.
	 */
	-(void)setOffset:(NSString*)Offset {
		[super setInput:@"Offset" toValue:Offset];
	}

	/*!
	 * Set the value of the Since input for this Choreo.
	*(optional, date) The start of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
	 */
	-(void)setSince:(NSString*)Since {
		[super setInput:@"Since" toValue:Since];
	}

	/*!
	 * Set the value of the SubDomain input for this Choreo.
	*(required, string) The subdomain of your PagerDuty site address.
	 */
	-(void)setSubDomain:(NSString*)SubDomain {
		[super setInput:@"SubDomain" toValue:SubDomain];
	}

	/*!
	 * Set the value of the TimeZone input for this Choreo.
	*(optional, string) The time zone in which dates in the result will be rendered. Defaults to account time zone.
	 */
	-(void)setTimeZone:(NSString*)TimeZone {
		[super setInput:@"TimeZone" toValue:TimeZone];
	}

	/*!
	 * Set the value of the Until input for this Choreo.
	*(optional, date) The end of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
	 */
	-(void)setUntil:(NSString*)Until {
		[super setInput:@"Until" toValue:Until];
	}

	/*!
	 * Set the value of the UserID input for this Choreo.
	*(required, string) The ID of the user associated with the log entries to retrieve.
	 */
	-(void)setUserID:(NSString*)UserID {
		[super setInput:@"UserID" toValue:UserID];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListLogEntriesByUser Choreo.
 */
@implementation TMBPagerDuty_LogEntries_ListLogEntriesByUser_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from PagerDuty.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Lists all incident log entries associated with a specific user.
 */
@implementation TMBPagerDuty_LogEntries_ListLogEntriesByUser

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPagerDuty_LogEntries_ListLogEntriesByUser Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/PagerDuty/LogEntries/ListLogEntriesByUser"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPagerDuty_LogEntries_ListLogEntriesByUser_ResultSet *results = [[TMBPagerDuty_LogEntries_ListLogEntriesByUser_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the ListLogEntriesByUser Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPagerDuty_LogEntries_ListLogEntriesByUser_Inputs*)newInputSet {
		return [[TMBPagerDuty_LogEntries_ListLogEntriesByUser_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the AlertsPerTime Choreo.
 */
@implementation TMBPagerDuty_Reports_AlertsPerTime_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by PagerDuty.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the Rollup input for this Choreo.
	*(optional, string) Used to rollup totals by time period. Valid values are: daily, weekly, or monthly.
	 */
	-(void)setRollup:(NSString*)Rollup {
		[super setInput:@"Rollup" toValue:Rollup];
	}

	/*!
	 * Set the value of the Since input for this Choreo.
	*(required, date) The start of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
	 */
	-(void)setSince:(NSString*)Since {
		[super setInput:@"Since" toValue:Since];
	}

	/*!
	 * Set the value of the SubDomain input for this Choreo.
	*(required, string) The subdomain of your PagerDuty site address.
	 */
	-(void)setSubDomain:(NSString*)SubDomain {
		[super setInput:@"SubDomain" toValue:SubDomain];
	}

	/*!
	 * Set the value of the Until input for this Choreo.
	*(required, date) The end of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
	 */
	-(void)setUntil:(NSString*)Until {
		[super setInput:@"Until" toValue:Until];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AlertsPerTime Choreo.
 */
@implementation TMBPagerDuty_Reports_AlertsPerTime_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from PagerDuty.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns high-level statistics about the number of alerts sent for a specified time period.
 */
@implementation TMBPagerDuty_Reports_AlertsPerTime

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPagerDuty_Reports_AlertsPerTime Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/PagerDuty/Reports/AlertsPerTime"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPagerDuty_Reports_AlertsPerTime_ResultSet *results = [[TMBPagerDuty_Reports_AlertsPerTime_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the AlertsPerTime Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPagerDuty_Reports_AlertsPerTime_Inputs*)newInputSet {
		return [[TMBPagerDuty_Reports_AlertsPerTime_Inputs alloc] init];
	}
@end



/*!
 * Input object with appropriate setters for specifying arguments to the IncidentsPerTime Choreo.
 */
@implementation TMBPagerDuty_Reports_IncidentsPerTime_Inputs

	/*!
	 * Set the value of the APIKey input for this Choreo.
	*(required, string) The API Key provided by PagerDuty.
	 */
	-(void)setAPIKey:(NSString*)APIKey {
		[super setInput:@"APIKey" toValue:APIKey];
	}

	/*!
	 * Set the value of the Rollup input for this Choreo.
	*(optional, string) Used to rollup totals by time period. Valid values are: daily, weekly, or monthly.
	 */
	-(void)setRollup:(NSString*)Rollup {
		[super setInput:@"Rollup" toValue:Rollup];
	}

	/*!
	 * Set the value of the Since input for this Choreo.
	*(required, date) The start of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
	 */
	-(void)setSince:(NSString*)Since {
		[super setInput:@"Since" toValue:Since];
	}

	/*!
	 * Set the value of the SubDomain input for this Choreo.
	*(required, string) The subdomain of your PagerDuty site address.
	 */
	-(void)setSubDomain:(NSString*)SubDomain {
		[super setInput:@"SubDomain" toValue:SubDomain];
	}

	/*!
	 * Set the value of the Until input for this Choreo.
	*(required, date) The end of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.
	 */
	-(void)setUntil:(NSString*)Until {
		[super setInput:@"Until" toValue:Until];
	}	

@end

/*!
 * Results object with appropriate getters for retrieving outputs from the IncidentsPerTime Choreo.
 */
@implementation TMBPagerDuty_Reports_IncidentsPerTime_ResultSet

	-(id)initWithResponse:(NSDictionary*)document {
		return [super initWithResponse:document];
	}	
	
	/*!
	 * Retrieve the value of the "Response" output from an execution of this Choreo.
	 * @return - NSString* (json) The response from PagerDuty.
	 * @throws TMBExceptionNotFound if output does not exist. (Note an empty response is considered valid)
	 */
	-(NSString*)getResponse {
		return [super getOutputByName:@"Response"];
	}
	
@end

/*!
 * Returns high-level statistics about the number of incidents created for a specified time period.
 */
@implementation TMBPagerDuty_Reports_IncidentsPerTime

	/*!
	 * Initialize the Choreo with a valid session
	 *
	 * @param session - A TMBTembooSession containing valid Temboo Application Key credentials
	 *
	 * @return - The initialized TMBPagerDuty_Reports_IncidentsPerTime Choreo
	 */
	-(id)initWithSession:(TMBTembooSession *)session {
		TMBTembooUri *uri = [[TMBTembooUri alloc] initWithString:@"/Library/PagerDuty/Reports/IncidentsPerTime"];
		return [super initWithSession:session andUri:uri];
	}	
	
	/**
	 * TMBChoreographyDelegate protocol method - called when this Choreo's execution
	 * completes successfully. This class in turn calls the same function on the object
	 * (delegate) which was specified as when the choreo execution was initiated.
	 *
	 * @param response The execution response from the Temboo server
	 *
	 * @return void
	 */
	-(void)choreographyDidFinishExecuting:(NSDictionary*)response {
		TMBPagerDuty_Reports_IncidentsPerTime_ResultSet *results = [[TMBPagerDuty_Reports_IncidentsPerTime_ResultSet alloc] initWithResponse:response];
		[self.choreoDelegate choreographyDidFinishExecuting:results];
	}
	
	/*!
	 * Obtain an inputs object for the IncidentsPerTime Choreo.
	 *
	 * @return - New inputs object
	 */
	-(TMBPagerDuty_Reports_IncidentsPerTime_Inputs*)newInputSet {
		return [[TMBPagerDuty_Reports_IncidentsPerTime_Inputs alloc] init];
	}
@end
	