/*!
 * @file TMBUtil.m
 *
 * Convenience routines used internally by the Temboo iOS SDK
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import "TMBUtil.h"
#import "NSString+Base64.h"

@implementation TMBUtil

/*!
 * Builds a "Basic" authentication header for the provided username and password.
 *
 * @param username
 *		The username to use for authentication
 * @param password
 *		The password to use for authentication
 *
 * @return The encoded authentication string
 */
+(NSString*)buildBasicAuthenticationHeaderForUsername:(NSString*)username andPassword:(NSString*)password {
	// Build string username:password	
	NSString *raw = [NSString stringWithFormat:@"%@:%@", username, password];
	// UTF8-escape		  
	NSString *escaped = [raw stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding];
	// Base64-encode
	NSString *encoded = [escaped base64EncodedString];
	// Add "Basic " prefix
	return [NSString stringWithFormat:@"Basic %@", encoded];
}

@end
