/*!
 * @header Temboo iOS SDK Zendesk classes
 *
 * Execute Choreographies from the Temboo Zendesk bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import <Foundation/Foundation.h>
#import "TMBChoreography.h"

@class TMBTembooSession;

/*! group TMBZendesk.ActivityStream.ListActivity Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListActivity Choreo.
 */
@interface TMBZendesk_ActivityStream_ListActivity_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListActivity Choreo.
 */
@interface TMBZendesk_ActivityStream_ListActivity_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns a list of activities for the authenticating user.
 */
@interface TMBZendesk_ActivityStream_ListActivity : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_ActivityStream_ListActivity_Inputs*)newInputSet;
@end

/*! group TMBZendesk.ActivityStream_ListActivity Choreo */


/*! group TMBZendesk.ActivityStream.ShowActivity Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ShowActivity Choreo.
 */
@interface TMBZendesk_ActivityStream_ShowActivity_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ShowActivity Choreo.
 */
@interface TMBZendesk_ActivityStream_ShowActivity_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns detailed information about a particular activity.
 */
@interface TMBZendesk_ActivityStream_ShowActivity : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_ActivityStream_ShowActivity_Inputs*)newInputSet;
@end

/*! group TMBZendesk.ActivityStream_ShowActivity Choreo */


/*! group TMBZendesk.Attachments.UploadAttachment Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UploadAttachment Choreo.
 */
@interface TMBZendesk_Attachments_UploadAttachment_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setExistingToken:(NSString*)ExistingToken;
	-(void)setFileContents:(NSString*)FileContents;
	-(void)setFileName:(NSString*)FileName;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setVaultFile:(NSString*)VaultFile;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UploadAttachment Choreo.
 */
@interface TMBZendesk_Attachments_UploadAttachment_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getToken;
	-(NSString*)getResponse;	
@end

/*!
 * Uploads a file to be used as an attachment to a ticket.
 */
@interface TMBZendesk_Attachments_UploadAttachment : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Attachments_UploadAttachment_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Attachments_UploadAttachment Choreo */


/*! group TMBZendesk.Groups.CreateGroup Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateGroup Choreo.
 */
@interface TMBZendesk_Groups_CreateGroup_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setGroupName:(NSString*)GroupName;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateGroup Choreo.
 */
@interface TMBZendesk_Groups_CreateGroup_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new group.
 */
@interface TMBZendesk_Groups_CreateGroup : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Groups_CreateGroup_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Groups_CreateGroup Choreo */


/*! group TMBZendesk.Groups.DeleteGroup Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteGroup Choreo.
 */
@interface TMBZendesk_Groups_DeleteGroup_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setGroupID:(NSString*)GroupID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteGroup Choreo.
 */
@interface TMBZendesk_Groups_DeleteGroup_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes an existing group.
 */
@interface TMBZendesk_Groups_DeleteGroup : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Groups_DeleteGroup_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Groups_DeleteGroup Choreo */


/*! group TMBZendesk.Groups.ListGroups Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListGroups Choreo.
 */
@interface TMBZendesk_Groups_ListGroups_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListGroups Choreo.
 */
@interface TMBZendesk_Groups_ListGroups_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * List available groups.
 */
@interface TMBZendesk_Groups_ListGroups : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Groups_ListGroups_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Groups_ListGroups Choreo */


/*! group TMBZendesk.Groups.ShowAssignableGroups Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ShowAssignableGroups Choreo.
 */
@interface TMBZendesk_Groups_ShowAssignableGroups_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ShowAssignableGroups Choreo.
 */
@interface TMBZendesk_Groups_ShowAssignableGroups_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Show assignable groups.
 */
@interface TMBZendesk_Groups_ShowAssignableGroups : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Groups_ShowAssignableGroups_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Groups_ShowAssignableGroups Choreo */


/*! group TMBZendesk.Groups.ShowGroup Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ShowGroup Choreo.
 */
@interface TMBZendesk_Groups_ShowGroup_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setGroupID:(NSString*)GroupID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ShowGroup Choreo.
 */
@interface TMBZendesk_Groups_ShowGroup_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Shows information for an existing group.
 */
@interface TMBZendesk_Groups_ShowGroup : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Groups_ShowGroup_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Groups_ShowGroup Choreo */


/*! group TMBZendesk.Groups.UpdateGroup Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateGroup Choreo.
 */
@interface TMBZendesk_Groups_UpdateGroup_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setGroupID:(NSString*)GroupID;
	-(void)setGroupName:(NSString*)GroupName;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateGroup Choreo.
 */
@interface TMBZendesk_Groups_UpdateGroup_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Updates an existing group.
 */
@interface TMBZendesk_Groups_UpdateGroup : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Groups_UpdateGroup_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Groups_UpdateGroup Choreo */


/*! group TMBZendesk.IncrementalTickets.ExportIncrementalTickets Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ExportIncrementalTickets Choreo.
 */
@interface TMBZendesk_IncrementalTickets_ExportIncrementalTickets_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setStartTime:(NSString*)StartTime;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ExportIncrementalTickets Choreo.
 */
@interface TMBZendesk_IncrementalTickets_ExportIncrementalTickets_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns a lightweight representation of what changed in the ticket "since you last asked".
 */
@interface TMBZendesk_IncrementalTickets_ExportIncrementalTickets : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_IncrementalTickets_ExportIncrementalTickets_Inputs*)newInputSet;
@end

/*! group TMBZendesk.IncrementalTickets_ExportIncrementalTickets Choreo */


/*! group TMBZendesk.Macros.ApplyMacroToAllTickets Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ApplyMacroToAllTickets Choreo.
 */
@interface TMBZendesk_Macros_ApplyMacroToAllTickets_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setMacroID:(NSString*)MacroID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ApplyMacroToAllTickets Choreo.
 */
@interface TMBZendesk_Macros_ApplyMacroToAllTickets_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Applies a given macro to all applicable tickets.
 */
@interface TMBZendesk_Macros_ApplyMacroToAllTickets : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Macros_ApplyMacroToAllTickets_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Macros_ApplyMacroToAllTickets Choreo */


/*! group TMBZendesk.Macros.ApplyMacroToTicket Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ApplyMacroToTicket Choreo.
 */
@interface TMBZendesk_Macros_ApplyMacroToTicket_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setMacroID:(NSString*)MacroID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setTicketID:(NSString*)TicketID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ApplyMacroToTicket Choreo.
 */
@interface TMBZendesk_Macros_ApplyMacroToTicket_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Applies a macro to a given ticket.
 */
@interface TMBZendesk_Macros_ApplyMacroToTicket : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Macros_ApplyMacroToTicket_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Macros_ApplyMacroToTicket Choreo */


/*! group TMBZendesk.Macros.ListMacros Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListMacros Choreo.
 */
@interface TMBZendesk_Macros_ListMacros_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListMacros Choreo.
 */
@interface TMBZendesk_Macros_ListMacros_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of all active macros available to the current user.
 */
@interface TMBZendesk_Macros_ListMacros : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Macros_ListMacros_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Macros_ListMacros Choreo */


/*! group TMBZendesk.MonitoredTwitterHandles.GetMonitoredTwitterHandle Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetMonitoredTwitterHandle Choreo.
 */
@interface TMBZendesk_MonitoredTwitterHandles_GetMonitoredTwitterHandle_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetMonitoredTwitterHandle Choreo.
 */
@interface TMBZendesk_MonitoredTwitterHandles_GetMonitoredTwitterHandle_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 *  Retrieves detailed information on a specified monitored Twitter account. 
 */
@interface TMBZendesk_MonitoredTwitterHandles_GetMonitoredTwitterHandle : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_MonitoredTwitterHandles_GetMonitoredTwitterHandle_Inputs*)newInputSet;
@end

/*! group TMBZendesk.MonitoredTwitterHandles_GetMonitoredTwitterHandle Choreo */


/*! group TMBZendesk.MonitoredTwitterHandles.ListMonitoredTwitterHandles Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListMonitoredTwitterHandles Choreo.
 */
@interface TMBZendesk_MonitoredTwitterHandles_ListMonitoredTwitterHandles_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListMonitoredTwitterHandles Choreo.
 */
@interface TMBZendesk_MonitoredTwitterHandles_ListMonitoredTwitterHandles_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of monitored Twitter accounts that you have configured in your Zendesk account.  
 */
@interface TMBZendesk_MonitoredTwitterHandles_ListMonitoredTwitterHandles : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_MonitoredTwitterHandles_ListMonitoredTwitterHandles_Inputs*)newInputSet;
@end

/*! group TMBZendesk.MonitoredTwitterHandles_ListMonitoredTwitterHandles Choreo */


/*! group TMBZendesk.Organizations.AutocompleteOrganizationName Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AutocompleteOrganizationName Choreo.
 */
@interface TMBZendesk_Organizations_AutocompleteOrganizationName_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setName:(NSString*)Name;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AutocompleteOrganizationName Choreo.
 */
@interface TMBZendesk_Organizations_AutocompleteOrganizationName_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns an array of organizations whose name starts with the value specified in the name parameter.
 */
@interface TMBZendesk_Organizations_AutocompleteOrganizationName : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Organizations_AutocompleteOrganizationName_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Organizations_AutocompleteOrganizationName Choreo */


/*! group TMBZendesk.Organizations.CreateManyOrganizations Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateManyOrganizations Choreo.
 */
@interface TMBZendesk_Organizations_CreateManyOrganizations_Inputs : TMBChoreographyInputSet
	-(void)setOrganizationData:(NSString*)OrganizationData;
	-(void)setEmail:(NSString*)Email;
	-(void)setNames:(NSString*)Names;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateManyOrganizations Choreo.
 */
@interface TMBZendesk_Organizations_CreateManyOrganizations_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Create multiple organizations with a single request. 
 */
@interface TMBZendesk_Organizations_CreateManyOrganizations : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Organizations_CreateManyOrganizations_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Organizations_CreateManyOrganizations Choreo */


/*! group TMBZendesk.Organizations.CreateOrganization Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateOrganization Choreo.
 */
@interface TMBZendesk_Organizations_CreateOrganization_Inputs : TMBChoreographyInputSet
	-(void)setOrganizationData:(NSString*)OrganizationData;
	-(void)setEmail:(NSString*)Email;
	-(void)setName:(NSString*)Name;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateOrganization Choreo.
 */
@interface TMBZendesk_Organizations_CreateOrganization_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Create an organization.
 */
@interface TMBZendesk_Organizations_CreateOrganization : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Organizations_CreateOrganization_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Organizations_CreateOrganization Choreo */


/*! group TMBZendesk.Organizations.DeleteOrganization Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteOrganization Choreo.
 */
@interface TMBZendesk_Organizations_DeleteOrganization_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteOrganization Choreo.
 */
@interface TMBZendesk_Organizations_DeleteOrganization_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes an existing organization.
 */
@interface TMBZendesk_Organizations_DeleteOrganization : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Organizations_DeleteOrganization_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Organizations_DeleteOrganization Choreo */


/*! group TMBZendesk.Organizations.GetOrganization Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetOrganization Choreo.
 */
@interface TMBZendesk_Organizations_GetOrganization_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetOrganization Choreo.
 */
@interface TMBZendesk_Organizations_GetOrganization_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Get detailed info for a given organization.
 */
@interface TMBZendesk_Organizations_GetOrganization : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Organizations_GetOrganization_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Organizations_GetOrganization Choreo */


/*! group TMBZendesk.Organizations.ListOrganizations Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListOrganizations Choreo.
 */
@interface TMBZendesk_Organizations_ListOrganizations_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListOrganizations Choreo.
 */
@interface TMBZendesk_Organizations_ListOrganizations_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Lists all organizations.
 */
@interface TMBZendesk_Organizations_ListOrganizations : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Organizations_ListOrganizations_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Organizations_ListOrganizations Choreo */


/*! group TMBZendesk.Organizations.ListOrganizationsByUser Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListOrganizationsByUser Choreo.
 */
@interface TMBZendesk_Organizations_ListOrganizationsByUser_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListOrganizationsByUser Choreo.
 */
@interface TMBZendesk_Organizations_ListOrganizationsByUser_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Lists all organizations by user.
 */
@interface TMBZendesk_Organizations_ListOrganizationsByUser : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Organizations_ListOrganizationsByUser_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Organizations_ListOrganizationsByUser Choreo */


/*! group TMBZendesk.Organizations.UpdateOrganization Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateOrganization Choreo.
 */
@interface TMBZendesk_Organizations_UpdateOrganization_Inputs : TMBChoreographyInputSet
	-(void)setOrganizationData:(NSString*)OrganizationData;
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setNotes:(NSString*)Notes;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateOrganization Choreo.
 */
@interface TMBZendesk_Organizations_UpdateOrganization_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Update an existing organization.
 */
@interface TMBZendesk_Organizations_UpdateOrganization : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Organizations_UpdateOrganization_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Organizations_UpdateOrganization Choreo */


/*! group TMBZendesk.Requests.CreateRequest Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateRequest Choreo.
 */
@interface TMBZendesk_Requests_CreateRequest_Inputs : TMBChoreographyInputSet
	-(void)setRequestData:(NSString*)RequestData;
	-(void)setComment:(NSString*)Comment;
	-(void)setEmail:(NSString*)Email;
	-(void)setPassword:(NSString*)Password;
	-(void)setPriority:(NSString*)Priority;
	-(void)setServer:(NSString*)Server;
	-(void)setSubject:(NSString*)Subject;
	-(void)setType:(NSString*)Type;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateRequest Choreo.
 */
@interface TMBZendesk_Requests_CreateRequest_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new end-user request.
 */
@interface TMBZendesk_Requests_CreateRequest : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Requests_CreateRequest_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Requests_CreateRequest Choreo */


/*! group TMBZendesk.Requests.GetComment Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetComment Choreo.
 */
@interface TMBZendesk_Requests_GetComment_Inputs : TMBChoreographyInputSet
	-(void)setCommentID:(NSString*)CommentID;
	-(void)setEmail:(NSString*)Email;
	-(void)setPassword:(NSString*)Password;
	-(void)setRequestID:(NSString*)RequestID;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetComment Choreo.
 */
@interface TMBZendesk_Requests_GetComment_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the specified comment from a request.
 */
@interface TMBZendesk_Requests_GetComment : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Requests_GetComment_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Requests_GetComment Choreo */


/*! group TMBZendesk.Requests.GetRequest Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetRequest Choreo.
 */
@interface TMBZendesk_Requests_GetRequest_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setStatus:(NSString*)Status;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetRequest Choreo.
 */
@interface TMBZendesk_Requests_GetRequest_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the request for the specified ID.
 */
@interface TMBZendesk_Requests_GetRequest : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Requests_GetRequest_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Requests_GetRequest Choreo */


/*! group TMBZendesk.Requests.ListAllRequests Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListAllRequests Choreo.
 */
@interface TMBZendesk_Requests_ListAllRequests_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
	-(void)setStatus:(NSString*)Status;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListAllRequests Choreo.
 */
@interface TMBZendesk_Requests_ListAllRequests_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * List all existing requests for your account.
 */
@interface TMBZendesk_Requests_ListAllRequests : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Requests_ListAllRequests_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Requests_ListAllRequests Choreo */


/*! group TMBZendesk.Requests.ListComments Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListComments Choreo.
 */
@interface TMBZendesk_Requests_ListComments_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListComments Choreo.
 */
@interface TMBZendesk_Requests_ListComments_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Lists all comments for the specifed request.
 */
@interface TMBZendesk_Requests_ListComments : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Requests_ListComments_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Requests_ListComments Choreo */


/*! group TMBZendesk.Requests.ListOrganizationRequests Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListOrganizationRequests Choreo.
 */
@interface TMBZendesk_Requests_ListOrganizationRequests_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
	-(void)setStatus:(NSString*)Status;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListOrganizationRequests Choreo.
 */
@interface TMBZendesk_Requests_ListOrganizationRequests_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * List all requests for the specified organization.
 */
@interface TMBZendesk_Requests_ListOrganizationRequests : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Requests_ListOrganizationRequests_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Requests_ListOrganizationRequests Choreo */


/*! group TMBZendesk.Requests.ListUserRequests Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListUserRequests Choreo.
 */
@interface TMBZendesk_Requests_ListUserRequests_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
	-(void)setStatus:(NSString*)Status;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListUserRequests Choreo.
 */
@interface TMBZendesk_Requests_ListUserRequests_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * List all requests that are tied to a specified user.
 */
@interface TMBZendesk_Requests_ListUserRequests : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Requests_ListUserRequests_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Requests_ListUserRequests Choreo */


/*! group TMBZendesk.Requests.UpdateRequest Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateRequest Choreo.
 */
@interface TMBZendesk_Requests_UpdateRequest_Inputs : TMBChoreographyInputSet
	-(void)setRequestData:(NSString*)RequestData;
	-(void)setComment:(NSString*)Comment;
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPassword:(NSString*)Password;
	-(void)setPriority:(NSString*)Priority;
	-(void)setServer:(NSString*)Server;
	-(void)setSubject:(NSString*)Subject;
	-(void)setType:(NSString*)Type;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateRequest Choreo.
 */
@interface TMBZendesk_Requests_UpdateRequest_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Updates an existing request.
 */
@interface TMBZendesk_Requests_UpdateRequest : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Requests_UpdateRequest_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Requests_UpdateRequest Choreo */


/*! group TMBZendesk.Search.SearchAll Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SearchAll Choreo.
 */
@interface TMBZendesk_Search_SearchAll_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setQuery:(NSString*)Query;
	-(void)setServer:(NSString*)Server;
	-(void)setSortBy:(NSString*)SortBy;
	-(void)setSortOrder:(NSString*)SortOrder;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SearchAll Choreo.
 */
@interface TMBZendesk_Search_SearchAll_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Returns search results across all ticket fields.
 */
@interface TMBZendesk_Search_SearchAll : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Search_SearchAll_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Search_SearchAll Choreo */


/*! group TMBZendesk.Search.SearchAnonymous Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SearchAnonymous Choreo.
 */
@interface TMBZendesk_Search_SearchAnonymous_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setQuery:(NSString*)Query;
	-(void)setServer:(NSString*)Server;
	-(void)setSortBy:(NSString*)SortBy;
	-(void)setSortOrder:(NSString*)SortOrder;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SearchAnonymous Choreo.
 */
@interface TMBZendesk_Search_SearchAnonymous_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Allows anonymous users to search public forums.
 */
@interface TMBZendesk_Search_SearchAnonymous : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Search_SearchAnonymous_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Search_SearchAnonymous Choreo */


/*! group TMBZendesk.Tags.ListTags Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListTags Choreo.
 */
@interface TMBZendesk_Tags_ListTags_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListTags Choreo.
 */
@interface TMBZendesk_Tags_ListTags_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the most popular recent tags in decreasing popularity.
 */
@interface TMBZendesk_Tags_ListTags : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Tags_ListTags_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Tags_ListTags Choreo */


/*! group TMBZendesk.TicketAudits.ChangeCommentFromPublicToPrivate Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ChangeCommentFromPublicToPrivate Choreo.
 */
@interface TMBZendesk_TicketAudits_ChangeCommentFromPublicToPrivate_Inputs : TMBChoreographyInputSet
	-(void)setAuditID:(NSString*)AuditID;
	-(void)setEmail:(NSString*)Email;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setTicketID:(NSString*)TicketID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ChangeCommentFromPublicToPrivate Choreo.
 */
@interface TMBZendesk_TicketAudits_ChangeCommentFromPublicToPrivate_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Changes a comment from public to private.
 */
@interface TMBZendesk_TicketAudits_ChangeCommentFromPublicToPrivate : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_TicketAudits_ChangeCommentFromPublicToPrivate_Inputs*)newInputSet;
@end

/*! group TMBZendesk.TicketAudits_ChangeCommentFromPublicToPrivate Choreo */


/*! group TMBZendesk.TicketAudits.ListAudits Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListAudits Choreo.
 */
@interface TMBZendesk_TicketAudits_ListAudits_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListAudits Choreo.
 */
@interface TMBZendesk_TicketAudits_ListAudits_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Lists all the audits made for the specifed ticket.
 */
@interface TMBZendesk_TicketAudits_ListAudits : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_TicketAudits_ListAudits_Inputs*)newInputSet;
@end

/*! group TMBZendesk.TicketAudits_ListAudits Choreo */


/*! group TMBZendesk.TicketAudits.MarkAuditAsTrusted Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the MarkAuditAsTrusted Choreo.
 */
@interface TMBZendesk_TicketAudits_MarkAuditAsTrusted_Inputs : TMBChoreographyInputSet
	-(void)setAuditID:(NSString*)AuditID;
	-(void)setEmail:(NSString*)Email;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setTicketID:(NSString*)TicketID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the MarkAuditAsTrusted Choreo.
 */
@interface TMBZendesk_TicketAudits_MarkAuditAsTrusted_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Marks the specified audit as trusted. 
 */
@interface TMBZendesk_TicketAudits_MarkAuditAsTrusted : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_TicketAudits_MarkAuditAsTrusted_Inputs*)newInputSet;
@end

/*! group TMBZendesk.TicketAudits_MarkAuditAsTrusted Choreo */


/*! group TMBZendesk.TicketAudits.ShowAudit Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ShowAudit Choreo.
 */
@interface TMBZendesk_TicketAudits_ShowAudit_Inputs : TMBChoreographyInputSet
	-(void)setAuditID:(NSString*)AuditID;
	-(void)setEmail:(NSString*)Email;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setTicketID:(NSString*)TicketID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ShowAudit Choreo.
 */
@interface TMBZendesk_TicketAudits_ShowAudit_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns detailed information on the specified audit.
 */
@interface TMBZendesk_TicketAudits_ShowAudit : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_TicketAudits_ShowAudit_Inputs*)newInputSet;
@end

/*! group TMBZendesk.TicketAudits_ShowAudit Choreo */


/*! group TMBZendesk.TicketMetrics.GetTicketMetrics Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetTicketMetrics Choreo.
 */
@interface TMBZendesk_TicketMetrics_GetTicketMetrics_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetTicketMetrics Choreo.
 */
@interface TMBZendesk_TicketMetrics_GetTicketMetrics_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a specific ticket metric.
 */
@interface TMBZendesk_TicketMetrics_GetTicketMetrics : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_TicketMetrics_GetTicketMetrics_Inputs*)newInputSet;
@end

/*! group TMBZendesk.TicketMetrics_GetTicketMetrics Choreo */


/*! group TMBZendesk.TicketMetrics.ListTicketMetrics Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListTicketMetrics Choreo.
 */
@interface TMBZendesk_TicketMetrics_ListTicketMetrics_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListTicketMetrics Choreo.
 */
@interface TMBZendesk_TicketMetrics_ListTicketMetrics_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of metrics for all available tickets.
 */
@interface TMBZendesk_TicketMetrics_ListTicketMetrics : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_TicketMetrics_ListTicketMetrics_Inputs*)newInputSet;
@end

/*! group TMBZendesk.TicketMetrics_ListTicketMetrics Choreo */


/*! group TMBZendesk.Tickets.CreateTicket Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateTicket Choreo.
 */
@interface TMBZendesk_Tickets_CreateTicket_Inputs : TMBChoreographyInputSet
	-(void)setComment:(NSString*)Comment;
	-(void)setEmail:(NSString*)Email;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setSubject:(NSString*)Subject;
	-(void)setTicketData:(NSString*)TicketData;
	-(void)setToken:(NSString*)Token;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateTicket Choreo.
 */
@interface TMBZendesk_Tickets_CreateTicket_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new ticket.
 */
@interface TMBZendesk_Tickets_CreateTicket : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Tickets_CreateTicket_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Tickets_CreateTicket Choreo */


/*! group TMBZendesk.Tickets.CreateTicketNewRequester Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateTicketNewRequester Choreo.
 */
@interface TMBZendesk_Tickets_CreateTicketNewRequester_Inputs : TMBChoreographyInputSet
	-(void)setComment:(NSString*)Comment;
	-(void)setEmail:(NSString*)Email;
	-(void)setLocaleID:(NSString*)LocaleID;
	-(void)setName:(NSString*)Name;
	-(void)setPassword:(NSString*)Password;
	-(void)setRequesterEmail:(NSString*)RequesterEmail;
	-(void)setServer:(NSString*)Server;
	-(void)setSubject:(NSString*)Subject;
	-(void)setToken:(NSString*)Token;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateTicketNewRequester Choreo.
 */
@interface TMBZendesk_Tickets_CreateTicketNewRequester_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new ticket as well as a new requester account.
 */
@interface TMBZendesk_Tickets_CreateTicketNewRequester : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Tickets_CreateTicketNewRequester_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Tickets_CreateTicketNewRequester Choreo */


/*! group TMBZendesk.Tickets.DeleteTicket Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteTicket Choreo.
 */
@interface TMBZendesk_Tickets_DeleteTicket_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteTicket Choreo.
 */
@interface TMBZendesk_Tickets_DeleteTicket_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes an existing ticket.
 */
@interface TMBZendesk_Tickets_DeleteTicket : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Tickets_DeleteTicket_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Tickets_DeleteTicket Choreo */


/*! group TMBZendesk.Tickets.GetTicket Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetTicket Choreo.
 */
@interface TMBZendesk_Tickets_GetTicket_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetTicket Choreo.
 */
@interface TMBZendesk_Tickets_GetTicket_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns information about a ticket using its ID.
 */
@interface TMBZendesk_Tickets_GetTicket : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Tickets_GetTicket_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Tickets_GetTicket Choreo */


/*! group TMBZendesk.Tickets.ListAllTickets Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListAllTickets Choreo.
 */
@interface TMBZendesk_Tickets_ListAllTickets_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListAllTickets Choreo.
 */
@interface TMBZendesk_Tickets_ListAllTickets_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of all existing tickets.
 */
@interface TMBZendesk_Tickets_ListAllTickets : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Tickets_ListAllTickets_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Tickets_ListAllTickets Choreo */


/*! group TMBZendesk.Tickets.ListRecent Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListRecent Choreo.
 */
@interface TMBZendesk_Tickets_ListRecent_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListRecent Choreo.
 */
@interface TMBZendesk_Tickets_ListRecent_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of all recent tickets.
 */
@interface TMBZendesk_Tickets_ListRecent : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Tickets_ListRecent_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Tickets_ListRecent Choreo */


/*! group TMBZendesk.Tickets.ListTicketCollaborators Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListTicketCollaborators Choreo.
 */
@interface TMBZendesk_Tickets_ListTicketCollaborators_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListTicketCollaborators Choreo.
 */
@interface TMBZendesk_Tickets_ListTicketCollaborators_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves all the collaborators associated with a given ticket.
 */
@interface TMBZendesk_Tickets_ListTicketCollaborators : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Tickets_ListTicketCollaborators_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Tickets_ListTicketCollaborators Choreo */


/*! group TMBZendesk.Tickets.ListTicketIncidents Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListTicketIncidents Choreo.
 */
@interface TMBZendesk_Tickets_ListTicketIncidents_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListTicketIncidents Choreo.
 */
@interface TMBZendesk_Tickets_ListTicketIncidents_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves all the incidents associated with a given ticket.
 */
@interface TMBZendesk_Tickets_ListTicketIncidents : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Tickets_ListTicketIncidents_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Tickets_ListTicketIncidents Choreo */


/*! group TMBZendesk.Tickets.ListTicketsByOrganization Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListTicketsByOrganization Choreo.
 */
@interface TMBZendesk_Tickets_ListTicketsByOrganization_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setOrganizationID:(NSString*)OrganizationID;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListTicketsByOrganization Choreo.
 */
@interface TMBZendesk_Tickets_ListTicketsByOrganization_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of all tickets involving a specified organization.
 */
@interface TMBZendesk_Tickets_ListTicketsByOrganization : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Tickets_ListTicketsByOrganization_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Tickets_ListTicketsByOrganization Choreo */


/*! group TMBZendesk.Tickets.ListTicketsByUser Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListTicketsByUser Choreo.
 */
@interface TMBZendesk_Tickets_ListTicketsByUser_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
	-(void)setUserID:(NSString*)UserID;
	-(void)setUserType:(NSString*)UserType;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListTicketsByUser Choreo.
 */
@interface TMBZendesk_Tickets_ListTicketsByUser_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of all tickets involving a specified user.
 */
@interface TMBZendesk_Tickets_ListTicketsByUser : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Tickets_ListTicketsByUser_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Tickets_ListTicketsByUser Choreo */


/*! group TMBZendesk.Tickets.UpdateTicket Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateTicket Choreo.
 */
@interface TMBZendesk_Tickets_UpdateTicket_Inputs : TMBChoreographyInputSet
	-(void)setComment:(NSString*)Comment;
	-(void)setEmail:(NSString*)Email;
	-(void)setMetadata:(NSString*)Metadata;
	-(void)setPassword:(NSString*)Password;
	-(void)setPublic:(NSString*)Public;
	-(void)setServer:(NSString*)Server;
	-(void)setStatus:(NSString*)Status;
	-(void)setTicketData:(NSString*)TicketData;
	-(void)setTicketID:(NSString*)TicketID;
	-(void)setToken:(NSString*)Token;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateTicket Choreo.
 */
@interface TMBZendesk_Tickets_UpdateTicket_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Updates an existing ticket.
 */
@interface TMBZendesk_Tickets_UpdateTicket : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Tickets_UpdateTicket_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Tickets_UpdateTicket Choreo */


/*! group TMBZendesk.UserIdentities.AddUserIdentity Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AddUserIdentity Choreo.
 */
@interface TMBZendesk_UserIdentities_AddUserIdentity_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setIdentity:(NSString*)Identity;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setType:(NSString*)Type;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddUserIdentity Choreo.
 */
@interface TMBZendesk_UserIdentities_AddUserIdentity_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Allows an agent to add new identities for a given user ID. 
 */
@interface TMBZendesk_UserIdentities_AddUserIdentity : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_UserIdentities_AddUserIdentity_Inputs*)newInputSet;
@end

/*! group TMBZendesk.UserIdentities_AddUserIdentity Choreo */


/*! group TMBZendesk.UserIdentities.AddUserIdentityByEndUser Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AddUserIdentityByEndUser Choreo.
 */
@interface TMBZendesk_UserIdentities_AddUserIdentityByEndUser_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setIdentity:(NSString*)Identity;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setType:(NSString*)Type;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddUserIdentityByEndUser Choreo.
 */
@interface TMBZendesk_UserIdentities_AddUserIdentityByEndUser_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 *  Allows an end-user  to add new identities for a given user ID.
 */
@interface TMBZendesk_UserIdentities_AddUserIdentityByEndUser : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_UserIdentities_AddUserIdentityByEndUser_Inputs*)newInputSet;
@end

/*! group TMBZendesk.UserIdentities_AddUserIdentityByEndUser Choreo */


/*! group TMBZendesk.UserIdentities.DeleteUserIdentity Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteUserIdentity Choreo.
 */
@interface TMBZendesk_UserIdentities_DeleteUserIdentity_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setIdentityID:(NSString*)IdentityID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteUserIdentity Choreo.
 */
@interface TMBZendesk_UserIdentities_DeleteUserIdentity_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 *  Deletes the user identity for a user/
 */
@interface TMBZendesk_UserIdentities_DeleteUserIdentity : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_UserIdentities_DeleteUserIdentity_Inputs*)newInputSet;
@end

/*! group TMBZendesk.UserIdentities_DeleteUserIdentity Choreo */


/*! group TMBZendesk.UserIdentities.ListUserIdentities Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListUserIdentities Choreo.
 */
@interface TMBZendesk_UserIdentities_ListUserIdentities_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListUserIdentities Choreo.
 */
@interface TMBZendesk_UserIdentities_ListUserIdentities_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Lists all User Identities for a given User
 */
@interface TMBZendesk_UserIdentities_ListUserIdentities : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_UserIdentities_ListUserIdentities_Inputs*)newInputSet;
@end

/*! group TMBZendesk.UserIdentities_ListUserIdentities Choreo */


/*! group TMBZendesk.UserIdentities.MakeUserIdentityThePrimary Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the MakeUserIdentityThePrimary Choreo.
 */
@interface TMBZendesk_UserIdentities_MakeUserIdentityThePrimary_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setIdentityID:(NSString*)IdentityID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the MakeUserIdentityThePrimary Choreo.
 */
@interface TMBZendesk_UserIdentities_MakeUserIdentityThePrimary_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Sets the given user identity to primary.
 */
@interface TMBZendesk_UserIdentities_MakeUserIdentityThePrimary : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_UserIdentities_MakeUserIdentityThePrimary_Inputs*)newInputSet;
@end

/*! group TMBZendesk.UserIdentities_MakeUserIdentityThePrimary Choreo */


/*! group TMBZendesk.UserIdentities.RequestUserVerification Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RequestUserVerification Choreo.
 */
@interface TMBZendesk_UserIdentities_RequestUserVerification_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setIdentityID:(NSString*)IdentityID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RequestUserVerification Choreo.
 */
@interface TMBZendesk_UserIdentities_RequestUserVerification_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * This sends a verification email to the user, asking him to click a link in order to verify ownership of the email address.
 */
@interface TMBZendesk_UserIdentities_RequestUserVerification : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_UserIdentities_RequestUserVerification_Inputs*)newInputSet;
@end

/*! group TMBZendesk.UserIdentities_RequestUserVerification Choreo */


/*! group TMBZendesk.UserIdentities.ShowUserIdentity Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ShowUserIdentity Choreo.
 */
@interface TMBZendesk_UserIdentities_ShowUserIdentity_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setIdentityID:(NSString*)IdentityID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ShowUserIdentity Choreo.
 */
@interface TMBZendesk_UserIdentities_ShowUserIdentity_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Shows the identity with the given ID.
 */
@interface TMBZendesk_UserIdentities_ShowUserIdentity : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_UserIdentities_ShowUserIdentity_Inputs*)newInputSet;
@end

/*! group TMBZendesk.UserIdentities_ShowUserIdentity Choreo */


/*! group TMBZendesk.UserIdentities.UpdateUserIdentity Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateUserIdentity Choreo.
 */
@interface TMBZendesk_UserIdentities_UpdateUserIdentity_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setIdentityID:(NSString*)IdentityID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setUserID:(NSString*)UserID;
	-(void)setVerified:(NSString*)Verified;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateUserIdentity Choreo.
 */
@interface TMBZendesk_UserIdentities_UpdateUserIdentity_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Updates the User Identity.    This API method only allows you to set an identity as verified.
 */
@interface TMBZendesk_UserIdentities_UpdateUserIdentity : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_UserIdentities_UpdateUserIdentity_Inputs*)newInputSet;
@end

/*! group TMBZendesk.UserIdentities_UpdateUserIdentity Choreo */


/*! group TMBZendesk.UserIdentities.VerifyUserIdentity Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the VerifyUserIdentity Choreo.
 */
@interface TMBZendesk_UserIdentities_VerifyUserIdentity_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setIdentityID:(NSString*)IdentityID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the VerifyUserIdentity Choreo.
 */
@interface TMBZendesk_UserIdentities_VerifyUserIdentity_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Verifies the User Identity.   
 */
@interface TMBZendesk_UserIdentities_VerifyUserIdentity : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_UserIdentities_VerifyUserIdentity_Inputs*)newInputSet;
@end

/*! group TMBZendesk.UserIdentities_VerifyUserIdentity Choreo */


/*! group TMBZendesk.Users.CreateManyUsers Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateManyUsers Choreo.
 */
@interface TMBZendesk_Users_CreateManyUsers_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setUsers:(NSString*)Users;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateManyUsers Choreo.
 */
@interface TMBZendesk_Users_CreateManyUsers_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Creates many new users at one time.
 */
@interface TMBZendesk_Users_CreateManyUsers : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Users_CreateManyUsers_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Users_CreateManyUsers Choreo */


/*! group TMBZendesk.Users.CreateUser Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateUser Choreo.
 */
@interface TMBZendesk_Users_CreateUser_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setUserData:(NSString*)UserData;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateUser Choreo.
 */
@interface TMBZendesk_Users_CreateUser_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new user.
 */
@interface TMBZendesk_Users_CreateUser : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Users_CreateUser_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Users_CreateUser Choreo */


/*! group TMBZendesk.Users.DeleteUser Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteUser Choreo.
 */
@interface TMBZendesk_Users_DeleteUser_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteUser Choreo.
 */
@interface TMBZendesk_Users_DeleteUser_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes a given user.
 */
@interface TMBZendesk_Users_DeleteUser : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Users_DeleteUser_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Users_DeleteUser Choreo */


/*! group TMBZendesk.Users.ListAllUsers Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListAllUsers Choreo.
 */
@interface TMBZendesk_Users_ListAllUsers_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListAllUsers Choreo.
 */
@interface TMBZendesk_Users_ListAllUsers_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of all existing users.
 */
@interface TMBZendesk_Users_ListAllUsers : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Users_ListAllUsers_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Users_ListAllUsers Choreo */


/*! group TMBZendesk.Users.ListUsersByGroup Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListUsersByGroup Choreo.
 */
@interface TMBZendesk_Users_ListUsersByGroup_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setGroupID:(NSString*)GroupID;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListUsersByGroup Choreo.
 */
@interface TMBZendesk_Users_ListUsersByGroup_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of all users in a specified group.
 */
@interface TMBZendesk_Users_ListUsersByGroup : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Users_ListUsersByGroup_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Users_ListUsersByGroup Choreo */


/*! group TMBZendesk.Users.ListUsersByOrganization Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListUsersByOrganization Choreo.
 */
@interface TMBZendesk_Users_ListUsersByOrganization_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setOrganizationID:(NSString*)OrganizationID;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListUsersByOrganization Choreo.
 */
@interface TMBZendesk_Users_ListUsersByOrganization_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of users involving a specified organization.
 */
@interface TMBZendesk_Users_ListUsersByOrganization : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Users_ListUsersByOrganization_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Users_ListUsersByOrganization Choreo */


/*! group TMBZendesk.Users.SearchUsers Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SearchUsers Choreo.
 */
@interface TMBZendesk_Users_SearchUsers_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setQuery:(NSString*)Query;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SearchUsers Choreo.
 */
@interface TMBZendesk_Users_SearchUsers_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Returns a list of users who match the search parameters.
 */
@interface TMBZendesk_Users_SearchUsers : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Users_SearchUsers_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Users_SearchUsers Choreo */


/*! group TMBZendesk.Users.ShowCurrentUser Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ShowCurrentUser Choreo.
 */
@interface TMBZendesk_Users_ShowCurrentUser_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ShowCurrentUser Choreo.
 */
@interface TMBZendesk_Users_ShowCurrentUser_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns information about the currently authenticated user.
 */
@interface TMBZendesk_Users_ShowCurrentUser : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Users_ShowCurrentUser_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Users_ShowCurrentUser Choreo */


/*! group TMBZendesk.Users.ShowUser Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ShowUser Choreo.
 */
@interface TMBZendesk_Users_ShowUser_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ShowUser Choreo.
 */
@interface TMBZendesk_Users_ShowUser_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns information about given user.
 */
@interface TMBZendesk_Users_ShowUser : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Users_ShowUser_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Users_ShowUser Choreo */


/*! group TMBZendesk.Users.SuspendUser Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SuspendUser Choreo.
 */
@interface TMBZendesk_Users_SuspendUser_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SuspendUser Choreo.
 */
@interface TMBZendesk_Users_SuspendUser_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Suspends an existing user.
 */
@interface TMBZendesk_Users_SuspendUser : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Users_SuspendUser_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Users_SuspendUser Choreo */


/*! group TMBZendesk.Users.UpdateUser Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateUser Choreo.
 */
@interface TMBZendesk_Users_UpdateUser_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setUserData:(NSString*)UserData;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateUser Choreo.
 */
@interface TMBZendesk_Users_UpdateUser_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Updates an existing user.
 */
@interface TMBZendesk_Users_UpdateUser : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Users_UpdateUser_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Users_UpdateUser Choreo */


/*! group TMBZendesk.Users.UpdateUserImage Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateUserImage Choreo.
 */
@interface TMBZendesk_Users_UpdateUserImage_Inputs : TMBChoreographyInputSet
	-(void)setResponse:(NSString*)Response;
	-(void)setEmail:(NSString*)Email;
	-(void)setImageURL:(NSString*)ImageURL;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateUserImage Choreo.
 */
@interface TMBZendesk_Users_UpdateUserImage_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Updates a user's profile image.
 */
@interface TMBZendesk_Users_UpdateUserImage : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Users_UpdateUserImage_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Users_UpdateUserImage Choreo */


/*! group TMBZendesk.Views.CreateView Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateView Choreo.
 */
@interface TMBZendesk_Views_CreateView_Inputs : TMBChoreographyInputSet
	-(void)setAllConditions:(NSString*)AllConditions;
	-(void)setAnyConditions:(NSString*)AnyConditions;
	-(void)setEmail:(NSString*)Email;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
	-(void)setTitle:(NSString*)Title;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateView Choreo.
 */
@interface TMBZendesk_Views_CreateView_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new view.
 */
@interface TMBZendesk_Views_CreateView : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Views_CreateView_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Views_CreateView Choreo */


/*! group TMBZendesk.Views.DeleteView Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteView Choreo.
 */
@interface TMBZendesk_Views_DeleteView_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteView Choreo.
 */
@interface TMBZendesk_Views_DeleteView_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes the specified view.
 */
@interface TMBZendesk_Views_DeleteView : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Views_DeleteView_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Views_DeleteView Choreo */


/*! group TMBZendesk.Views.ExecuteViews Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ExecuteViews Choreo.
 */
@interface TMBZendesk_Views_ExecuteViews_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ExecuteViews Choreo.
 */
@interface TMBZendesk_Views_ExecuteViews_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Execute a view and retrieve tickets that fulfill the conditions of the view.
 */
@interface TMBZendesk_Views_ExecuteViews : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Views_ExecuteViews_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Views_ExecuteViews Choreo */


/*! group TMBZendesk.Views.ExportViews Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ExportViews Choreo.
 */
@interface TMBZendesk_Views_ExportViews_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ExportViews Choreo.
 */
@interface TMBZendesk_Views_ExportViews_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns the CSV attachment of the current view if possible.
 */
@interface TMBZendesk_Views_ExportViews : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Views_ExportViews_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Views_ExportViews Choreo */


/*! group TMBZendesk.Views.GetTicketsFromAView Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetTicketsFromAView Choreo.
 */
@interface TMBZendesk_Views_GetTicketsFromAView_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetTicketsFromAView Choreo.
 */
@interface TMBZendesk_Views_GetTicketsFromAView_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieve tickets from a view.
 */
@interface TMBZendesk_Views_GetTicketsFromAView : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Views_GetTicketsFromAView_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Views_GetTicketsFromAView Choreo */


/*! group TMBZendesk.Views.GetViewCount Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetViewCount Choreo.
 */
@interface TMBZendesk_Views_GetViewCount_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setID:(NSString*)ID;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetViewCount Choreo.
 */
@interface TMBZendesk_Views_GetViewCount_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Returns the ticket count for a single view.
 */
@interface TMBZendesk_Views_GetViewCount : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Views_GetViewCount_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Views_GetViewCount Choreo */


/*! group TMBZendesk.Views.GetViewCounts Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetViewCounts Choreo.
 */
@interface TMBZendesk_Views_GetViewCounts_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setIDs:(NSString*)IDs;
	-(void)setPassword:(NSString*)Password;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetViewCounts Choreo.
 */
@interface TMBZendesk_Views_GetViewCounts_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Calculates the size of the view in terms of number of tickets the view will return.
 */
@interface TMBZendesk_Views_GetViewCounts : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Views_GetViewCounts_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Views_GetViewCounts Choreo */


/*! group TMBZendesk.Views.ListActiveViews Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListActiveViews Choreo.
 */
@interface TMBZendesk_Views_ListActiveViews_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListActiveViews Choreo.
 */
@interface TMBZendesk_Views_ListActiveViews_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Lists active shared and personal views available to the current user.
 */
@interface TMBZendesk_Views_ListActiveViews : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Views_ListActiveViews_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Views_ListActiveViews Choreo */


/*! group TMBZendesk.Views.ListCompactViews Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListCompactViews Choreo.
 */
@interface TMBZendesk_Views_ListCompactViews_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListCompactViews Choreo.
 */
@interface TMBZendesk_Views_ListCompactViews_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a compacted list of shared and personal views available to the current user.
 */
@interface TMBZendesk_Views_ListCompactViews : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Views_ListCompactViews_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Views_ListCompactViews Choreo */


/*! group TMBZendesk.Views.ListViews Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListViews Choreo.
 */
@interface TMBZendesk_Views_ListViews_Inputs : TMBChoreographyInputSet
	-(void)setEmail:(NSString*)Email;
	-(void)setPage:(NSString*)Page;
	-(void)setPassword:(NSString*)Password;
	-(void)setPerPage:(NSString*)PerPage;
	-(void)setServer:(NSString*)Server;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListViews Choreo.
 */
@interface TMBZendesk_Views_ListViews_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNextPage;
	-(NSString*)getPreviousPage;
	-(NSString*)getResponse;	
@end

/*!
 * Lists shared and personal views available to the current user.
 */
@interface TMBZendesk_Views_ListViews : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBZendesk_Views_ListViews_Inputs*)newInputSet;
@end

/*! group TMBZendesk.Views_ListViews Choreo */
