/*!
 * @header Temboo iOS SDK Wikipedia classes
 *
 * Execute Choreographies from the Temboo Wikipedia bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import <Foundation/Foundation.h>
#import "TMBChoreography.h"

@class TMBTembooSession;

/*! group TMBWikipedia.GetPageSummary Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetPageSummary Choreo.
 */
@interface TMBWikipedia_GetPageSummary_Inputs : TMBChoreographyInputSet
	-(void)setTitle:(NSString*)Title;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetPageSummary Choreo.
 */
@interface TMBWikipedia_GetPageSummary_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getExtract;
	-(NSString*)getResponseCode;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a summary response including a text extract of the first several sentences, as well as information about a thumbnail that represents the page.
 */
@interface TMBWikipedia_GetPageSummary : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBWikipedia_GetPageSummary_Inputs*)newInputSet;
@end

/*! group TMBWikipedia_GetPageSummary Choreo */
