/*!
 * @header Temboo iOS SDK Google classes
 *
 * Execute Choreographies from the Temboo Google bundle.
 *
 * iOS version 10.6.8
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @author     Reid Simonton, Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @version    1.7
 */

#import <Foundation/Foundation.h>
#import "TMBChoreography.h"

@class TMBTembooSession;

/*! group TMBGoogle.Analytics.GetMetrics Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetMetrics Choreo.
 */
@interface TMBGoogle_Analytics_GetMetrics_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDimensions:(NSString*)Dimensions;
	-(void)setEndDate:(NSString*)EndDate;
	-(void)setFilters:(NSString*)Filters;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setMetrics:(NSString*)Metrics;
	-(void)setPassword:(NSString*)Password;
	-(void)setProfileId:(NSString*)ProfileId;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSegment:(NSString*)Segment;
	-(void)setSort:(NSString*)Sort;
	-(void)setStartDate:(NSString*)StartDate;
	-(void)setStartIndex:(NSString*)StartIndex;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetMetrics Choreo.
 */
@interface TMBGoogle_Analytics_GetMetrics_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getBounces;
	-(NSString*)getNewAccessToken;
	-(NSString*)getPageViews;
	-(NSString*)getVisits;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves metrics such as visits, page views, bounces within a specified time frame.
 */
@interface TMBGoogle_Analytics_GetMetrics : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Analytics_GetMetrics_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Analytics_GetMetrics Choreo */


/*! group TMBGoogle.BigQuery.Jobs.GetQueryResults Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetQueryResults Choreo.
 */
@interface TMBGoogle_BigQuery_Jobs_GetQueryResults_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setJobID:(NSString*)JobID;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProjectID:(NSString*)ProjectID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setStartIndex:(NSString*)StartIndex;
	-(void)setTimeoutMs:(NSString*)TimeoutMs;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetQueryResults Choreo.
 */
@interface TMBGoogle_BigQuery_Jobs_GetQueryResults_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the results of a query with a given JobID when a query request times out and returns before the results are available.
 */
@interface TMBGoogle_BigQuery_Jobs_GetQueryResults : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_BigQuery_Jobs_GetQueryResults_Inputs*)newInputSet;
@end

/*! group TMBGoogle.BigQuery.Jobs_GetQueryResults Choreo */


/*! group TMBGoogle.BigQuery.Jobs.Query Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Query Choreo.
 */
@interface TMBGoogle_BigQuery_Jobs_Query_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDatasetID:(NSString*)DatasetID;
	-(void)setDryRun:(NSString*)DryRun;
	-(void)setFields:(NSString*)Fields;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProjectID:(NSString*)ProjectID;
	-(void)setQuery:(NSString*)Query;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setTimeoutMs:(NSString*)TimeoutMs;
	-(void)setUseQueryCache:(NSString*)UseQueryCache;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Query Choreo.
 */
@interface TMBGoogle_BigQuery_Jobs_Query_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Runs a BigQuery SQL query and returns results if the query completes within a specified timeout. When a query timeout occurs, results can be retrieved using the Job ID returned in the response.
 */
@interface TMBGoogle_BigQuery_Jobs_Query : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_BigQuery_Jobs_Query_Inputs*)newInputSet;
@end

/*! group TMBGoogle.BigQuery.Jobs_Query Choreo */


/*! group TMBGoogle.BigQuery.TableData.InsertAll Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the InsertAll Choreo.
 */
@interface TMBGoogle_BigQuery_TableData_InsertAll_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDatasetID:(NSString*)DatasetID;
	-(void)setFields:(NSString*)Fields;
	-(void)setIgnoreUnknownValues:(NSString*)IgnoreUnknownValues;
	-(void)setProjectID:(NSString*)ProjectID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setRows:(NSString*)Rows;
	-(void)setTableID:(NSString*)TableID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the InsertAll Choreo.
 */
@interface TMBGoogle_BigQuery_TableData_InsertAll_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Streams data into BigQuery one record at a time.
 */
@interface TMBGoogle_BigQuery_TableData_InsertAll : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_BigQuery_TableData_InsertAll_Inputs*)newInputSet;
@end

/*! group TMBGoogle.BigQuery.TableData_InsertAll Choreo */


/*! group TMBGoogle.BigQuery.TableData.List Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the List Choreo.
 */
@interface TMBGoogle_BigQuery_TableData_List_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDatasetID:(NSString*)DatasetID;
	-(void)setFields:(NSString*)Fields;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProjectID:(NSString*)ProjectID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setStartIndex:(NSString*)StartIndex;
	-(void)setTableID:(NSString*)TableID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the List Choreo.
 */
@interface TMBGoogle_BigQuery_TableData_List_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves table data from a specified set of rows.
 */
@interface TMBGoogle_BigQuery_TableData_List : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_BigQuery_TableData_List_Inputs*)newInputSet;
@end

/*! group TMBGoogle.BigQuery.TableData_List Choreo */


/*! group TMBGoogle.Calendar.CreateCalendar Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateCalendar Choreo.
 */
@interface TMBGoogle_Calendar_CreateCalendar_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDescription:(NSString*)Description;
	-(void)setLocation:(NSString*)Location;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setTimezone:(NSString*)Timezone;
	-(void)setTitle:(NSString*)Title;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateCalendar Choreo.
 */
@interface TMBGoogle_Calendar_CreateCalendar_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Create a new secondary calendar.
 */
@interface TMBGoogle_Calendar_CreateCalendar : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Calendar_CreateCalendar_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Calendar_CreateCalendar Choreo */


/*! group TMBGoogle.Calendar.CreateEvent Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateEvent Choreo.
 */
@interface TMBGoogle_Calendar_CreateEvent_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCalendarID:(NSString*)CalendarID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setEndDate:(NSString*)EndDate;
	-(void)setEndTime:(NSString*)EndTime;
	-(void)setEventDescription:(NSString*)EventDescription;
	-(void)setEventLocation:(NSString*)EventLocation;
	-(void)setEventTitle:(NSString*)EventTitle;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setStartDate:(NSString*)StartDate;
	-(void)setStartTime:(NSString*)StartTime;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateEvent Choreo.
 */
@interface TMBGoogle_Calendar_CreateEvent_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getTimezoneSetting;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Create a new event in a specified calendar.
 */
@interface TMBGoogle_Calendar_CreateEvent : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Calendar_CreateEvent_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Calendar_CreateEvent Choreo */


/*! group TMBGoogle.Calendar.DeleteAllEvents Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteAllEvents Choreo.
 */
@interface TMBGoogle_Calendar_DeleteAllEvents_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteAllEvents Choreo.
 */
@interface TMBGoogle_Calendar_DeleteAllEvents_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Delete all events from a primary calendar of an account. Note that this operation can't be undone.
 */
@interface TMBGoogle_Calendar_DeleteAllEvents : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Calendar_DeleteAllEvents_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Calendar_DeleteAllEvents Choreo */


/*! group TMBGoogle.Calendar.DeleteCalendar Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteCalendar Choreo.
 */
@interface TMBGoogle_Calendar_DeleteCalendar_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCalendarID:(NSString*)CalendarID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteCalendar Choreo.
 */
@interface TMBGoogle_Calendar_DeleteCalendar_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Delete a secondary calendar.
 */
@interface TMBGoogle_Calendar_DeleteCalendar : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Calendar_DeleteCalendar_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Calendar_DeleteCalendar Choreo */


/*! group TMBGoogle.Calendar.DeleteEvent Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteEvent Choreo.
 */
@interface TMBGoogle_Calendar_DeleteEvent_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCalendarID:(NSString*)CalendarID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setEventID:(NSString*)EventID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteEvent Choreo.
 */
@interface TMBGoogle_Calendar_DeleteEvent_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAccessToken;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Delete a specific event from a specified calendar.
 */
@interface TMBGoogle_Calendar_DeleteEvent : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Calendar_DeleteEvent_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Calendar_DeleteEvent Choreo */


/*! group TMBGoogle.Calendar.GetAllCalendars Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetAllCalendars Choreo.
 */
@interface TMBGoogle_Calendar_GetAllCalendars_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setCount:(NSString*)Count;
	-(void)setFields:(NSString*)Fields;
	-(void)setHidden:(NSString*)Hidden;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetAllCalendars Choreo.
 */
@interface TMBGoogle_Calendar_GetAllCalendars_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieve data for all calendars.
 */
@interface TMBGoogle_Calendar_GetAllCalendars : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Calendar_GetAllCalendars_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Calendar_GetAllCalendars Choreo */


/*! group TMBGoogle.Calendar.GetAllEvents Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetAllEvents Choreo.
 */
@interface TMBGoogle_Calendar_GetAllEvents_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCalendarID:(NSString*)CalendarID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetAllEvents Choreo.
 */
@interface TMBGoogle_Calendar_GetAllEvents_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieve data for all events in a specified calendar.
 */
@interface TMBGoogle_Calendar_GetAllEvents : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Calendar_GetAllEvents_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Calendar_GetAllEvents Choreo */


/*! group TMBGoogle.Calendar.GetAllSettings Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetAllSettings Choreo.
 */
@interface TMBGoogle_Calendar_GetAllSettings_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetAllSettings Choreo.
 */
@interface TMBGoogle_Calendar_GetAllSettings_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves all settings for a Google Calendar account.
 */
@interface TMBGoogle_Calendar_GetAllSettings : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Calendar_GetAllSettings_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Calendar_GetAllSettings Choreo */


/*! group TMBGoogle.Calendar.GetCalendar Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetCalendar Choreo.
 */
@interface TMBGoogle_Calendar_GetCalendar_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCalendarID:(NSString*)CalendarID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetCalendar Choreo.
 */
@interface TMBGoogle_Calendar_GetCalendar_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieve data for a specific calendar in a Google account.
 */
@interface TMBGoogle_Calendar_GetCalendar : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Calendar_GetCalendar_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Calendar_GetCalendar Choreo */


/*! group TMBGoogle.Calendar.GetEvent Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetEvent Choreo.
 */
@interface TMBGoogle_Calendar_GetEvent_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCalendarID:(NSString*)CalendarID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setEventID:(NSString*)EventID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetEvent Choreo.
 */
@interface TMBGoogle_Calendar_GetEvent_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieve data for all calendars in an account.
 */
@interface TMBGoogle_Calendar_GetEvent : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Calendar_GetEvent_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Calendar_GetEvent Choreo */


/*! group TMBGoogle.Calendar.GetNextEvent Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetNextEvent Choreo.
 */
@interface TMBGoogle_Calendar_GetNextEvent_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCalendarID:(NSString*)CalendarID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setTimezone:(NSString*)Timezone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetNextEvent Choreo.
 */
@interface TMBGoogle_Calendar_GetNextEvent_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getBeginTime;
	-(NSString*)getEndTime;
	-(NSString*)getNewAccessToken;
	-(NSString*)getSummary;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the next upcoming event in a Google calendar based on the current timestamp and the specified calendar's timezone setting.
 */
@interface TMBGoogle_Calendar_GetNextEvent : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Calendar_GetNextEvent_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Calendar_GetNextEvent Choreo */


/*! group TMBGoogle.Calendar.GetSetting Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetSetting Choreo.
 */
@interface TMBGoogle_Calendar_GetSetting_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSettingID:(NSString*)SettingID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetSetting Choreo.
 */
@interface TMBGoogle_Calendar_GetSetting_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a specifed setting for a Google Calendar account.
 */
@interface TMBGoogle_Calendar_GetSetting : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Calendar_GetSetting_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Calendar_GetSetting Choreo */


/*! group TMBGoogle.Calendar.SearchCalendarsByName Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SearchCalendarsByName Choreo.
 */
@interface TMBGoogle_Calendar_SearchCalendarsByName_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCalendarName:(NSString*)CalendarName;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setCount:(NSString*)Count;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SearchCalendarsByName Choreo.
 */
@interface TMBGoogle_Calendar_SearchCalendarsByName_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getCalendarDescription;
	-(NSString*)getCalendarId;
	-(NSString*)getCalendarSummary;
	-(NSString*)getCalendarTimezone;
	-(NSString*)getNewAccessToken;	
@end

/*!
 * Retrieves information about a calendar including the id with a given calendar name.
 */
@interface TMBGoogle_Calendar_SearchCalendarsByName : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Calendar_SearchCalendarsByName_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Calendar_SearchCalendarsByName Choreo */


/*! group TMBGoogle.Calendar.SearchEvents Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SearchEvents Choreo.
 */
@interface TMBGoogle_Calendar_SearchEvents_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCalendarID:(NSString*)CalendarID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setLastModified:(NSString*)LastModified;
	-(void)setMaxAttendees:(NSString*)MaxAttendees;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setMaxTime:(NSString*)MaxTime;
	-(void)setMinTime:(NSString*)MinTime;
	-(void)setOrderBy:(NSString*)OrderBy;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setQuery:(NSString*)Query;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setShowDeleted:(NSString*)ShowDeleted;
	-(void)setShowHiddenInvitations:(NSString*)ShowHiddenInvitations;
	-(void)setSingleEvent:(NSString*)SingleEvent;
	-(void)setTimezone:(NSString*)Timezone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SearchEvents Choreo.
 */
@interface TMBGoogle_Calendar_SearchEvents_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Allows you to search for events using a variety of search parameters.
 */
@interface TMBGoogle_Calendar_SearchEvents : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Calendar_SearchEvents_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Calendar_SearchEvents Choreo */


/*! group TMBGoogle.Calendar.UpdateCalendar Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateCalendar Choreo.
 */
@interface TMBGoogle_Calendar_UpdateCalendar_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCalendarID:(NSString*)CalendarID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setNewDescription:(NSString*)NewDescription;
	-(void)setNewLocation:(NSString*)NewLocation;
	-(void)setNewSummary:(NSString*)NewSummary;
	-(void)setNewTimezone:(NSString*)NewTimezone;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateCalendar Choreo.
 */
@interface TMBGoogle_Calendar_UpdateCalendar_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Updates the metadata for a calendar.
 */
@interface TMBGoogle_Calendar_UpdateCalendar : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Calendar_UpdateCalendar_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Calendar_UpdateCalendar Choreo */


/*! group TMBGoogle.ComputeEngine.Addresses.AggregatedList Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AggregatedList Choreo.
 */
@interface TMBGoogle_ComputeEngine_Addresses_AggregatedList_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFilter:(NSString*)Filter;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AggregatedList Choreo.
 */
@interface TMBGoogle_ComputeEngine_Addresses_AggregatedList_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of Address resources across all available regions.
 */
@interface TMBGoogle_ComputeEngine_Addresses_AggregatedList : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Addresses_AggregatedList_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Addresses_AggregatedList Choreo */


/*! group TMBGoogle.ComputeEngine.Addresses.DeleteAddress Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteAddress Choreo.
 */
@interface TMBGoogle_ComputeEngine_Addresses_DeleteAddress_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAddress:(NSString*)Address;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setRegion:(NSString*)Region;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteAddress Choreo.
 */
@interface TMBGoogle_ComputeEngine_Addresses_DeleteAddress_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes a specified address resource.
 */
@interface TMBGoogle_ComputeEngine_Addresses_DeleteAddress : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Addresses_DeleteAddress_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Addresses_DeleteAddress Choreo */


/*! group TMBGoogle.ComputeEngine.Addresses.GetAddress Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetAddress Choreo.
 */
@interface TMBGoogle_ComputeEngine_Addresses_GetAddress_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAddress:(NSString*)Address;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setRegion:(NSString*)Region;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetAddress Choreo.
 */
@interface TMBGoogle_ComputeEngine_Addresses_GetAddress_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves information about the specified Address.
 */
@interface TMBGoogle_ComputeEngine_Addresses_GetAddress : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Addresses_GetAddress_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Addresses_GetAddress Choreo */


/*! group TMBGoogle.ComputeEngine.Addresses.InsertAddress Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the InsertAddress Choreo.
 */
@interface TMBGoogle_ComputeEngine_Addresses_InsertAddress_Inputs : TMBChoreographyInputSet
	-(void)setAddressResource:(NSString*)AddressResource;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAddress:(NSString*)Address;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDescription:(NSString*)Description;
	-(void)setName:(NSString*)Name;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setRegion:(NSString*)Region;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the InsertAddress Choreo.
 */
@interface TMBGoogle_ComputeEngine_Addresses_InsertAddress_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Creates an Address resource in the specified project.
 */
@interface TMBGoogle_ComputeEngine_Addresses_InsertAddress : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Addresses_InsertAddress_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Addresses_InsertAddress Choreo */


/*! group TMBGoogle.ComputeEngine.Addresses.ListAddresses Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListAddresses Choreo.
 */
@interface TMBGoogle_ComputeEngine_Addresses_ListAddresses_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFilter:(NSString*)Filter;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setRegion:(NSString*)Region;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListAddresses Choreo.
 */
@interface TMBGoogle_ComputeEngine_Addresses_ListAddresses_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of Address resources contained within the specified region
 */
@interface TMBGoogle_ComputeEngine_Addresses_ListAddresses : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Addresses_ListAddresses_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Addresses_ListAddresses Choreo */


/*! group TMBGoogle.ComputeEngine.Disks.AggregatedList Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AggregatedList Choreo.
 */
@interface TMBGoogle_ComputeEngine_Disks_AggregatedList_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFilter:(NSString*)Filter;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AggregatedList Choreo.
 */
@interface TMBGoogle_ComputeEngine_Disks_AggregatedList_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves an aggregated list of Disk resources across all zones.
 */
@interface TMBGoogle_ComputeEngine_Disks_AggregatedList : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Disks_AggregatedList_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Disks_AggregatedList Choreo */


/*! group TMBGoogle.ComputeEngine.Disks.CreateSnapshot Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateSnapshot Choreo.
 */
@interface TMBGoogle_ComputeEngine_Disks_CreateSnapshot_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDescription:(NSString*)Description;
	-(void)setDisk:(NSString*)Disk;
	-(void)setName:(NSString*)Name;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSourceDiskID:(NSString*)SourceDiskID;
	-(void)setStorageBytes:(NSString*)StorageBytes;
	-(void)setStorageBytesStatus:(NSString*)StorageBytesStatus;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateSnapshot Choreo.
 */
@interface TMBGoogle_ComputeEngine_Disks_CreateSnapshot_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a snapshot of a specified disk.
 */
@interface TMBGoogle_ComputeEngine_Disks_CreateSnapshot : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Disks_CreateSnapshot_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Disks_CreateSnapshot Choreo */


/*! group TMBGoogle.ComputeEngine.Disks.DeleteDisk Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteDisk Choreo.
 */
@interface TMBGoogle_ComputeEngine_Disks_DeleteDisk_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDisk:(NSString*)Disk;
	-(void)setFields:(NSString*)Fields;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteDisk Choreo.
 */
@interface TMBGoogle_ComputeEngine_Disks_DeleteDisk_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes the specified Persistent Disk resource.
 */
@interface TMBGoogle_ComputeEngine_Disks_DeleteDisk : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Disks_DeleteDisk_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Disks_DeleteDisk Choreo */


/*! group TMBGoogle.ComputeEngine.Disks.GetDisk Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetDisk Choreo.
 */
@interface TMBGoogle_ComputeEngine_Disks_GetDisk_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDisk:(NSString*)Disk;
	-(void)setFields:(NSString*)Fields;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetDisk Choreo.
 */
@interface TMBGoogle_ComputeEngine_Disks_GetDisk_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves information about the specified Persistent Disk.
 */
@interface TMBGoogle_ComputeEngine_Disks_GetDisk : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Disks_GetDisk_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Disks_GetDisk Choreo */


/*! group TMBGoogle.ComputeEngine.Disks.InsertDisk Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the InsertDisk Choreo.
 */
@interface TMBGoogle_ComputeEngine_Disks_InsertDisk_Inputs : TMBChoreographyInputSet
	-(void)setDiskResource:(NSString*)DiskResource;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setName:(NSString*)Name;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSizeGB:(NSString*)SizeGB;
	-(void)setSourceImage:(NSString*)SourceImage;
	-(void)setSourceSnapshot:(NSString*)SourceSnapshot;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the InsertDisk Choreo.
 */
@interface TMBGoogle_ComputeEngine_Disks_InsertDisk_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a Persistent Disk resource in the specified project.
 */
@interface TMBGoogle_ComputeEngine_Disks_InsertDisk : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Disks_InsertDisk_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Disks_InsertDisk Choreo */


/*! group TMBGoogle.ComputeEngine.Disks.ListDisks Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListDisks Choreo.
 */
@interface TMBGoogle_ComputeEngine_Disks_ListDisks_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFilter:(NSString*)Filter;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListDisks Choreo.
 */
@interface TMBGoogle_ComputeEngine_Disks_ListDisks_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the list of Disk resources available to the specified project.
 */
@interface TMBGoogle_ComputeEngine_Disks_ListDisks : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Disks_ListDisks_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Disks_ListDisks Choreo */


/*! group TMBGoogle.ComputeEngine.Firewalls.DeleteFirewall Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteFirewall Choreo.
 */
@interface TMBGoogle_ComputeEngine_Firewalls_DeleteFirewall_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFirewall:(NSString*)Firewall;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteFirewall Choreo.
 */
@interface TMBGoogle_ComputeEngine_Firewalls_DeleteFirewall_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes the specified Firewall resource.
 */
@interface TMBGoogle_ComputeEngine_Firewalls_DeleteFirewall : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Firewalls_DeleteFirewall_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Firewalls_DeleteFirewall Choreo */


/*! group TMBGoogle.ComputeEngine.Firewalls.GetFirewall Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetFirewall Choreo.
 */
@interface TMBGoogle_ComputeEngine_Firewalls_GetFirewall_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFirewall:(NSString*)Firewall;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetFirewall Choreo.
 */
@interface TMBGoogle_ComputeEngine_Firewalls_GetFirewall_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves information about the specified Firewall.
 */
@interface TMBGoogle_ComputeEngine_Firewalls_GetFirewall : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Firewalls_GetFirewall_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Firewalls_GetFirewall Choreo */


/*! group TMBGoogle.ComputeEngine.Firewalls.InsertFirewall Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the InsertFirewall Choreo.
 */
@interface TMBGoogle_ComputeEngine_Firewalls_InsertFirewall_Inputs : TMBChoreographyInputSet
	-(void)setFirewallResource:(NSString*)FirewallResource;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAllowedIPProtocol:(NSString*)AllowedIPProtocol;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDescription:(NSString*)Description;
	-(void)setName:(NSString*)Name;
	-(void)setNetwork:(NSString*)Network;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSourceRanges:(NSString*)SourceRanges;
	-(void)setSourceTags:(NSString*)SourceTags;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the InsertFirewall Choreo.
 */
@interface TMBGoogle_ComputeEngine_Firewalls_InsertFirewall_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a Firewall resource in the specified project.
 */
@interface TMBGoogle_ComputeEngine_Firewalls_InsertFirewall : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Firewalls_InsertFirewall_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Firewalls_InsertFirewall Choreo */


/*! group TMBGoogle.ComputeEngine.Firewalls.ListFirewalls Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListFirewalls Choreo.
 */
@interface TMBGoogle_ComputeEngine_Firewalls_ListFirewalls_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFilter:(NSString*)Filter;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListFirewalls Choreo.
 */
@interface TMBGoogle_ComputeEngine_Firewalls_ListFirewalls_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the list of Firewall resources for the specified project.
 */
@interface TMBGoogle_ComputeEngine_Firewalls_ListFirewalls : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Firewalls_ListFirewalls_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Firewalls_ListFirewalls Choreo */


/*! group TMBGoogle.ComputeEngine.Firewalls.UpdateFirewall Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateFirewall Choreo.
 */
@interface TMBGoogle_ComputeEngine_Firewalls_UpdateFirewall_Inputs : TMBChoreographyInputSet
	-(void)setFirewallResource:(NSString*)FirewallResource;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFirewall:(NSString*)Firewall;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateFirewall Choreo.
 */
@interface TMBGoogle_ComputeEngine_Firewalls_UpdateFirewall_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Updates an existing Firewall resource.
 */
@interface TMBGoogle_ComputeEngine_Firewalls_UpdateFirewall : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Firewalls_UpdateFirewall_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Firewalls_UpdateFirewall Choreo */


/*! group TMBGoogle.ComputeEngine.GlobalOperations.AggregatedList Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AggregatedList Choreo.
 */
@interface TMBGoogle_ComputeEngine_GlobalOperations_AggregatedList_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFilter:(NSString*)Filter;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AggregatedList Choreo.
 */
@interface TMBGoogle_ComputeEngine_GlobalOperations_AggregatedList_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of all Global Operation resources grouped by scope.
 */
@interface TMBGoogle_ComputeEngine_GlobalOperations_AggregatedList : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_GlobalOperations_AggregatedList_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.GlobalOperations_AggregatedList Choreo */


/*! group TMBGoogle.ComputeEngine.GlobalOperations.DeleteGlobalOperation Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteGlobalOperation Choreo.
 */
@interface TMBGoogle_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setOperation:(NSString*)Operation;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteGlobalOperation Choreo.
 */
@interface TMBGoogle_ComputeEngine_GlobalOperations_DeleteGlobalOperation_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes the specified Global Operation.
 */
@interface TMBGoogle_ComputeEngine_GlobalOperations_DeleteGlobalOperation : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.GlobalOperations_DeleteGlobalOperation Choreo */


/*! group TMBGoogle.ComputeEngine.GlobalOperations.GetGlobalOperation Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetGlobalOperation Choreo.
 */
@interface TMBGoogle_ComputeEngine_GlobalOperations_GetGlobalOperation_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setOperation:(NSString*)Operation;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetGlobalOperation Choreo.
 */
@interface TMBGoogle_ComputeEngine_GlobalOperations_GetGlobalOperation_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves information about the specified Global Operation.
 */
@interface TMBGoogle_ComputeEngine_GlobalOperations_GetGlobalOperation : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_GlobalOperations_GetGlobalOperation_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.GlobalOperations_GetGlobalOperation Choreo */


/*! group TMBGoogle.ComputeEngine.GlobalOperations.ListGlobalOperations Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListGlobalOperations Choreo.
 */
@interface TMBGoogle_ComputeEngine_GlobalOperations_ListGlobalOperations_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFilter:(NSString*)Filter;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListGlobalOperations Choreo.
 */
@interface TMBGoogle_ComputeEngine_GlobalOperations_ListGlobalOperations_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of GlobalOperations resources contained within the specified project.
 */
@interface TMBGoogle_ComputeEngine_GlobalOperations_ListGlobalOperations : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_GlobalOperations_ListGlobalOperations_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.GlobalOperations_ListGlobalOperations Choreo */


/*! group TMBGoogle.ComputeEngine.Images.DeleteImage Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteImage Choreo.
 */
@interface TMBGoogle_ComputeEngine_Images_DeleteImage_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setImage:(NSString*)Image;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteImage Choreo.
 */
@interface TMBGoogle_ComputeEngine_Images_DeleteImage_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes the specified Image resource.
 */
@interface TMBGoogle_ComputeEngine_Images_DeleteImage : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Images_DeleteImage_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Images_DeleteImage Choreo */


/*! group TMBGoogle.ComputeEngine.Images.GetImage Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetImage Choreo.
 */
@interface TMBGoogle_ComputeEngine_Images_GetImage_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setImage:(NSString*)Image;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetImage Choreo.
 */
@interface TMBGoogle_ComputeEngine_Images_GetImage_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves information about the specified Image.
 */
@interface TMBGoogle_ComputeEngine_Images_GetImage : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Images_GetImage_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Images_GetImage Choreo */


/*! group TMBGoogle.ComputeEngine.Images.InsertImage Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the InsertImage Choreo.
 */
@interface TMBGoogle_ComputeEngine_Images_InsertImage_Inputs : TMBChoreographyInputSet
	-(void)setImageResource:(NSString*)ImageResource;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDescription:(NSString*)Description;
	-(void)setName:(NSString*)Name;
	-(void)setProject:(NSString*)Project;
	-(void)setRawDiskSource:(NSString*)RawDiskSource;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the InsertImage Choreo.
 */
@interface TMBGoogle_ComputeEngine_Images_InsertImage_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new custom Image resource in the specified project.
 */
@interface TMBGoogle_ComputeEngine_Images_InsertImage : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Images_InsertImage_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Images_InsertImage Choreo */


/*! group TMBGoogle.ComputeEngine.Images.ListImages Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListImages Choreo.
 */
@interface TMBGoogle_ComputeEngine_Images_ListImages_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFilter:(NSString*)Filter;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListImages Choreo.
 */
@interface TMBGoogle_ComputeEngine_Images_ListImages_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of Image resources for the specified project.
 */
@interface TMBGoogle_ComputeEngine_Images_ListImages : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Images_ListImages_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Images_ListImages Choreo */


/*! group TMBGoogle.ComputeEngine.Instances.AddAccessConfig Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AddAccessConfig Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_AddAccessConfig_Inputs : TMBChoreographyInputSet
	-(void)setAccessConfiguration:(NSString*)AccessConfiguration;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setInstance:(NSString*)Instance;
	-(void)setName:(NSString*)Name;
	-(void)setNatIP:(NSString*)NatIP;
	-(void)setNetworkInterface:(NSString*)NetworkInterface;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setType:(NSString*)Type;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddAccessConfig Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_AddAccessConfig_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Adds an access config to an instance's network interface.
 */
@interface TMBGoogle_ComputeEngine_Instances_AddAccessConfig : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Instances_AddAccessConfig_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Instances_AddAccessConfig Choreo */


/*! group TMBGoogle.ComputeEngine.Instances.AggregatedList Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AggregatedList Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_AggregatedList_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFilter:(NSString*)Filter;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AggregatedList Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_AggregatedList_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of Instance resources across all available zones.
 */
@interface TMBGoogle_ComputeEngine_Instances_AggregatedList : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Instances_AggregatedList_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Instances_AggregatedList Choreo */


/*! group TMBGoogle.ComputeEngine.Instances.AttachDisk Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AttachDisk Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_AttachDisk_Inputs : TMBChoreographyInputSet
	-(void)setAttachedDisk:(NSString*)AttachedDisk;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setBoot:(NSString*)Boot;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDeviceName:(NSString*)DeviceName;
	-(void)setFields:(NSString*)Fields;
	-(void)setInstance:(NSString*)Instance;
	-(void)setMode:(NSString*)Mode;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSource:(NSString*)Source;
	-(void)setType:(NSString*)Type;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AttachDisk Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_AttachDisk_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Attaches a Disk resource to an instance.
 */
@interface TMBGoogle_ComputeEngine_Instances_AttachDisk : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Instances_AttachDisk_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Instances_AttachDisk Choreo */


/*! group TMBGoogle.ComputeEngine.Instances.DeleteAccessConfig Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteAccessConfig Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_DeleteAccessConfig_Inputs : TMBChoreographyInputSet
	-(void)setAccessConfig:(NSString*)AccessConfig;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setInstance:(NSString*)Instance;
	-(void)setNetworkInterface:(NSString*)NetworkInterface;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteAccessConfig Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_DeleteAccessConfig_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes an access configuation from an instance's network interface.
 */
@interface TMBGoogle_ComputeEngine_Instances_DeleteAccessConfig : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Instances_DeleteAccessConfig_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Instances_DeleteAccessConfig Choreo */


/*! group TMBGoogle.ComputeEngine.Instances.DeleteInstance Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteInstance Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_DeleteInstance_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setInstance:(NSString*)Instance;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteInstance Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_DeleteInstance_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes the specified Instance resource.
 */
@interface TMBGoogle_ComputeEngine_Instances_DeleteInstance : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Instances_DeleteInstance_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Instances_DeleteInstance Choreo */


/*! group TMBGoogle.ComputeEngine.Instances.DetachDisk Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DetachDisk Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_DetachDisk_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDeviceName:(NSString*)DeviceName;
	-(void)setFields:(NSString*)Fields;
	-(void)setInstance:(NSString*)Instance;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DetachDisk Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_DetachDisk_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Detaches a Disk resource from an instance.
 */
@interface TMBGoogle_ComputeEngine_Instances_DetachDisk : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Instances_DetachDisk_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Instances_DetachDisk Choreo */


/*! group TMBGoogle.ComputeEngine.Instances.GetInstance Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetInstance Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_GetInstance_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setInstance:(NSString*)Instance;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetInstance Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_GetInstance_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves information about the specified Instance.
 */
@interface TMBGoogle_ComputeEngine_Instances_GetInstance : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Instances_GetInstance_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Instances_GetInstance Choreo */


/*! group TMBGoogle.ComputeEngine.Instances.GetSerialPortOutput Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetSerialPortOutput Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_GetSerialPortOutput_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setInstance:(NSString*)Instance;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetSerialPortOutput Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_GetSerialPortOutput_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Returns the specified instance's serial port output.
 */
@interface TMBGoogle_ComputeEngine_Instances_GetSerialPortOutput : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Instances_GetSerialPortOutput_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Instances_GetSerialPortOutput Choreo */


/*! group TMBGoogle.ComputeEngine.Instances.InsertInstance Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the InsertInstance Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_InsertInstance_Inputs : TMBChoreographyInputSet
	-(void)setInstanceResource:(NSString*)InstanceResource;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDescription:(NSString*)Description;
	-(void)setDisks:(NSString*)Disks;
	-(void)setMachineType:(NSString*)MachineType;
	-(void)setName:(NSString*)Name;
	-(void)setNetworkInterfaces:(NSString*)NetworkInterfaces;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the InsertInstance Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_InsertInstance_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Creates an Instance resource in the specified project.
 */
@interface TMBGoogle_ComputeEngine_Instances_InsertInstance : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Instances_InsertInstance_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Instances_InsertInstance Choreo */


/*! group TMBGoogle.ComputeEngine.Instances.ListInstances Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListInstances Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_ListInstances_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFilter:(NSString*)Filter;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListInstances Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_ListInstances_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the list of Instance resources contained within the specified Zone.
 */
@interface TMBGoogle_ComputeEngine_Instances_ListInstances : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Instances_ListInstances_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Instances_ListInstances Choreo */


/*! group TMBGoogle.ComputeEngine.Instances.SetMetadata Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SetMetadata Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_SetMetadata_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFingerprint:(NSString*)Fingerprint;
	-(void)setInstance:(NSString*)Instance;
	-(void)setItems:(NSString*)Items;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SetMetadata Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_SetMetadata_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Sets the metadata for the specified instance.
 */
@interface TMBGoogle_ComputeEngine_Instances_SetMetadata : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Instances_SetMetadata_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Instances_SetMetadata Choreo */


/*! group TMBGoogle.ComputeEngine.Instances.SetTags Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SetTags Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_SetTags_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFingerprint:(NSString*)Fingerprint;
	-(void)setInstance:(NSString*)Instance;
	-(void)setItems:(NSString*)Items;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SetTags Choreo.
 */
@interface TMBGoogle_ComputeEngine_Instances_SetTags_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Sets tags for the specified instance.
 */
@interface TMBGoogle_ComputeEngine_Instances_SetTags : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Instances_SetTags_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Instances_SetTags Choreo */


/*! group TMBGoogle.ComputeEngine.MachineTypes.AggregatedList Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AggregatedList Choreo.
 */
@interface TMBGoogle_ComputeEngine_MachineTypes_AggregatedList_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFilter:(NSString*)Filter;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AggregatedList Choreo.
 */
@interface TMBGoogle_ComputeEngine_MachineTypes_AggregatedList_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of Machine Type resources across all available zones.
 */
@interface TMBGoogle_ComputeEngine_MachineTypes_AggregatedList : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_MachineTypes_AggregatedList_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.MachineTypes_AggregatedList Choreo */


/*! group TMBGoogle.ComputeEngine.MachineTypes.GetMachineType Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetMachineType Choreo.
 */
@interface TMBGoogle_ComputeEngine_MachineTypes_GetMachineType_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setMachineType:(NSString*)MachineType;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetMachineType Choreo.
 */
@interface TMBGoogle_ComputeEngine_MachineTypes_GetMachineType_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves information about the specified Machine Type.
 */
@interface TMBGoogle_ComputeEngine_MachineTypes_GetMachineType : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_MachineTypes_GetMachineType_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.MachineTypes_GetMachineType Choreo */


/*! group TMBGoogle.ComputeEngine.MachineTypes.ListMachineTypes Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListMachineTypes Choreo.
 */
@interface TMBGoogle_ComputeEngine_MachineTypes_ListMachineTypes_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFilter:(NSString*)Filter;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListMachineTypes Choreo.
 */
@interface TMBGoogle_ComputeEngine_MachineTypes_ListMachineTypes_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the list of Machine Type resources for the specified project.
 */
@interface TMBGoogle_ComputeEngine_MachineTypes_ListMachineTypes : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_MachineTypes_ListMachineTypes_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.MachineTypes_ListMachineTypes Choreo */


/*! group TMBGoogle.ComputeEngine.Networks.DeleteNetwork Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteNetwork Choreo.
 */
@interface TMBGoogle_ComputeEngine_Networks_DeleteNetwork_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setNetwork:(NSString*)Network;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteNetwork Choreo.
 */
@interface TMBGoogle_ComputeEngine_Networks_DeleteNetwork_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes the specified Network resource.
 */
@interface TMBGoogle_ComputeEngine_Networks_DeleteNetwork : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Networks_DeleteNetwork_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Networks_DeleteNetwork Choreo */


/*! group TMBGoogle.ComputeEngine.Networks.GetNetwork Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetNetwork Choreo.
 */
@interface TMBGoogle_ComputeEngine_Networks_GetNetwork_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setNetwork:(NSString*)Network;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetNetwork Choreo.
 */
@interface TMBGoogle_ComputeEngine_Networks_GetNetwork_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves information about the specified Network.
 */
@interface TMBGoogle_ComputeEngine_Networks_GetNetwork : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Networks_GetNetwork_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Networks_GetNetwork Choreo */


/*! group TMBGoogle.ComputeEngine.Networks.InsertNetwork Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the InsertNetwork Choreo.
 */
@interface TMBGoogle_ComputeEngine_Networks_InsertNetwork_Inputs : TMBChoreographyInputSet
	-(void)setNetworkResource:(NSString*)NetworkResource;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDescription:(NSString*)Description;
	-(void)setGatewayIP:(NSString*)GatewayIP;
	-(void)setIPRange:(NSString*)IPRange;
	-(void)setName:(NSString*)Name;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the InsertNetwork Choreo.
 */
@interface TMBGoogle_ComputeEngine_Networks_InsertNetwork_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new Network resource in the specified project.
 */
@interface TMBGoogle_ComputeEngine_Networks_InsertNetwork : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Networks_InsertNetwork_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Networks_InsertNetwork Choreo */


/*! group TMBGoogle.ComputeEngine.Networks.ListNetworks Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListNetworks Choreo.
 */
@interface TMBGoogle_ComputeEngine_Networks_ListNetworks_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFilter:(NSString*)Filter;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListNetworks Choreo.
 */
@interface TMBGoogle_ComputeEngine_Networks_ListNetworks_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the list of Network resources for the specified project.
 */
@interface TMBGoogle_ComputeEngine_Networks_ListNetworks : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Networks_ListNetworks_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Networks_ListNetworks Choreo */


/*! group TMBGoogle.ComputeEngine.Projects.GetProject Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetProject Choreo.
 */
@interface TMBGoogle_ComputeEngine_Projects_GetProject_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetProject Choreo.
 */
@interface TMBGoogle_ComputeEngine_Projects_GetProject_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the specified Project resource.
 */
@interface TMBGoogle_ComputeEngine_Projects_GetProject : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Projects_GetProject_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Projects_GetProject Choreo */


/*! group TMBGoogle.ComputeEngine.Projects.SetCommonInstanceMetadata Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SetCommonInstanceMetadata Choreo.
 */
@interface TMBGoogle_ComputeEngine_Projects_SetCommonInstanceMetadata_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFingerprint:(NSString*)Fingerprint;
	-(void)setItems:(NSString*)Items;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SetCommonInstanceMetadata Choreo.
 */
@interface TMBGoogle_ComputeEngine_Projects_SetCommonInstanceMetadata_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Sets metadata common to all instances within the specified Project.
 */
@interface TMBGoogle_ComputeEngine_Projects_SetCommonInstanceMetadata : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Projects_SetCommonInstanceMetadata_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Projects_SetCommonInstanceMetadata Choreo */


/*! group TMBGoogle.ComputeEngine.RegionOperations.DeleteRegionOperation Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteRegionOperation Choreo.
 */
@interface TMBGoogle_ComputeEngine_RegionOperations_DeleteRegionOperation_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setOperation:(NSString*)Operation;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setRegion:(NSString*)Region;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteRegionOperation Choreo.
 */
@interface TMBGoogle_ComputeEngine_RegionOperations_DeleteRegionOperation_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes the specified operation within a region.
 */
@interface TMBGoogle_ComputeEngine_RegionOperations_DeleteRegionOperation : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_RegionOperations_DeleteRegionOperation_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.RegionOperations_DeleteRegionOperation Choreo */


/*! group TMBGoogle.ComputeEngine.RegionOperations.GetRegionOperation Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetRegionOperation Choreo.
 */
@interface TMBGoogle_ComputeEngine_RegionOperations_GetRegionOperation_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setOperation:(NSString*)Operation;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setRegion:(NSString*)Region;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetRegionOperation Choreo.
 */
@interface TMBGoogle_ComputeEngine_RegionOperations_GetRegionOperation_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves information about the specified operation within a region.
 */
@interface TMBGoogle_ComputeEngine_RegionOperations_GetRegionOperation : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_RegionOperations_GetRegionOperation_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.RegionOperations_GetRegionOperation Choreo */


/*! group TMBGoogle.ComputeEngine.RegionOperations.ListRegionOperations Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListRegionOperations Choreo.
 */
@interface TMBGoogle_ComputeEngine_RegionOperations_ListRegionOperations_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFilter:(NSString*)Filter;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setRegion:(NSString*)Region;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListRegionOperations Choreo.
 */
@interface TMBGoogle_ComputeEngine_RegionOperations_ListRegionOperations_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of operation resources contained within the specified region.
 */
@interface TMBGoogle_ComputeEngine_RegionOperations_ListRegionOperations : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_RegionOperations_ListRegionOperations_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.RegionOperations_ListRegionOperations Choreo */


/*! group TMBGoogle.ComputeEngine.Regions.GetRegion Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetRegion Choreo.
 */
@interface TMBGoogle_ComputeEngine_Regions_GetRegion_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setRegion:(NSString*)Region;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetRegion Choreo.
 */
@interface TMBGoogle_ComputeEngine_Regions_GetRegion_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves information about the specified Region.
 */
@interface TMBGoogle_ComputeEngine_Regions_GetRegion : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Regions_GetRegion_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Regions_GetRegion Choreo */


/*! group TMBGoogle.ComputeEngine.Regions.ListRegions Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListRegions Choreo.
 */
@interface TMBGoogle_ComputeEngine_Regions_ListRegions_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFilter:(NSString*)Filter;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListRegions Choreo.
 */
@interface TMBGoogle_ComputeEngine_Regions_ListRegions_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the list of Regions available to the specified project.
 */
@interface TMBGoogle_ComputeEngine_Regions_ListRegions : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Regions_ListRegions_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Regions_ListRegions Choreo */


/*! group TMBGoogle.ComputeEngine.Routes.DeleteRoute Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteRoute Choreo.
 */
@interface TMBGoogle_ComputeEngine_Routes_DeleteRoute_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setRoute:(NSString*)Route;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteRoute Choreo.
 */
@interface TMBGoogle_ComputeEngine_Routes_DeleteRoute_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes the specified Route.
 */
@interface TMBGoogle_ComputeEngine_Routes_DeleteRoute : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Routes_DeleteRoute_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Routes_DeleteRoute Choreo */


/*! group TMBGoogle.ComputeEngine.Routes.GetRoute Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetRoute Choreo.
 */
@interface TMBGoogle_ComputeEngine_Routes_GetRoute_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setRoute:(NSString*)Route;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetRoute Choreo.
 */
@interface TMBGoogle_ComputeEngine_Routes_GetRoute_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves information about the specified Route.
 */
@interface TMBGoogle_ComputeEngine_Routes_GetRoute : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Routes_GetRoute_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Routes_GetRoute Choreo */


/*! group TMBGoogle.ComputeEngine.Routes.InsertRoute Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the InsertRoute Choreo.
 */
@interface TMBGoogle_ComputeEngine_Routes_InsertRoute_Inputs : TMBChoreographyInputSet
	-(void)setRouteResource:(NSString*)RouteResource;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the InsertRoute Choreo.
 */
@interface TMBGoogle_ComputeEngine_Routes_InsertRoute_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a Route resource in the specified project.
 */
@interface TMBGoogle_ComputeEngine_Routes_InsertRoute : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Routes_InsertRoute_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Routes_InsertRoute Choreo */


/*! group TMBGoogle.ComputeEngine.Routes.ListRoutes Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListRoutes Choreo.
 */
@interface TMBGoogle_ComputeEngine_Routes_ListRoutes_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFilter:(NSString*)Filter;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListRoutes Choreo.
 */
@interface TMBGoogle_ComputeEngine_Routes_ListRoutes_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of route resources available to the specified project.
 */
@interface TMBGoogle_ComputeEngine_Routes_ListRoutes : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Routes_ListRoutes_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Routes_ListRoutes Choreo */


/*! group TMBGoogle.ComputeEngine.Snapshots.DeleteSnapshot Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteSnapshot Choreo.
 */
@interface TMBGoogle_ComputeEngine_Snapshots_DeleteSnapshot_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSnapshot:(NSString*)Snapshot;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteSnapshot Choreo.
 */
@interface TMBGoogle_ComputeEngine_Snapshots_DeleteSnapshot_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes a specified Snapshot resource.
 */
@interface TMBGoogle_ComputeEngine_Snapshots_DeleteSnapshot : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Snapshots_DeleteSnapshot_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Snapshots_DeleteSnapshot Choreo */


/*! group TMBGoogle.ComputeEngine.Snapshots.GetSnapshot Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetSnapshot Choreo.
 */
@interface TMBGoogle_ComputeEngine_Snapshots_GetSnapshot_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSnapshot:(NSString*)Snapshot;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetSnapshot Choreo.
 */
@interface TMBGoogle_ComputeEngine_Snapshots_GetSnapshot_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves information about the specified Snapshot.
 */
@interface TMBGoogle_ComputeEngine_Snapshots_GetSnapshot : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Snapshots_GetSnapshot_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Snapshots_GetSnapshot Choreo */


/*! group TMBGoogle.ComputeEngine.Snapshots.ListSnapshots Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListSnapshots Choreo.
 */
@interface TMBGoogle_ComputeEngine_Snapshots_ListSnapshots_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFilter:(NSString*)Filter;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListSnapshots Choreo.
 */
@interface TMBGoogle_ComputeEngine_Snapshots_ListSnapshots_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of persistent disk snapshot resources for the specified project.
 */
@interface TMBGoogle_ComputeEngine_Snapshots_ListSnapshots : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Snapshots_ListSnapshots_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Snapshots_ListSnapshots Choreo */


/*! group TMBGoogle.ComputeEngine.ZoneOperations.DeleteZoneOperation Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteZoneOperation Choreo.
 */
@interface TMBGoogle_ComputeEngine_ZoneOperations_DeleteZoneOperation_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setOperation:(NSString*)Operation;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteZoneOperation Choreo.
 */
@interface TMBGoogle_ComputeEngine_ZoneOperations_DeleteZoneOperation_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes the specified Zone Operation resource.
 */
@interface TMBGoogle_ComputeEngine_ZoneOperations_DeleteZoneOperation : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_ZoneOperations_DeleteZoneOperation_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.ZoneOperations_DeleteZoneOperation Choreo */


/*! group TMBGoogle.ComputeEngine.ZoneOperations.GetZoneOperation Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetZoneOperation Choreo.
 */
@interface TMBGoogle_ComputeEngine_ZoneOperations_GetZoneOperation_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setOperation:(NSString*)Operation;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetZoneOperation Choreo.
 */
@interface TMBGoogle_ComputeEngine_ZoneOperations_GetZoneOperation_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves information about the specified Zone Operation.
 */
@interface TMBGoogle_ComputeEngine_ZoneOperations_GetZoneOperation : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_ZoneOperations_GetZoneOperation_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.ZoneOperations_GetZoneOperation Choreo */


/*! group TMBGoogle.ComputeEngine.ZoneOperations.ListZoneOperations Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListZoneOperations Choreo.
 */
@interface TMBGoogle_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFilter:(NSString*)Filter;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListZoneOperations Choreo.
 */
@interface TMBGoogle_ComputeEngine_ZoneOperations_ListZoneOperations_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the list of Zone Operation resources contained within the specified Zone.
 */
@interface TMBGoogle_ComputeEngine_ZoneOperations_ListZoneOperations : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.ZoneOperations_ListZoneOperations Choreo */


/*! group TMBGoogle.ComputeEngine.Zones.GetZone Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetZone Choreo.
 */
@interface TMBGoogle_ComputeEngine_Zones_GetZone_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setZone:(NSString*)Zone;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetZone Choreo.
 */
@interface TMBGoogle_ComputeEngine_Zones_GetZone_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves information about the specified Zone.
 */
@interface TMBGoogle_ComputeEngine_Zones_GetZone : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Zones_GetZone_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Zones_GetZone Choreo */


/*! group TMBGoogle.ComputeEngine.Zones.ListZones Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListZones Choreo.
 */
@interface TMBGoogle_ComputeEngine_Zones_ListZones_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFilter:(NSString*)Filter;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setProject:(NSString*)Project;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListZones Choreo.
 */
@interface TMBGoogle_ComputeEngine_Zones_ListZones_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the list of Zone resources for the specified project.
 */
@interface TMBGoogle_ComputeEngine_Zones_ListZones : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_ComputeEngine_Zones_ListZones_Inputs*)newInputSet;
@end

/*! group TMBGoogle.ComputeEngine.Zones_ListZones Choreo */


/*! group TMBGoogle.Contacts.CreateContact Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateContact Choreo.
 */
@interface TMBGoogle_Contacts_CreateContact_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setEmail:(NSString*)Email;
	-(void)setFirstName:(NSString*)FirstName;
	-(void)setLastName:(NSString*)LastName;
	-(void)setPhone:(NSString*)Phone;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateContact Choreo.
 */
@interface TMBGoogle_Contacts_CreateContact_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAccessToken;
	-(NSString*)getContactID;
	-(NSString*)getResponse;	
@end

/*!
 * Create a new contact.
 */
@interface TMBGoogle_Contacts_CreateContact : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Contacts_CreateContact_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Contacts_CreateContact Choreo */


/*! group TMBGoogle.Contacts.DeleteContact Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteContact Choreo.
 */
@interface TMBGoogle_Contacts_DeleteContact_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setContactID:(NSString*)ContactID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteContact Choreo.
 */
@interface TMBGoogle_Contacts_DeleteContact_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes a specified contact.
 */
@interface TMBGoogle_Contacts_DeleteContact : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Contacts_DeleteContact_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Contacts_DeleteContact Choreo */


/*! group TMBGoogle.Contacts.GetAllContacts Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetAllContacts Choreo.
 */
@interface TMBGoogle_Contacts_GetAllContacts_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setGroup:(NSString*)Group;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSortOrder:(NSString*)SortOrder;
	-(void)setStartIndex:(NSString*)StartIndex;
	-(void)setUpdatedMin:(NSString*)UpdatedMin;
	-(void)setUserEmail:(NSString*)UserEmail;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetAllContacts Choreo.
 */
@interface TMBGoogle_Contacts_GetAllContacts_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieve data for all contacts in an account.
 */
@interface TMBGoogle_Contacts_GetAllContacts : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Contacts_GetAllContacts_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Contacts_GetAllContacts Choreo */


/*! group TMBGoogle.Contacts.GetAllGroups Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetAllGroups Choreo.
 */
@interface TMBGoogle_Contacts_GetAllGroups_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setStartIndex:(NSString*)StartIndex;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetAllGroups Choreo.
 */
@interface TMBGoogle_Contacts_GetAllGroups_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieve data for all groups in an account.
 */
@interface TMBGoogle_Contacts_GetAllGroups : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Contacts_GetAllGroups_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Contacts_GetAllGroups Choreo */


/*! group TMBGoogle.Contacts.GetContactById Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetContactById Choreo.
 */
@interface TMBGoogle_Contacts_GetContactById_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setContactId:(NSString*)ContactId;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserEmail:(NSString*)UserEmail;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetContactById Choreo.
 */
@interface TMBGoogle_Contacts_GetContactById_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a specific contact with a given id.
 */
@interface TMBGoogle_Contacts_GetContactById : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Contacts_GetContactById_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Contacts_GetContactById Choreo */


/*! group TMBGoogle.Contacts.GetContactsWithQuery Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetContactsWithQuery Choreo.
 */
@interface TMBGoogle_Contacts_GetContactsWithQuery_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setGroup:(NSString*)Group;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setQuery:(NSString*)Query;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSortOrder:(NSString*)SortOrder;
	-(void)setStartIndex:(NSString*)StartIndex;
	-(void)setUpdatedMin:(NSString*)UpdatedMin;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetContactsWithQuery Choreo.
 */
@interface TMBGoogle_Contacts_GetContactsWithQuery_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAccessToken;
	-(NSString*)getContactID;
	-(NSString*)getLink;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the contact or contacts in that account that match a specified query term.
 */
@interface TMBGoogle_Contacts_GetContactsWithQuery : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Contacts_GetContactsWithQuery_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Contacts_GetContactsWithQuery Choreo */


/*! group TMBGoogle.Contacts.UpdateContact Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateContact Choreo.
 */
@interface TMBGoogle_Contacts_UpdateContact_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setID:(NSString*)ID;
	-(void)setNewEmail:(NSString*)NewEmail;
	-(void)setNewFirstName:(NSString*)NewFirstName;
	-(void)setNewLastName:(NSString*)NewLastName;
	-(void)setNewPhone:(NSString*)NewPhone;
	-(void)setQuery:(NSString*)Query;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateContact Choreo.
 */
@interface TMBGoogle_Contacts_UpdateContact_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAccessToken;
	-(NSString*)getContactID;
	-(NSString*)getEmail;
	-(NSString*)getFirstName;
	-(NSString*)getLastName;
	-(NSString*)getPhone;
	-(NSString*)getResponse;	
@end

/*!
 * Update an existing contact's information.
 */
@interface TMBGoogle_Contacts_UpdateContact : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Contacts_UpdateContact_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Contacts_UpdateContact Choreo */


/*! group TMBGoogle.Directions.GetBicyclingDirections Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetBicyclingDirections Choreo.
 */
@interface TMBGoogle_Directions_GetBicyclingDirections_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAlternatives:(NSString*)Alternatives;
	-(void)setDestination:(NSString*)Destination;
	-(void)setOrigin:(NSString*)Origin;
	-(void)setRegion:(NSString*)Region;
	-(void)setSensor:(NSString*)Sensor;
	-(void)setUnits:(NSString*)Units;
	-(void)setWaypoints:(NSString*)Waypoints;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetBicyclingDirections Choreo.
 */
@interface TMBGoogle_Directions_GetBicyclingDirections_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 *  Generate biking directions between two locations, denoted by address or latitude/longitude coordinates.
 */
@interface TMBGoogle_Directions_GetBicyclingDirections : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Directions_GetBicyclingDirections_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Directions_GetBicyclingDirections Choreo */


/*! group TMBGoogle.Directions.GetDrivingDirections Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetDrivingDirections Choreo.
 */
@interface TMBGoogle_Directions_GetDrivingDirections_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAlternatives:(NSString*)Alternatives;
	-(void)setAvoid:(NSString*)Avoid;
	-(void)setDestination:(NSString*)Destination;
	-(void)setOrigin:(NSString*)Origin;
	-(void)setRegion:(NSString*)Region;
	-(void)setSensor:(NSString*)Sensor;
	-(void)setUnits:(NSString*)Units;
	-(void)setWaypoints:(NSString*)Waypoints;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetDrivingDirections Choreo.
 */
@interface TMBGoogle_Directions_GetDrivingDirections_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 *  Generates directions between two locations, denoted by address, or latitude/longitude coordinates.
 */
@interface TMBGoogle_Directions_GetDrivingDirections : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Directions_GetDrivingDirections_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Directions_GetDrivingDirections Choreo */


/*! group TMBGoogle.Directions.GetWalkingDirections Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetWalkingDirections Choreo.
 */
@interface TMBGoogle_Directions_GetWalkingDirections_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAlternatives:(NSString*)Alternatives;
	-(void)setDestination:(NSString*)Destination;
	-(void)setOrigin:(NSString*)Origin;
	-(void)setRegion:(NSString*)Region;
	-(void)setSensor:(NSString*)Sensor;
	-(void)setUnits:(NSString*)Units;
	-(void)setWaypoints:(NSString*)Waypoints;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetWalkingDirections Choreo.
 */
@interface TMBGoogle_Directions_GetWalkingDirections_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 *  Generate walking directions between two locations, denoted by address or latitude/longitude coordinates.
 */
@interface TMBGoogle_Directions_GetWalkingDirections : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Directions_GetWalkingDirections_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Directions_GetWalkingDirections Choreo */


/*! group TMBGoogle.DistanceMatrix.BicyclingDistanceMatrix Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the BicyclingDistanceMatrix Choreo.
 */
@interface TMBGoogle_DistanceMatrix_BicyclingDistanceMatrix_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAlternatives:(NSString*)Alternatives;
	-(void)setDestinations:(NSString*)Destinations;
	-(void)setLanguage:(NSString*)Language;
	-(void)setOrigins:(NSString*)Origins;
	-(void)setRegion:(NSString*)Region;
	-(void)setSensor:(NSString*)Sensor;
	-(void)setUnits:(NSString*)Units;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the BicyclingDistanceMatrix Choreo.
 */
@interface TMBGoogle_DistanceMatrix_BicyclingDistanceMatrix_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getDistance;
	-(NSString*)getDuration;
	-(NSString*)getResponse;	
@end

/*!
 * Obtain bicycling distances and times for a matrix of addresses and/or latitude/longitude coordinates.
 */
@interface TMBGoogle_DistanceMatrix_BicyclingDistanceMatrix : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_DistanceMatrix_BicyclingDistanceMatrix_Inputs*)newInputSet;
@end

/*! group TMBGoogle.DistanceMatrix_BicyclingDistanceMatrix Choreo */


/*! group TMBGoogle.DistanceMatrix.DrivingDistanceMatrix Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DrivingDistanceMatrix Choreo.
 */
@interface TMBGoogle_DistanceMatrix_DrivingDistanceMatrix_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAlternatives:(NSString*)Alternatives;
	-(void)setAvoid:(NSString*)Avoid;
	-(void)setDestinations:(NSString*)Destinations;
	-(void)setLanguage:(NSString*)Language;
	-(void)setOrigins:(NSString*)Origins;
	-(void)setRegion:(NSString*)Region;
	-(void)setSensor:(NSString*)Sensor;
	-(void)setUnits:(NSString*)Units;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DrivingDistanceMatrix Choreo.
 */
@interface TMBGoogle_DistanceMatrix_DrivingDistanceMatrix_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getDistance;
	-(NSString*)getDuration;
	-(NSString*)getResponse;	
@end

/*!
 * Obtain travel distances and times for a matrix of addresses and/or latitude/longitude coordinates.
 */
@interface TMBGoogle_DistanceMatrix_DrivingDistanceMatrix : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_DistanceMatrix_DrivingDistanceMatrix_Inputs*)newInputSet;
@end

/*! group TMBGoogle.DistanceMatrix_DrivingDistanceMatrix Choreo */


/*! group TMBGoogle.DistanceMatrix.WalkingDistanceMatrix Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the WalkingDistanceMatrix Choreo.
 */
@interface TMBGoogle_DistanceMatrix_WalkingDistanceMatrix_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAlternatives:(NSString*)Alternatives;
	-(void)setDestinations:(NSString*)Destinations;
	-(void)setLanguage:(NSString*)Language;
	-(void)setOrigins:(NSString*)Origins;
	-(void)setRegion:(NSString*)Region;
	-(void)setSensor:(NSString*)Sensor;
	-(void)setUnits:(NSString*)Units;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the WalkingDistanceMatrix Choreo.
 */
@interface TMBGoogle_DistanceMatrix_WalkingDistanceMatrix_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getDistance;
	-(NSString*)getDuration;
	-(NSString*)getResponse;	
@end

/*!
 * Obtain walking distances and times for a matrix of addresses and/or latitude/longitude coordinates.
 */
@interface TMBGoogle_DistanceMatrix_WalkingDistanceMatrix : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_DistanceMatrix_WalkingDistanceMatrix_Inputs*)newInputSet;
@end

/*! group TMBGoogle.DistanceMatrix_WalkingDistanceMatrix Choreo */


/*! group TMBGoogle.Drive.Changes.Get Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Get Choreo.
 */
@interface TMBGoogle_Drive_Changes_Get_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setChangeID:(NSString*)ChangeID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Get Choreo.
 */
@interface TMBGoogle_Drive_Changes_Get_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Gets a specific change.
 */
@interface TMBGoogle_Drive_Changes_Get : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Changes_Get_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Changes_Get Choreo */


/*! group TMBGoogle.Drive.Changes.List Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the List Choreo.
 */
@interface TMBGoogle_Drive_Changes_List_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setIncludeDeleted:(NSString*)IncludeDeleted;
	-(void)setIncludeSubscribed:(NSString*)IncludeSubscribed;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setStartChangeID:(NSString*)StartChangeID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the List Choreo.
 */
@interface TMBGoogle_Drive_Changes_List_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists the changes for a user.
 */
@interface TMBGoogle_Drive_Changes_List : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Changes_List_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Changes_List Choreo */


/*! group TMBGoogle.Drive.Children.Delete Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Delete Choreo.
 */
@interface TMBGoogle_Drive_Children_Delete_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setChildID:(NSString*)ChildID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFolderID:(NSString*)FolderID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Delete Choreo.
 */
@interface TMBGoogle_Drive_Children_Delete_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Removes a child for a folder.
 */
@interface TMBGoogle_Drive_Children_Delete : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Children_Delete_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Children_Delete Choreo */


/*! group TMBGoogle.Drive.Children.Get Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Get Choreo.
 */
@interface TMBGoogle_Drive_Children_Get_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setChildID:(NSString*)ChildID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFolderID:(NSString*)FolderID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Get Choreo.
 */
@interface TMBGoogle_Drive_Children_Get_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Gets a specific child reference.
 */
@interface TMBGoogle_Drive_Children_Get : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Children_Get_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Children_Get Choreo */


/*! group TMBGoogle.Drive.Children.Insert Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Insert Choreo.
 */
@interface TMBGoogle_Drive_Children_Insert_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFolderID:(NSString*)FolderID;
	-(void)setID:(NSString*)ID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Insert Choreo.
 */
@interface TMBGoogle_Drive_Children_Insert_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Inserts a file into a folder.
 */
@interface TMBGoogle_Drive_Children_Insert : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Children_Insert_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Children_Insert Choreo */


/*! group TMBGoogle.Drive.Children.List Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the List Choreo.
 */
@interface TMBGoogle_Drive_Children_List_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFolderID:(NSString*)FolderID;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setQuery:(NSString*)Query;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the List Choreo.
 */
@interface TMBGoogle_Drive_Children_List_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists the children of a specified folder.
 */
@interface TMBGoogle_Drive_Children_List : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Children_List_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Children_List Choreo */


/*! group TMBGoogle.Drive.Comments.Delete Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Delete Choreo.
 */
@interface TMBGoogle_Drive_Comments_Delete_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setCommentID:(NSString*)CommentID;
	-(void)setFileID:(NSString*)FileID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Delete Choreo.
 */
@interface TMBGoogle_Drive_Comments_Delete_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes a comment.
 */
@interface TMBGoogle_Drive_Comments_Delete : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Comments_Delete_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Comments_Delete Choreo */


/*! group TMBGoogle.Drive.Comments.Get Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Get Choreo.
 */
@interface TMBGoogle_Drive_Comments_Get_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setCommentID:(NSString*)CommentID;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileID:(NSString*)FileID;
	-(void)setIncludeDeleted:(NSString*)IncludeDeleted;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Get Choreo.
 */
@interface TMBGoogle_Drive_Comments_Get_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Gets a comment by ID.
 */
@interface TMBGoogle_Drive_Comments_Get : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Comments_Get_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Comments_Get Choreo */


/*! group TMBGoogle.Drive.Comments.Insert Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Insert Choreo.
 */
@interface TMBGoogle_Drive_Comments_Insert_Inputs : TMBChoreographyInputSet
	-(void)setRequestBody:(NSString*)RequestBody;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileID:(NSString*)FileID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Insert Choreo.
 */
@interface TMBGoogle_Drive_Comments_Insert_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new comment on the given file.
 */
@interface TMBGoogle_Drive_Comments_Insert : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Comments_Insert_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Comments_Insert Choreo */


/*! group TMBGoogle.Drive.Comments.List Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the List Choreo.
 */
@interface TMBGoogle_Drive_Comments_List_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileID:(NSString*)FileID;
	-(void)setIncludeDeleted:(NSString*)IncludeDeleted;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUpdatedMIn:(NSString*)UpdatedMIn;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the List Choreo.
 */
@interface TMBGoogle_Drive_Comments_List_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists a file's comments.
 */
@interface TMBGoogle_Drive_Comments_List : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Comments_List_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Comments_List Choreo */


/*! group TMBGoogle.Drive.Comments.Update Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Update Choreo.
 */
@interface TMBGoogle_Drive_Comments_Update_Inputs : TMBChoreographyInputSet
	-(void)setRequestBody:(NSString*)RequestBody;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setCommentID:(NSString*)CommentID;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileID:(NSString*)FileID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Update Choreo.
 */
@interface TMBGoogle_Drive_Comments_Update_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Updates an existing comment.
 */
@interface TMBGoogle_Drive_Comments_Update : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Comments_Update_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Comments_Update Choreo */


/*! group TMBGoogle.Drive.Files.Copy Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Copy Choreo.
 */
@interface TMBGoogle_Drive_Files_Copy_Inputs : TMBChoreographyInputSet
	-(void)setRequestBody:(NSString*)RequestBody;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setConvert:(NSString*)Convert;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileID:(NSString*)FileID;
	-(void)setOCR:(NSString*)OCR;
	-(void)setOcrLanguage:(NSString*)OcrLanguage;
	-(void)setPinned:(NSString*)Pinned;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSourceLanguage:(NSString*)SourceLanguage;
	-(void)setTargetLanguage:(NSString*)TargetLanguage;
	-(void)setTimedTextLanguage:(NSString*)TimedTextLanguage;
	-(void)setTimedTextTrackName:(NSString*)TimedTextTrackName;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Copy Choreo.
 */
@interface TMBGoogle_Drive_Files_Copy_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a copy of the specified file.
 */
@interface TMBGoogle_Drive_Files_Copy : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Files_Copy_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Files_Copy Choreo */


/*! group TMBGoogle.Drive.Files.Delete Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Delete Choreo.
 */
@interface TMBGoogle_Drive_Files_Delete_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFileID:(NSString*)FileID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Delete Choreo.
 */
@interface TMBGoogle_Drive_Files_Delete_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Permanently deletes a file by ID.
 */
@interface TMBGoogle_Drive_Files_Delete : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Files_Delete_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Files_Delete Choreo */


/*! group TMBGoogle.Drive.Files.Get Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Get Choreo.
 */
@interface TMBGoogle_Drive_Files_Get_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setExportFormat:(NSString*)ExportFormat;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileID:(NSString*)FileID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUpdateViewDate:(NSString*)UpdateViewDate;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Get Choreo.
 */
@interface TMBGoogle_Drive_Files_Get_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getFileContent;
	-(NSString*)getFileMetadata;
	-(NSString*)getNewAccessToken;	
@end

/*!
 * Gets a file's metadata and content by ID.
 */
@interface TMBGoogle_Drive_Files_Get : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Files_Get_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Files_Get Choreo */


/*! group TMBGoogle.Drive.Files.Insert Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Insert Choreo.
 */
@interface TMBGoogle_Drive_Files_Insert_Inputs : TMBChoreographyInputSet
	-(void)setRequestBody:(NSString*)RequestBody;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setContentType:(NSString*)ContentType;
	-(void)setConvert:(NSString*)Convert;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileContent:(NSString*)FileContent;
	-(void)setOCR:(NSString*)OCR;
	-(void)setOcrLanguage:(NSString*)OcrLanguage;
	-(void)setPinned:(NSString*)Pinned;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSourceLanguage:(NSString*)SourceLanguage;
	-(void)setTargetLanguage:(NSString*)TargetLanguage;
	-(void)setTimedTextLanguage:(NSString*)TimedTextLanguage;
	-(void)setTimedTextTrackName:(NSString*)TimedTextTrackName;
	-(void)setVaultFile:(NSString*)VaultFile;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Insert Choreo.
 */
@interface TMBGoogle_Drive_Files_Insert_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Inserts a new file.
 */
@interface TMBGoogle_Drive_Files_Insert : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Files_Insert_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Files_Insert Choreo */


/*! group TMBGoogle.Drive.Files.List Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the List Choreo.
 */
@interface TMBGoogle_Drive_Files_List_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setQuery:(NSString*)Query;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the List Choreo.
 */
@interface TMBGoogle_Drive_Files_List_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getFileID;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists the user's files.
 */
@interface TMBGoogle_Drive_Files_List : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Files_List_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Files_List Choreo */


/*! group TMBGoogle.Drive.Files.Touch Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Touch Choreo.
 */
@interface TMBGoogle_Drive_Files_Touch_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileID:(NSString*)FileID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Touch Choreo.
 */
@interface TMBGoogle_Drive_Files_Touch_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Sets the file's updated time to the current server time.
 */
@interface TMBGoogle_Drive_Files_Touch : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Files_Touch_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Files_Touch Choreo */


/*! group TMBGoogle.Drive.Files.Trash Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Trash Choreo.
 */
@interface TMBGoogle_Drive_Files_Trash_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileID:(NSString*)FileID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Trash Choreo.
 */
@interface TMBGoogle_Drive_Files_Trash_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Moves a file to the trash.
 */
@interface TMBGoogle_Drive_Files_Trash : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Files_Trash_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Files_Trash Choreo */


/*! group TMBGoogle.Drive.Files.Untrash Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Untrash Choreo.
 */
@interface TMBGoogle_Drive_Files_Untrash_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileID:(NSString*)FileID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Untrash Choreo.
 */
@interface TMBGoogle_Drive_Files_Untrash_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Restores a file from the trash.
 */
@interface TMBGoogle_Drive_Files_Untrash : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Files_Untrash_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Files_Untrash Choreo */


/*! group TMBGoogle.Drive.Files.Update Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Update Choreo.
 */
@interface TMBGoogle_Drive_Files_Update_Inputs : TMBChoreographyInputSet
	-(void)setRequestBody:(NSString*)RequestBody;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setContentType:(NSString*)ContentType;
	-(void)setConvert:(NSString*)Convert;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileContent:(NSString*)FileContent;
	-(void)setFileID:(NSString*)FileID;
	-(void)setOCR:(NSString*)OCR;
	-(void)setOcrLanguage:(NSString*)OcrLanguage;
	-(void)setPinned:(NSString*)Pinned;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSetModifiedDate:(NSString*)SetModifiedDate;
	-(void)setSourceLanguage:(NSString*)SourceLanguage;
	-(void)setTargetLanguage:(NSString*)TargetLanguage;
	-(void)setTimedTextLanguage:(NSString*)TimedTextLanguage;
	-(void)setTimedTextTrackName:(NSString*)TimedTextTrackName;
	-(void)setUpdateViewedDate:(NSString*)UpdateViewedDate;
	-(void)setVaultFile:(NSString*)VaultFile;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Update Choreo.
 */
@interface TMBGoogle_Drive_Files_Update_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Updates the metadata or content of an existing file.
 */
@interface TMBGoogle_Drive_Files_Update : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Files_Update_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Files_Update Choreo */


/*! group TMBGoogle.Drive.Parents.Delete Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Delete Choreo.
 */
@interface TMBGoogle_Drive_Parents_Delete_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFileID:(NSString*)FileID;
	-(void)setParentID:(NSString*)ParentID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Delete Choreo.
 */
@interface TMBGoogle_Drive_Parents_Delete_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Removes a parent from a file.
 */
@interface TMBGoogle_Drive_Parents_Delete : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Parents_Delete_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Parents_Delete Choreo */


/*! group TMBGoogle.Drive.Parents.Get Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Get Choreo.
 */
@interface TMBGoogle_Drive_Parents_Get_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFileID:(NSString*)FileID;
	-(void)setParentID:(NSString*)ParentID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Get Choreo.
 */
@interface TMBGoogle_Drive_Parents_Get_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Gets a specific parent reference.
 */
@interface TMBGoogle_Drive_Parents_Get : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Parents_Get_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Parents_Get Choreo */


/*! group TMBGoogle.Drive.Parents.Insert Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Insert Choreo.
 */
@interface TMBGoogle_Drive_Parents_Insert_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileID:(NSString*)FileID;
	-(void)setParentID:(NSString*)ParentID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Insert Choreo.
 */
@interface TMBGoogle_Drive_Parents_Insert_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Adds a parent folder for a file.
 */
@interface TMBGoogle_Drive_Parents_Insert : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Parents_Insert_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Parents_Insert Choreo */


/*! group TMBGoogle.Drive.Parents.List Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the List Choreo.
 */
@interface TMBGoogle_Drive_Parents_List_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFileID:(NSString*)FileID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the List Choreo.
 */
@interface TMBGoogle_Drive_Parents_List_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists a file's parents.
 */
@interface TMBGoogle_Drive_Parents_List : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Parents_List_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Parents_List Choreo */


/*! group TMBGoogle.Drive.Permissions.Delete Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Delete Choreo.
 */
@interface TMBGoogle_Drive_Permissions_Delete_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFileID:(NSString*)FileID;
	-(void)setPermissionID:(NSString*)PermissionID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Delete Choreo.
 */
@interface TMBGoogle_Drive_Permissions_Delete_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes a permission from a file.
 */
@interface TMBGoogle_Drive_Permissions_Delete : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Permissions_Delete_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Permissions_Delete Choreo */


/*! group TMBGoogle.Drive.Permissions.Get Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Get Choreo.
 */
@interface TMBGoogle_Drive_Permissions_Get_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileID:(NSString*)FileID;
	-(void)setPermissionID:(NSString*)PermissionID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Get Choreo.
 */
@interface TMBGoogle_Drive_Permissions_Get_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Gets a permission by ID.
 */
@interface TMBGoogle_Drive_Permissions_Get : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Permissions_Get_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Permissions_Get Choreo */


/*! group TMBGoogle.Drive.Permissions.Insert Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Insert Choreo.
 */
@interface TMBGoogle_Drive_Permissions_Insert_Inputs : TMBChoreographyInputSet
	-(void)setRequestBody:(NSString*)RequestBody;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileID:(NSString*)FileID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSendNotificationEmails:(NSString*)SendNotificationEmails;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Insert Choreo.
 */
@interface TMBGoogle_Drive_Permissions_Insert_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Inserts a permission for a file.
 */
@interface TMBGoogle_Drive_Permissions_Insert : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Permissions_Insert_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Permissions_Insert Choreo */


/*! group TMBGoogle.Drive.Permissions.List Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the List Choreo.
 */
@interface TMBGoogle_Drive_Permissions_List_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileID:(NSString*)FileID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the List Choreo.
 */
@interface TMBGoogle_Drive_Permissions_List_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists a file's permissions.
 */
@interface TMBGoogle_Drive_Permissions_List : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Permissions_List_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Permissions_List Choreo */


/*! group TMBGoogle.Drive.Permissions.Update Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Update Choreo.
 */
@interface TMBGoogle_Drive_Permissions_Update_Inputs : TMBChoreographyInputSet
	-(void)setRequestBody:(NSString*)RequestBody;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileID:(NSString*)FileID;
	-(void)setPermissionID:(NSString*)PermissionID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Update Choreo.
 */
@interface TMBGoogle_Drive_Permissions_Update_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Updates an existing permission.
 */
@interface TMBGoogle_Drive_Permissions_Update : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Permissions_Update_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Permissions_Update Choreo */


/*! group TMBGoogle.Drive.Replies.Delete Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Delete Choreo.
 */
@interface TMBGoogle_Drive_Replies_Delete_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setCommentID:(NSString*)CommentID;
	-(void)setFileID:(NSString*)FileID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setReplyID:(NSString*)ReplyID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Delete Choreo.
 */
@interface TMBGoogle_Drive_Replies_Delete_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes a reply.
 */
@interface TMBGoogle_Drive_Replies_Delete : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Replies_Delete_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Replies_Delete Choreo */


/*! group TMBGoogle.Drive.Replies.Get Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Get Choreo.
 */
@interface TMBGoogle_Drive_Replies_Get_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setCommentID:(NSString*)CommentID;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileID:(NSString*)FileID;
	-(void)setIncludeDeleted:(NSString*)IncludeDeleted;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setReplyID:(NSString*)ReplyID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Get Choreo.
 */
@interface TMBGoogle_Drive_Replies_Get_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Gets a reply
 */
@interface TMBGoogle_Drive_Replies_Get : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Replies_Get_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Replies_Get Choreo */


/*! group TMBGoogle.Drive.Replies.Insert Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Insert Choreo.
 */
@interface TMBGoogle_Drive_Replies_Insert_Inputs : TMBChoreographyInputSet
	-(void)setRequestBody:(NSString*)RequestBody;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setCommentID:(NSString*)CommentID;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileID:(NSString*)FileID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Insert Choreo.
 */
@interface TMBGoogle_Drive_Replies_Insert_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new reply to the given comment.
 */
@interface TMBGoogle_Drive_Replies_Insert : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Replies_Insert_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Replies_Insert Choreo */


/*! group TMBGoogle.Drive.Replies.List Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the List Choreo.
 */
@interface TMBGoogle_Drive_Replies_List_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setCommentID:(NSString*)CommentID;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileID:(NSString*)FileID;
	-(void)setIncludeDeleted:(NSString*)IncludeDeleted;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the List Choreo.
 */
@interface TMBGoogle_Drive_Replies_List_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists all of the replies to a comment.
 */
@interface TMBGoogle_Drive_Replies_List : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Replies_List_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Replies_List Choreo */


/*! group TMBGoogle.Drive.Replies.Update Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Update Choreo.
 */
@interface TMBGoogle_Drive_Replies_Update_Inputs : TMBChoreographyInputSet
	-(void)setRequestBody:(NSString*)RequestBody;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setCommentID:(NSString*)CommentID;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileID:(NSString*)FileID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setReplyID:(NSString*)ReplyID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Update Choreo.
 */
@interface TMBGoogle_Drive_Replies_Update_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Updates an existing reply.
 */
@interface TMBGoogle_Drive_Replies_Update : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Replies_Update_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Replies_Update Choreo */


/*! group TMBGoogle.Drive.Revisions.Delete Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Delete Choreo.
 */
@interface TMBGoogle_Drive_Revisions_Delete_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFileID:(NSString*)FileID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setRevisionID:(NSString*)RevisionID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Delete Choreo.
 */
@interface TMBGoogle_Drive_Revisions_Delete_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Removes a revision.
 */
@interface TMBGoogle_Drive_Revisions_Delete : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Revisions_Delete_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Revisions_Delete Choreo */


/*! group TMBGoogle.Drive.Revisions.Get Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Get Choreo.
 */
@interface TMBGoogle_Drive_Revisions_Get_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileID:(NSString*)FileID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setRevisionID:(NSString*)RevisionID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Get Choreo.
 */
@interface TMBGoogle_Drive_Revisions_Get_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Gets a specific revision.
 */
@interface TMBGoogle_Drive_Revisions_Get : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Revisions_Get_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Revisions_Get Choreo */


/*! group TMBGoogle.Drive.Revisions.List Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the List Choreo.
 */
@interface TMBGoogle_Drive_Revisions_List_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileID:(NSString*)FileID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the List Choreo.
 */
@interface TMBGoogle_Drive_Revisions_List_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists a file's revisions.
 */
@interface TMBGoogle_Drive_Revisions_List : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Revisions_List_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Revisions_List Choreo */


/*! group TMBGoogle.Drive.Revisions.Update Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Update Choreo.
 */
@interface TMBGoogle_Drive_Revisions_Update_Inputs : TMBChoreographyInputSet
	-(void)setRequestBody:(NSString*)RequestBody;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileID:(NSString*)FileID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setRevisionID:(NSString*)RevisionID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Update Choreo.
 */
@interface TMBGoogle_Drive_Revisions_Update_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Updates a revision.
 */
@interface TMBGoogle_Drive_Revisions_Update : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Drive_Revisions_Update_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Drive.Revisions_Update Choreo */


/*! group TMBGoogle.Elevation.GetLocationElevation Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetLocationElevation Choreo.
 */
@interface TMBGoogle_Elevation_GetLocationElevation_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setLocations:(NSString*)Locations;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSensor:(NSString*)Sensor;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLocationElevation Choreo.
 */
@interface TMBGoogle_Elevation_GetLocationElevation_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Obtain elevation information for a path generated by a set of geo-coordinates.
 */
@interface TMBGoogle_Elevation_GetLocationElevation : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Elevation_GetLocationElevation_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Elevation_GetLocationElevation Choreo */


/*! group TMBGoogle.Elevation.GetPathElevation Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetPathElevation Choreo.
 */
@interface TMBGoogle_Elevation_GetPathElevation_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setPath:(NSString*)Path;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSamples:(NSString*)Samples;
	-(void)setSensor:(NSString*)Sensor;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetPathElevation Choreo.
 */
@interface TMBGoogle_Elevation_GetPathElevation_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Obtain elevation information for a path specified by a set of  geo-coordinates.
 */
@interface TMBGoogle_Elevation_GetPathElevation : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Elevation_GetPathElevation_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Elevation_GetPathElevation Choreo */


/*! group TMBGoogle.Geocoding.GeocodeByAddress Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GeocodeByAddress Choreo.
 */
@interface TMBGoogle_Geocoding_GeocodeByAddress_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setAddress:(NSString*)Address;
	-(void)setBounds:(NSString*)Bounds;
	-(void)setLanguage:(NSString*)Language;
	-(void)setRegion:(NSString*)Region;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSensor:(NSString*)Sensor;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GeocodeByAddress Choreo.
 */
@interface TMBGoogle_Geocoding_GeocodeByAddress_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getLatitude;
	-(NSString*)getLongitude;
	-(NSString*)getResponse;	
@end

/*!
 * Converts a human-readable address into geographic coordinates.
 */
@interface TMBGoogle_Geocoding_GeocodeByAddress : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Geocoding_GeocodeByAddress_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Geocoding_GeocodeByAddress Choreo */


/*! group TMBGoogle.Geocoding.GeocodeByCoordinates Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GeocodeByCoordinates Choreo.
 */
@interface TMBGoogle_Geocoding_GeocodeByCoordinates_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setBounds:(NSString*)Bounds;
	-(void)setLanguage:(NSString*)Language;
	-(void)setLatitude:(NSString*)Latitude;
	-(void)setLongitude:(NSString*)Longitude;
	-(void)setRegion:(NSString*)Region;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSensor:(NSString*)Sensor;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GeocodeByCoordinates Choreo.
 */
@interface TMBGoogle_Geocoding_GeocodeByCoordinates_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getFormattedAddress;
	-(NSString*)getResponse;	
@end

/*!
 * Converts latitude and longitude coordinates into a human-readable address.
 */
@interface TMBGoogle_Geocoding_GeocodeByCoordinates : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Geocoding_GeocodeByCoordinates_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Geocoding_GeocodeByCoordinates Choreo */


/*! group TMBGoogle.Gmail.GetLatestUnreadEmail Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetLatestUnreadEmail Choreo.
 */
@interface TMBGoogle_Gmail_GetLatestUnreadEmail_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setLabel:(NSString*)Label;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLatestUnreadEmail Choreo.
 */
@interface TMBGoogle_Gmail_GetLatestUnreadEmail_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAuthorEmail;
	-(NSString*)getAuthorName;
	-(NSString*)getMessageBody;
	-(NSString*)getNewAccessToken;
	-(NSString*)getSubject;
	-(NSString*)getResponse;	
@end

/*!
 * Returns the latest unread email from a user's Gmail feed.
 */
@interface TMBGoogle_Gmail_GetLatestUnreadEmail : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmail_GetLatestUnreadEmail_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmail_GetLatestUnreadEmail Choreo */


/*! group TMBGoogle.Gmail.GetUnreadImportantEmail Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetUnreadImportantEmail Choreo.
 */
@interface TMBGoogle_Gmail_GetUnreadImportantEmail_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseMode:(NSString*)ResponseMode;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetUnreadImportantEmail Choreo.
 */
@interface TMBGoogle_Gmail_GetUnreadImportantEmail_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Allows you to access a read-only Gmail feed that contains a list of unread emails that are marked important.
 */
@interface TMBGoogle_Gmail_GetUnreadImportantEmail : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmail_GetUnreadImportantEmail_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmail_GetUnreadImportantEmail Choreo */


/*! group TMBGoogle.Gmail.GetUnreadMail Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetUnreadMail Choreo.
 */
@interface TMBGoogle_Gmail_GetUnreadMail_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setLabel:(NSString*)Label;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseMode:(NSString*)ResponseMode;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetUnreadMail Choreo.
 */
@interface TMBGoogle_Gmail_GetUnreadMail_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getFullCount;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Allows you to access a read-only Gmail feed that contains a list of unread emails.
 */
@interface TMBGoogle_Gmail_GetUnreadMail : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmail_GetUnreadMail_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmail_GetUnreadMail Choreo */


/*! group TMBGoogle.Gmail.GetUnreadMailFromSender Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetUnreadMailFromSender Choreo.
 */
@interface TMBGoogle_Gmail_GetUnreadMailFromSender_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setLabel:(NSString*)Label;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseMode:(NSString*)ResponseMode;
	-(void)setSenderEmail:(NSString*)SenderEmail;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetUnreadMailFromSender Choreo.
 */
@interface TMBGoogle_Gmail_GetUnreadMailFromSender_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getFullCount;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Allows you to access a read-only Gmail feed that contains a list of unread emails for the specified sender.
 */
@interface TMBGoogle_Gmail_GetUnreadMailFromSender : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmail_GetUnreadMailFromSender_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmail_GetUnreadMailFromSender Choreo */


/*! group TMBGoogle.Gmail.GetUnreadMailWithLabel Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetUnreadMailWithLabel Choreo.
 */
@interface TMBGoogle_Gmail_GetUnreadMailWithLabel_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setLabel:(NSString*)Label;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseMode:(NSString*)ResponseMode;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetUnreadMailWithLabel Choreo.
 */
@interface TMBGoogle_Gmail_GetUnreadMailWithLabel_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getFullCount;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Allows you to access a read-only Gmail feed that contains a list of unread emails with the specified label.
 */
@interface TMBGoogle_Gmail_GetUnreadMailWithLabel : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmail_GetUnreadMailWithLabel_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmail_GetUnreadMailWithLabel Choreo */


/*! group TMBGoogle.Gmail.InboxFeed Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the InboxFeed Choreo.
 */
@interface TMBGoogle_Gmail_InboxFeed_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setLabel:(NSString*)Label;
	-(void)setMode:(NSString*)Mode;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setUsername:(NSString*)Username;
	-(void)setXPath:(NSString*)XPath;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the InboxFeed Choreo.
 */
@interface TMBGoogle_Gmail_InboxFeed_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getFullCount;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Allows you to access a read-only Gmail feed that contains a list of unread emails.
 */
@interface TMBGoogle_Gmail_InboxFeed : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmail_InboxFeed_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmail_InboxFeed Choreo */


/*! group TMBGoogle.Gmail.SendEmail Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SendEmail Choreo.
 */
@interface TMBGoogle_Gmail_SendEmail_Inputs : TMBChoreographyInputSet
	-(void)setAttachment:(NSString*)Attachment;
	-(void)setAttachmentName:(NSString*)AttachmentName;
	-(void)setAttachmentURL:(NSString*)AttachmentURL;
	-(void)setBCC:(NSString*)BCC;
	-(void)setCC:(NSString*)CC;
	-(void)setFromAddress:(NSString*)FromAddress;
	-(void)setMessageBody:(NSString*)MessageBody;
	-(void)setPassword:(NSString*)Password;
	-(void)setSubject:(NSString*)Subject;
	-(void)setToAddress:(NSString*)ToAddress;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SendEmail Choreo.
 */
@interface TMBGoogle_Gmail_SendEmail_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getSuccess;	
@end

/*!
 * Sends an email using a specified Gmail account.
 */
@interface TMBGoogle_Gmail_SendEmail : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmail_SendEmail_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmail_SendEmail Choreo */


/*! group TMBGoogle.Gmailv2.Attachments.GetAttachment Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetAttachment Choreo.
 */
@interface TMBGoogle_Gmailv2_Attachments_GetAttachment_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAttachmentID:(NSString*)AttachmentID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFormat:(NSString*)Format;
	-(void)setMessageID:(NSString*)MessageID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetAttachment Choreo.
 */
@interface TMBGoogle_Gmailv2_Attachments_GetAttachment_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Gets the specified message attachment.
 */
@interface TMBGoogle_Gmailv2_Attachments_GetAttachment : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Attachments_GetAttachment_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Attachments_GetAttachment Choreo */


/*! group TMBGoogle.Gmailv2.Drafts.CreateDraft Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateDraft Choreo.
 */
@interface TMBGoogle_Gmailv2_Drafts_CreateDraft_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAttachmentContentType:(NSString*)AttachmentContentType;
	-(void)setAttachmentFileContent:(NSString*)AttachmentFileContent;
	-(void)setAttachmentFileName:(NSString*)AttachmentFileName;
	-(void)setBCC:(NSString*)BCC;
	-(void)setCC:(NSString*)CC;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFrom:(NSString*)From;
	-(void)setMessageBody:(NSString*)MessageBody;
	-(void)setMessageBodyContentType:(NSString*)MessageBodyContentType;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setReplyTo:(NSString*)ReplyTo;
	-(void)setSubject:(NSString*)Subject;
	-(void)setThreadID:(NSString*)ThreadID;
	-(void)setTo:(NSString*)To;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateDraft Choreo.
 */
@interface TMBGoogle_Gmailv2_Drafts_CreateDraft_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new draft with the DRAFT label.
 */
@interface TMBGoogle_Gmailv2_Drafts_CreateDraft : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Drafts_CreateDraft_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Drafts_CreateDraft Choreo */


/*! group TMBGoogle.Gmailv2.Drafts.DeleteDraft Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteDraft Choreo.
 */
@interface TMBGoogle_Gmailv2_Drafts_DeleteDraft_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDraftID:(NSString*)DraftID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteDraft Choreo.
 */
@interface TMBGoogle_Gmailv2_Drafts_DeleteDraft_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Permanently deletes the specified draft.
 */
@interface TMBGoogle_Gmailv2_Drafts_DeleteDraft : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Drafts_DeleteDraft_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Drafts_DeleteDraft Choreo */


/*! group TMBGoogle.Gmailv2.Drafts.GetDraft Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetDraft Choreo.
 */
@interface TMBGoogle_Gmailv2_Drafts_GetDraft_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDraftID:(NSString*)DraftID;
	-(void)setFields:(NSString*)Fields;
	-(void)setFormat:(NSString*)Format;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetDraft Choreo.
 */
@interface TMBGoogle_Gmailv2_Drafts_GetDraft_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a specific draft from a user's mailbox.
 */
@interface TMBGoogle_Gmailv2_Drafts_GetDraft : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Drafts_GetDraft_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Drafts_GetDraft Choreo */


/*! group TMBGoogle.Gmailv2.Drafts.ListDrafts Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListDrafts Choreo.
 */
@interface TMBGoogle_Gmailv2_Drafts_ListDrafts_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListDrafts Choreo.
 */
@interface TMBGoogle_Gmailv2_Drafts_ListDrafts_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists the drafts in the user's mailbox.
 */
@interface TMBGoogle_Gmailv2_Drafts_ListDrafts : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Drafts_ListDrafts_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Drafts_ListDrafts Choreo */


/*! group TMBGoogle.Gmailv2.Drafts.SendDraft Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SendDraft Choreo.
 */
@interface TMBGoogle_Gmailv2_Drafts_SendDraft_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDraftID:(NSString*)DraftID;
	-(void)setFields:(NSString*)Fields;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SendDraft Choreo.
 */
@interface TMBGoogle_Gmailv2_Drafts_SendDraft_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Sends the specified, existing draft.
 */
@interface TMBGoogle_Gmailv2_Drafts_SendDraft : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Drafts_SendDraft_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Drafts_SendDraft Choreo */


/*! group TMBGoogle.Gmailv2.Drafts.UpdateDraft Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateDraft Choreo.
 */
@interface TMBGoogle_Gmailv2_Drafts_UpdateDraft_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAttachmentContentType:(NSString*)AttachmentContentType;
	-(void)setAttachmentFileContent:(NSString*)AttachmentFileContent;
	-(void)setAttachmentFileName:(NSString*)AttachmentFileName;
	-(void)setBCC:(NSString*)BCC;
	-(void)setCC:(NSString*)CC;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDraftID:(NSString*)DraftID;
	-(void)setFields:(NSString*)Fields;
	-(void)setFrom:(NSString*)From;
	-(void)setMessageBody:(NSString*)MessageBody;
	-(void)setMessageBodyContentType:(NSString*)MessageBodyContentType;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setReplyTo:(NSString*)ReplyTo;
	-(void)setSubject:(NSString*)Subject;
	-(void)setThreadID:(NSString*)ThreadID;
	-(void)setTo:(NSString*)To;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateDraft Choreo.
 */
@interface TMBGoogle_Gmailv2_Drafts_UpdateDraft_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Updates the content of an existing draft.
 */
@interface TMBGoogle_Gmailv2_Drafts_UpdateDraft : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Drafts_UpdateDraft_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Drafts_UpdateDraft Choreo */


/*! group TMBGoogle.Gmailv2.History.ListHistory Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListHistory Choreo.
 */
@interface TMBGoogle_Gmailv2_History_ListHistory_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setLabelID:(NSString*)LabelID;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setStartHistoryID:(NSString*)StartHistoryID;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListHistory Choreo.
 */
@interface TMBGoogle_Gmailv2_History_ListHistory_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists the history of all changes to the given mailbox.
 */
@interface TMBGoogle_Gmailv2_History_ListHistory : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_History_ListHistory_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.History_ListHistory Choreo */


/*! group TMBGoogle.Gmailv2.Labels.CreateLabel Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateLabel Choreo.
 */
@interface TMBGoogle_Gmailv2_Labels_CreateLabel_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setLabelListVisibility:(NSString*)LabelListVisibility;
	-(void)setMessageListVisibility:(NSString*)MessageListVisibility;
	-(void)setName:(NSString*)Name;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateLabel Choreo.
 */
@interface TMBGoogle_Gmailv2_Labels_CreateLabel_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new label.
 */
@interface TMBGoogle_Gmailv2_Labels_CreateLabel : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Labels_CreateLabel_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Labels_CreateLabel Choreo */


/*! group TMBGoogle.Gmailv2.Labels.DeleteLabel Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteLabel Choreo.
 */
@interface TMBGoogle_Gmailv2_Labels_DeleteLabel_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setLabelID:(NSString*)LabelID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteLabel Choreo.
 */
@interface TMBGoogle_Gmailv2_Labels_DeleteLabel_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes a specific label.
 */
@interface TMBGoogle_Gmailv2_Labels_DeleteLabel : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Labels_DeleteLabel_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Labels_DeleteLabel Choreo */


/*! group TMBGoogle.Gmailv2.Labels.GetLabel Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetLabel Choreo.
 */
@interface TMBGoogle_Gmailv2_Labels_GetLabel_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setLabelID:(NSString*)LabelID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLabel Choreo.
 */
@interface TMBGoogle_Gmailv2_Labels_GetLabel_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a specific label.
 */
@interface TMBGoogle_Gmailv2_Labels_GetLabel : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Labels_GetLabel_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Labels_GetLabel Choreo */


/*! group TMBGoogle.Gmailv2.Labels.ListLabels Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListLabels Choreo.
 */
@interface TMBGoogle_Gmailv2_Labels_ListLabels_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListLabels Choreo.
 */
@interface TMBGoogle_Gmailv2_Labels_ListLabels_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists all labels in the user's mailbox.
 */
@interface TMBGoogle_Gmailv2_Labels_ListLabels : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Labels_ListLabels_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Labels_ListLabels Choreo */


/*! group TMBGoogle.Gmailv2.Labels.UpdateLabel Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateLabel Choreo.
 */
@interface TMBGoogle_Gmailv2_Labels_UpdateLabel_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setLabelID:(NSString*)LabelID;
	-(void)setLabelListVisibility:(NSString*)LabelListVisibility;
	-(void)setMessageListVisibility:(NSString*)MessageListVisibility;
	-(void)setName:(NSString*)Name;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateLabel Choreo.
 */
@interface TMBGoogle_Gmailv2_Labels_UpdateLabel_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Updates a specific label.
 */
@interface TMBGoogle_Gmailv2_Labels_UpdateLabel : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Labels_UpdateLabel_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Labels_UpdateLabel Choreo */


/*! group TMBGoogle.Gmailv2.Messages.ClearStoredHistory Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ClearStoredHistory Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_ClearStoredHistory_Inputs : TMBChoreographyInputSet
	-(void)setLabelID:(NSString*)LabelID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ClearStoredHistory Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_ClearStoredHistory_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getDeleted;	
@end

/*!
 * Clears the history ID stored in your Temboo account when executing the GetNextMessage Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_ClearStoredHistory : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Messages_ClearStoredHistory_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Messages_ClearStoredHistory Choreo */


/*! group TMBGoogle.Gmailv2.Messages.DeleteMessage Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteMessage Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_DeleteMessage_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setMessageID:(NSString*)MessageID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteMessage Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_DeleteMessage_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Permanently deletes a specified message.
 */
@interface TMBGoogle_Gmailv2_Messages_DeleteMessage : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Messages_DeleteMessage_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Messages_DeleteMessage Choreo */


/*! group TMBGoogle.Gmailv2.Messages.GetLatestMessage Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetLatestMessage Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_GetLatestMessage_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setEncodeMessage:(NSString*)EncodeMessage;
	-(void)setIncludeSpamTrash:(NSString*)IncludeSpamTrash;
	-(void)setLabelID:(NSString*)LabelID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setStartHistoryID:(NSString*)StartHistoryID;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLatestMessage Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_GetLatestMessage_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getBody;
	-(NSString*)getFrom;
	-(NSString*)getHistoryID;
	-(NSString*)getMessageID;
	-(NSString*)getNewAccessToken;
	-(NSString*)getSnippet;
	-(NSString*)getSubject;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the latest email from a user's inbox.
 */
@interface TMBGoogle_Gmailv2_Messages_GetLatestMessage : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Messages_GetLatestMessage_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Messages_GetLatestMessage Choreo */


/*! group TMBGoogle.Gmailv2.Messages.GetMessage Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetMessage Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_GetMessage_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFormat:(NSString*)Format;
	-(void)setMessageID:(NSString*)MessageID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetMessage Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_GetMessage_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves an individual message from a user's mailbox.
 */
@interface TMBGoogle_Gmailv2_Messages_GetMessage : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Messages_GetMessage_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Messages_GetMessage Choreo */


/*! group TMBGoogle.Gmailv2.Messages.GetNextMessage Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetNextMessage Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_GetNextMessage_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setEncodeMessage:(NSString*)EncodeMessage;
	-(void)setLabelID:(NSString*)LabelID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetNextMessage Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_GetNextMessage_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getBody;
	-(NSString*)getFrom;
	-(NSString*)getMessageID;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getSnippet;
	-(NSString*)getSubject;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the next email from a user's inbox.
 */
@interface TMBGoogle_Gmailv2_Messages_GetNextMessage : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Messages_GetNextMessage_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Messages_GetNextMessage Choreo */


/*! group TMBGoogle.Gmailv2.Messages.InsertMessage Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the InsertMessage Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_InsertMessage_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAttachmentContentType:(NSString*)AttachmentContentType;
	-(void)setAttachmentFileContent:(NSString*)AttachmentFileContent;
	-(void)setAttachmentFileName:(NSString*)AttachmentFileName;
	-(void)setBCC:(NSString*)BCC;
	-(void)setCC:(NSString*)CC;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFrom:(NSString*)From;
	-(void)setLabelIDs:(NSString*)LabelIDs;
	-(void)setMessageBody:(NSString*)MessageBody;
	-(void)setMessageBodyContentType:(NSString*)MessageBodyContentType;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setReplyTo:(NSString*)ReplyTo;
	-(void)setSubject:(NSString*)Subject;
	-(void)setThreadID:(NSString*)ThreadID;
	-(void)setTo:(NSString*)To;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the InsertMessage Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_InsertMessage_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Directly inserts a message into a user's mailbox. Does not send a message.
 */
@interface TMBGoogle_Gmailv2_Messages_InsertMessage : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Messages_InsertMessage_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Messages_InsertMessage Choreo */


/*! group TMBGoogle.Gmailv2.Messages.ListMessages Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListMessages Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_ListMessages_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setIncludeSpamTrash:(NSString*)IncludeSpamTrash;
	-(void)setLabelIDs:(NSString*)LabelIDs;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setQuery:(NSString*)Query;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListMessages Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_ListMessages_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists the messages in the user's mailbox.
 */
@interface TMBGoogle_Gmailv2_Messages_ListMessages : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Messages_ListMessages_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Messages_ListMessages Choreo */


/*! group TMBGoogle.Gmailv2.Messages.ModifyMessage Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ModifyMessage Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_ModifyMessage_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAddLabelIDs:(NSString*)AddLabelIDs;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setMessageID:(NSString*)MessageID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setRemoveLabelIDs:(NSString*)RemoveLabelIDs;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ModifyMessage Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_ModifyMessage_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Modifies the labels for a specific message.
 */
@interface TMBGoogle_Gmailv2_Messages_ModifyMessage : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Messages_ModifyMessage_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Messages_ModifyMessage Choreo */


/*! group TMBGoogle.Gmailv2.Messages.SendMessage Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SendMessage Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_SendMessage_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAttachmentContentType:(NSString*)AttachmentContentType;
	-(void)setAttachmentFileContent:(NSString*)AttachmentFileContent;
	-(void)setAttachmentFileName:(NSString*)AttachmentFileName;
	-(void)setBCC:(NSString*)BCC;
	-(void)setCC:(NSString*)CC;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setFrom:(NSString*)From;
	-(void)setMessageBody:(NSString*)MessageBody;
	-(void)setMessageBodyContentType:(NSString*)MessageBodyContentType;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setReplyTo:(NSString*)ReplyTo;
	-(void)setSubject:(NSString*)Subject;
	-(void)setThreadID:(NSString*)ThreadID;
	-(void)setTo:(NSString*)To;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SendMessage Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_SendMessage_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Sends an email to the recipients specified in the To, CC, and BCC parameters.
 */
@interface TMBGoogle_Gmailv2_Messages_SendMessage : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Messages_SendMessage_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Messages_SendMessage Choreo */


/*! group TMBGoogle.Gmailv2.Messages.TrashMessage Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the TrashMessage Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_TrashMessage_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setMessageID:(NSString*)MessageID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the TrashMessage Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_TrashMessage_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Moves a specific message to the trash.
 */
@interface TMBGoogle_Gmailv2_Messages_TrashMessage : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Messages_TrashMessage_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Messages_TrashMessage Choreo */


/*! group TMBGoogle.Gmailv2.Messages.UnTrashMessage Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UnTrashMessage Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_UnTrashMessage_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setMessageID:(NSString*)MessageID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UnTrashMessage Choreo.
 */
@interface TMBGoogle_Gmailv2_Messages_UnTrashMessage_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Moves a specific message out of the trash.
 */
@interface TMBGoogle_Gmailv2_Messages_UnTrashMessage : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Messages_UnTrashMessage_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Messages_UnTrashMessage Choreo */


/*! group TMBGoogle.Gmailv2.Threads.DeleteThread Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteThread Choreo.
 */
@interface TMBGoogle_Gmailv2_Threads_DeleteThread_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setThreadID:(NSString*)ThreadID;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteThread Choreo.
 */
@interface TMBGoogle_Gmailv2_Threads_DeleteThread_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Permanently deletes a specific thread.
 */
@interface TMBGoogle_Gmailv2_Threads_DeleteThread : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Threads_DeleteThread_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Threads_DeleteThread Choreo */


/*! group TMBGoogle.Gmailv2.Threads.GetThread Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetThread Choreo.
 */
@interface TMBGoogle_Gmailv2_Threads_GetThread_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setThreadID:(NSString*)ThreadID;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetThread Choreo.
 */
@interface TMBGoogle_Gmailv2_Threads_GetThread_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves an individual thread from a user's mailbox.
 */
@interface TMBGoogle_Gmailv2_Threads_GetThread : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Threads_GetThread_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Threads_GetThread Choreo */


/*! group TMBGoogle.Gmailv2.Threads.ListThreads Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListThreads Choreo.
 */
@interface TMBGoogle_Gmailv2_Threads_ListThreads_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setIncludeSpamTrash:(NSString*)IncludeSpamTrash;
	-(void)setLabelIDs:(NSString*)LabelIDs;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setQuery:(NSString*)Query;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListThreads Choreo.
 */
@interface TMBGoogle_Gmailv2_Threads_ListThreads_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists the threads in the user's mailbox.
 */
@interface TMBGoogle_Gmailv2_Threads_ListThreads : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Threads_ListThreads_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Threads_ListThreads Choreo */


/*! group TMBGoogle.Gmailv2.Threads.ModifyThread Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ModifyThread Choreo.
 */
@interface TMBGoogle_Gmailv2_Threads_ModifyThread_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAddLabelIDs:(NSString*)AddLabelIDs;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setRemoveLabelIDs:(NSString*)RemoveLabelIDs;
	-(void)setThreadID:(NSString*)ThreadID;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ModifyThread Choreo.
 */
@interface TMBGoogle_Gmailv2_Threads_ModifyThread_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Modifies the labels for a specific thread.
 */
@interface TMBGoogle_Gmailv2_Threads_ModifyThread : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Threads_ModifyThread_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Threads_ModifyThread Choreo */


/*! group TMBGoogle.Gmailv2.Threads.TrashThread Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the TrashThread Choreo.
 */
@interface TMBGoogle_Gmailv2_Threads_TrashThread_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setThreadID:(NSString*)ThreadID;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the TrashThread Choreo.
 */
@interface TMBGoogle_Gmailv2_Threads_TrashThread_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Moves a specific thread to the trash.
 */
@interface TMBGoogle_Gmailv2_Threads_TrashThread : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Threads_TrashThread_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Threads_TrashThread Choreo */


/*! group TMBGoogle.Gmailv2.Threads.UnTrashThread Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UnTrashThread Choreo.
 */
@interface TMBGoogle_Gmailv2_Threads_UnTrashThread_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setThreadID:(NSString*)ThreadID;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UnTrashThread Choreo.
 */
@interface TMBGoogle_Gmailv2_Threads_UnTrashThread_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Moves a specific thread out of the trash.
 */
@interface TMBGoogle_Gmailv2_Threads_UnTrashThread : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Gmailv2_Threads_UnTrashThread_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Gmailv2.Threads_UnTrashThread Choreo */


/*! group TMBGoogle.NaturalLanguage.Documents.AnalyzeEntities Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AnalyzeEntities Choreo.
 */
@interface TMBGoogle_NaturalLanguage_Documents_AnalyzeEntities_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setContent:(NSString*)Content;
	-(void)setEncodingType:(NSString*)EncodingType;
	-(void)setFields:(NSString*)Fields;
	-(void)setGCSContentUri:(NSString*)GCSContentUri;
	-(void)setLanguage:(NSString*)Language;
	-(void)setType:(NSString*)Type;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AnalyzeEntities Choreo.
 */
@interface TMBGoogle_NaturalLanguage_Documents_AnalyzeEntities_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Finds named entities (currently proper names and common nouns) in the text along with entity types, salience, mentions for each entity, and other properties.
 */
@interface TMBGoogle_NaturalLanguage_Documents_AnalyzeEntities : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_NaturalLanguage_Documents_AnalyzeEntities_Inputs*)newInputSet;
@end

/*! group TMBGoogle.NaturalLanguage.Documents_AnalyzeEntities Choreo */


/*! group TMBGoogle.NaturalLanguage.Documents.AnalyzeSentiment Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AnalyzeSentiment Choreo.
 */
@interface TMBGoogle_NaturalLanguage_Documents_AnalyzeSentiment_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setContent:(NSString*)Content;
	-(void)setEncodingType:(NSString*)EncodingType;
	-(void)setFields:(NSString*)Fields;
	-(void)setGCSContentUri:(NSString*)GCSContentUri;
	-(void)setLanguage:(NSString*)Language;
	-(void)setType:(NSString*)Type;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AnalyzeSentiment Choreo.
 */
@interface TMBGoogle_NaturalLanguage_Documents_AnalyzeSentiment_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getScore;
	-(NSString*)getResponse;	
@end

/*!
 * Analyzes the sentiment of the provided text.
 */
@interface TMBGoogle_NaturalLanguage_Documents_AnalyzeSentiment : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_NaturalLanguage_Documents_AnalyzeSentiment_Inputs*)newInputSet;
@end

/*! group TMBGoogle.NaturalLanguage.Documents_AnalyzeSentiment Choreo */


/*! group TMBGoogle.NaturalLanguage.Documents.AnalyzeSyntax Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AnalyzeSyntax Choreo.
 */
@interface TMBGoogle_NaturalLanguage_Documents_AnalyzeSyntax_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setContent:(NSString*)Content;
	-(void)setEncodingType:(NSString*)EncodingType;
	-(void)setFields:(NSString*)Fields;
	-(void)setGCSContentUri:(NSString*)GCSContentUri;
	-(void)setLanguage:(NSString*)Language;
	-(void)setType:(NSString*)Type;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AnalyzeSyntax Choreo.
 */
@interface TMBGoogle_NaturalLanguage_Documents_AnalyzeSyntax_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Analyzes the syntax of the text and provides sentence boundaries and tokenization along with part of speech tags, dependency trees, and other properties.
 */
@interface TMBGoogle_NaturalLanguage_Documents_AnalyzeSyntax : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_NaturalLanguage_Documents_AnalyzeSyntax_Inputs*)newInputSet;
@end

/*! group TMBGoogle.NaturalLanguage.Documents_AnalyzeSyntax Choreo */


/*! group TMBGoogle.NaturalLanguage.Documents.AnnotateText Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AnnotateText Choreo.
 */
@interface TMBGoogle_NaturalLanguage_Documents_AnnotateText_Inputs : TMBChoreographyInputSet
	-(void)setAPIKey:(NSString*)APIKey;
	-(void)setContent:(NSString*)Content;
	-(void)setEncodingType:(NSString*)EncodingType;
	-(void)setExtractDocumentSentiment:(NSString*)ExtractDocumentSentiment;
	-(void)setExtractEntities:(NSString*)ExtractEntities;
	-(void)setExtractSyntax:(NSString*)ExtractSyntax;
	-(void)setFields:(NSString*)Fields;
	-(void)setGCSContentUri:(NSString*)GCSContentUri;
	-(void)setLanguage:(NSString*)Language;
	-(void)setType:(NSString*)Type;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AnnotateText Choreo.
 */
@interface TMBGoogle_NaturalLanguage_Documents_AnnotateText_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * A convenience method that provides all the features that analyzeSentiment, analyzeEntities, and analyzeSyntax provide in one call.
 */
@interface TMBGoogle_NaturalLanguage_Documents_AnnotateText : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_NaturalLanguage_Documents_AnnotateText_Inputs*)newInputSet;
@end

/*! group TMBGoogle.NaturalLanguage.Documents_AnnotateText Choreo */


/*! group TMBGoogle.OAuth.FinalizeOAuth Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the FinalizeOAuth Choreo.
 */
@interface TMBGoogle_OAuth_FinalizeOAuth_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setAppKeyName:(NSString*)AppKeyName;
	-(void)setAppKeyValue:(NSString*)AppKeyValue;
	-(void)setCallbackID:(NSString*)CallbackID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setSuppressErrors:(NSString*)SuppressErrors;
	-(void)setTimeout:(NSString*)Timeout;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the FinalizeOAuth Choreo.
 */
@interface TMBGoogle_OAuth_FinalizeOAuth_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAccessToken;
	-(NSString*)getErrorMessage;
	-(NSString*)getExpires;
	-(NSString*)getRefreshToken;	
@end

/*!
 * Completes the OAuth process by retrieving a Google access token for a user, after they have visited the authorization URL returned by the InitializeOAuth Choreo and clicked "allow."
 */
@interface TMBGoogle_OAuth_FinalizeOAuth : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_OAuth_FinalizeOAuth_Inputs*)newInputSet;
@end

/*! group TMBGoogle.OAuth_FinalizeOAuth Choreo */


/*! group TMBGoogle.OAuth.InitializeOAuth Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the InitializeOAuth Choreo.
 */
@interface TMBGoogle_OAuth_InitializeOAuth_Inputs : TMBChoreographyInputSet
	-(void)setAccountName:(NSString*)AccountName;
	-(void)setAppKeyName:(NSString*)AppKeyName;
	-(void)setAppKeyValue:(NSString*)AppKeyValue;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setCustomCallbackID:(NSString*)CustomCallbackID;
	-(void)setForwardingURL:(NSString*)ForwardingURL;
	-(void)setScope:(NSString*)Scope;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the InitializeOAuth Choreo.
 */
@interface TMBGoogle_OAuth_InitializeOAuth_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAuthorizationURL;
	-(NSString*)getCallbackID;	
@end

/*!
 * Generates an authorization URL that an application can use to complete the first step in the OAuth process.
 */
@interface TMBGoogle_OAuth_InitializeOAuth : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_OAuth_InitializeOAuth_Inputs*)newInputSet;
@end

/*! group TMBGoogle.OAuth_InitializeOAuth Choreo */


/*! group TMBGoogle.Picasa.AddCommentToPhoto Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AddCommentToPhoto Choreo.
 */
@interface TMBGoogle_Picasa_AddCommentToPhoto_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAlbumID:(NSString*)AlbumID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setComment:(NSString*)Comment;
	-(void)setPhotoID:(NSString*)PhotoID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddCommentToPhoto Choreo.
 */
@interface TMBGoogle_Picasa_AddCommentToPhoto_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Adds a comment to a specified photo in Google Picasa.
 */
@interface TMBGoogle_Picasa_AddCommentToPhoto : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Picasa_AddCommentToPhoto_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Picasa_AddCommentToPhoto Choreo */


/*! group TMBGoogle.Picasa.CreateAlbum Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateAlbum Choreo.
 */
@interface TMBGoogle_Picasa_CreateAlbum_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setKeywords:(NSString*)Keywords;
	-(void)setPhotoAccess:(NSString*)PhotoAccess;
	-(void)setPhotoLocation:(NSString*)PhotoLocation;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSummary:(NSString*)Summary;
	-(void)setTimestamp:(NSString*)Timestamp;
	-(void)setTitle:(NSString*)Title;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateAlbum Choreo.
 */
@interface TMBGoogle_Picasa_CreateAlbum_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a photo album in a Google Picasa account.
 */
@interface TMBGoogle_Picasa_CreateAlbum : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Picasa_CreateAlbum_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Picasa_CreateAlbum Choreo */


/*! group TMBGoogle.Picasa.DeleteAlbum Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteAlbum Choreo.
 */
@interface TMBGoogle_Picasa_DeleteAlbum_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAlbumID:(NSString*)AlbumID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteAlbum Choreo.
 */
@interface TMBGoogle_Picasa_DeleteAlbum_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes an album in Google Picasa with a specified album Id.
 */
@interface TMBGoogle_Picasa_DeleteAlbum : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Picasa_DeleteAlbum_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Picasa_DeleteAlbum Choreo */


/*! group TMBGoogle.Picasa.DeleteTag Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteTag Choreo.
 */
@interface TMBGoogle_Picasa_DeleteTag_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAlbumId:(NSString*)AlbumId;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setPhotoID:(NSString*)PhotoID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setTagID:(NSString*)TagID;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteTag Choreo.
 */
@interface TMBGoogle_Picasa_DeleteTag_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Removes a tag from a specified photo in Google Picasa.
 */
@interface TMBGoogle_Picasa_DeleteTag : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Picasa_DeleteTag_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Picasa_DeleteTag Choreo */


/*! group TMBGoogle.Picasa.ListAlbums Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListAlbums Choreo.
 */
@interface TMBGoogle_Picasa_ListAlbums_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListAlbums Choreo.
 */
@interface TMBGoogle_Picasa_ListAlbums_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * List all albums created in a Google Picasa account.
 */
@interface TMBGoogle_Picasa_ListAlbums : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Picasa_ListAlbums_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Picasa_ListAlbums Choreo */


/*! group TMBGoogle.Picasa.ListPhotosByAlbum Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListPhotosByAlbum Choreo.
 */
@interface TMBGoogle_Picasa_ListPhotosByAlbum_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAlbumID:(NSString*)AlbumID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListPhotosByAlbum Choreo.
 */
@interface TMBGoogle_Picasa_ListPhotosByAlbum_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists all photos in a specified Google Picasa album.
 */
@interface TMBGoogle_Picasa_ListPhotosByAlbum : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Picasa_ListPhotosByAlbum_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Picasa_ListPhotosByAlbum Choreo */


/*! group TMBGoogle.Picasa.PostPhoto Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the PostPhoto Choreo.
 */
@interface TMBGoogle_Picasa_PostPhoto_Inputs : TMBChoreographyInputSet
	-(void)setFileContents:(NSString*)FileContents;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAlbumID:(NSString*)AlbumID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setImageName:(NSString*)ImageName;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
	-(void)setVaultFile:(NSString*)VaultFile;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the PostPhoto Choreo.
 */
@interface TMBGoogle_Picasa_PostPhoto_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Uploads a photo to Google Picasa.
 */
@interface TMBGoogle_Picasa_PostPhoto : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Picasa_PostPhoto_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Picasa_PostPhoto Choreo */


/*! group TMBGoogle.Picasa.RetrieveComments Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RetrieveComments Choreo.
 */
@interface TMBGoogle_Picasa_RetrieveComments_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RetrieveComments Choreo.
 */
@interface TMBGoogle_Picasa_RetrieveComments_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Returns a feed of the photo comments for a specified user.
 */
@interface TMBGoogle_Picasa_RetrieveComments : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Picasa_RetrieveComments_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Picasa_RetrieveComments Choreo */


/*! group TMBGoogle.Picasa.RetrieveTagsByUser Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RetrieveTagsByUser Choreo.
 */
@interface TMBGoogle_Picasa_RetrieveTagsByUser_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RetrieveTagsByUser Choreo.
 */
@interface TMBGoogle_Picasa_RetrieveTagsByUser_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Returns a feed of the photo tags for a specified user.
 */
@interface TMBGoogle_Picasa_RetrieveTagsByUser : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Picasa_RetrieveTagsByUser_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Picasa_RetrieveTagsByUser Choreo */


/*! group TMBGoogle.Picasa.SearchPhotosByTag Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SearchPhotosByTag Choreo.
 */
@interface TMBGoogle_Picasa_SearchPhotosByTag_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setTag:(NSString*)Tag;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SearchPhotosByTag Choreo.
 */
@interface TMBGoogle_Picasa_SearchPhotosByTag_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Searches photos using tags that you specify.
 */
@interface TMBGoogle_Picasa_SearchPhotosByTag : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Picasa_SearchPhotosByTag_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Picasa_SearchPhotosByTag Choreo */


/*! group TMBGoogle.Picasa.TagPhoto Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the TagPhoto Choreo.
 */
@interface TMBGoogle_Picasa_TagPhoto_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setAlbumID:(NSString*)AlbumID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setPhotoID:(NSString*)PhotoID;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setTag:(NSString*)Tag;
	-(void)setUserID:(NSString*)UserID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the TagPhoto Choreo.
 */
@interface TMBGoogle_Picasa_TagPhoto_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getAccessToken;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a tag for a specified photo in Google Picasa.
 */
@interface TMBGoogle_Picasa_TagPhoto : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Picasa_TagPhoto_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Picasa_TagPhoto Choreo */


/*! group TMBGoogle.Places.DeletePlace Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeletePlace Choreo.
 */
@interface TMBGoogle_Places_DeletePlace_Inputs : TMBChoreographyInputSet
	-(void)setKey:(NSString*)Key;
	-(void)setPlaceID:(NSString*)PlaceID;
	-(void)setPlaceReference:(NSString*)PlaceReference;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSensor:(NSString*)Sensor;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeletePlace Choreo.
 */
@interface TMBGoogle_Places_DeletePlace_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Delete a new Place from Google Places.
 */
@interface TMBGoogle_Places_DeletePlace : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Places_DeletePlace_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Places_DeletePlace Choreo */


/*! group TMBGoogle.Places.PlaceDetails Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the PlaceDetails Choreo.
 */
@interface TMBGoogle_Places_PlaceDetails_Inputs : TMBChoreographyInputSet
	-(void)setKey:(NSString*)Key;
	-(void)setLanguage:(NSString*)Language;
	-(void)setPlaceID:(NSString*)PlaceID;
	-(void)setReference:(NSString*)Reference;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSensor:(NSString*)Sensor;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the PlaceDetails Choreo.
 */
@interface TMBGoogle_Places_PlaceDetails_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieve detailed information about places retrieved by the PlaceSearch Choreo.
 */
@interface TMBGoogle_Places_PlaceDetails : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Places_PlaceDetails_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Places_PlaceDetails Choreo */


/*! group TMBGoogle.Places.PlaceSearch Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the PlaceSearch Choreo.
 */
@interface TMBGoogle_Places_PlaceSearch_Inputs : TMBChoreographyInputSet
	-(void)setKey:(NSString*)Key;
	-(void)setKeyword:(NSString*)Keyword;
	-(void)setLanguage:(NSString*)Language;
	-(void)setLatitude:(NSString*)Latitude;
	-(void)setLongitude:(NSString*)Longitude;
	-(void)setMaxPrice:(NSString*)MaxPrice;
	-(void)setMinPrice:(NSString*)MinPrice;
	-(void)setName:(NSString*)Name;
	-(void)setOpenNow:(NSString*)OpenNow;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setRadius:(NSString*)Radius;
	-(void)setRankBy:(NSString*)RankBy;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSensor:(NSString*)Sensor;
	-(void)setTypes:(NSString*)Types;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the PlaceSearch Choreo.
 */
@interface TMBGoogle_Places_PlaceSearch_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Search for places based on latitude/longitude coordinates, keywords, and distance.
 */
@interface TMBGoogle_Places_PlaceSearch : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Places_PlaceSearch_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Places_PlaceSearch Choreo */


/*! group TMBGoogle.Places.RadarSearch Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RadarSearch Choreo.
 */
@interface TMBGoogle_Places_RadarSearch_Inputs : TMBChoreographyInputSet
	-(void)setKey:(NSString*)Key;
	-(void)setKeyword:(NSString*)Keyword;
	-(void)setLanguage:(NSString*)Language;
	-(void)setLatitude:(NSString*)Latitude;
	-(void)setLongitude:(NSString*)Longitude;
	-(void)setMaxPrice:(NSString*)MaxPrice;
	-(void)setMinPrice:(NSString*)MinPrice;
	-(void)setName:(NSString*)Name;
	-(void)setOpenNow:(NSString*)OpenNow;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setRadius:(NSString*)Radius;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSensor:(NSString*)Sensor;
	-(void)setTypes:(NSString*)Types;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RadarSearch Choreo.
 */
@interface TMBGoogle_Places_RadarSearch_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Search up to 200 places at once.   RadarSearch helps identify specific areas of interest within a geographic area.
 */
@interface TMBGoogle_Places_RadarSearch : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Places_RadarSearch_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Places_RadarSearch Choreo */


/*! group TMBGoogle.Places.TextSearch Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the TextSearch Choreo.
 */
@interface TMBGoogle_Places_TextSearch_Inputs : TMBChoreographyInputSet
	-(void)setKey:(NSString*)Key;
	-(void)setLanguage:(NSString*)Language;
	-(void)setLatitude:(NSString*)Latitude;
	-(void)setLongitude:(NSString*)Longitude;
	-(void)setMaxPrice:(NSString*)MaxPrice;
	-(void)setMinPrice:(NSString*)MinPrice;
	-(void)setOpenNow:(NSString*)OpenNow;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setQuery:(NSString*)Query;
	-(void)setRadius:(NSString*)Radius;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSensor:(NSString*)Sensor;
	-(void)setTypes:(NSString*)Types;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the TextSearch Choreo.
 */
@interface TMBGoogle_Places_TextSearch_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Search for places based on a text query and optional location.
 */
@interface TMBGoogle_Places_TextSearch : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Places_TextSearch_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Places_TextSearch Choreo */


/*! group TMBGoogle.Places.UserPlaceReports Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UserPlaceReports Choreo.
 */
@interface TMBGoogle_Places_UserPlaceReports_Inputs : TMBChoreographyInputSet
	-(void)setPOSTForm:(NSString*)POSTForm;
	-(void)setAccuracy:(NSString*)Accuracy;
	-(void)setAddress:(NSString*)Address;
	-(void)setKey:(NSString*)Key;
	-(void)setLanguage:(NSString*)Language;
	-(void)setLatitude:(NSString*)Latitude;
	-(void)setLongitude:(NSString*)Longitude;
	-(void)setName:(NSString*)Name;
	-(void)setPhoneNumber:(NSString*)PhoneNumber;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSensor:(NSString*)Sensor;
	-(void)setTypes:(NSString*)Types;
	-(void)setWebsite:(NSString*)Website;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UserPlaceReports Choreo.
 */
@interface TMBGoogle_Places_UserPlaceReports_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getResponse;	
@end

/*!
 * Add a new Place to Google Places.
 */
@interface TMBGoogle_Places_UserPlaceReports : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Places_UserPlaceReports_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Places_UserPlaceReports Choreo */


/*! group TMBGoogle.Plus.Activities.Get Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Get Choreo.
 */
@interface TMBGoogle_Plus_Activities_Get_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setActivityID:(NSString*)ActivityID;
	-(void)setCallback:(NSString*)Callback;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Get Choreo.
 */
@interface TMBGoogle_Plus_Activities_Get_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a given activity.
 */
@interface TMBGoogle_Plus_Activities_Get : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Activities_Get_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Activities_Get Choreo */


/*! group TMBGoogle.Plus.Activities.List Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the List Choreo.
 */
@interface TMBGoogle_Plus_Activities_List_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCallback:(NSString*)Callback;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setCollection:(NSString*)Collection;
	-(void)setFields:(NSString*)Fields;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the List Choreo.
 */
@interface TMBGoogle_Plus_Activities_List_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 *  Returns a list of all activities in the specified collection for a particular user.
 */
@interface TMBGoogle_Plus_Activities_List : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Activities_List_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Activities_List Choreo */


/*! group TMBGoogle.Plus.Activities.Search Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Search Choreo.
 */
@interface TMBGoogle_Plus_Activities_Search_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCallback:(NSString*)Callback;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setLanguage:(NSString*)Language;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setOrderBy:(NSString*)OrderBy;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setQuery:(NSString*)Query;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Search Choreo.
 */
@interface TMBGoogle_Plus_Activities_Search_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Searches all public activities.
 */
@interface TMBGoogle_Plus_Activities_Search : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Activities_Search_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Activities_Search Choreo */


/*! group TMBGoogle.Plus.Comments.Get Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Get Choreo.
 */
@interface TMBGoogle_Plus_Comments_Get_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCallback:(NSString*)Callback;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setCommentID:(NSString*)CommentID;
	-(void)setFields:(NSString*)Fields;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Get Choreo.
 */
@interface TMBGoogle_Plus_Comments_Get_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a given comment.
 */
@interface TMBGoogle_Plus_Comments_Get : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Comments_Get_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Comments_Get Choreo */


/*! group TMBGoogle.Plus.Comments.List Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the List Choreo.
 */
@interface TMBGoogle_Plus_Comments_List_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setActivityID:(NSString*)ActivityID;
	-(void)setCallback:(NSString*)Callback;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSortOrder:(NSString*)SortOrder;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the List Choreo.
 */
@interface TMBGoogle_Plus_Comments_List_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list all of the comments for a given activity.
 */
@interface TMBGoogle_Plus_Comments_List : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Comments_List_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Comments_List Choreo */


/*! group TMBGoogle.Plus.Domains.Activities.Get Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Get Choreo.
 */
@interface TMBGoogle_Plus_Domains_Activities_Get_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setActivityID:(NSString*)ActivityID;
	-(void)setCallback:(NSString*)Callback;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Get Choreo.
 */
@interface TMBGoogle_Plus_Domains_Activities_Get_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a specific activity.
 */
@interface TMBGoogle_Plus_Domains_Activities_Get : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Domains_Activities_Get_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Domains.Activities_Get Choreo */


/*! group TMBGoogle.Plus.Domains.Activities.Insert Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Insert Choreo.
 */
@interface TMBGoogle_Plus_Domains_Activities_Insert_Inputs : TMBChoreographyInputSet
	-(void)setActivityResource:(NSString*)ActivityResource;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCallback:(NSString*)Callback;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setContent:(NSString*)Content;
	-(void)setDescription:(NSString*)Description;
	-(void)setFields:(NSString*)Fields;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setPreview:(NSString*)Preview;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setShareWithDomain:(NSString*)ShareWithDomain;
	-(void)setShareWithExtendedCircles:(NSString*)ShareWithExtendedCircles;
	-(void)setShareWithMyCircles:(NSString*)ShareWithMyCircles;
	-(void)setShareWithPublic:(NSString*)ShareWithPublic;
	-(void)setShareWithTheseCircles:(NSString*)ShareWithTheseCircles;
	-(void)setShareWithThesePeople:(NSString*)ShareWithThesePeople;
	-(void)setUserID:(NSString*)UserID;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Insert Choreo.
 */
@interface TMBGoogle_Plus_Domains_Activities_Insert_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Inserts a new activity into a user's stream.
 */
@interface TMBGoogle_Plus_Domains_Activities_Insert : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Domains_Activities_Insert_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Domains.Activities_Insert Choreo */


/*! group TMBGoogle.Plus.Domains.Activities.List Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the List Choreo.
 */
@interface TMBGoogle_Plus_Domains_Activities_List_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCallback:(NSString*)Callback;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setCollection:(NSString*)Collection;
	-(void)setFields:(NSString*)Fields;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setOrderBy:(NSString*)OrderBy;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the List Choreo.
 */
@interface TMBGoogle_Plus_Domains_Activities_List_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists all of the activities in the specified collection for a particular user.
 */
@interface TMBGoogle_Plus_Domains_Activities_List : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Domains_Activities_List_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Domains.Activities_List Choreo */


/*! group TMBGoogle.Plus.Domains.Audiences.List Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the List Choreo.
 */
@interface TMBGoogle_Plus_Domains_Audiences_List_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCallback:(NSString*)Callback;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setOrderBy:(NSString*)OrderBy;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the List Choreo.
 */
@interface TMBGoogle_Plus_Domains_Audiences_List_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists all of the audiences with which a user can share.
 */
@interface TMBGoogle_Plus_Domains_Audiences_List : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Domains_Audiences_List_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Domains.Audiences_List Choreo */


/*! group TMBGoogle.Plus.Domains.Circles.AddPeople Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AddPeople Choreo.
 */
@interface TMBGoogle_Plus_Domains_Circles_AddPeople_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCallback:(NSString*)Callback;
	-(void)setCircleID:(NSString*)CircleID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setEmail:(NSString*)Email;
	-(void)setFields:(NSString*)Fields;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddPeople Choreo.
 */
@interface TMBGoogle_Plus_Domains_Circles_AddPeople_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Adds people to a circle.
 */
@interface TMBGoogle_Plus_Domains_Circles_AddPeople : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Domains_Circles_AddPeople_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Domains.Circles_AddPeople Choreo */


/*! group TMBGoogle.Plus.Domains.Circles.Delete Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Delete Choreo.
 */
@interface TMBGoogle_Plus_Domains_Circles_Delete_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCallback:(NSString*)Callback;
	-(void)setCircleID:(NSString*)CircleID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Delete Choreo.
 */
@interface TMBGoogle_Plus_Domains_Circles_Delete_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes the specified circle.
 */
@interface TMBGoogle_Plus_Domains_Circles_Delete : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Domains_Circles_Delete_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Domains.Circles_Delete Choreo */


/*! group TMBGoogle.Plus.Domains.Circles.Get Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Get Choreo.
 */
@interface TMBGoogle_Plus_Domains_Circles_Get_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCallback:(NSString*)Callback;
	-(void)setCircleID:(NSString*)CircleID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Get Choreo.
 */
@interface TMBGoogle_Plus_Domains_Circles_Get_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a specific circle.
 */
@interface TMBGoogle_Plus_Domains_Circles_Get : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Domains_Circles_Get_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Domains.Circles_Get Choreo */


/*! group TMBGoogle.Plus.Domains.Circles.Insert Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Insert Choreo.
 */
@interface TMBGoogle_Plus_Domains_Circles_Insert_Inputs : TMBChoreographyInputSet
	-(void)setCircleResource:(NSString*)CircleResource;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCallback:(NSString*)Callback;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDescription:(NSString*)Description;
	-(void)setDisplayName:(NSString*)DisplayName;
	-(void)setFields:(NSString*)Fields;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Insert Choreo.
 */
@interface TMBGoogle_Plus_Domains_Circles_Insert_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new circle for the authenticated user.
 */
@interface TMBGoogle_Plus_Domains_Circles_Insert : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Domains_Circles_Insert_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Domains.Circles_Insert Choreo */


/*! group TMBGoogle.Plus.Domains.Circles.List Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the List Choreo.
 */
@interface TMBGoogle_Plus_Domains_Circles_List_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCallback:(NSString*)Callback;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setOrderBy:(NSString*)OrderBy;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the List Choreo.
 */
@interface TMBGoogle_Plus_Domains_Circles_List_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists a user's circles.
 */
@interface TMBGoogle_Plus_Domains_Circles_List : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Domains_Circles_List_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Domains.Circles_List Choreo */


/*! group TMBGoogle.Plus.Domains.Circles.RemovePeople Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RemovePeople Choreo.
 */
@interface TMBGoogle_Plus_Domains_Circles_RemovePeople_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCallback:(NSString*)Callback;
	-(void)setCircleID:(NSString*)CircleID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setEmail:(NSString*)Email;
	-(void)setFields:(NSString*)Fields;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RemovePeople Choreo.
 */
@interface TMBGoogle_Plus_Domains_Circles_RemovePeople_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponseStatusCode;
	-(NSString*)getResponse;	
@end

/*!
 * Removes a person from a circle.
 */
@interface TMBGoogle_Plus_Domains_Circles_RemovePeople : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Domains_Circles_RemovePeople_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Domains.Circles_RemovePeople Choreo */


/*! group TMBGoogle.Plus.Domains.Circles.Update Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Update Choreo.
 */
@interface TMBGoogle_Plus_Domains_Circles_Update_Inputs : TMBChoreographyInputSet
	-(void)setCircleResource:(NSString*)CircleResource;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCallback:(NSString*)Callback;
	-(void)setCircleID:(NSString*)CircleID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDescription:(NSString*)Description;
	-(void)setDisplayName:(NSString*)DisplayName;
	-(void)setFields:(NSString*)Fields;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Update Choreo.
 */
@interface TMBGoogle_Plus_Domains_Circles_Update_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Updates a specified circle.
 */
@interface TMBGoogle_Plus_Domains_Circles_Update : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Domains_Circles_Update_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Domains.Circles_Update Choreo */


/*! group TMBGoogle.Plus.Domains.Comments.Get Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Get Choreo.
 */
@interface TMBGoogle_Plus_Domains_Comments_Get_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCallback:(NSString*)Callback;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setCommentID:(NSString*)CommentID;
	-(void)setFields:(NSString*)Fields;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Get Choreo.
 */
@interface TMBGoogle_Plus_Domains_Comments_Get_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves the specified comment.
 */
@interface TMBGoogle_Plus_Domains_Comments_Get : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Domains_Comments_Get_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Domains.Comments_Get Choreo */


/*! group TMBGoogle.Plus.Domains.Comments.Insert Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Insert Choreo.
 */
@interface TMBGoogle_Plus_Domains_Comments_Insert_Inputs : TMBChoreographyInputSet
	-(void)setCommentResource:(NSString*)CommentResource;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setActivityID:(NSString*)ActivityID;
	-(void)setCallback:(NSString*)Callback;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setContent:(NSString*)Content;
	-(void)setDescription:(NSString*)Description;
	-(void)setFields:(NSString*)Fields;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Insert Choreo.
 */
@interface TMBGoogle_Plus_Domains_Comments_Insert_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new comment in reply to an activity.
 */
@interface TMBGoogle_Plus_Domains_Comments_Insert : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Domains_Comments_Insert_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Domains.Comments_Insert Choreo */


/*! group TMBGoogle.Plus.Domains.Comments.List Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the List Choreo.
 */
@interface TMBGoogle_Plus_Domains_Comments_List_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setActivityID:(NSString*)ActivityID;
	-(void)setCallback:(NSString*)Callback;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setOrderBy:(NSString*)OrderBy;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the List Choreo.
 */
@interface TMBGoogle_Plus_Domains_Comments_List_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists all of the comments for an activity.
 */
@interface TMBGoogle_Plus_Domains_Comments_List : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Domains_Comments_List_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Domains.Comments_List Choreo */


/*! group TMBGoogle.Plus.Domains.Media.Insert Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Insert Choreo.
 */
@interface TMBGoogle_Plus_Domains_Media_Insert_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setCollection:(NSString*)Collection;
	-(void)setContentType:(NSString*)ContentType;
	-(void)setDisplayName:(NSString*)DisplayName;
	-(void)setFields:(NSString*)Fields;
	-(void)setFileContent:(NSString*)FileContent;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
	-(void)setVaultFile:(NSString*)VaultFile;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Insert Choreo.
 */
@interface TMBGoogle_Plus_Domains_Media_Insert_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Adds a new media item to an album. 
 */
@interface TMBGoogle_Plus_Domains_Media_Insert : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Domains_Media_Insert_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Domains.Media_Insert Choreo */


/*! group TMBGoogle.Plus.Domains.People.Get Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Get Choreo.
 */
@interface TMBGoogle_Plus_Domains_People_Get_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCallback:(NSString*)Callback;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Get Choreo.
 */
@interface TMBGoogle_Plus_Domains_People_Get_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a person's profile.
 */
@interface TMBGoogle_Plus_Domains_People_Get : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Domains_People_Get_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Domains.People_Get Choreo */


/*! group TMBGoogle.Plus.Domains.People.List Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the List Choreo.
 */
@interface TMBGoogle_Plus_Domains_People_List_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCallback:(NSString*)Callback;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setCollection:(NSString*)Collection;
	-(void)setFields:(NSString*)Fields;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setOrderBy:(NSString*)OrderBy;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the List Choreo.
 */
@interface TMBGoogle_Plus_Domains_People_List_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists all of the people in the specified collection.
 */
@interface TMBGoogle_Plus_Domains_People_List : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Domains_People_List_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Domains.People_List Choreo */


/*! group TMBGoogle.Plus.Domains.People.ListByActivity Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListByActivity Choreo.
 */
@interface TMBGoogle_Plus_Domains_People_ListByActivity_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setActivityID:(NSString*)ActivityID;
	-(void)setCallback:(NSString*)Callback;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setCollection:(NSString*)Collection;
	-(void)setFields:(NSString*)Fields;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setOrderBy:(NSString*)OrderBy;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListByActivity Choreo.
 */
@interface TMBGoogle_Plus_Domains_People_ListByActivity_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists all of the people in the specified collection for a particular activity.
 */
@interface TMBGoogle_Plus_Domains_People_ListByActivity : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Domains_People_ListByActivity_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Domains.People_ListByActivity Choreo */


/*! group TMBGoogle.Plus.Domains.People.ListByCircle Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListByCircle Choreo.
 */
@interface TMBGoogle_Plus_Domains_People_ListByCircle_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCallback:(NSString*)Callback;
	-(void)setCircleID:(NSString*)CircleID;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setOrderBy:(NSString*)OrderBy;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListByCircle Choreo.
 */
@interface TMBGoogle_Plus_Domains_People_ListByCircle_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Lists all of the people who are members of a circle.
 */
@interface TMBGoogle_Plus_Domains_People_ListByCircle : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_Domains_People_ListByCircle_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.Domains.People_ListByCircle Choreo */


/*! group TMBGoogle.Plus.People.Get Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Get Choreo.
 */
@interface TMBGoogle_Plus_People_Get_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCallback:(NSString*)Callback;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Get Choreo.
 */
@interface TMBGoogle_Plus_People_Get_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a person's profile.
 */
@interface TMBGoogle_Plus_People_Get : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_People_Get_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.People_Get Choreo */


/*! group TMBGoogle.Plus.People.List Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the List Choreo.
 */
@interface TMBGoogle_Plus_People_List_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCallback:(NSString*)Callback;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setOrderBy:(NSString*)OrderBy;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserID:(NSString*)UserID;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the List Choreo.
 */
@interface TMBGoogle_Plus_People_List_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Returns all of the people who the authenticated user has added to one or more circles.
 */
@interface TMBGoogle_Plus_People_List : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_People_List_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.People_List Choreo */


/*! group TMBGoogle.Plus.People.ListByActivity Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ListByActivity Choreo.
 */
@interface TMBGoogle_Plus_People_ListByActivity_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setActivityID:(NSString*)ActivityID;
	-(void)setCallback:(NSString*)Callback;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setCollection:(NSString*)Collection;
	-(void)setFields:(NSString*)Fields;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ListByActivity Choreo.
 */
@interface TMBGoogle_Plus_People_ListByActivity_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 *  Returns all of the people in the specified collection for a particular activity.
 */
@interface TMBGoogle_Plus_People_ListByActivity : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_People_ListByActivity_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.People_ListByActivity Choreo */


/*! group TMBGoogle.Plus.People.Search Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the Search Choreo.
 */
@interface TMBGoogle_Plus_People_Search_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCallback:(NSString*)Callback;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setLanguage:(NSString*)Language;
	-(void)setMaxResults:(NSString*)MaxResults;
	-(void)setPageToken:(NSString*)PageToken;
	-(void)setPrettyPrint:(NSString*)PrettyPrint;
	-(void)setQuery:(NSString*)Query;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setUserIP:(NSString*)UserIP;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the Search Choreo.
 */
@interface TMBGoogle_Plus_People_Search_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Searches all public profiles.
 */
@interface TMBGoogle_Plus_People_Search : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Plus_People_Search_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Plus.People_Search Choreo */


/*! group TMBGoogle.Sheets.AppendValues Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AppendValues Choreo.
 */
@interface TMBGoogle_Sheets_AppendValues_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setInsertDataOption:(NSString*)InsertDataOption;
	-(void)setMajorDimension:(NSString*)MajorDimension;
	-(void)setRange:(NSString*)Range;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSpreadsheetID:(NSString*)SpreadsheetID;
	-(void)setValueInputOption:(NSString*)ValueInputOption;
	-(void)setValues:(NSString*)Values;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AppendValues Choreo.
 */
@interface TMBGoogle_Sheets_AppendValues_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Appends values to a spreadsheet.
 */
@interface TMBGoogle_Sheets_AppendValues : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Sheets_AppendValues_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Sheets_AppendValues Choreo */


/*! group TMBGoogle.Sheets.BatchGetValues Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the BatchGetValues Choreo.
 */
@interface TMBGoogle_Sheets_BatchGetValues_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDateTimeRenderOption:(NSString*)DateTimeRenderOption;
	-(void)setFields:(NSString*)Fields;
	-(void)setMajorDimension:(NSString*)MajorDimension;
	-(void)setRanges:(NSString*)Ranges;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSpreadsheetID:(NSString*)SpreadsheetID;
	-(void)setValueRenderOption:(NSString*)ValueRenderOption;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the BatchGetValues Choreo.
 */
@interface TMBGoogle_Sheets_BatchGetValues_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Returns one or more ranges of values from a spreadsheet.
 */
@interface TMBGoogle_Sheets_BatchGetValues : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Sheets_BatchGetValues_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Sheets_BatchGetValues Choreo */


/*! group TMBGoogle.Sheets.BatchUpdateValues Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the BatchUpdateValues Choreo.
 */
@interface TMBGoogle_Sheets_BatchUpdateValues_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setData:(NSString*)Data;
	-(void)setFields:(NSString*)Fields;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSpreadsheetID:(NSString*)SpreadsheetID;
	-(void)setValueInputOption:(NSString*)ValueInputOption;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the BatchUpdateValues Choreo.
 */
@interface TMBGoogle_Sheets_BatchUpdateValues_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Updates values in one or more ranges of a spreadsheet. 
 */
@interface TMBGoogle_Sheets_BatchUpdateValues : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Sheets_BatchUpdateValues_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Sheets_BatchUpdateValues Choreo */


/*! group TMBGoogle.Sheets.ClearValues Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the ClearValues Choreo.
 */
@interface TMBGoogle_Sheets_ClearValues_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setRange:(NSString*)Range;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSpreadsheetID:(NSString*)SpreadsheetID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the ClearValues Choreo.
 */
@interface TMBGoogle_Sheets_ClearValues_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Clears values from a spreadsheet.
 */
@interface TMBGoogle_Sheets_ClearValues : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Sheets_ClearValues_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Sheets_ClearValues Choreo */


/*! group TMBGoogle.Sheets.CopyToSheet Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CopyToSheet Choreo.
 */
@interface TMBGoogle_Sheets_CopyToSheet_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDestinationSpreadsheetID:(NSString*)DestinationSpreadsheetID;
	-(void)setFields:(NSString*)Fields;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSheetID:(NSString*)SheetID;
	-(void)setSpreadsheetID:(NSString*)SpreadsheetID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CopyToSheet Choreo.
 */
@interface TMBGoogle_Sheets_CopyToSheet_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Copies a single sheet from a spreadsheet to another spreadsheet.
 */
@interface TMBGoogle_Sheets_CopyToSheet : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Sheets_CopyToSheet_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Sheets_CopyToSheet Choreo */


/*! group TMBGoogle.Sheets.CreateSpreadsheet Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the CreateSpreadsheet Choreo.
 */
@interface TMBGoogle_Sheets_CreateSpreadsheet_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setNamedRanges:(NSString*)NamedRanges;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSheets:(NSString*)Sheets;
	-(void)setSpreadsheetProperties:(NSString*)SpreadsheetProperties;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the CreateSpreadsheet Choreo.
 */
@interface TMBGoogle_Sheets_CreateSpreadsheet_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a spreadsheet.
 */
@interface TMBGoogle_Sheets_CreateSpreadsheet : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Sheets_CreateSpreadsheet_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Sheets_CreateSpreadsheet Choreo */


/*! group TMBGoogle.Sheets.GetLastRow Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetLastRow Choreo.
 */
@interface TMBGoogle_Sheets_GetLastRow_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDateTimeRenderOption:(NSString*)DateTimeRenderOption;
	-(void)setFields:(NSString*)Fields;
	-(void)setMaxColumn:(NSString*)MaxColumn;
	-(void)setMinColumn:(NSString*)MinColumn;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSheetName:(NSString*)SheetName;
	-(void)setSpreadsheetID:(NSString*)SpreadsheetID;
	-(void)setValueRenderOption:(NSString*)ValueRenderOption;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetLastRow Choreo.
 */
@interface TMBGoogle_Sheets_GetLastRow_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Returns the last row in a sheet.
 */
@interface TMBGoogle_Sheets_GetLastRow : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Sheets_GetLastRow_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Sheets_GetLastRow Choreo */


/*! group TMBGoogle.Sheets.GetSpreadsheet Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetSpreadsheet Choreo.
 */
@interface TMBGoogle_Sheets_GetSpreadsheet_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setIncludeGridData:(NSString*)IncludeGridData;
	-(void)setRanges:(NSString*)Ranges;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSpreadsheetID:(NSString*)SpreadsheetID;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetSpreadsheet Choreo.
 */
@interface TMBGoogle_Sheets_GetSpreadsheet_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Returns the spreadsheet at the given ID.
 */
@interface TMBGoogle_Sheets_GetSpreadsheet : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Sheets_GetSpreadsheet_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Sheets_GetSpreadsheet Choreo */


/*! group TMBGoogle.Sheets.GetValues Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the GetValues Choreo.
 */
@interface TMBGoogle_Sheets_GetValues_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDateTimeRenderOption:(NSString*)DateTimeRenderOption;
	-(void)setFields:(NSString*)Fields;
	-(void)setMajorDimension:(NSString*)MajorDimension;
	-(void)setRange:(NSString*)Range;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSpreadsheetID:(NSString*)SpreadsheetID;
	-(void)setValueRenderOption:(NSString*)ValueRenderOption;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the GetValues Choreo.
 */
@interface TMBGoogle_Sheets_GetValues_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Returns a range of values from a spreadsheet.
 */
@interface TMBGoogle_Sheets_GetValues : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Sheets_GetValues_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Sheets_GetValues Choreo */


/*! group TMBGoogle.Sheets.UpdateValues Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateValues Choreo.
 */
@interface TMBGoogle_Sheets_UpdateValues_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFields:(NSString*)Fields;
	-(void)setMajorDimension:(NSString*)MajorDimension;
	-(void)setRange:(NSString*)Range;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSpreadsheetID:(NSString*)SpreadsheetID;
	-(void)setValueInputOption:(NSString*)ValueInputOption;
	-(void)setValues:(NSString*)Values;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateValues Choreo.
 */
@interface TMBGoogle_Sheets_UpdateValues_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Updates values in the specified range of a spreadsheet.
 */
@interface TMBGoogle_Sheets_UpdateValues : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Sheets_UpdateValues_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Sheets_UpdateValues Choreo */


/*! group TMBGoogle.Spreadsheets.AddListRows Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AddListRows Choreo.
 */
@interface TMBGoogle_Spreadsheets_AddListRows_Inputs : TMBChoreographyInputSet
	-(void)setRowsetXML:(NSString*)RowsetXML;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSpreadsheetKey:(NSString*)SpreadsheetKey;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheetId:(NSString*)WorksheetId;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddListRows Choreo.
 */
@interface TMBGoogle_Spreadsheets_AddListRows_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Adds one or more rows to a worksheet in a Google spreadsheet using a simple XML file you provide.
 */
@interface TMBGoogle_Spreadsheets_AddListRows : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_AddListRows_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_AddListRows Choreo */


/*! group TMBGoogle.Spreadsheets.AddWorksheet Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AddWorksheet Choreo.
 */
@interface TMBGoogle_Spreadsheets_AddWorksheet_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setColumnCount:(NSString*)ColumnCount;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setRowCount:(NSString*)RowCount;
	-(void)setSpreadsheetKey:(NSString*)SpreadsheetKey;
	-(void)setTitle:(NSString*)Title;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AddWorksheet Choreo.
 */
@interface TMBGoogle_Spreadsheets_AddWorksheet_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a new worksheet within an existing spreadsheet.
 */
@interface TMBGoogle_Spreadsheets_AddWorksheet : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_AddWorksheet_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_AddWorksheet Choreo */


/*! group TMBGoogle.Spreadsheets.AppendRow Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AppendRow Choreo.
 */
@interface TMBGoogle_Spreadsheets_AppendRow_Inputs : TMBChoreographyInputSet
	-(void)setRowData:(NSString*)RowData;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSheetName:(NSString*)SheetName;
	-(void)setSpreadsheetTitle:(NSString*)SpreadsheetTitle;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AppendRow Choreo.
 */
@interface TMBGoogle_Spreadsheets_AppendRow_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Appends a simple comma-separated row of data to a given Google Spreadsheet.
 */
@interface TMBGoogle_Spreadsheets_AppendRow : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_AppendRow_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_AppendRow Choreo */


/*! group TMBGoogle.Spreadsheets.AppendRow_old Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the AppendRow_old Choreo.
 */
@interface TMBGoogle_Spreadsheets_AppendRow_old_Inputs : TMBChoreographyInputSet
	-(void)setRowData:(NSString*)RowData;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSheetName:(NSString*)SheetName;
	-(void)setSpreadsheetTitle:(NSString*)SpreadsheetTitle;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the AppendRow_old Choreo.
 */
@interface TMBGoogle_Spreadsheets_AppendRow_old_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Appends a simple comma-separated row of data to a given Google Spreadsheet.
 */
@interface TMBGoogle_Spreadsheets_AppendRow_old : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_AppendRow_old_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_AppendRow_old Choreo */


/*! group TMBGoogle.Spreadsheets.DeleteListRow Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteListRow Choreo.
 */
@interface TMBGoogle_Spreadsheets_DeleteListRow_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setEditLink:(NSString*)EditLink;
	-(void)setLink:(NSString*)Link;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setRowId:(NSString*)RowId;
	-(void)setSpreadsheetKey:(NSString*)SpreadsheetKey;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheetId:(NSString*)WorksheetId;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteListRow Choreo.
 */
@interface TMBGoogle_Spreadsheets_DeleteListRow_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes a specified worksheet row from a Google spreadsheet.
 */
@interface TMBGoogle_Spreadsheets_DeleteListRow : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_DeleteListRow_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_DeleteListRow Choreo */


/*! group TMBGoogle.Spreadsheets.DeleteRow Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteRow Choreo.
 */
@interface TMBGoogle_Spreadsheets_DeleteRow_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setDeleteLast:(NSString*)DeleteLast;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setRow:(NSString*)Row;
	-(void)setSpreadsheetKey:(NSString*)SpreadsheetKey;
	-(void)setSpreadsheetName:(NSString*)SpreadsheetName;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheetId:(NSString*)WorksheetId;
	-(void)setWorksheetName:(NSString*)WorksheetName;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteRow Choreo.
 */
@interface TMBGoogle_Spreadsheets_DeleteRow_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Allows you to delete a specifc row by its row number.
 */
@interface TMBGoogle_Spreadsheets_DeleteRow : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_DeleteRow_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_DeleteRow Choreo */


/*! group TMBGoogle.Spreadsheets.DeleteWorksheet Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DeleteWorksheet Choreo.
 */
@interface TMBGoogle_Spreadsheets_DeleteWorksheet_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSpreadsheetKey:(NSString*)SpreadsheetKey;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheetId:(NSString*)WorksheetId;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DeleteWorksheet Choreo.
 */
@interface TMBGoogle_Spreadsheets_DeleteWorksheet_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Deletes a specified worksheet from an existing spreadsheet.
 */
@interface TMBGoogle_Spreadsheets_DeleteWorksheet : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_DeleteWorksheet_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_DeleteWorksheet Choreo */


/*! group TMBGoogle.Spreadsheets.DownloadBase64EncodedSpreadsheet Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the DownloadBase64EncodedSpreadsheet Choreo.
 */
@interface TMBGoogle_Spreadsheets_DownloadBase64EncodedSpreadsheet_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setFormat:(NSString*)Format;
	-(void)setLink:(NSString*)Link;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setTitle:(NSString*)Title;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the DownloadBase64EncodedSpreadsheet Choreo.
 */
@interface TMBGoogle_Spreadsheets_DownloadBase64EncodedSpreadsheet_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getFileContents;
	-(NSString*)getNewAccessToken;	
@end

/*!
 * Downloads a document with the title you specify, and returns the content as Base64 encoded data.
 */
@interface TMBGoogle_Spreadsheets_DownloadBase64EncodedSpreadsheet : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_DownloadBase64EncodedSpreadsheet_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_DownloadBase64EncodedSpreadsheet Choreo */


/*! group TMBGoogle.Spreadsheets.RetrieveCellFeed Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RetrieveCellFeed Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveCellFeed_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSpreadsheetKey:(NSString*)SpreadsheetKey;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheetId:(NSString*)WorksheetId;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RetrieveCellFeed Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveCellFeed_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of cell names and values in a specified Google worksheet.
 */
@interface TMBGoogle_Spreadsheets_RetrieveCellFeed : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_RetrieveCellFeed_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_RetrieveCellFeed Choreo */


/*! group TMBGoogle.Spreadsheets.RetrieveCellList Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RetrieveCellList Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveCellList_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCellLocations:(NSString*)CellLocations;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSpreadsheetKey:(NSString*)SpreadsheetKey;
	-(void)setSpreadsheetName:(NSString*)SpreadsheetName;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheetId:(NSString*)WorksheetId;
	-(void)setWorksheetName:(NSString*)WorksheetName;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RetrieveCellList Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveCellList_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getCellValues;
	-(NSString*)getNewAccessToken;	
@end

/*!
 * Retrieves a list of cell values using the specified cell locations.
 */
@interface TMBGoogle_Spreadsheets_RetrieveCellList : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_RetrieveCellList_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_RetrieveCellList Choreo */


/*! group TMBGoogle.Spreadsheets.RetrieveCellValue Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RetrieveCellValue Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveCellValue_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setCellLocation:(NSString*)CellLocation;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSpreadsheetKey:(NSString*)SpreadsheetKey;
	-(void)setSpreadsheetName:(NSString*)SpreadsheetName;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheetId:(NSString*)WorksheetId;
	-(void)setWorksheetName:(NSString*)WorksheetName;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RetrieveCellValue Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveCellValue_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getCellValue;
	-(NSString*)getNewAccessToken;	
@end

/*!
 * Retrieves the value of given cell.
 */
@interface TMBGoogle_Spreadsheets_RetrieveCellValue : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_RetrieveCellValue_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_RetrieveCellValue Choreo */


/*! group TMBGoogle.Spreadsheets.RetrieveLastColumnValue Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RetrieveLastColumnValue Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveLastColumnValue_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setColumnName:(NSString*)ColumnName;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setSpreadsheetKey:(NSString*)SpreadsheetKey;
	-(void)setSpreadsheetName:(NSString*)SpreadsheetName;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheetId:(NSString*)WorksheetId;
	-(void)setWorksheetName:(NSString*)WorksheetName;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RetrieveLastColumnValue Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveLastColumnValue_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getCellValue;
	-(NSString*)getColumn;
	-(NSString*)getNewAccessToken;
	-(NSString*)getRow;	
@end

/*!
 * Returns the value of the last cell in a specified column.
 */
@interface TMBGoogle_Spreadsheets_RetrieveLastColumnValue : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_RetrieveLastColumnValue_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_RetrieveLastColumnValue Choreo */


/*! group TMBGoogle.Spreadsheets.RetrieveListFeed Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RetrieveListFeed Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveListFeed_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSpreadsheetKey:(NSString*)SpreadsheetKey;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheetId:(NSString*)WorksheetId;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RetrieveListFeed Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveListFeed_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list-based feed containing data in your Google spreadsheet.
 */
@interface TMBGoogle_Spreadsheets_RetrieveListFeed : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_RetrieveListFeed_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_RetrieveListFeed Choreo */


/*! group TMBGoogle.Spreadsheets.RetrieveListRow Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RetrieveListRow Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveListRow_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setLink:(NSString*)Link;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setRowId:(NSString*)RowId;
	-(void)setSpreadsheetKey:(NSString*)SpreadsheetKey;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheetId:(NSString*)WorksheetId;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RetrieveListRow Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveListRow_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a specified worksheet row from a Google spreadsheet.
 */
@interface TMBGoogle_Spreadsheets_RetrieveListRow : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_RetrieveListRow_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_RetrieveListRow Choreo */


/*! group TMBGoogle.Spreadsheets.RetrieveRow Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RetrieveRow Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveRow_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setRow:(NSString*)Row;
	-(void)setSpreadsheetKey:(NSString*)SpreadsheetKey;
	-(void)setSpreadsheetName:(NSString*)SpreadsheetName;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheetId:(NSString*)WorksheetId;
	-(void)setWorksheetName:(NSString*)WorksheetName;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RetrieveRow Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveRow_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getRowData;
	-(NSString*)getNewAccessToken;	
@end

/*!
 * Retrieves a specific row as comma-separated values.
 */
@interface TMBGoogle_Spreadsheets_RetrieveRow : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_RetrieveRow_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_RetrieveRow Choreo */


/*! group TMBGoogle.Spreadsheets.RetrieveSpecificRowsOrColumns Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RetrieveSpecificRowsOrColumns Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveSpecificRowsOrColumns_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setMaxColumn:(NSString*)MaxColumn;
	-(void)setMaxRow:(NSString*)MaxRow;
	-(void)setMinColumn:(NSString*)MinColumn;
	-(void)setMinRow:(NSString*)MinRow;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSpreadsheetKey:(NSString*)SpreadsheetKey;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheetId:(NSString*)WorksheetId;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RetrieveSpecificRowsOrColumns Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveSpecificRowsOrColumns_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves specific rows or columns based on a specified range.
 */
@interface TMBGoogle_Spreadsheets_RetrieveSpecificRowsOrColumns : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_RetrieveSpecificRowsOrColumns_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_RetrieveSpecificRowsOrColumns Choreo */


/*! group TMBGoogle.Spreadsheets.RetrieveSpreadsheetDetailsByName Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RetrieveSpreadsheetDetailsByName Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveSpreadsheetDetailsByName_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSpreadsheetName:(NSString*)SpreadsheetName;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RetrieveSpreadsheetDetailsByName Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveSpreadsheetDetailsByName_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getSpreadsheetDetails;
	-(NSString*)getNewAccessToken;	
@end

/*!
 * Retrieves spreadsheet and worksheet IDs with a given spreadsheet name.
 */
@interface TMBGoogle_Spreadsheets_RetrieveSpreadsheetDetailsByName : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_RetrieveSpreadsheetDetailsByName_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_RetrieveSpreadsheetDetailsByName Choreo */


/*! group TMBGoogle.Spreadsheets.RetrieveSpreadsheets Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RetrieveSpreadsheets Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveSpreadsheets_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RetrieveSpreadsheets Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveSpreadsheets_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of spreadsheets that exist in your Google account.
 */
@interface TMBGoogle_Spreadsheets_RetrieveSpreadsheets : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_RetrieveSpreadsheets_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_RetrieveSpreadsheets Choreo */


/*! group TMBGoogle.Spreadsheets.RetrieveWorksheet Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RetrieveWorksheet Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveWorksheet_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSpreadsheetKey:(NSString*)SpreadsheetKey;
	-(void)setSpreadsheetName:(NSString*)SpreadsheetName;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheetId:(NSString*)WorksheetId;
	-(void)setWorksheetName:(NSString*)WorksheetName;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RetrieveWorksheet Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveWorksheet_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a specified worksheet from a Google spreadsheet in CSV, XML, or JSON format.
 */
@interface TMBGoogle_Spreadsheets_RetrieveWorksheet : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_RetrieveWorksheet_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_RetrieveWorksheet Choreo */


/*! group TMBGoogle.Spreadsheets.RetrieveWorksheets Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the RetrieveWorksheets Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveWorksheets_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSpreadsheetKey:(NSString*)SpreadsheetKey;
	-(void)setUsername:(NSString*)Username;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the RetrieveWorksheets Choreo.
 */
@interface TMBGoogle_Spreadsheets_RetrieveWorksheets_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list of worksheets in a given Google spreadsheet.
 */
@interface TMBGoogle_Spreadsheets_RetrieveWorksheets : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_RetrieveWorksheets_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_RetrieveWorksheets Choreo */


/*! group TMBGoogle.Spreadsheets.SearchColumn Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the SearchColumn Choreo.
 */
@interface TMBGoogle_Spreadsheets_SearchColumn_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setReturnMatches:(NSString*)ReturnMatches;
	-(void)setSearchColumn:(NSString*)SearchColumn;
	-(void)setSearchOperator:(NSString*)SearchOperator;
	-(void)setSearchValue:(NSString*)SearchValue;
	-(void)setSpreadsheetKey:(NSString*)SpreadsheetKey;
	-(void)setSpreadsheetName:(NSString*)SpreadsheetName;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheetId:(NSString*)WorksheetId;
	-(void)setWorksheetName:(NSString*)WorksheetName;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the SearchColumn Choreo.
 */
@interface TMBGoogle_Spreadsheets_SearchColumn_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getMatchFound;
	-(NSString*)getCount;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResults;	
@end

/*!
 * Searches a column for a specified value.
 */
@interface TMBGoogle_Spreadsheets_SearchColumn : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_SearchColumn_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_SearchColumn Choreo */


/*! group TMBGoogle.Spreadsheets.StructuredQuery Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the StructuredQuery Choreo.
 */
@interface TMBGoogle_Spreadsheets_StructuredQuery_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setPassword:(NSString*)Password;
	-(void)setQuery:(NSString*)Query;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setSpreadsheetKey:(NSString*)SpreadsheetKey;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheetId:(NSString*)WorksheetId;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the StructuredQuery Choreo.
 */
@interface TMBGoogle_Spreadsheets_StructuredQuery_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Retrieves a list-based feed containing data in your Google spreadsheet that meets a specified criteria.
 */
@interface TMBGoogle_Spreadsheets_StructuredQuery : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_StructuredQuery_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_StructuredQuery Choreo */


/*! group TMBGoogle.Spreadsheets.UpdateCells Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateCells Choreo.
 */
@interface TMBGoogle_Spreadsheets_UpdateCells_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setColumn:(NSString*)Column;
	-(void)setInputValue:(NSString*)InputValue;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setRow:(NSString*)Row;
	-(void)setSpreadsheetKey:(NSString*)SpreadsheetKey;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheetId:(NSString*)WorksheetId;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateCells Choreo.
 */
@interface TMBGoogle_Spreadsheets_UpdateCells_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Updates a specified cell in a Google worksheet.
 */
@interface TMBGoogle_Spreadsheets_UpdateCells : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_UpdateCells_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_UpdateCells Choreo */


/*! group TMBGoogle.Spreadsheets.UpdateListRows Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateListRows Choreo.
 */
@interface TMBGoogle_Spreadsheets_UpdateListRows_Inputs : TMBChoreographyInputSet
	-(void)setRowsetXML:(NSString*)RowsetXML;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setLink:(NSString*)Link;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setRowId:(NSString*)RowId;
	-(void)setSpreadsheetKey:(NSString*)SpreadsheetKey;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheetId:(NSString*)WorksheetId;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateListRows Choreo.
 */
@interface TMBGoogle_Spreadsheets_UpdateListRows_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Updates a worksheet row in a Google spreadsheet using a simple XML file you provide.
 */
@interface TMBGoogle_Spreadsheets_UpdateListRows : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_UpdateListRows_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_UpdateListRows Choreo */


/*! group TMBGoogle.Spreadsheets.UpdateRow Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateRow Choreo.
 */
@interface TMBGoogle_Spreadsheets_UpdateRow_Inputs : TMBChoreographyInputSet
	-(void)setRowData:(NSString*)RowData;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setRow:(NSString*)Row;
	-(void)setSpreadsheetKey:(NSString*)SpreadsheetKey;
	-(void)setSpreadsheetName:(NSString*)SpreadsheetName;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheetId:(NSString*)WorksheetId;
	-(void)setWorksheetName:(NSString*)WorksheetName;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateRow Choreo.
 */
@interface TMBGoogle_Spreadsheets_UpdateRow_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Allows you to update a row by providing the row number and comma-separated data.
 */
@interface TMBGoogle_Spreadsheets_UpdateRow : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_UpdateRow_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_UpdateRow Choreo */


/*! group TMBGoogle.Spreadsheets.UpdateWorksheet Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UpdateWorksheet Choreo.
 */
@interface TMBGoogle_Spreadsheets_UpdateWorksheet_Inputs : TMBChoreographyInputSet
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setColumnCount:(NSString*)ColumnCount;
	-(void)setPassword:(NSString*)Password;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setRowCount:(NSString*)RowCount;
	-(void)setSpreadsheetKey:(NSString*)SpreadsheetKey;
	-(void)setTitle:(NSString*)Title;
	-(void)setUsername:(NSString*)Username;
	-(void)setWorksheetId:(NSString*)WorksheetId;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UpdateWorksheet Choreo.
 */
@interface TMBGoogle_Spreadsheets_UpdateWorksheet_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Updates existing worksheet metadata such as: Title, Row Count, and Column Count.
 */
@interface TMBGoogle_Spreadsheets_UpdateWorksheet : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_UpdateWorksheet_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_UpdateWorksheet Choreo */


/*! group TMBGoogle.Spreadsheets.UploadSpreadsheet Choreo */

/*!
 * Input object with appropriate setters for specifying arguments to the UploadSpreadsheet Choreo.
 */
@interface TMBGoogle_Spreadsheets_UploadSpreadsheet_Inputs : TMBChoreographyInputSet
	-(void)setRowData:(NSString*)RowData;
	-(void)setAccessToken:(NSString*)AccessToken;
	-(void)setClientID:(NSString*)ClientID;
	-(void)setClientSecret:(NSString*)ClientSecret;
	-(void)setRefreshToken:(NSString*)RefreshToken;
	-(void)setResponseFormat:(NSString*)ResponseFormat;
	-(void)setTitle:(NSString*)Title;
	-(void)setWorksheetName:(NSString*)WorksheetName;
	-(void)setVaultCSVFile:(NSString*)VaultCSVFile;
@end

/*!
 * Results object with appropriate getters for retrieving outputs from the UploadSpreadsheet Choreo.
 */
@interface TMBGoogle_Spreadsheets_UploadSpreadsheet_ResultSet : TMBChoreographyResultSet
	-(id)initWithResponse:(NSDictionary*)document;
	-(NSString*)getNewAccessToken;
	-(NSString*)getResponse;	
@end

/*!
 * Creates a Google spreadsheet from a CSV file.
 */
@interface TMBGoogle_Spreadsheets_UploadSpreadsheet : TMBChoreography <TMBChoreographyDelegate>
	-(id)initWithSession:(TMBTembooSession*)session;
	-(TMBGoogle_Spreadsheets_UploadSpreadsheet_Inputs*)newInputSet;
@end

/*! group TMBGoogle.Spreadsheets_UploadSpreadsheet Choreo */
