using System;
using Temboo.Core;
using System.Web.Script.Serialization;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

namespace Temboo.Library.Dropbox.Files
{
    /// <summary>
    /// UploadSessionStart
    /// Allows you to upload a single file in one or more requests. This call starts a new upload session with the first chunk of data.
    /// </summary>
    public class UploadSessionStart : Temboo.Core.Choreography
    {

        /// <summary>
        /// Create a new instance of the UploadSessionStart Choreo
        /// </summary>
        /// <param name="session">A TembooSession object, containing a valid set of Temboo credentials.</param>
        public UploadSessionStart(TembooSession session) : base(session, "/Library/Dropbox/Files/UploadSessionStart")
        {
        }

         /// <summary>
         /// (required, string) The access token for a specific Dropbox user.
         /// </summary>
         /// <param name="value">Value of the AccessToken input for this Choreo.</param>
         public void setAccessToken(String value) {
             base.addInput ("AccessToken", value);
         }
         /// <summary>
         /// (optional, boolean) If true, the current session will be closed, at which point you won't be able to call UploadSessionAppend anymore with the current session. The default for this field is false.
         /// </summary>
         /// <param name="value">Value of the Close input for this Choreo.</param>
         public void setClose(String value) {
             base.addInput ("Close", value);
         }
         /// <summary>
         /// (optional, string) The content type of the file being uploaded. Defaults to application/octet-stream.
         /// </summary>
         /// <param name="value">Value of the ContentType input for this Choreo.</param>
         public void setContentType(String value) {
             base.addInput ("ContentType", value);
         }
         /// <summary>
         /// (conditional, string) The first file segment to upload. Binary files should be Base64-encoded. Encoding is not required when ContentType is set to "text/plain".
         /// </summary>
         /// <param name="value">Value of the FileContent input for this Choreo.</param>
         public void setFileContent(String value) {
             base.addInput ("FileContent", value);
         }

        /// <summary>
        /// Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete
        /// and return a ResultSet containing the execution results
        /// </summary>
        /// <returns>A UploadSessionStartResultSet containing execution metadata and results.</returns>
        new public UploadSessionStartResultSet execute()
        {
            String json = base.getResponseJSON(false, true);
            UploadSessionStartResultSet results = new JavaScriptSerializer().Deserialize<UploadSessionStartResultSet>(json);

            // Note that we may actually have run into an exception while trying to execute
            // this request; if so, then throw an appropriate exception
            if (results.Execution.LastError != null)
            {
                throw new TembooException(results.Execution.LastError);
            }
            return results;
        }

    }

    /// <summary>
    /// A ResultSet with methods tailored to the values returned by the UploadSessionStart Choreo
    /// The ResultSet object is used to retrieve the results of a Choreo execution
    /// </summary>
    public class UploadSessionStartResultSet : Temboo.Core.ResultSet
    {
        /// <summary> 
        /// Retrieve the value for the "SessionID" output from this Choreo execution
        /// <returns>String - (string) The upload session ID that can be used to append to the upload or finish the upload.</returns>
        /// </summary>
        public String SessionID
        {
            get
            {
                return (String) base.Output["SessionID"];
            }
        }
    }
}
