using System;
using Temboo.Core;
using System.Web.Script.Serialization;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

namespace Temboo.Library.Stripe.Coupons
{
    /// <summary>
    /// CreateCoupon
    /// Creates a coupon that can be redeemed by customers for a discount.
    /// </summary>
    public class CreateCoupon : Temboo.Core.Choreography
    {

        /// <summary>
        /// Create a new instance of the CreateCoupon Choreo
        /// </summary>
        /// <param name="session">A TembooSession object, containing a valid set of Temboo credentials.</param>
        public CreateCoupon(TembooSession session) : base(session, "/Library/Stripe/Coupons/CreateCoupon")
        {
        }

         /// <summary>
         /// (required, string) The API Key provided by Stripe
         /// </summary>
         /// <param name="value">Value of the APIKey input for this Choreo.</param>
         public void setAPIKey(String value) {
             base.addInput ("APIKey", value);
         }
         /// <summary>
         /// (optional, string) The unique identifier of your choice for the coupon. If not specified, a random code will be generated by Stripe.
         /// </summary>
         /// <param name="value">Value of the CouponID input for this Choreo.</param>
         public void setCouponID(String value) {
             base.addInput ("CouponID", value);
         }
         /// <summary>
         /// (required, string) Indicates how long the discount will be in effect. Valid values are: forever, once, repeating.
         /// </summary>
         /// <param name="value">Value of the Duration input for this Choreo.</param>
         public void setDuration(String value) {
             base.addInput ("Duration", value);
         }
         /// <summary>
         /// (optional, integer) If Duration is set to 'repeating', specify the number of months the discount will be valid.
         /// </summary>
         /// <param name="value">Value of the DurationInMonths input for this Choreo.</param>
         public void setDurationInMonths(String value) {
             base.addInput ("DurationInMonths", value);
         }
         /// <summary>
         /// (optional, integer) Specify the number times the coupon can be used.
         /// </summary>
         /// <param name="value">Value of the MaxRedemptions input for this Choreo.</param>
         public void setMaxRedemptions(String value) {
             base.addInput ("MaxRedemptions", value);
         }
         /// <summary>
         /// (required, integer) A integer between 1 and 100 that represents the discount that the coupon will apply when used by a customer
         /// </summary>
         /// <param name="value">Value of the PercentOff input for this Choreo.</param>
         public void setPercentOff(String value) {
             base.addInput ("PercentOff", value);
         }
         /// <summary>
         /// (optional, date) An epoch timestamp in seconds representing the the last time at which the coupon can be used. Specify timestamp in UTC.
         /// </summary>
         /// <param name="value">Value of the RedeemBy input for this Choreo.</param>
         public void setRedeemBy(String value) {
             base.addInput ("RedeemBy", value);
         }

        /// <summary>
        /// Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete
        /// and return a ResultSet containing the execution results
        /// </summary>
        /// <returns>A CreateCouponResultSet containing execution metadata and results.</returns>
        new public CreateCouponResultSet execute()
        {
            String json = base.getResponseJSON(false, true);
            CreateCouponResultSet results = new JavaScriptSerializer().Deserialize<CreateCouponResultSet>(json);

            // Note that we may actually have run into an exception while trying to execute
            // this request; if so, then throw an appropriate exception
            if (results.Execution.LastError != null)
            {
                throw new TembooException(results.Execution.LastError);
            }
            return results;
        }

    }

    /// <summary>
    /// A ResultSet with methods tailored to the values returned by the CreateCoupon Choreo
    /// The ResultSet object is used to retrieve the results of a Choreo execution
    /// </summary>
    public class CreateCouponResultSet : Temboo.Core.ResultSet
    {
        /// <summary> 
        /// Retrieve the value for the "Response" output from this Choreo execution
        /// <returns>String - (json) The response from Stripe</returns>
        /// </summary>
        public String Response
        {
            get
            {
                return (String) base.Output["Response"];
            }
        }
    }
}
