using System;
using Temboo.Core;
using System.Web.Script.Serialization;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

namespace Temboo.Library.Zoho.CRM
{
    /// <summary>
    /// GetSearchRecords
    /// Lets you to search your Zoho CRM account for records based on Zoho's search expressions.
    /// </summary>
    public class GetSearchRecords : Temboo.Core.Choreography
    {

        /// <summary>
        /// Create a new instance of the GetSearchRecords Choreo
        /// </summary>
        /// <param name="session">A TembooSession object, containing a valid set of Temboo credentials.</param>
        public GetSearchRecords(TembooSession session) : base(session, "/Library/Zoho/CRM/GetSearchRecords")
        {
        }

         /// <summary>
         /// (required, string) A valid authentication token. Permanent authentication tokens can be generated by the GenerateAuthToken Choreo.
         /// </summary>
         /// <param name="value">Value of the AuthenticationToken input for this Choreo.</param>
         public void setAuthenticationToken(String value) {
             base.addInput ("AuthenticationToken", value);
         }
         /// <summary>
         /// (optional, integer) The beginning index of the result set to return. Defaults to 1.
         /// </summary>
         /// <param name="value">Value of the FromIndex input for this Choreo.</param>
         public void setFromIndex(String value) {
             base.addInput ("FromIndex", value);
         }
         /// <summary>
         /// (optional, string) The Zoho module you want to access. Defaults to 'Leads'.
         /// </summary>
         /// <param name="value">Value of the Module input for this Choreo.</param>
         public void setModule(String value) {
             base.addInput ("Module", value);
         }
         /// <summary>
         /// (optional, string) The format that the response should be in. Valid formats are: json and xml (the default).
         /// </summary>
         /// <param name="value">Value of the ResponseFormat input for this Choreo.</param>
         public void setResponseFormat(String value) {
             base.addInput ("ResponseFormat", value);
         }
         /// <summary>
         /// (required, string) Specify the name of the column you want to search (i.e. Email)
         /// </summary>
         /// <param name="value">Value of the SearchColumn input for this Choreo.</param>
         public void setSearchColumn(String value) {
             base.addInput ("SearchColumn", value);
         }
         /// <summary>
         /// (required, string) Specify an expression to use in your search (i.e. =, <>, contains, starts with, ends with, doesn't contain, <, >, <=, =>)
         /// </summary>
         /// <param name="value">Value of the SearchExpression input for this Choreo.</param>
         public void setSearchExpression(String value) {
             base.addInput ("SearchExpression", value);
         }
         /// <summary>
         /// (required, string) Specify a search string to use in the search (i.e. *gmail.com*)
         /// </summary>
         /// <param name="value">Value of the SearchString input for this Choreo.</param>
         public void setSearchString(String value) {
             base.addInput ("SearchString", value);
         }
         /// <summary>
         /// (optional, string) The columns to return separated by commas (i.e. First Name,Last Name,Email). When left empty, only IDs are returned.
         /// </summary>
         /// <param name="value">Value of the SelectColumns input for this Choreo.</param>
         public void setSelectColumns(String value) {
             base.addInput ("SelectColumns", value);
         }
         /// <summary>
         /// (optional, integer) The ending index of the result set to return. Defaults to 20. Max is 200.
         /// </summary>
         /// <param name="value">Value of the ToIndex input for this Choreo.</param>
         public void setToIndex(String value) {
             base.addInput ("ToIndex", value);
         }

        /// <summary>
        /// Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete
        /// and return a ResultSet containing the execution results
        /// </summary>
        /// <returns>A GetSearchRecordsResultSet containing execution metadata and results.</returns>
        new public GetSearchRecordsResultSet execute()
        {
            String json = base.getResponseJSON(false, true);
            GetSearchRecordsResultSet results = new JavaScriptSerializer().Deserialize<GetSearchRecordsResultSet>(json);

            // Note that we may actually have run into an exception while trying to execute
            // this request; if so, then throw an appropriate exception
            if (results.Execution.LastError != null)
            {
                throw new TembooException(results.Execution.LastError);
            }
            return results;
        }

    }

    /// <summary>
    /// A ResultSet with methods tailored to the values returned by the GetSearchRecords Choreo
    /// The ResultSet object is used to retrieve the results of a Choreo execution
    /// </summary>
    public class GetSearchRecordsResultSet : Temboo.Core.ResultSet
    {
        /// <summary> 
        /// Retrieve the value for the "Response" output from this Choreo execution
        /// <returns>String - The response from Zoho. Format corresponds to the ResponseFormat input. Defaults to xml.</returns>
        /// </summary>
        public String Response
        {
            get
            {
                return (String) base.Output["Response"];
            }
        }
    }
}
