using System;
using Temboo.Core;
using System.Web.Script.Serialization;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

namespace Temboo.Library.Wikipedia
{
    /// <summary>
    /// GetPageSummary
    /// Retrieves a summary response including a text extract of the first several sentences, as well as information about a thumbnail that represents the page.
    /// </summary>
    public class GetPageSummary : Temboo.Core.Choreography
    {

        /// <summary>
        /// Create a new instance of the GetPageSummary Choreo
        /// </summary>
        /// <param name="session">A TembooSession object, containing a valid set of Temboo credentials.</param>
        public GetPageSummary(TembooSession session) : base(session, "/Library/Wikipedia/GetPageSummary")
        {
        }

         /// <summary>
         /// (required, string) The Wikipedia page title.
         /// </summary>
         /// <param name="value">Value of the Title input for this Choreo.</param>
         public void setTitle(String value) {
             base.addInput ("Title", value);
         }

        /// <summary>
        /// Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete
        /// and return a ResultSet containing the execution results
        /// </summary>
        /// <returns>A GetPageSummaryResultSet containing execution metadata and results.</returns>
        new public GetPageSummaryResultSet execute()
        {
            String json = base.getResponseJSON(false, true);
            GetPageSummaryResultSet results = new JavaScriptSerializer().Deserialize<GetPageSummaryResultSet>(json);

            // Note that we may actually have run into an exception while trying to execute
            // this request; if so, then throw an appropriate exception
            if (results.Execution.LastError != null)
            {
                throw new TembooException(results.Execution.LastError);
            }
            return results;
        }

    }

    /// <summary>
    /// A ResultSet with methods tailored to the values returned by the GetPageSummary Choreo
    /// The ResultSet object is used to retrieve the results of a Choreo execution
    /// </summary>
    public class GetPageSummaryResultSet : Temboo.Core.ResultSet
    {
        /// <summary> 
        /// Retrieve the value for the "Extract" output from this Choreo execution
        /// <returns>String - (string) The page summary.</returns>
        /// </summary>
        public String Extract
        {
            get
            {
                return (String) base.Output["Extract"];
            }
        }
        /// <summary> 
        /// Retrieve the value for the "ResponseCode" output from this Choreo execution
        /// <returns>String - (integer) The response code returned by the API.</returns>
        /// </summary>
        public String ResponseCode
        {
            get
            {
                return (String) base.Output["ResponseCode"];
            }
        }
        /// <summary> 
        /// Retrieve the value for the "Response" output from this Choreo execution
        /// <returns>String - (json) The response from Wikipedia.</returns>
        /// </summary>
        public String Response
        {
            get
            {
                return (String) base.Output["Response"];
            }
        }
    }
}
