using System;
using Temboo.Core;
using System.Web.Script.Serialization;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

namespace Temboo.Library.Plotly
{
    /// <summary>
    /// PlotLineGraph
    /// Plots an array of points on a line graph.
    /// </summary>
    public class PlotLineGraph : Temboo.Core.Choreography
    {

        /// <summary>
        /// Create a new instance of the PlotLineGraph Choreo
        /// </summary>
        /// <param name="session">A TembooSession object, containing a valid set of Temboo credentials.</param>
        public PlotLineGraph(TembooSession session) : base(session, "/Library/Plotly/PlotLineGraph")
        {
        }

         /// <summary>
         /// (required, string) The API Key provided by Plotly.
         /// </summary>
         /// <param name="value">Value of the APIKey input for this Choreo.</param>
         public void setAPIKey(String value) {
             base.addInput ("APIKey", value);
         }
         /// <summary>
         /// (required, string) The file name of your Plotly graph. If the file is nested within a directory, you can specify a path here (e.g., myFolder/myPlot).
         /// </summary>
         /// <param name="value">Value of the FileName input for this Choreo.</param>
         public void setFileName(String value) {
             base.addInput ("FileName", value);
         }
         /// <summary>
         /// (optional, string) The file operation being performed. Valid values are: "new", "overwrite", "append", or "extend". See Choreo description for more details. This defaults to "overwrite".
         /// </summary>
         /// <param name="value">Value of the FileOption input for this Choreo.</param>
         public void setFileOption(String value) {
             base.addInput ("FileOption", value);
         }
         /// <summary>
         /// (optional, string) The title of the graph.
         /// </summary>
         /// <param name="value">Value of the Title input for this Choreo.</param>
         public void setTitle(String value) {
             base.addInput ("Title", value);
         }
         /// <summary>
         /// (required, string) A valid Plotly username.
         /// </summary>
         /// <param name="value">Value of the Username input for this Choreo.</param>
         public void setUsername(String value) {
             base.addInput ("Username", value);
         }
         /// <summary>
         /// (optional, boolean) When set to true, the graph is viewable by anyone who has the link. If false (the default), the graph is only viewable in the owner's Plotly account.
         /// </summary>
         /// <param name="value">Value of the WorldReadable input for this Choreo.</param>
         public void setWorldReadable(String value) {
             base.addInput ("WorldReadable", value);
         }
         /// <summary>
         /// (required, json) A JSON array containing the "x" coordinate values to be plotted on the graph.
         /// </summary>
         /// <param name="value">Value of the XValues input for this Choreo.</param>
         public void setXValues(String value) {
             base.addInput ("XValues", value);
         }
         /// <summary>
         /// (required, json) A JSON array containing the "y" coordinate values to be plotted on the graph.
         /// </summary>
         /// <param name="value">Value of the YValues input for this Choreo.</param>
         public void setYValues(String value) {
             base.addInput ("YValues", value);
         }

        /// <summary>
        /// Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete
        /// and return a ResultSet containing the execution results
        /// </summary>
        /// <returns>A PlotLineGraphResultSet containing execution metadata and results.</returns>
        new public PlotLineGraphResultSet execute()
        {
            String json = base.getResponseJSON(false, true);
            PlotLineGraphResultSet results = new JavaScriptSerializer().Deserialize<PlotLineGraphResultSet>(json);

            // Note that we may actually have run into an exception while trying to execute
            // this request; if so, then throw an appropriate exception
            if (results.Execution.LastError != null)
            {
                throw new TembooException(results.Execution.LastError);
            }
            return results;
        }

    }

    /// <summary>
    /// A ResultSet with methods tailored to the values returned by the PlotLineGraph Choreo
    /// The ResultSet object is used to retrieve the results of a Choreo execution
    /// </summary>
    public class PlotLineGraphResultSet : Temboo.Core.ResultSet
    {
        /// <summary> 
        /// Retrieve the value for the "URL" output from this Choreo execution
        /// <returns>String - (string) The Plotly URL for the graph.</returns>
        /// </summary>
        public String URL
        {
            get
            {
                return (String) base.Output["URL"];
            }
        }
        /// <summary> 
        /// Retrieve the value for the "Response" output from this Choreo execution
        /// <returns>String - (json) The response from Plotly</returns>
        /// </summary>
        public String Response
        {
            get
            {
                return (String) base.Output["Response"];
            }
        }
    }
}
