using System;
using Temboo.Core;
using System.Web.Script.Serialization;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

namespace Temboo.Library._23andMe
{
    /// <summary>
    /// Genotype
    /// For each of the user's profiles, retrieves the base-pairs for given locations.
    /// </summary>
    public class Genotype : Temboo.Core.Choreography
    {

        /// <summary>
        /// Create a new instance of the Genotype Choreo
        /// </summary>
        /// <param name="session">A TembooSession object, containing a valid set of Temboo credentials.</param>
        public Genotype(TembooSession session) : base(session, "/Library/23andMe/Genotype")
        {
        }

         /// <summary>
         /// (required, string) The Access Token retrieved after completing the OAuth2 process.
         /// </summary>
         /// <param name="value">Value of the AccessToken input for this Choreo.</param>
         public void setAccessToken(String value) {
             base.addInput ("AccessToken", value);
         }
         /// <summary>
         /// (required, string) A space delimited list of SNPs (i.e. rs3094315 rs3737728).
         /// </summary>
         /// <param name="value">Value of the Locations input for this Choreo.</param>
         public void setLocations(String value) {
             base.addInput ("Locations", value);
         }
         /// <summary>
         /// (optional, boolean) A boolean flag indicating that the request should be made to the "demo" 23andMe endpoint for testing. Set to 1 for test mode. Defaults to 0.
         /// </summary>
         /// <param name="value">Value of the TestMode input for this Choreo.</param>
         public void setTestMode(String value) {
             base.addInput ("TestMode", value);
         }

        /// <summary>
        /// Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete
        /// and return a ResultSet containing the execution results
        /// </summary>
        /// <returns>A GenotypeResultSet containing execution metadata and results.</returns>
        new public GenotypeResultSet execute()
        {
            String json = base.getResponseJSON(false, true);
            GenotypeResultSet results = new JavaScriptSerializer().Deserialize<GenotypeResultSet>(json);

            // Note that we may actually have run into an exception while trying to execute
            // this request; if so, then throw an appropriate exception
            if (results.Execution.LastError != null)
            {
                throw new TembooException(results.Execution.LastError);
            }
            return results;
        }

    }

    /// <summary>
    /// A ResultSet with methods tailored to the values returned by the Genotype Choreo
    /// The ResultSet object is used to retrieve the results of a Choreo execution
    /// </summary>
    public class GenotypeResultSet : Temboo.Core.ResultSet
    {
        /// <summary> 
        /// Retrieve the value for the "Response" output from this Choreo execution
        /// <returns>String - (json) The response from 23AndMe.</returns>
        /// </summary>
        public String Response
        {
            get
            {
                return (String) base.Output["Response"];
            }
        }
    }
}
