using System;
using Temboo.Core;
using System.Web.Script.Serialization;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

namespace Temboo.Library.Pusher.Events
{
    /// <summary>
    /// PostEvent
    /// Triggers an event on one or more channels.
    /// </summary>
    public class PostEvent : Temboo.Core.Choreography
    {

        /// <summary>
        /// Create a new instance of the PostEvent Choreo
        /// </summary>
        /// <param name="session">A TembooSession object, containing a valid set of Temboo credentials.</param>
        public PostEvent(TembooSession session) : base(session, "/Library/Pusher/Events/PostEvent")
        {
        }

         /// <summary>
         /// (required, string) The application ID provided by Pusher.
         /// </summary>
         /// <param name="value">Value of the AppID input for this Choreo.</param>
         public void setAppID(String value) {
             base.addInput ("AppID", value);
         }
         /// <summary>
         /// (required, string) The authenticaion key provided by Pusher.
         /// </summary>
         /// <param name="value">Value of the AppKey input for this Choreo.</param>
         public void setAppKey(String value) {
             base.addInput ("AppKey", value);
         }
         /// <summary>
         /// (required, string) The authentication secret provided by Pusher.
         /// </summary>
         /// <param name="value">Value of the AppSecret input for this Choreo.</param>
         public void setAppSecret(String value) {
             base.addInput ("AppSecret", value);
         }
         /// <summary>
         /// (required, string) The name of the channel to publish to. This can also be a list of channels formatted as a JSON array.
         /// </summary>
         /// <param name="value">Value of the ChannelName input for this Choreo.</param>
         public void setChannelName(String value) {
             base.addInput ("ChannelName", value);
         }
         /// <summary>
         /// (required, json) A JSON object containing the event data.
         /// </summary>
         /// <param name="value">Value of the EventData input for this Choreo.</param>
         public void setEventData(String value) {
             base.addInput ("EventData", value);
         }
         /// <summary>
         /// (required, string) The name of the event being triggered.
         /// </summary>
         /// <param name="value">Value of the EventName input for this Choreo.</param>
         public void setEventName(String value) {
             base.addInput ("EventName", value);
         }
         /// <summary>
         /// (optional, string) Excludes the event from being sent to a specific connection.
         /// </summary>
         /// <param name="value">Value of the SocketID input for this Choreo.</param>
         public void setSocketID(String value) {
             base.addInput ("SocketID", value);
         }

        /// <summary>
        /// Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete
        /// and return a ResultSet containing the execution results
        /// </summary>
        /// <returns>A PostEventResultSet containing execution metadata and results.</returns>
        new public PostEventResultSet execute()
        {
            String json = base.getResponseJSON(false, true);
            PostEventResultSet results = new JavaScriptSerializer().Deserialize<PostEventResultSet>(json);

            // Note that we may actually have run into an exception while trying to execute
            // this request; if so, then throw an appropriate exception
            if (results.Execution.LastError != null)
            {
                throw new TembooException(results.Execution.LastError);
            }
            return results;
        }

    }

    /// <summary>
    /// A ResultSet with methods tailored to the values returned by the PostEvent Choreo
    /// The ResultSet object is used to retrieve the results of a Choreo execution
    /// </summary>
    public class PostEventResultSet : Temboo.Core.ResultSet
    {
        /// <summary> 
        /// Retrieve the value for the "Response" output from this Choreo execution
        /// <returns>String - (json) The response from Pusher. A successful request returns an empty JSON hash.</returns>
        /// </summary>
        public String Response
        {
            get
            {
                return (String) base.Output["Response"];
            }
        }
    }
}
