using System;
using Temboo.Core;
using System.Web.Script.Serialization;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

namespace Temboo.Library.Pusher.Channels
{
    /// <summary>
    /// ListChannels
    /// Retrieves information for occupied channels.
    /// </summary>
    public class ListChannels : Temboo.Core.Choreography
    {

        /// <summary>
        /// Create a new instance of the ListChannels Choreo
        /// </summary>
        /// <param name="session">A TembooSession object, containing a valid set of Temboo credentials.</param>
        public ListChannels(TembooSession session) : base(session, "/Library/Pusher/Channels/ListChannels")
        {
        }

         /// <summary>
         /// (required, string) The application ID provided by Pusher.
         /// </summary>
         /// <param name="value">Value of the AppID input for this Choreo.</param>
         public void setAppID(String value) {
             base.addInput ("AppID", value);
         }
         /// <summary>
         /// (required, string) The authenticaion key provided by Pusher.
         /// </summary>
         /// <param name="value">Value of the AppKey input for this Choreo.</param>
         public void setAppKey(String value) {
             base.addInput ("AppKey", value);
         }
         /// <summary>
         /// (required, string) The authentication secret provided by Pusher.
         /// </summary>
         /// <param name="value">Value of the AppSecret input for this Choreo.</param>
         public void setAppSecret(String value) {
             base.addInput ("AppSecret", value);
         }
         /// <summary>
         /// (optional, string) Filter the returned channels by a specific prefix (e.g. "presence-").
         /// </summary>
         /// <param name="value">Value of the FilterByPrefix input for this Choreo.</param>
         public void setFilterByPrefix(String value) {
             base.addInput ("FilterByPrefix", value);
         }
         /// <summary>
         /// (optional, string) A comma separated list of attributes which should be returned for each channel (e.g., user_count). Note that the user_count attribute is only applicable for presence channels.
         /// </summary>
         /// <param name="value">Value of the Info input for this Choreo.</param>
         public void setInfo(String value) {
             base.addInput ("Info", value);
         }

        /// <summary>
        /// Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete
        /// and return a ResultSet containing the execution results
        /// </summary>
        /// <returns>A ListChannelsResultSet containing execution metadata and results.</returns>
        new public ListChannelsResultSet execute()
        {
            String json = base.getResponseJSON(false, true);
            ListChannelsResultSet results = new JavaScriptSerializer().Deserialize<ListChannelsResultSet>(json);

            // Note that we may actually have run into an exception while trying to execute
            // this request; if so, then throw an appropriate exception
            if (results.Execution.LastError != null)
            {
                throw new TembooException(results.Execution.LastError);
            }
            return results;
        }

    }

    /// <summary>
    /// A ResultSet with methods tailored to the values returned by the ListChannels Choreo
    /// The ResultSet object is used to retrieve the results of a Choreo execution
    /// </summary>
    public class ListChannelsResultSet : Temboo.Core.ResultSet
    {
        /// <summary> 
        /// Retrieve the value for the "Response" output from this Choreo execution
        /// <returns>String - (json) The response from Pusher.</returns>
        /// </summary>
        public String Response
        {
            get
            {
                return (String) base.Output["Response"];
            }
        }
    }
}
