using System;
using Temboo.Core;
using System.Web.Script.Serialization;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

namespace Temboo.Library.Dropbox.Files
{
    /// <summary>
    /// GetLatestCursor
    /// Gets a cursor for the folder's state.
    /// </summary>
    public class GetLatestCursor : Temboo.Core.Choreography
    {

        /// <summary>
        /// Create a new instance of the GetLatestCursor Choreo
        /// </summary>
        /// <param name="session">A TembooSession object, containing a valid set of Temboo credentials.</param>
        public GetLatestCursor(TembooSession session) : base(session, "/Library/Dropbox/Files/GetLatestCursor")
        {
        }

         /// <summary>
         /// (required, string) The access token for a specific Dropbox user.
         /// </summary>
         /// <param name="value">Value of the AccessToken input for this Choreo.</param>
         public void setAccessToken(String value) {
             base.addInput ("AccessToken", value);
         }
         /// <summary>
         /// (optional, boolean) If true, the results will include entries for files and folders that used to exist but were deleted. The default for this field is false.
         /// </summary>
         /// <param name="value">Value of the IncludeDeleted input for this Choreo.</param>
         public void setIncludeDeleted(String value) {
             base.addInput ("IncludeDeleted", value);
         }
         /// <summary>
         /// (optional, boolean) If true, the results will include a flag for each file indicating whether or not that file has any explicit members. The default for this field is false.
         /// </summary>
         /// <param name="value">Value of the IncludeHasExplicitSharedMembers input for this Choreo.</param>
         public void setIncludeHasExplicitSharedMembers(String value) {
             base.addInput ("IncludeHasExplicitSharedMembers", value);
         }
         /// <summary>
         /// (optional, boolean) If true, FileMetadata.media_info is set for photo and video. The default for this field is false.
         /// </summary>
         /// <param name="value">Value of the IncludeMediaInfo input for this Choreo.</param>
         public void setIncludeMediaInfo(String value) {
             base.addInput ("IncludeMediaInfo", value);
         }
         /// <summary>
         /// (required, string) The path to the folder you want to see the contents of. This should be empty to list contents at the root level.
         /// </summary>
         /// <param name="value">Value of the Path input for this Choreo.</param>
         public void setPath(String value) {
             base.addInput ("Path", value);
         }
         /// <summary>
         /// (optional, boolean) If true, the list folder operation will be applied recursively to all subfolders and the response will contain contents of all subfolders. The default for this field is false.
         /// </summary>
         /// <param name="value">Value of the Recursive input for this Choreo.</param>
         public void setRecursive(String value) {
             base.addInput ("Recursive", value);
         }

        /// <summary>
        /// Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete
        /// and return a ResultSet containing the execution results
        /// </summary>
        /// <returns>A GetLatestCursorResultSet containing execution metadata and results.</returns>
        new public GetLatestCursorResultSet execute()
        {
            String json = base.getResponseJSON(false, true);
            GetLatestCursorResultSet results = new JavaScriptSerializer().Deserialize<GetLatestCursorResultSet>(json);

            // Note that we may actually have run into an exception while trying to execute
            // this request; if so, then throw an appropriate exception
            if (results.Execution.LastError != null)
            {
                throw new TembooException(results.Execution.LastError);
            }
            return results;
        }

    }

    /// <summary>
    /// A ResultSet with methods tailored to the values returned by the GetLatestCursor Choreo
    /// The ResultSet object is used to retrieve the results of a Choreo execution
    /// </summary>
    public class GetLatestCursorResultSet : Temboo.Core.ResultSet
    {
        /// <summary> 
        /// Retrieve the value for the "Cursor" output from this Choreo execution
        /// <returns>String - (string) A cursor used to retrieve the next set of results with ListFolderContinue.</returns>
        /// </summary>
        public String Cursor
        {
            get
            {
                return (String) base.Output["Cursor"];
            }
        }
    }
}
