using System;
using Temboo.Core;
using System.Web.Script.Serialization;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

namespace Temboo.Library.Dropbox.Files
{
    /// <summary>
    /// Copy
    /// Copies a file or folder to a different location in the user's Dropbox.
    /// </summary>
    public class Copy : Temboo.Core.Choreography
    {

        /// <summary>
        /// Create a new instance of the Copy Choreo
        /// </summary>
        /// <param name="session">A TembooSession object, containing a valid set of Temboo credentials.</param>
        public Copy(TembooSession session) : base(session, "/Library/Dropbox/Files/Copy")
        {
        }

         /// <summary>
         /// (required, string) The access token for a specific Dropbox user.
         /// </summary>
         /// <param name="value">Value of the AccessToken input for this Choreo.</param>
         public void setAccessToken(String value) {
             base.addInput ("AccessToken", value);
         }
         /// <summary>
         /// (optional, boolean) If true, contents are copied into a shared folder, otherwise an error will be returned if the FromPath contains a shared folder. The default for this field is false.
         /// </summary>
         /// <param name="value">Value of the AllowSharedFolder input for this Choreo.</param>
         public void setAllowSharedFolder(String value) {
             base.addInput ("AllowSharedFolder", value);
         }
         /// <summary>
         /// (optional, boolean) If there's a conflict, have the Dropbox server try to autorename the file to avoid the conflict. The default for this field is false.
         /// </summary>
         /// <param name="value">Value of the AutoRename input for this Choreo.</param>
         public void setAutoRename(String value) {
             base.addInput ("AutoRename", value);
         }
         /// <summary>
         /// (required, string) Path in the user's Dropbox to be copied or moved.
         /// </summary>
         /// <param name="value">Value of the FromPath input for this Choreo.</param>
         public void setFromPath(String value) {
             base.addInput ("FromPath", value);
         }
         /// <summary>
         /// (required, string) Path in the user's Dropbox that is the destination.
         /// </summary>
         /// <param name="value">Value of the ToPath input for this Choreo.</param>
         public void setToPath(String value) {
             base.addInput ("ToPath", value);
         }

        /// <summary>
        /// Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete
        /// and return a ResultSet containing the execution results
        /// </summary>
        /// <returns>A CopyResultSet containing execution metadata and results.</returns>
        new public CopyResultSet execute()
        {
            String json = base.getResponseJSON(false, true);
            CopyResultSet results = new JavaScriptSerializer().Deserialize<CopyResultSet>(json);

            // Note that we may actually have run into an exception while trying to execute
            // this request; if so, then throw an appropriate exception
            if (results.Execution.LastError != null)
            {
                throw new TembooException(results.Execution.LastError);
            }
            return results;
        }

    }

    /// <summary>
    /// A ResultSet with methods tailored to the values returned by the Copy Choreo
    /// The ResultSet object is used to retrieve the results of a Choreo execution
    /// </summary>
    public class CopyResultSet : Temboo.Core.ResultSet
    {
        /// <summary> 
        /// Retrieve the value for the "Response" output from this Choreo execution
        /// <returns>String - (json) The response from Dropbox.</returns>
        /// </summary>
        public String Response
        {
            get
            {
                return (String) base.Output["Response"];
            }
        }
    }
}
