using System;
using Temboo.Core;
using System.Web.Script.Serialization;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

namespace Temboo.Library.Amazon.MachineLearning
{
    /// <summary>
    /// DescribeMLModels
    /// Returns a list of MLModels that match the search criteria in the request.
    /// </summary>
    public class DescribeMLModels : Temboo.Core.Choreography
    {

        /// <summary>
        /// Create a new instance of the DescribeMLModels Choreo
        /// </summary>
        /// <param name="session">A TembooSession object, containing a valid set of Temboo credentials.</param>
        public DescribeMLModels(TembooSession session) : base(session, "/Library/Amazon/MachineLearning/DescribeMLModels")
        {
        }

         /// <summary>
         /// (required, string) The Access Key ID provided by Amazon Web Services.
         /// </summary>
         /// <param name="value">Value of the AWSAccessKeyId input for this Choreo.</param>
         public void setAWSAccessKeyId(String value) {
             base.addInput ("AWSAccessKeyId", value);
         }
         /// <summary>
         /// (required, string) The Secret Key ID provided by Amazon Web Services.
         /// </summary>
         /// <param name="value">Value of the AWSSecretKeyId input for this Choreo.</param>
         public void setAWSSecretKeyId(String value) {
             base.addInput ("AWSSecretKeyId", value);
         }
         /// <summary>
         /// (optional, string) The equal to operator. The MLModel results will have FilterVariable values that exactly match the value specified with EQ.
         /// </summary>
         /// <param name="value">Value of the EQ input for this Choreo.</param>
         public void setEQ(String value) {
             base.addInput ("EQ", value);
         }
         /// <summary>
         /// (optional, string) Use one of the following variables to filter a list of MLModel: CreatedAt, Status, Name, IAMUser, TrainingDataSourceId, RealtimeEndpointStatus, MLModelType, Algorithm, TrainingDataURI.
         /// </summary>
         /// <param name="value">Value of the FilterVariable input for this Choreo.</param>
         public void setFilterVariable(String value) {
             base.addInput ("FilterVariable", value);
         }
         /// <summary>
         /// (optional, string) The greater than or equal to operator. The MLModel results will have FilterVariable values that are greater than or equal to the value specified with GE.
         /// </summary>
         /// <param name="value">Value of the GE input for this Choreo.</param>
         public void setGE(String value) {
             base.addInput ("GE", value);
         }
         /// <summary>
         /// (optional, string) The greater than operator. The MLModel results will have FilterVariable values that are greater than the value specified with GT.
         /// </summary>
         /// <param name="value">Value of the GT input for this Choreo.</param>
         public void setGT(String value) {
             base.addInput ("GT", value);
         }
         /// <summary>
         /// (optional, string) The less than or equal to operator. The MLModel results will have FilterVariable values that are less than or equal to the value specified with LE.
         /// </summary>
         /// <param name="value">Value of the LE input for this Choreo.</param>
         public void setLE(String value) {
             base.addInput ("LE", value);
         }
         /// <summary>
         /// (optional, string) The less than operator. The MLModel results will have FilterVariable values that are less than the value specified with LT.
         /// </summary>
         /// <param name="value">Value of the LT input for this Choreo.</param>
         public void setLT(String value) {
             base.addInput ("LT", value);
         }
         /// <summary>
         /// (optional, integer) The maximum number of MLModel to include in the result.
         /// </summary>
         /// <param name="value">Value of the Limit input for this Choreo.</param>
         public void setLimit(String value) {
             base.addInput ("Limit", value);
         }
         /// <summary>
         /// (optional, string) The not equal to operator. The MLModel results will have FilterVariable values not equal to the value specified with NE.
         /// </summary>
         /// <param name="value">Value of the NE input for this Choreo.</param>
         public void setNE(String value) {
             base.addInput ("NE", value);
         }
         /// <summary>
         /// (optional, string) The ID of the page in the paginated results.
         /// </summary>
         /// <param name="value">Value of the NextToken input for this Choreo.</param>
         public void setNextToken(String value) {
             base.addInput ("NextToken", value);
         }
         /// <summary>
         /// (optional, string) A string that is found at the beginning of a variable, such as Name or Id.
         /// </summary>
         /// <param name="value">Value of the Prefix input for this Choreo.</param>
         public void setPrefix(String value) {
             base.addInput ("Prefix", value);
         }
         /// <summary>
         /// (optional, string) Determines the sequence of the resulting list of MLModel. Valid values are: asc, dsc.
         /// </summary>
         /// <param name="value">Value of the SortOrder input for this Choreo.</param>
         public void setSortOrder(String value) {
             base.addInput ("SortOrder", value);
         }
         /// <summary>
         /// (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
         /// </summary>
         /// <param name="value">Value of the UserRegion input for this Choreo.</param>
         public void setUserRegion(String value) {
             base.addInput ("UserRegion", value);
         }

        /// <summary>
        /// Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete
        /// and return a ResultSet containing the execution results
        /// </summary>
        /// <returns>A DescribeMLModelsResultSet containing execution metadata and results.</returns>
        new public DescribeMLModelsResultSet execute()
        {
            String json = base.getResponseJSON(false, true);
            DescribeMLModelsResultSet results = new JavaScriptSerializer().Deserialize<DescribeMLModelsResultSet>(json);

            // Note that we may actually have run into an exception while trying to execute
            // this request; if so, then throw an appropriate exception
            if (results.Execution.LastError != null)
            {
                throw new TembooException(results.Execution.LastError);
            }
            return results;
        }

    }

    /// <summary>
    /// A ResultSet with methods tailored to the values returned by the DescribeMLModels Choreo
    /// The ResultSet object is used to retrieve the results of a Choreo execution
    /// </summary>
    public class DescribeMLModelsResultSet : Temboo.Core.ResultSet
    {
        /// <summary> 
        /// Retrieve the value for the "Response" output from this Choreo execution
        /// <returns>String - (json) The response from Amazon.</returns>
        /// </summary>
        public String Response
        {
            get
            {
                return (String) base.Output["Response"];
            }
        }
    }
}
