using System;
using Temboo.Core;
using System.Web.Script.Serialization;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

namespace Temboo.Library.Amazon.MachineLearning
{
    /// <summary>
    /// CreateDataSourceFromS3
    /// Creates a DataSource object.
    /// </summary>
    public class CreateDataSourceFromS3 : Temboo.Core.Choreography
    {

        /// <summary>
        /// Create a new instance of the CreateDataSourceFromS3 Choreo
        /// </summary>
        /// <param name="session">A TembooSession object, containing a valid set of Temboo credentials.</param>
        public CreateDataSourceFromS3(TembooSession session) : base(session, "/Library/Amazon/MachineLearning/CreateDataSourceFromS3")
        {
        }

         /// <summary>
         /// (required, string) The Access Key ID provided by Amazon Web Services.
         /// </summary>
         /// <param name="value">Value of the AWSAccessKeyId input for this Choreo.</param>
         public void setAWSAccessKeyId(String value) {
             base.addInput ("AWSAccessKeyId", value);
         }
         /// <summary>
         /// (required, string) The Secret Key ID provided by Amazon Web Services.
         /// </summary>
         /// <param name="value">Value of the AWSSecretKeyId input for this Choreo.</param>
         public void setAWSSecretKeyId(String value) {
             base.addInput ("AWSSecretKeyId", value);
         }
         /// <summary>
         /// (optional, boolean) The compute statistics for a DataSource. This parameter must be set to true if the DataSource needs to be used for MLModel training. Defaults to false.
         /// </summary>
         /// <param name="value">Value of the ComputeStatistics input for this Choreo.</param>
         public void setComputeStatistics(String value) {
             base.addInput ("ComputeStatistics", value);
         }
         /// <summary>
         /// (required, string) The location of the data file(s) used by a DataSource. The URI specifies a data file or an Amazon Simple Storage Service (Amazon S3) directory or bucket containing data files.
         /// </summary>
         /// <param name="value">Value of the DataLocationS3 input for this Choreo.</param>
         public void setDataLocationS3(String value) {
             base.addInput ("DataLocationS3", value);
         }
         /// <summary>
         /// (optional, json) A JSON string that represents the splitting and rearrangement requirements for the Datasource.
         /// </summary>
         /// <param name="value">Value of the DataRearrangement input for this Choreo.</param>
         public void setDataRearrangement(String value) {
             base.addInput ("DataRearrangement", value);
         }
         /// <summary>
         /// (optional, json) A JSON string representing the schema. This is required unless specifying a valid URI for DataSchemaLocationS3.
         /// </summary>
         /// <param name="value">Value of the DataSchema input for this Choreo.</param>
         public void setDataSchema(String value) {
             base.addInput ("DataSchema", value);
         }
         /// <summary>
         /// (conditional, string) The Amazon S3 location of the DataSchema. This is required unless specifying a valid JSON schema file for DataSchema (see optional inputs).
         /// </summary>
         /// <param name="value">Value of the DataSchemaLocationS3 input for this Choreo.</param>
         public void setDataSchemaLocationS3(String value) {
             base.addInput ("DataSchemaLocationS3", value);
         }
         /// <summary>
         /// (required, string) A user-supplied identifier that uniquely identifies the DataSource.
         /// </summary>
         /// <param name="value">Value of the DataSourceId input for this Choreo.</param>
         public void setDataSourceId(String value) {
             base.addInput ("DataSourceId", value);
         }
         /// <summary>
         /// (optional, string) A user-supplied name or description of the DataSource.
         /// </summary>
         /// <param name="value">Value of the DataSourceName input for this Choreo.</param>
         public void setDataSourceName(String value) {
             base.addInput ("DataSourceName", value);
         }
         /// <summary>
         /// (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
         /// </summary>
         /// <param name="value">Value of the UserRegion input for this Choreo.</param>
         public void setUserRegion(String value) {
             base.addInput ("UserRegion", value);
         }

        /// <summary>
        /// Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete
        /// and return a ResultSet containing the execution results
        /// </summary>
        /// <returns>A CreateDataSourceFromS3ResultSet containing execution metadata and results.</returns>
        new public CreateDataSourceFromS3ResultSet execute()
        {
            String json = base.getResponseJSON(false, true);
            CreateDataSourceFromS3ResultSet results = new JavaScriptSerializer().Deserialize<CreateDataSourceFromS3ResultSet>(json);

            // Note that we may actually have run into an exception while trying to execute
            // this request; if so, then throw an appropriate exception
            if (results.Execution.LastError != null)
            {
                throw new TembooException(results.Execution.LastError);
            }
            return results;
        }

    }

    /// <summary>
    /// A ResultSet with methods tailored to the values returned by the CreateDataSourceFromS3 Choreo
    /// The ResultSet object is used to retrieve the results of a Choreo execution
    /// </summary>
    public class CreateDataSourceFromS3ResultSet : Temboo.Core.ResultSet
    {
        /// <summary> 
        /// Retrieve the value for the "Response" output from this Choreo execution
        /// <returns>String - (json) The response from Amazon.</returns>
        /// </summary>
        public String Response
        {
            get
            {
                return (String) base.Output["Response"];
            }
        }
    }
}
