using System;
using Temboo.Core;
using System.Web.Script.Serialization;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

namespace Temboo.Library.Zoho.CRM
{
    /// <summary>
    /// ConvertLead
    /// Converts a lead to a potential, account, or contact in your Zoho CRM account.
    /// </summary>
    public class ConvertLead : Temboo.Core.Choreography
    {

        /// <summary>
        /// Create a new instance of the ConvertLead Choreo
        /// </summary>
        /// <param name="session">A TembooSession object, containing a valid set of Temboo credentials.</param>
        public ConvertLead(TembooSession session) : base(session, "/Library/Zoho/CRM/ConvertLead")
        {
        }

         /// <summary>
         /// (conditional, decimal) Corresponds to the Amount field in Zoho. Required if CreatePotential is set to 1.
         /// </summary>
         /// <param name="value">Value of the Amount input for this Choreo.</param>
         public void setAmount(String value) {
             base.addInput ("Amount", value);
         }
         /// <summary>
         /// (optional, string) Corresponds to the Assign To field in Zoho
         /// </summary>
         /// <param name="value">Value of the AssignTo input for this Choreo.</param>
         public void setAssignTo(String value) {
             base.addInput ("AssignTo", value);
         }
         /// <summary>
         /// (required, string) A valid authentication token. Permanent authentication tokens can be generated by the GenerateAuthToken Choreo.
         /// </summary>
         /// <param name="value">Value of the AuthenticationToken input for this Choreo.</param>
         public void setAuthenticationToken(String value) {
             base.addInput ("AuthenticationToken", value);
         }
         /// <summary>
         /// (conditional, date) Corresponds to the Closing Date field in Zoho. Formatted like MM/dd/yyyy. Required if CreatePotential is set to 1.
         /// </summary>
         /// <param name="value">Value of the ClosingDate input for this Choreo.</param>
         public void setClosingDate(String value) {
             base.addInput ("ClosingDate", value);
         }
         /// <summary>
         /// (conditional, string) Corresponds to the Contact Role field in Zoho. Required if CreatePotential is set to 1.
         /// </summary>
         /// <param name="value">Value of the ContactRole input for this Choreo.</param>
         public void setContactRole(String value) {
             base.addInput ("ContactRole", value);
         }
         /// <summary>
         /// (optional, boolean) Whether or not to create a potential
         /// </summary>
         /// <param name="value">Value of the CreatePotential input for this Choreo.</param>
         public void setCreatePotential(String value) {
             base.addInput ("CreatePotential", value);
         }
         /// <summary>
         /// (required, integer) The ID for the lead that you wish to convert to a potential
         /// </summary>
         /// <param name="value">Value of the ID input for this Choreo.</param>
         public void setID(String value) {
             base.addInput ("ID", value);
         }
         /// <summary>
         /// (optional, boolean) Whether or not to notifiy the lead owner. Defaults to 0 for false.
         /// </summary>
         /// <param name="value">Value of the NotifyLeadOwner input for this Choreo.</param>
         public void setNotifyLeadOwner(String value) {
             base.addInput ("NotifyLeadOwner", value);
         }
         /// <summary>
         /// (optional, boolean) Whether or not to notify the new entity owner. Defaults to 0 for false.
         /// </summary>
         /// <param name="value">Value of the NotifyNewEntityOwner input for this Choreo.</param>
         public void setNotifyNewEntityOwner(String value) {
             base.addInput ("NotifyNewEntityOwner", value);
         }
         /// <summary>
         /// (conditional, string) Corresponds to the Potential Name field in Zoho. Required if CreatePotential is set to 1.
         /// </summary>
         /// <param name="value">Value of the PotentialName input for this Choreo.</param>
         public void setPotentialName(String value) {
             base.addInput ("PotentialName", value);
         }
         /// <summary>
         /// (conditional, string) Corresponds to the Potential Stage field in Zoho. Required if CreatePotential is set to 1.
         /// </summary>
         /// <param name="value">Value of the PotentialStage input for this Choreo.</param>
         public void setPotentialStage(String value) {
             base.addInput ("PotentialStage", value);
         }
         /// <summary>
         /// (conditional, integer) Corresponds to the Probability field in Zoho. Required if CreatePotential is set to 1.
         /// </summary>
         /// <param name="value">Value of the Probability input for this Choreo.</param>
         public void setProbability(String value) {
             base.addInput ("Probability", value);
         }
         /// <summary>
         /// (optional, string) The format that the response should be in. Valid formats are: json and xml (the default).
         /// </summary>
         /// <param name="value">Value of the ResponseFormat input for this Choreo.</param>
         public void setResponseFormat(String value) {
             base.addInput ("ResponseFormat", value);
         }

        /// <summary>
        /// Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete
        /// and return a ResultSet containing the execution results
        /// </summary>
        /// <returns>A ConvertLeadResultSet containing execution metadata and results.</returns>
        new public ConvertLeadResultSet execute()
        {
            String json = base.getResponseJSON(false, true);
            ConvertLeadResultSet results = new JavaScriptSerializer().Deserialize<ConvertLeadResultSet>(json);

            // Note that we may actually have run into an exception while trying to execute
            // this request; if so, then throw an appropriate exception
            if (results.Execution.LastError != null)
            {
                throw new TembooException(results.Execution.LastError);
            }
            return results;
        }

    }

    /// <summary>
    /// A ResultSet with methods tailored to the values returned by the ConvertLead Choreo
    /// The ResultSet object is used to retrieve the results of a Choreo execution
    /// </summary>
    public class ConvertLeadResultSet : Temboo.Core.ResultSet
    {
        /// <summary> 
        /// Retrieve the value for the "Response" output from this Choreo execution
        /// <returns>String - The response from Zoho. Format corresponds to the ResponseFormat input. Defaults to xml.</returns>
        /// </summary>
        public String Response
        {
            get
            {
                return (String) base.Output["Response"];
            }
        }
    }
}
