using System;
using Temboo.Core;
using System.Web.Script.Serialization;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

namespace Temboo.Library.Twilio.Calls
{
    /// <summary>
    /// CaptureKeyPadEntry
    /// Initiates a call from the specified Twilio account and returns a key pad entry.
    /// </summary>
    public class CaptureKeyPadEntry : Temboo.Core.Choreography
    {

        /// <summary>
        /// Create a new instance of the CaptureKeyPadEntry Choreo
        /// </summary>
        /// <param name="session">A TembooSession object, containing a valid set of Temboo credentials.</param>
        public CaptureKeyPadEntry(TembooSession session) : base(session, "/Library/Twilio/Calls/CaptureKeyPadEntry")
        {
        }

         /// <summary>
         /// (required, string) The AccountSID provided when you signed up for a Twilio account.
         /// </summary>
         /// <param name="value">Value of the AccountSID input for this Choreo.</param>
         public void setAccountSID(String value) {
             base.addInput ("AccountSID", value);
         }
         /// <summary>
         /// (conditional, string) The URL for the Twiml file containing your Temboo Callback URL. See Choreo notes below.
         /// </summary>
         /// <param name="value">Value of the AnswerURL input for this Choreo.</param>
         public void setAnswerURL(String value) {
             base.addInput ("AnswerURL", value);
         }
         /// <summary>
         /// (required, string) The authorization token provided when you signed up for a Twilio account.
         /// </summary>
         /// <param name="value">Value of the AuthToken input for this Choreo.</param>
         public void setAuthToken(String value) {
             base.addInput ("AuthToken", value);
         }
         /// <summary>
         /// (required, string) The Twilio phone number or client identifier to use as the caller id.
         /// </summary>
         /// <param name="value">Value of the From input for this Choreo.</param>
         public void setFrom(String value) {
             base.addInput ("From", value);
         }
         /// <summary>
         /// (required, string) The URL for the Twiml file that contains a "goodbye" message that will be evalated after a Twilio webhook event. This is an optional input that can be used when passing the AnswerURL.
         /// </summary>
         /// <param name="value">Value of the GoodbyeURL input for this Choreo.</param>
         public void setGoodbyeURL(String value) {
             base.addInput ("GoodbyeURL", value);
         }
         /// <summary>
         /// (optional, string) Indicates if Twilio should to try and determine if a machine (like voicemail) or a human has answered the call. Possible values are "Continue" and "Hangup".
         /// </summary>
         /// <param name="value">Value of the IfMachine input for this Choreo.</param>
         public void setIfMachine(String value) {
             base.addInput ("IfMachine", value);
         }
         /// <summary>
         /// (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
         /// </summary>
         /// <param name="value">Value of the ResponseFormat input for this Choreo.</param>
         public void setResponseFormat(String value) {
             base.addInput ("ResponseFormat", value);
         }
         /// <summary>
         /// (optional, string) The SID of the subaccount associated with this call. If not specified, the main AccountSID used to authenticate is used in request.
         /// </summary>
         /// <param name="value">Value of the SubAccountSID input for this Choreo.</param>
         public void setSubAccountSID(String value) {
             base.addInput ("SubAccountSID", value);
         }
         /// <summary>
         /// (optional, integer) The integer number of seconds that Twilio should allow the phone to ring before assuming there is no answer. Default is 60 seconds, the maximum is 999 seconds.
         /// </summary>
         /// <param name="value">Value of the Timeout input for this Choreo.</param>
         public void setTimeout(String value) {
             base.addInput ("Timeout", value);
         }
         /// <summary>
         /// (required, string) The phone number or client identifier to call.
         /// </summary>
         /// <param name="value">Value of the To input for this Choreo.</param>
         public void setTo(String value) {
             base.addInput ("To", value);
         }

        /// <summary>
        /// Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete
        /// and return a ResultSet containing the execution results
        /// </summary>
        /// <returns>A CaptureKeyPadEntryResultSet containing execution metadata and results.</returns>
        new public CaptureKeyPadEntryResultSet execute()
        {
            String json = base.getResponseJSON(false, true);
            CaptureKeyPadEntryResultSet results = new JavaScriptSerializer().Deserialize<CaptureKeyPadEntryResultSet>(json);

            // Note that we may actually have run into an exception while trying to execute
            // this request; if so, then throw an appropriate exception
            if (results.Execution.LastError != null)
            {
                throw new TembooException(results.Execution.LastError);
            }
            return results;
        }

    }

    /// <summary>
    /// A ResultSet with methods tailored to the values returned by the CaptureKeyPadEntry Choreo
    /// The ResultSet object is used to retrieve the results of a Choreo execution
    /// </summary>
    public class CaptureKeyPadEntryResultSet : Temboo.Core.ResultSet
    {
        /// <summary> 
        /// Retrieve the value for the "CallbackData" output from this Choreo execution
        /// <returns>String - (string) The Twilio callback data retrieved after a user has entered a pin code.</returns>
        /// </summary>
        public String CallbackData
        {
            get
            {
                return (String) base.Output["CallbackData"];
            }
        }
        /// <summary> 
        /// Retrieve the value for the "Digits" output from this Choreo execution
        /// <returns>String - (integer) The digits that the call recipient entered into the keypad after receiving the call from Twilio.</returns>
        /// </summary>
        public String Digits
        {
            get
            {
                return (String) base.Output["Digits"];
            }
        }
        /// <summary> 
        /// Retrieve the value for the "Response" output from this Choreo execution
        /// <returns>String - The response from Twilio.</returns>
        /// </summary>
        public String Response
        {
            get
            {
                return (String) base.Output["Response"];
            }
        }
    }
}
