using System;
using Temboo.Core;
using System.Web.Script.Serialization;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

namespace Temboo.Library.Google.NaturalLanguage.Documents
{
    /// <summary>
    /// AnalyzeSyntax
    /// Analyzes the syntax of the text and provides sentence boundaries and tokenization along with part of speech tags, dependency trees, and other properties.
    /// </summary>
    public class AnalyzeSyntax : Temboo.Core.Choreography
    {

        /// <summary>
        /// Create a new instance of the AnalyzeSyntax Choreo
        /// </summary>
        /// <param name="session">A TembooSession object, containing a valid set of Temboo credentials.</param>
        public AnalyzeSyntax(TembooSession session) : base(session, "/Library/Google/NaturalLanguage/Documents/AnalyzeSyntax")
        {
        }

         /// <summary>
         /// (conditional, string) The API Key provided by Google.
         /// </summary>
         /// <param name="value">Value of the APIKey input for this Choreo.</param>
         public void setAPIKey(String value) {
             base.addInput ("APIKey", value);
         }
         /// <summary>
         /// (conditional, string) The content to analyze.
         /// </summary>
         /// <param name="value">Value of the Content input for this Choreo.</param>
         public void setContent(String value) {
             base.addInput ("Content", value);
         }
         /// <summary>
         /// (optional, string) The encoding type used by the API to calculate sentence offsets. Defaults to UTF-8.
         /// </summary>
         /// <param name="value">Value of the EncodingType input for this Choreo.</param>
         public void setEncodingType(String value) {
             base.addInput ("EncodingType", value);
         }
         /// <summary>
         /// (optional, string) Selector specifying which fields to include in a partial response.
         /// </summary>
         /// <param name="value">Value of the Fields input for this Choreo.</param>
         public void setFields(String value) {
             base.addInput ("Fields", value);
         }
         /// <summary>
         /// (optional, string) The Google Cloud Storage URI where the file content is located. This can be used instead of the Content input.
         /// </summary>
         /// <param name="value">Value of the GCSContentUri input for this Choreo.</param>
         public void setGCSContentUri(String value) {
             base.addInput ("GCSContentUri", value);
         }
         /// <summary>
         /// (optional, string) The language of the document. This is specified with the ISO-639-1 Code (e.g. "en"). If not specified, the language is detected if possible.
         /// </summary>
         /// <param name="value">Value of the Language input for this Choreo.</param>
         public void setLanguage(String value) {
             base.addInput ("Language", value);
         }
         /// <summary>
         /// (optional, string) The type of content being sent. Valid values are PLAIN_TEXT (the default) and HTML.
         /// </summary>
         /// <param name="value">Value of the Type input for this Choreo.</param>
         public void setType(String value) {
             base.addInput ("Type", value);
         }

        /// <summary>
        /// Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete
        /// and return a ResultSet containing the execution results
        /// </summary>
        /// <returns>A AnalyzeSyntaxResultSet containing execution metadata and results.</returns>
        new public AnalyzeSyntaxResultSet execute()
        {
            String json = base.getResponseJSON(false, true);
            AnalyzeSyntaxResultSet results = new JavaScriptSerializer().Deserialize<AnalyzeSyntaxResultSet>(json);

            // Note that we may actually have run into an exception while trying to execute
            // this request; if so, then throw an appropriate exception
            if (results.Execution.LastError != null)
            {
                throw new TembooException(results.Execution.LastError);
            }
            return results;
        }

    }

    /// <summary>
    /// A ResultSet with methods tailored to the values returned by the AnalyzeSyntax Choreo
    /// The ResultSet object is used to retrieve the results of a Choreo execution
    /// </summary>
    public class AnalyzeSyntaxResultSet : Temboo.Core.ResultSet
    {
        /// <summary> 
        /// Retrieve the value for the "Response" output from this Choreo execution
        /// <returns>String - (json) The response from Google.</returns>
        /// </summary>
        public String Response
        {
            get
            {
                return (String) base.Output["Response"];
            }
        }
    }
}
