using System;
using Temboo.Core;
using System.Web.Script.Serialization;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

namespace Temboo.Library.Dropbox.OAuth
{
    /// <summary>
    /// FromOAuth1
    /// Creates an OAuth 2.0 access token from the supplied OAuth 1.0 access token.
    /// </summary>
    public class FromOAuth1 : Temboo.Core.Choreography
    {

        /// <summary>
        /// Create a new instance of the FromOAuth1 Choreo
        /// </summary>
        /// <param name="session">A TembooSession object, containing a valid set of Temboo credentials.</param>
        public FromOAuth1(TembooSession session) : base(session, "/Library/Dropbox/OAuth/FromOAuth1")
        {
        }

         /// <summary>
         /// (required, string) An OAuth 1.0 access token for a specific Dropbox user.
         /// </summary>
         /// <param name="value">Value of the AccessToken input for this Choreo.</param>
         public void setAccessToken(String value) {
             base.addInput ("AccessToken", value);
         }
         /// <summary>
         /// (required, string) An OAuth 1.0 access token secret for a specific Dropbox user.
         /// </summary>
         /// <param name="value">Value of the AccessTokenSecret input for this Choreo.</param>
         public void setAccessTokenSecret(String value) {
             base.addInput ("AccessTokenSecret", value);
         }
         /// <summary>
         /// (required, string) The App Key provided by Dropbox after registering your application.
         /// </summary>
         /// <param name="value">Value of the AppKey input for this Choreo.</param>
         public void setAppKey(String value) {
             base.addInput ("AppKey", value);
         }
         /// <summary>
         /// (required, string) The App Secret provided by Dropbox after registering your application.
         /// </summary>
         /// <param name="value">Value of the AppSecret input for this Choreo.</param>
         public void setAppSecret(String value) {
             base.addInput ("AppSecret", value);
         }

        /// <summary>
        /// Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete
        /// and return a ResultSet containing the execution results
        /// </summary>
        /// <returns>A FromOAuth1ResultSet containing execution metadata and results.</returns>
        new public FromOAuth1ResultSet execute()
        {
            String json = base.getResponseJSON(false, true);
            FromOAuth1ResultSet results = new JavaScriptSerializer().Deserialize<FromOAuth1ResultSet>(json);

            // Note that we may actually have run into an exception while trying to execute
            // this request; if so, then throw an appropriate exception
            if (results.Execution.LastError != null)
            {
                throw new TembooException(results.Execution.LastError);
            }
            return results;
        }

    }

    /// <summary>
    /// A ResultSet with methods tailored to the values returned by the FromOAuth1 Choreo
    /// The ResultSet object is used to retrieve the results of a Choreo execution
    /// </summary>
    public class FromOAuth1ResultSet : Temboo.Core.ResultSet
    {
        /// <summary> 
        /// Retrieve the value for the "OAuth2AccessToken" output from this Choreo execution
        /// <returns>String - (string) The OAuth 2.0 access for a specific Dropbox user.</returns>
        /// </summary>
        public String OAuth2AccessToken
        {
            get
            {
                return (String) base.Output["OAuth2AccessToken"];
            }
        }
    }
}
