using System;
using Temboo.Core;
using System.Web.Script.Serialization;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

namespace Temboo.Library.DarkSky
{
    /// <summary>
    /// GetForecastByCoordinates
    /// Returns the current weather conditions for a specified location by geo-coordinates.
    /// </summary>
    public class GetForecastByCoordinates : Temboo.Core.Choreography
    {

        /// <summary>
        /// Create a new instance of the GetForecastByCoordinates Choreo
        /// </summary>
        /// <param name="session">A TembooSession object, containing a valid set of Temboo credentials.</param>
        public GetForecastByCoordinates(TembooSession session) : base(session, "/Library/DarkSky/GetForecastByCoordinates")
        {
        }

         /// <summary>
         /// (required, string) The API Key provided by Dark Sky.
         /// </summary>
         /// <param name="value">Value of the APIKey input for this Choreo.</param>
         public void setAPIKey(String value) {
             base.addInput ("APIKey", value);
         }
         /// <summary>
         /// (optional, string) Exclude some number of data blocks from the API response. Valid values are: currently, minutely, hourly, daily, alerts, and flags.
         /// </summary>
         /// <param name="value">Value of the Exclude input for this Choreo.</param>
         public void setExclude(String value) {
             base.addInput ("Exclude", value);
         }
         /// <summary>
         /// (optional, string) When present, returns hour-by-hour data for the next 168 hours, instead of the next 48. Valid value: hourly.
         /// </summary>
         /// <param name="value">Value of the Extend input for this Choreo.</param>
         public void setExtend(String value) {
             base.addInput ("Extend", value);
         }
         /// <summary>
         /// (optional, string) The language in which to return results e.g., es, fr, it, en (the default). See Choreo notes for a link to a full list of supported languages.
         /// </summary>
         /// <param name="value">Value of the Language input for this Choreo.</param>
         public void setLanguage(String value) {
             base.addInput ("Language", value);
         }
         /// <summary>
         /// (required, decimal) The latitude of the location.
         /// </summary>
         /// <param name="value">Value of the Latitude input for this Choreo.</param>
         public void setLatitude(String value) {
             base.addInput ("Latitude", value);
         }
         /// <summary>
         /// (required, decimal) The longitude of the location.
         /// </summary>
         /// <param name="value">Value of the Longitude input for this Choreo.</param>
         public void setLongitude(String value) {
             base.addInput ("Longitude", value);
         }
         /// <summary>
         /// (optional, string) Return weather conditions in the requested units. Valid values are: auto, ca, uk2, us (use for Farenheit), and si (use for Celsius).
         /// </summary>
         /// <param name="value">Value of the Units input for this Choreo.</param>
         public void setUnits(String value) {
             base.addInput ("Units", value);
         }

        /// <summary>
        /// Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete
        /// and return a ResultSet containing the execution results
        /// </summary>
        /// <returns>A GetForecastByCoordinatesResultSet containing execution metadata and results.</returns>
        new public GetForecastByCoordinatesResultSet execute()
        {
            String json = base.getResponseJSON(false, true);
            GetForecastByCoordinatesResultSet results = new JavaScriptSerializer().Deserialize<GetForecastByCoordinatesResultSet>(json);

            // Note that we may actually have run into an exception while trying to execute
            // this request; if so, then throw an appropriate exception
            if (results.Execution.LastError != null)
            {
                throw new TembooException(results.Execution.LastError);
            }
            return results;
        }

    }

    /// <summary>
    /// A ResultSet with methods tailored to the values returned by the GetForecastByCoordinates Choreo
    /// The ResultSet object is used to retrieve the results of a Choreo execution
    /// </summary>
    public class GetForecastByCoordinatesResultSet : Temboo.Core.ResultSet
    {
        /// <summary> 
        /// Retrieve the value for the "HourlySummary" output from this Choreo execution
        /// <returns>String - (string) The hourly summary.</returns>
        /// </summary>
        public String HourlySummary
        {
            get
            {
                return (String) base.Output["HourlySummary"];
            }
        }
        /// <summary> 
        /// Retrieve the value for the "Humidity" output from this Choreo execution
        /// <returns>String - (decimal) The current humidity.</returns>
        /// </summary>
        public String Humidity
        {
            get
            {
                return (String) base.Output["Humidity"];
            }
        }
        /// <summary> 
        /// Retrieve the value for the "Pressure" output from this Choreo execution
        /// <returns>String - (decimal) The current pressure.</returns>
        /// </summary>
        public String Pressure
        {
            get
            {
                return (String) base.Output["Pressure"];
            }
        }
        /// <summary> 
        /// Retrieve the value for the "Summary" output from this Choreo execution
        /// <returns>String - (string) The current weather summary.</returns>
        /// </summary>
        public String Summary
        {
            get
            {
                return (String) base.Output["Summary"];
            }
        }
        /// <summary> 
        /// Retrieve the value for the "Temperature" output from this Choreo execution
        /// <returns>String - (decimal) The current temperature.</returns>
        /// </summary>
        public String Temperature
        {
            get
            {
                return (String) base.Output["Temperature"];
            }
        }
        /// <summary> 
        /// Retrieve the value for the "UVIndex" output from this Choreo execution
        /// <returns>String - (integer) The current uv index.</returns>
        /// </summary>
        public String UVIndex
        {
            get
            {
                return (String) base.Output["UVIndex"];
            }
        }
        /// <summary> 
        /// Retrieve the value for the "Visibility" output from this Choreo execution
        /// <returns>String - (decimal) The current visibility.</returns>
        /// </summary>
        public String Visibility
        {
            get
            {
                return (String) base.Output["Visibility"];
            }
        }
        /// <summary> 
        /// Retrieve the value for the "Response" output from this Choreo execution
        /// <returns>String - (json) The response from Dark Sky.</returns>
        /// </summary>
        public String Response
        {
            get
            {
                return (String) base.Output["Response"];
            }
        }
    }
}
