using System;
using Temboo.Core;
using System.Web.Script.Serialization;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

namespace Temboo.Library.Amazon.MachineLearning
{
    /// <summary>
    /// CreateMLModel
    /// Creates a new MLModel using the DataSource and the recipe as information sources.
    /// </summary>
    public class CreateMLModel : Temboo.Core.Choreography
    {

        /// <summary>
        /// Create a new instance of the CreateMLModel Choreo
        /// </summary>
        /// <param name="session">A TembooSession object, containing a valid set of Temboo credentials.</param>
        public CreateMLModel(TembooSession session) : base(session, "/Library/Amazon/MachineLearning/CreateMLModel")
        {
        }

         /// <summary>
         /// (required, string) The Access Key ID provided by Amazon Web Services.
         /// </summary>
         /// <param name="value">Value of the AWSAccessKeyId input for this Choreo.</param>
         public void setAWSAccessKeyId(String value) {
             base.addInput ("AWSAccessKeyId", value);
         }
         /// <summary>
         /// (required, string) The Secret Key ID provided by Amazon Web Services.
         /// </summary>
         /// <param name="value">Value of the AWSSecretKeyId input for this Choreo.</param>
         public void setAWSSecretKeyId(String value) {
             base.addInput ("AWSSecretKeyId", value);
         }
         /// <summary>
         /// (required, string) A user-supplied identifier that uniquely identifies the MLModel.
         /// </summary>
         /// <param name="value">Value of the MLModelId input for this Choreo.</param>
         public void setMLModelId(String value) {
             base.addInput ("MLModelId", value);
         }
         /// <summary>
         /// (optional, string) A user-supplied name or description of the MLModel.
         /// </summary>
         /// <param name="value">Value of the MLModelName input for this Choreo.</param>
         public void setMLModelName(String value) {
             base.addInput ("MLModelName", value);
         }
         /// <summary>
         /// (required, string) The category of supervised learning that this MLModel will address. Choose from the following types: REGRESSION, BINARY, MULTICLASS.
         /// </summary>
         /// <param name="value">Value of the MLModelType input for this Choreo.</param>
         public void setMLModelType(String value) {
             base.addInput ("MLModelType", value);
         }
         /// <summary>
         /// (optional, json) A list of the training parameters in the MLModel. The list is implemented as a map of key-value pairs.
         /// </summary>
         /// <param name="value">Value of the Parameters input for this Choreo.</param>
         public void setParameters(String value) {
             base.addInput ("Parameters", value);
         }
         /// <summary>
         /// (optional, string) The data recipe for creating the MLModel. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.
         /// </summary>
         /// <param name="value">Value of the Recipe input for this Choreo.</param>
         public void setRecipe(String value) {
             base.addInput ("Recipe", value);
         }
         /// <summary>
         /// (optional, string) The Amazon S3 location and file name that contains the MLModel recipe. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.
         /// </summary>
         /// <param name="value">Value of the RecipeUri input for this Choreo.</param>
         public void setRecipeUri(String value) {
             base.addInput ("RecipeUri", value);
         }
         /// <summary>
         /// (required, string) The DataSource that points to the training data.
         /// </summary>
         /// <param name="value">Value of the TrainingDataSourceId input for this Choreo.</param>
         public void setTrainingDataSourceId(String value) {
             base.addInput ("TrainingDataSourceId", value);
         }
         /// <summary>
         /// (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
         /// </summary>
         /// <param name="value">Value of the UserRegion input for this Choreo.</param>
         public void setUserRegion(String value) {
             base.addInput ("UserRegion", value);
         }

        /// <summary>
        /// Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete
        /// and return a ResultSet containing the execution results
        /// </summary>
        /// <returns>A CreateMLModelResultSet containing execution metadata and results.</returns>
        new public CreateMLModelResultSet execute()
        {
            String json = base.getResponseJSON(false, true);
            CreateMLModelResultSet results = new JavaScriptSerializer().Deserialize<CreateMLModelResultSet>(json);

            // Note that we may actually have run into an exception while trying to execute
            // this request; if so, then throw an appropriate exception
            if (results.Execution.LastError != null)
            {
                throw new TembooException(results.Execution.LastError);
            }
            return results;
        }

    }

    /// <summary>
    /// A ResultSet with methods tailored to the values returned by the CreateMLModel Choreo
    /// The ResultSet object is used to retrieve the results of a Choreo execution
    /// </summary>
    public class CreateMLModelResultSet : Temboo.Core.ResultSet
    {
        /// <summary> 
        /// Retrieve the value for the "Response" output from this Choreo execution
        /// <returns>String - (json) The response from Amazon.</returns>
        /// </summary>
        public String Response
        {
            get
            {
                return (String) base.Output["Response"];
            }
        }
    }
}
