package com.temboo.Library.GitHub.ReposAPI.Commits;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListCommits

Lists commits for a specified repository.
*/
public class ListCommits extends Choreography {

	/**
	Create a new instance of the ListCommits Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListCommits(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/GitHub/ReposAPI/Commits/ListCommits"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListCommitsInputSet
	*/
	public ListCommitsInputSet newInputSet() {
		return new ListCommitsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListCommitsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListCommitsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListCommits
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListCommitsInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (conditional, string) The Access Token retrieved during the OAuth process. Required when accessing a protected resource.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Author input for this Choreo. 

		@param String - (optional, string) GitHub login or email address by which to filter by commit author.
		*/
		public void set_Author(String value) {
			this.setInput("Author", value);
		}


		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) Indicates the page index that you want to retrieve. Defaults to 1.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) Indicates the page index that you want to retrieve. Defaults to 1.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the Path input for this Choreo. 

		@param String - (optional, string) Returns only commits containing this file path.
		*/
		public void set_Path(String value) {
			this.setInput("Path", value);
		}


		/** 
		Set the value of the PerPage input for this Choreo. 

		@param Integer - (optional, integer) The number of results to return per page.
		*/
		public void set_PerPage(Integer value) {
			this.setInput("PerPage", value);
		}

		/** 
		Set the value of the PerPage input for this Choreo as a String. 

		@param String - (optional, integer) The number of results to return per page.
		*/
		public void set_PerPage(String value) {
			this.setInput("PerPage", value);	
		}
		/** 
		Set the value of the Repo input for this Choreo. 

		@param String - (required, string) The name of the repository.
		*/
		public void set_Repo(String value) {
			this.setInput("Repo", value);
		}


		/** 
		Set the value of the SHA input for this Choreo. 

		@param String - (optional, string) The SHA or branch to start listing commits from.
		*/
		public void set_SHA(String value) {
			this.setInput("SHA", value);
		}


		/** 
		Set the value of the Since input for this Choreo. 

		@param String - (optional, date) Only commits after this date will be returned. This is a timestamp in ISO 8601 format: YYYY-MM-DDTHH:MM:SSZ.
		*/
		public void set_Since(String value) {
			this.setInput("Since", value);
		}


		/** 
		Set the value of the Until input for this Choreo. 

		@param String - (optional, date) Only commits before this date will be returned. This is a timestamp in ISO 8601 format: YYYY-MM-DDTHH:MM:SSZ.
		*/
		public void set_Until(String value) {
			this.setInput("Until", value);
		}


		/** 
		Set the value of the User input for this Choreo. 

		@param String - (required, string) The GitHub username.
		*/
		public void set_User(String value) {
			this.setInput("User", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListCommits Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListCommitsResultSet extends ResultSet {
		public ListCommitsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "FirstPage" output from this Choreo execution

		@return String - (integer) The index for the first page of results.
		*/
		public String get_FirstPage() {
			return this.getResultString("FirstPage");
		}
		/** 
		Retrieve the value for the "LastPage" output from this Choreo execution

		@return String - (integer) The index for the last page of results.
		*/
		public String get_LastPage() {
			return this.getResultString("LastPage");
		}
		/** 
		Retrieve the value for the "Limit" output from this Choreo execution

		@return String - (integer) The available rate limit for your account. This is returned in the GitHub response header.
		*/
		public String get_Limit() {
			return this.getResultString("Limit");
		}
		/** 
		Retrieve the value for the "NextPage" output from this Choreo execution

		@return String - (integer) The index for the next page of results.
		*/
		public String get_NextPage() {
			return this.getResultString("NextPage");
		}
		/** 
		Retrieve the value for the "PreviousPage" output from this Choreo execution

		@return String - (integer) The index for the previous page of results.
		*/
		public String get_PreviousPage() {
			return this.getResultString("PreviousPage");
		}
		/** 
		Retrieve the value for the "Remaining" output from this Choreo execution

		@return String - (integer) The remaining number of API requests available to you. This is returned in the GitHub response header.
		*/
		public String get_Remaining() {
			return this.getResultString("Remaining");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from GitHub.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
