package com.temboo.Library.GitHub.GistsAPI.Gists;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateGist

Creates a gist.
*/
public class CreateGist extends Choreography {

	/**
	Create a new instance of the CreateGist Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateGist(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/GitHub/GistsAPI/Gists/CreateGist"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateGistInputSet
	*/
	public CreateGistInputSet newInputSet() {
		return new CreateGistInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateGistResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateGistResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateGist
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateGistInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Description input for this Choreo. 

		@param String - (optional, string) The description for this gist.
		*/
		public void set_Description(String value) {
			this.setInput("Description", value);
		}


		/** 
		Set the value of the FileContents input for this Choreo. 

		@param String - (required, string) The file contents of the gist.
		*/
		public void set_FileContents(String value) {
			this.setInput("FileContents", value);
		}


		/** 
		Set the value of the FileName input for this Choreo. 

		@param String - (required, string) The file name of the gist (i.e. myProject.py).
		*/
		public void set_FileName(String value) {
			this.setInput("FileName", value);
		}


		/** 
		Set the value of the Public input for this Choreo. 

		@param Boolean - (required, boolean) Indicates whether or not the gist is public or private.
		*/
		public void set_Public(Boolean value) {
			this.setInput("Public", value);
		}

		/** 
		Set the value of the Public input for this Choreo as a String. 

		@param String - (required, boolean) Indicates whether or not the gist is public or private.
		*/
		public void set_Public(String value) {
			this.setInput("Public", value);	
		}
		/** 
		Set the value of the User input for this Choreo. 

		@param String - (required, string) Deprecated (retained for backward compatibility only).
		*/
		public void set_User(String value) {
			this.setInput("User", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateGist Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateGistResultSet extends ResultSet {
		public CreateGistResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Limit" output from this Choreo execution

		@return String - (integer) The available rate limit for your account. This is returned in the GitHub response header.
		*/
		public String get_Limit() {
			return this.getResultString("Limit");
		}
		/** 
		Retrieve the value for the "Remaining" output from this Choreo execution

		@return String - (integer) The remaining number of API requests available to you. This is returned in the GitHub response header.
		*/
		public String get_Remaining() {
			return this.getResultString("Remaining");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from GitHub.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
