package com.temboo.Library.ConstantContact;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SearchContactsByUpdatedSince

Searches your Constant Contact list by last updated date.  Use this Choreo for synchronizing your lists with other systems. 
*/
public class SearchContactsByUpdatedSince extends Choreography {

	/**
	Create a new instance of the SearchContactsByUpdatedSince Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SearchContactsByUpdatedSince(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/ConstantContact/SearchContactsByUpdatedSince"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SearchContactsByUpdatedSinceInputSet
	*/
	public SearchContactsByUpdatedSinceInputSet newInputSet() {
		return new SearchContactsByUpdatedSinceInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SearchContactsByUpdatedSinceResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SearchContactsByUpdatedSinceResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SearchContactsByUpdatedSince
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SearchContactsByUpdatedSinceInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Constant Contact.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the ListType input for this Choreo. 

		@param String - (optional, string) The list type to query. Supported values for this parameter are: active, removed and do-not-mail. Defaults to 'active'.
		*/
		public void set_ListType(String value) {
			this.setInput("ListType", value);
		}


		/** 
		Set the value of the NextResults input for this Choreo. 

		@param String - (optional, string) The URI returned in the "NextPage" output of this Choreo. This value is used to retrieve the next 50 results.
		*/
		public void set_NextResults(String value) {
			this.setInput("NextResults", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) Your Constant Contact password.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the UpdatedSince input for this Choreo. 

		@param String - (required, date) Epoch timestamp in milliseconds or formatted like 2009-12-01T01:00:00.000Z. Used to query for modified records.
		*/
		public void set_UpdatedSince(String value) {
			this.setInput("UpdatedSince", value);
		}


		/** 
		Set the value of the UserName input for this Choreo. 

		@param String - (required, string) Your Constant Contact username.
		*/
		public void set_UserName(String value) {
			this.setInput("UserName", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SearchContactsByUpdatedSince Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SearchContactsByUpdatedSinceResultSet extends ResultSet {
		public SearchContactsByUpdatedSinceResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "NextPage" output from this Choreo execution

		@return String - (string) A URI used to retrieve the next page of results. If this value is not returned, there are no more results to retrieve. This value can be passed to the "NextResults" input of this Choreo.
		*/
		public String get_NextPage() {
			return this.getResultString("NextPage");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from Constant Contact.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
