package com.temboo.Library.ConstantContact;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SearchContactsByEmail

Allows you to search Constant Contact by email to retrieve a contact's information.
*/
public class SearchContactsByEmail extends Choreography {

	/**
	Create a new instance of the SearchContactsByEmail Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SearchContactsByEmail(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/ConstantContact/SearchContactsByEmail"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SearchContactsByEmailInputSet
	*/
	public SearchContactsByEmailInputSet newInputSet() {
		return new SearchContactsByEmailInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SearchContactsByEmailResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SearchContactsByEmailResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SearchContactsByEmail
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SearchContactsByEmailInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Constant Contact.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the EmailAddress input for this Choreo. 

		@param String - (required, string) The email address to use in your search.
		*/
		public void set_EmailAddress(String value) {
			this.setInput("EmailAddress", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) Your Constant Contact password.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the UserName input for this Choreo. 

		@param String - (required, string) Your Constant Contact username.
		*/
		public void set_UserName(String value) {
			this.setInput("UserName", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SearchContactsByEmail Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SearchContactsByEmailResultSet extends ResultSet {
		public SearchContactsByEmailResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from Constant Contact.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
