package com.temboo.Library.ConstantContact;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateContact

Creates a contact in your Constant Contact account.
*/
public class CreateContact extends Choreography {

	/**
	Create a new instance of the CreateContact Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateContact(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/ConstantContact/CreateContact"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateContactInputSet
	*/
	public CreateContactInputSet newInputSet() {
		return new CreateContactInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateContactResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateContactResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateContact
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateContactInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Constant Contact.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Addr1 input for this Choreo. 

		@param String - (optional, string) The first line of the contact's address.
		*/
		public void set_Addr1(String value) {
			this.setInput("Addr1", value);
		}


		/** 
		Set the value of the Addr2 input for this Choreo. 

		@param String - (optional, string) The second line of the contact's address.
		*/
		public void set_Addr2(String value) {
			this.setInput("Addr2", value);
		}


		/** 
		Set the value of the Addr3 input for this Choreo. 

		@param String - (optional, string) The third line of the contact's address.
		*/
		public void set_Addr3(String value) {
			this.setInput("Addr3", value);
		}


		/** 
		Set the value of the City input for this Choreo. 

		@param String - (optional, string) The city portion of the contact's address.
		*/
		public void set_City(String value) {
			this.setInput("City", value);
		}


		/** 
		Set the value of the CompanyName input for this Choreo. 

		@param String - (optional, string) The company name for the contact.
		*/
		public void set_CompanyName(String value) {
			this.setInput("CompanyName", value);
		}


		/** 
		Set the value of the CountryCode input for this Choreo. 

		@param String - (optional, string) The country code associated with the contact's address.
		*/
		public void set_CountryCode(String value) {
			this.setInput("CountryCode", value);
		}


		/** 
		Set the value of the CountryName input for this Choreo. 

		@param String - (optional, string) Corresponds to the Country Name field in Constant Contact
		*/
		public void set_CountryName(String value) {
			this.setInput("CountryName", value);
		}


		/** 
		Set the value of the EmailAddress input for this Choreo. 

		@param String - (required, string) The email address for the contact.
		*/
		public void set_EmailAddress(String value) {
			this.setInput("EmailAddress", value);
		}


		/** 
		Set the value of the EmailType input for this Choreo. 

		@param String - (optional, string) The email type that the contact should receive.
		*/
		public void set_EmailType(String value) {
			this.setInput("EmailType", value);
		}


		/** 
		Set the value of the FirstName input for this Choreo. 

		@param String - (optional, string) The first name of the contact.
		*/
		public void set_FirstName(String value) {
			this.setInput("FirstName", value);
		}


		/** 
		Set the value of the HomePhone input for this Choreo. 

		@param String - (optional, string) The contact's home phone.
		*/
		public void set_HomePhone(String value) {
			this.setInput("HomePhone", value);
		}


		/** 
		Set the value of the JobTitle input for this Choreo. 

		@param String - (optional, string) The contact's job title.
		*/
		public void set_JobTitle(String value) {
			this.setInput("JobTitle", value);
		}


		/** 
		Set the value of the LastName input for this Choreo. 

		@param String - (optional, string) The last name of the contact.
		*/
		public void set_LastName(String value) {
			this.setInput("LastName", value);
		}


		/** 
		Set the value of the ListId input for this Choreo. 

		@param Integer - (required, integer) The ID for the list that you want to add the contact to.
		*/
		public void set_ListId(Integer value) {
			this.setInput("ListId", value);
		}

		/** 
		Set the value of the ListId input for this Choreo as a String. 

		@param String - (required, integer) The ID for the list that you want to add the contact to.
		*/
		public void set_ListId(String value) {
			this.setInput("ListId", value);	
		}
		/** 
		Set the value of the MiddleName input for this Choreo. 

		@param String - (optional, string) The middle name of the contact.
		*/
		public void set_MiddleName(String value) {
			this.setInput("MiddleName", value);
		}


		/** 
		Set the value of the Name input for this Choreo. 

		@param String - (optional, string) The full name of the contact.
		*/
		public void set_Name(String value) {
			this.setInput("Name", value);
		}


		/** 
		Set the value of the Note input for this Choreo. 

		@param String - (optional, string) A note associated with the contact.
		*/
		public void set_Note(String value) {
			this.setInput("Note", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) Your Constant Contact password.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the PostalCode input for this Choreo. 

		@param String - (optional, string) The postal code for the contact's address.
		*/
		public void set_PostalCode(String value) {
			this.setInput("PostalCode", value);
		}


		/** 
		Set the value of the StateCode input for this Choreo. 

		@param String - (optional, string) The state code for the contact's address.
		*/
		public void set_StateCode(String value) {
			this.setInput("StateCode", value);
		}


		/** 
		Set the value of the StateName input for this Choreo. 

		@param String - (optional, string) Corresponds to the State Name field in Constant Contact
		*/
		public void set_StateName(String value) {
			this.setInput("StateName", value);
		}


		/** 
		Set the value of the Status input for this Choreo. 

		@param String - (optional, string) The status of the contact (i.e. Active).
		*/
		public void set_Status(String value) {
			this.setInput("Status", value);
		}


		/** 
		Set the value of the SubPostalCode input for this Choreo. 

		@param String - (optional, string) The sub postal code for the contact.
		*/
		public void set_SubPostalCode(String value) {
			this.setInput("SubPostalCode", value);
		}


		/** 
		Set the value of the UserName input for this Choreo. 

		@param String - (required, string) Your Constant Contact username.
		*/
		public void set_UserName(String value) {
			this.setInput("UserName", value);
		}


		/** 
		Set the value of the WorkPhone input for this Choreo. 

		@param String - (optional, string) The contact's work phone.
		*/
		public void set_WorkPhone(String value) {
			this.setInput("WorkPhone", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateContact Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateContactResultSet extends ResultSet {
		public CreateContactResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from Constant Contact.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
