package com.temboo.Library.LittleSis.List;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListSearchByKeyword

Retrieves the name and description fields of Lists available in LittleSis that match a keyword search.
*/
public class ListSearchByKeyword extends Choreography {

	/**
	Create a new instance of the ListSearchByKeyword Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListSearchByKeyword(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/LittleSis/List/ListSearchByKeyword"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListSearchByKeywordInputSet
	*/
	public ListSearchByKeywordInputSet newInputSet() {
		return new ListSearchByKeywordInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListSearchByKeywordResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListSearchByKeywordResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListSearchByKeyword
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListSearchByKeywordInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key obtained from LittleSis.org.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Keywords input for this Choreo. 

		@param String - (required, string) Enter search text.
		*/
		public void set_Keywords(String value) {
			this.setInput("Keywords", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) Format of the response returned by LittleSis.org. Acceptable inputs: xml or json. Defaults to xml
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListSearchByKeyword Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListSearchByKeywordResultSet extends ResultSet {
		public ListSearchByKeywordResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from LittleSis.org.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
