package com.temboo.Library.Microsoft.Translator;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
TranslateArray

Translates multiple source texts.
*/
public class TranslateArray extends Choreography {

	/**
	Create a new instance of the TranslateArray Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public TranslateArray(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Microsoft/Translator/TranslateArray"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return TranslateArrayInputSet
	*/
	public TranslateArrayInputSet newInputSet() {
		return new TranslateArrayInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public TranslateArrayResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new TranslateArrayResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the TranslateArray
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class TranslateArrayInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Category input for this Choreo. 

		@param String - (optional, string) A string containing the category (domain) of the translation. Defaults to "general".
		*/
		public void set_Category(String value) {
			this.setInput("Category", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the ContentType input for this Choreo. 

		@param String - (optional, string) The format of the text being translated. The supported formats are "text/plain" (the default) and "text/html".
		*/
		public void set_ContentType(String value) {
			this.setInput("ContentType", value);
		}


		/** 
		Set the value of the From input for this Choreo. 

		@param String - (optional, string) A string representing the language code of the translation text (e.g., en). If not provided auto-detection is used.
		*/
		public void set_From(String value) {
			this.setInput("From", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Texts input for this Choreo. 

		@param String - (required, json) An array containing the texts for translation. All strings must be of the same language. The total of all texts must not exceed 10000 characters. The max number of array items is 2000.
		*/
		public void set_Texts(String value) {
			this.setInput("Texts", value);
		}


		/** 
		Set the value of the To input for this Choreo. 

		@param String - (required, string) A string representing the ISO 639-1 language code to translate the text into (e.g., es).
		*/
		public void set_To(String value) {
			this.setInput("To", value);
		}


		/** 
		Set the value of the URI input for this Choreo. 

		@param String - (optional, string) Filter results by this URI. Default: all
		*/
		public void set_URI(String value) {
			this.setInput("URI", value);
		}


		/** 
		Set the value of the User input for this Choreo. 

		@param String - (optional, multiline) Filter results by this user. Default: all
		*/
		public void set_User(String value) {
			this.setInput("User", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the TranslateArray Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class TranslateArrayResultSet extends ResultSet {
		public TranslateArrayResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "ExpiresIn" output from this Choreo execution

		@return String - (integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.
		*/
		public String get_ExpiresIn() {
			return this.getResultString("ExpiresIn");
		}
		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) Contains a new AccessToken when the ClientID and ClientSecret are provided.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Microsoft.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
