package com.temboo.Library.Microsoft.Translator;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
AddTranslation

Retrieves an array of all translations for a given text.
*/
public class AddTranslation extends Choreography {

	/**
	Create a new instance of the AddTranslation Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public AddTranslation(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Microsoft/Translator/AddTranslation"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return AddTranslationInputSet
	*/
	public AddTranslationInputSet newInputSet() {
		return new AddTranslationInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public AddTranslationResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new AddTranslationResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the AddTranslation
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class AddTranslationInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Category input for this Choreo. 

		@param String - (optional, string) A string containing the category (domain) of the translation. Defaults to "general".
		*/
		public void set_Category(String value) {
			this.setInput("Category", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the ContentType input for this Choreo. 

		@param String - (optional, string) The format of the text being translated. The supported formats are "text/plain" and "text/html".
		*/
		public void set_ContentType(String value) {
			this.setInput("ContentType", value);
		}


		/** 
		Set the value of the From input for this Choreo. 

		@param String - (required, string) A string containing the ISO 639-1 language code of the source language. Must be one of the languages returned by the method GetLanguagesForTranslate.(e.g., en).
		*/
		public void set_From(String value) {
			this.setInput("From", value);
		}


		/** 
		Set the value of the OriginalText input for this Choreo. 

		@param String - (required, string) A string containing the text to translate from. The string has a maximum length of 1000 characters.
		*/
		public void set_OriginalText(String value) {
			this.setInput("OriginalText", value);
		}


		/** 
		Set the value of the Rating input for this Choreo. 

		@param Integer - (optional, integer) An integer representing the quality rating for this string. Value between -10 and 10. Defaults to 1.
		*/
		public void set_Rating(Integer value) {
			this.setInput("Rating", value);
		}

		/** 
		Set the value of the Rating input for this Choreo as a String. 

		@param String - (optional, integer) An integer representing the quality rating for this string. Value between -10 and 10. Defaults to 1.
		*/
		public void set_Rating(String value) {
			this.setInput("Rating", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the To input for this Choreo. 

		@param String - (required, string) A string containing the lISO 639-1 language code of the target language. Must be one of the languages returned by the method GetLanguagesForTranslate (e.g., es).
		*/
		public void set_To(String value) {
			this.setInput("To", value);
		}


		/** 
		Set the value of the TranslatedText input for this Choreo. 

		@param String - (required, string) A string containing translated text in the target language. The string has a maximum length of 2000 characters.
		*/
		public void set_TranslatedText(String value) {
			this.setInput("TranslatedText", value);
		}


		/** 
		Set the value of the URI input for this Choreo. 

		@param String - (optional, string) A string containing the content location of this translation.
		*/
		public void set_URI(String value) {
			this.setInput("URI", value);
		}


		/** 
		Set the value of the User input for this Choreo. 

		@param String - (required, string) A string used to track the originator of the submission.
		*/
		public void set_User(String value) {
			this.setInput("User", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the AddTranslation Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class AddTranslationResultSet extends ResultSet {
		public AddTranslationResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "ExpiresIn" output from this Choreo execution

		@return String - (integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.
		*/
		public String get_ExpiresIn() {
			return this.getResultString("ExpiresIn");
		}
		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) Contains a new AccessToken when the ClientID and ClientSecret are provided.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Microsoft.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
