package com.temboo.Library.Labs.GetPlaces;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ByCoordinates

Retrieves information about places near a set of coordinates from multiple sources in one API call.
*/
public class ByCoordinates extends Choreography {

	/**
	Create a new instance of the ByCoordinates Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ByCoordinates(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Labs/GetPlaces/ByCoordinates"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ByCoordinatesInputSet
	*/
	public ByCoordinatesInputSet newInputSet() {
		return new ByCoordinatesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ByCoordinatesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ByCoordinatesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ByCoordinates
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ByCoordinatesInputSet extends InputSet {
		/** 
		Set the value of the APICredentials input for this Choreo. 

		@param String - (required, json) A JSON dictionary of credentials for the APIs you wish to access. See Choreo documentation for formatting examples.
		*/
		public void set_APICredentials(String value) {
			this.setInput("APICredentials", value);
		}


		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The latitude of the user's location.
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (required, decimal) The latitude of the user's location.
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) Limits the number of Foursquare venue results.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) Limits the number of Foursquare venue results.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The longitude of the user's location.
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (required, decimal) The longitude of the user's location.
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the Query input for this Choreo. 

		@param String - (optional, string) This keyword input can be used to narrow search results for Google Places and Foursquare.
		*/
		public void set_Query(String value) {
			this.setInput("Query", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Type input for this Choreo. 

		@param String - (optional, string) Filters results by type of place, such as: bar, dentist, etc. This is used to filter results for Google Places and Yelp.
		*/
		public void set_Type(String value) {
			this.setInput("Type", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ByCoordinates Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ByCoordinatesResultSet extends ResultSet {
		public ByCoordinatesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - Contains the merged results from the API responses.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
