package com.temboo.Library.Flickr.Places;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
FindByCoordinates

Returns a place ID for a given latitude, longitude and accuracy.
*/
public class FindByCoordinates extends Choreography {

	/**
	Create a new instance of the FindByCoordinates Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public FindByCoordinates(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Flickr/Places/FindByCoordinates"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return FindByCoordinatesInputSet
	*/
	public FindByCoordinatesInputSet newInputSet() {
		return new FindByCoordinatesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public FindByCoordinatesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new FindByCoordinatesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the FindByCoordinates
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class FindByCoordinatesInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Flickr (AKA the OAuth Consumer Key).
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Accuracy input for this Choreo. 

		@param Integer - (optional, integer) Recorded accuracy level of the location information. Valid range is 1-16. The default is 16.
		*/
		public void set_Accuracy(Integer value) {
			this.setInput("Accuracy", value);
		}

		/** 
		Set the value of the Accuracy input for this Choreo as a String. 

		@param String - (optional, integer) Recorded accuracy level of the location information. Valid range is 1-16. The default is 16.
		*/
		public void set_Accuracy(String value) {
			this.setInput("Accuracy", value);	
		}
		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The latitude whose valid range is -90 to 90. Anything more than 4 decimal places will be truncated.
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (required, decimal) The latitude whose valid range is -90 to 90. Anything more than 4 decimal places will be truncated.
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The longitude whose valid range is -180 to 180. Anything more than 4 decimal places will be truncated.
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (required, decimal) The longitude whose valid range is -180 to 180. Anything more than 4 decimal places will be truncated.
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) 
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the FindByCoordinates Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class FindByCoordinatesResultSet extends ResultSet {
		public FindByCoordinatesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Flickr.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
