package com.temboo.Library.Yahoo.PlaceFinder;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
FindByCoordinates

Retrieves complete location information from a specified pair of latitude and longitude coordinates.
*/
public class FindByCoordinates extends Choreography {

	/**
	Create a new instance of the FindByCoordinates Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public FindByCoordinates(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Yahoo/PlaceFinder/FindByCoordinates"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return FindByCoordinatesInputSet
	*/
	public FindByCoordinatesInputSet newInputSet() {
		return new FindByCoordinatesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public FindByCoordinatesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new FindByCoordinatesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the FindByCoordinates
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class FindByCoordinatesInputSet extends InputSet {
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (optional, string) Deprecated (retained for backward compatibility only).
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the GeocodeFlags input for this Choreo. 

		@param String - (optional, string) Affects how geocoding is performed for the request. Valid value are: A, C, L, Q, or R. See documentation for more details on this parameter.
		*/
		public void set_GeocodeFlags(String value) {
			this.setInput("GeocodeFlags", value);
		}


		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The latitude coordinate of the location you want to find (e.g., 38.898717).
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (required, decimal) The latitude coordinate of the location you want to find (e.g., 38.898717).
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The longitude coordinate of the location you want to find (e.g., -77.035974).
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (required, decimal) The longitude coordinate of the location you want to find (e.g., -77.035974).
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the ResponseFlags input for this Choreo. 

		@param String - (optional, string) Determines which data elements are returned in the response. Valid values are: B, C, D, E, G, I, J, Q, R, T, U, W, X. See documentation for details on this parameter.
		*/
		public void set_ResponseFlags(String value) {
			this.setInput("ResponseFlags", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the FindByCoordinates Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class FindByCoordinatesResultSet extends ResultSet {
		public FindByCoordinatesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "WOEID" output from this Choreo execution

		@return String - (integer) The unique Where On Earth ID of the location.
		*/
		public String get_WOEID() {
			return this.getResultString("WOEID");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Yahoo PlaceFinder.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
