package com.temboo.Library.Twilio.SMSMessages;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetLastMessageFromNumber

Retrieves the latest message received from a specified number.
*/
public class GetLastMessageFromNumber extends Choreography {

	/**
	Create a new instance of the GetLastMessageFromNumber Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetLastMessageFromNumber(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Twilio/SMSMessages/GetLastMessageFromNumber"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetLastMessageFromNumberInputSet
	*/
	public GetLastMessageFromNumberInputSet newInputSet() {
		return new GetLastMessageFromNumberInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetLastMessageFromNumberResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetLastMessageFromNumberResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetLastMessageFromNumber
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetLastMessageFromNumberInputSet extends InputSet {
		/** 
		Set the value of the AccountSID input for this Choreo. 

		@param String - (required, string) The AccountSID provided when you signed up for a Twilio account.
		*/
		public void set_AccountSID(String value) {
			this.setInput("AccountSID", value);
		}


		/** 
		Set the value of the AuthToken input for this Choreo. 

		@param String - (required, string) The authorization token provided when you signed up for a Twilio account.
		*/
		public void set_AuthToken(String value) {
			this.setInput("AuthToken", value);
		}


		/** 
		Set the value of the From input for this Choreo. 

		@param String - (required, string) The phone number to retrieve messages from.
		*/
		public void set_From(String value) {
			this.setInput("From", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml. This parameter is only valid when setting ResponseMode to "verbose".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the ResponseMode input for this Choreo. 

		@param String - (optional, string) Used to simplify the response. Valid values are: simple and verbose. When set to simple, only the message string is returned. Verbose mode returns the full object. Defaults to "simple".
		*/
		public void set_ResponseMode(String value) {
			this.setInput("ResponseMode", value);
		}


		/** 
		Set the value of the ReturnLegacyFormat input for this Choreo. 

		@param Boolean - (optional, boolean) If set to true, a verbose XML response will be formatted using the deprecated /SMS/Messages resource schema. This should only be used if you have existing code that relies on the older schema.
		*/
		public void set_ReturnLegacyFormat(Boolean value) {
			this.setInput("ReturnLegacyFormat", value);
		}

		/** 
		Set the value of the ReturnLegacyFormat input for this Choreo as a String. 

		@param String - (optional, boolean) If set to true, a verbose XML response will be formatted using the deprecated /SMS/Messages resource schema. This should only be used if you have existing code that relies on the older schema.
		*/
		public void set_ReturnLegacyFormat(String value) {
			this.setInput("ReturnLegacyFormat", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetLastMessageFromNumber Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetLastMessageFromNumberResultSet extends ResultSet {
		public GetLastMessageFromNumberResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Twilio.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
