package com.temboo.Library.UnlockPlaces;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SupportedFeatureTypes

Retrieves a list of supported feature types that can be used in searches.
*/
public class SupportedFeatureTypes extends Choreography {

	/**
	Create a new instance of the SupportedFeatureTypes Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SupportedFeatureTypes(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/UnlockPlaces/SupportedFeatureTypes"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SupportedFeatureTypesInputSet
	*/
	public SupportedFeatureTypesInputSet newInputSet() {
		return new SupportedFeatureTypesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SupportedFeatureTypesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SupportedFeatureTypesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SupportedFeatureTypes
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SupportedFeatureTypesInputSet extends InputSet {
		/** 
		Set the value of the Format input for this Choreo. 

		@param String - (optional, string) The format of the place search results. One of xml, kml, json, georss or txt. Defaults to "xml".
		*/
		public void set_Format(String value) {
			this.setInput("Format", value);
		}


		/** 
		Set the value of the Gazetteer input for this Choreo. 

		@param String - (optional, string) The place-name source to take locations from. The options are geonames, os, naturalearth or unlock which combines all the previous. Defaults to "unlock".
		*/
		public void set_Gazetteer(String value) {
			this.setInput("Gazetteer", value);
		}


		/** 
		Set the value of the MaxRows input for this Choreo. 

		@param Integer - (optional, integer) The maximum number of results to return. Defaults to 20. Cannot exceed 1000.
		*/
		public void set_MaxRows(Integer value) {
			this.setInput("MaxRows", value);
		}

		/** 
		Set the value of the MaxRows input for this Choreo as a String. 

		@param String - (optional, integer) The maximum number of results to return. Defaults to 20. Cannot exceed 1000.
		*/
		public void set_MaxRows(String value) {
			this.setInput("MaxRows", value);	
		}
		/** 
		Set the value of the StartRow input for this Choreo. 

		@param Integer - (optional, integer) The row to start results display from. Defaults to 1.
		*/
		public void set_StartRow(Integer value) {
			this.setInput("StartRow", value);
		}

		/** 
		Set the value of the StartRow input for this Choreo as a String. 

		@param String - (optional, integer) The row to start results display from. Defaults to 1.
		*/
		public void set_StartRow(String value) {
			this.setInput("StartRow", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SupportedFeatureTypes Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SupportedFeatureTypesResultSet extends ResultSet {
		public SupportedFeatureTypesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (XML) The response from Unlock. Defaults to XML based on the format input parameter.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
