package com.temboo.Library.LastFm.User;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetWeeklyAlbumChart

Retrieves an album chart for a user profile, for a given date range.
*/
public class GetWeeklyAlbumChart extends Choreography {

	/**
	Create a new instance of the GetWeeklyAlbumChart Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetWeeklyAlbumChart(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/LastFm/User/GetWeeklyAlbumChart"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetWeeklyAlbumChartInputSet
	*/
	public GetWeeklyAlbumChartInputSet newInputSet() {
		return new GetWeeklyAlbumChartInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetWeeklyAlbumChartResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetWeeklyAlbumChartResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetWeeklyAlbumChart
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetWeeklyAlbumChartInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (string) Your Last.fm API Key.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the EndTimestamp input for this Choreo. 

		@param String - (optional, date) End timestamp at which the chart should end on, in UNIX timestamp format. This must be in the UTC time zone.
		*/
		public void set_EndTimestamp(String value) {
			this.setInput("EndTimestamp", value);
		}


		/** 
		Set the value of the StartTimestamp input for this Choreo. 

		@param String - (optional, date) Beginning timestamp at which the chart should start from, in UNIX timestamp format. This must be in the UTC time zone.
		*/
		public void set_StartTimestamp(String value) {
			this.setInput("StartTimestamp", value);
		}


		/** 
		Set the value of the User input for this Choreo. 

		@param String - (string) The last.fm username to fetch the charts of.
		*/
		public void set_User(String value) {
			this.setInput("User", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetWeeklyAlbumChart Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetWeeklyAlbumChartResultSet extends ResultSet {
		public GetWeeklyAlbumChartResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (XML) The response from Last.fm.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
