package com.temboo.Library.Basecamp;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ReorderLists

Allows you to reorder To-do lists in a specified project.
*/
public class ReorderLists extends Choreography {

	/**
	Create a new instance of the ReorderLists Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ReorderLists(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Basecamp/ReorderLists"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ReorderListsInputSet
	*/
	public ReorderListsInputSet newInputSet() {
		return new ReorderListsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ReorderListsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ReorderListsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ReorderLists
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ReorderListsInputSet extends InputSet {
		/** 
		Set the value of the AccountName input for this Choreo. 

		@param String - (required, string) A valid Basecamp account name. This is the first part of the account's URL.
		*/
		public void set_AccountName(String value) {
			this.setInput("AccountName", value);
		}


		/** 
		Set the value of the FirstListID input for this Choreo. 

		@param Integer - (required, integer) The ID number for the project's first To-Do list.
		*/
		public void set_FirstListID(Integer value) {
			this.setInput("FirstListID", value);
		}

		/** 
		Set the value of the FirstListID input for this Choreo as a String. 

		@param String - (required, integer) The ID number for the project's first To-Do list.
		*/
		public void set_FirstListID(String value) {
			this.setInput("FirstListID", value);	
		}
		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) The Basecamp account password. Use the value 'X' when specifying an API Key for the Username input.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the ProjectID input for this Choreo. 

		@param Integer - (required, integer) The ID for the project associated with the to-do lists that you are reordering.
		*/
		public void set_ProjectID(Integer value) {
			this.setInput("ProjectID", value);
		}

		/** 
		Set the value of the ProjectID input for this Choreo as a String. 

		@param String - (required, integer) The ID for the project associated with the to-do lists that you are reordering.
		*/
		public void set_ProjectID(String value) {
			this.setInput("ProjectID", value);	
		}
		/** 
		Set the value of the SecondListID input for this Choreo. 

		@param Integer - (optional, integer) The ID number for the project's second To-Do list.
		*/
		public void set_SecondListID(Integer value) {
			this.setInput("SecondListID", value);
		}

		/** 
		Set the value of the SecondListID input for this Choreo as a String. 

		@param String - (optional, integer) The ID number for the project's second To-Do list.
		*/
		public void set_SecondListID(String value) {
			this.setInput("SecondListID", value);	
		}
		/** 
		Set the value of the ThirdListID input for this Choreo. 

		@param Integer - (optional, integer) The ID number for the project's third To-Do list.
		*/
		public void set_ThirdListID(Integer value) {
			this.setInput("ThirdListID", value);
		}

		/** 
		Set the value of the ThirdListID input for this Choreo as a String. 

		@param String - (optional, integer) The ID number for the project's third To-Do list.
		*/
		public void set_ThirdListID(String value) {
			this.setInput("ThirdListID", value);	
		}
		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) A Basecamp account username or API Key.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ReorderLists Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ReorderListsResultSet extends ResultSet {
		public ReorderListsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - No response is returned from Basecamp for update requests.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
