package com.temboo.Library.LastFm.User;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetFriends

Retrieves a list of the user's friends on Last.fm.
*/
public class GetFriends extends Choreography {

	/**
	Create a new instance of the GetFriends Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetFriends(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/LastFm/User/GetFriends"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetFriendsInputSet
	*/
	public GetFriendsInputSet newInputSet() {
		return new GetFriendsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetFriendsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetFriendsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetFriends
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetFriendsInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (string) Your Last.fm API Key.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) The number of results to fetch per page. Defaults to 50.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) The number of results to fetch per page. Defaults to 50.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) The page number to fetch. Defaults to 1.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) The page number to fetch. Defaults to 1.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the RecentTracks input for this Choreo. 

		@param Boolean - (optional, boolean) Whether or not to include information about friends' recent listening in the response. Defaults to 0 for false.
		*/
		public void set_RecentTracks(Boolean value) {
			this.setInput("RecentTracks", value);
		}

		/** 
		Set the value of the RecentTracks input for this Choreo as a String. 

		@param String - (optional, boolean) Whether or not to include information about friends' recent listening in the response. Defaults to 0 for false.
		*/
		public void set_RecentTracks(String value) {
			this.setInput("RecentTracks", value);	
		}
		/** 
		Set the value of the User input for this Choreo. 

		@param String - (string) The last.fm username to fetch the friends of.
		*/
		public void set_User(String value) {
			this.setInput("User", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetFriends Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetFriendsResultSet extends ResultSet {
		public GetFriendsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (XML) The response from Last.fm.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
