package com.temboo.Library.Microsoft.Translator;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Translate

Translates a text string from one language to another.
*/
public class Translate extends Choreography {

	/**
	Create a new instance of the Translate Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Translate(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Microsoft/Translator/Translate"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return TranslateInputSet
	*/
	public TranslateInputSet newInputSet() {
		return new TranslateInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public TranslateResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new TranslateResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Translate
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class TranslateInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid access token. This can be retrieved by running the GetToken Choreo. Required unless providing the ClientID and ClientSecret.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Category input for this Choreo. 

		@param String - (optional, string) A string containing the category (domain) of the translation. Defaults to "general".
		*/
		public void set_Category(String value) {
			this.setInput("Category", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret obtained when signing up for Microsoft Translator on Azure Marketplace. This is required unless providing an AccessToken.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the ContentType input for this Choreo. 

		@param String - (optional, string) The format of the text being translated. The supported formats are "text/plain" (the default) and "text/html".
		*/
		public void set_ContentType(String value) {
			this.setInput("ContentType", value);
		}


		/** 
		Set the value of the From input for this Choreo. 

		@param String - (required, string) A string representing the ISO 639-1 language code of the translation text (e.g., en).
		*/
		public void set_From(String value) {
			this.setInput("From", value);
		}


		/** 
		Set the value of the Text input for this Choreo. 

		@param String - (required, string) A string representing the text to translate. The size of the text must not exceed 10000 characters.
		*/
		public void set_Text(String value) {
			this.setInput("Text", value);
		}


		/** 
		Set the value of the To input for this Choreo. 

		@param String - (required, string) A string representing the ISO 639-1 language codee to translate the text into (e.g., es).
		*/
		public void set_To(String value) {
			this.setInput("To", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Translate Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class TranslateResultSet extends ResultSet {
		public TranslateResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "ExpiresIn" output from this Choreo execution

		@return String - (integer) Contains the number of seconds for which the access token is valid when ClientID and ClientSecret are provided.
		*/
		public String get_ExpiresIn() {
			return this.getResultString("ExpiresIn");
		}
		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) Contains a new AccessToken when the ClientID and ClientSecret are provided.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
		/** 
		Retrieve the value for the "TranslatedText" output from this Choreo execution

		@return String - (string) The translated text parsed from the Microsoft response.
		*/
		public String get_TranslatedText() {
			return this.getResultString("TranslatedText");
		}
	}
	
}
