package com.temboo.Library.Foursquare.Users;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
FindUsers

Allows a user to locate friends.
*/
public class FindUsers extends Choreography {

	/**
	Create a new instance of the FindUsers Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public FindUsers(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Foursquare/Users/FindUsers"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return FindUsersInputSet
	*/
	public FindUsersInputSet newInputSet() {
		return new FindUsersInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public FindUsersResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new FindUsersResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the FindUsers
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class FindUsersInputSet extends InputSet {
		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (conditional, string) A comma-delimited list of email addresses to look for. Must specify one of Name, Phone, Email, FacebookID, Twitter, or TwitterSource.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the FacebookID input for this Choreo. 

		@param String - (conditional, string) A comma-delimited list of Facebook ID's to look for. Must specify one of Name, Phone, Email, FacebookID, Twitter, or TwitterSource.
		*/
		public void set_FacebookID(String value) {
			this.setInput("FacebookID", value);
		}


		/** 
		Set the value of the Name input for this Choreo. 

		@param String - (conditional, string) A single string to search for in users' names. A single string to search for in users' names. Must specify one of Name, Phone, Email, FacebookID, Twitter, or TwitterSource.
		*/
		public void set_Name(String value) {
			this.setInput("Name", value);
		}


		/** 
		Set the value of the OauthToken input for this Choreo. 

		@param String - (required, string) The Foursquare API OAuth token string.
		*/
		public void set_OauthToken(String value) {
			this.setInput("OauthToken", value);
		}


		/** 
		Set the value of the Phone input for this Choreo. 

		@param String - (conditional, string) A comma-delimited list of phone numbers to look for. Must specify one of Name, Phone, Email, FacebookID, Twitter, or TwitterSource.
		*/
		public void set_Phone(String value) {
			this.setInput("Phone", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Twitter input for this Choreo. 

		@param String - (conditional, string) A comma-delimited list of Twitter handles to look for. Must specify one of Name, Phone, Email, FacebookID, Twitter, or TwitterSource.
		*/
		public void set_Twitter(String value) {
			this.setInput("Twitter", value);
		}


		/** 
		Set the value of the TwitterSource input for this Choreo. 

		@param String - (conditional, string) A single Twitter handle. Results will be users that this handle follows on Twitter who use Foursquare. Must specify one of Name, Phone, Email, FacebookID, Twitter, or TwitterSource.
		*/
		public void set_TwitterSource(String value) {
			this.setInput("TwitterSource", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the FindUsers Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class FindUsersResultSet extends ResultSet {
		public FindUsersResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Foursquare. Corresponds to the ResponseFormat input. Defaults to JSON.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
