package com.temboo.Library.Flickr.Geo;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListPhotosForLocation

Return a list of the user's photos for a specified location.
*/
public class ListPhotosForLocation extends Choreography {

	/**
	Create a new instance of the ListPhotosForLocation Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListPhotosForLocation(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Flickr/Geo/ListPhotosForLocation"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListPhotosForLocationInputSet
	*/
	public ListPhotosForLocationInputSet newInputSet() {
		return new ListPhotosForLocationInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListPhotosForLocationResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListPhotosForLocationResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListPhotosForLocation
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListPhotosForLocationInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Flickr (AKA the OAuth Consumer Key).
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the APISecret input for this Choreo. 

		@param String - (required, string) The API Secret provided by Flickr (AKA the OAuth Consumer Secret).
		*/
		public void set_APISecret(String value) {
			this.setInput("APISecret", value);
		}


		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AccessTokenSecret input for this Choreo. 

		@param String - (required, string) The Access Token Secret retrieved during the OAuth process.
		*/
		public void set_AccessTokenSecret(String value) {
			this.setInput("AccessTokenSecret", value);
		}


		/** 
		Set the value of the Accuracy input for this Choreo. 

		@param Integer - (optional, integer) Recorded accuracy level of the location information. Current range is 1-16. Defaults to 16 if not specified.
		*/
		public void set_Accuracy(Integer value) {
			this.setInput("Accuracy", value);
		}

		/** 
		Set the value of the Accuracy input for this Choreo as a String. 

		@param String - (optional, integer) Recorded accuracy level of the location information. Current range is 1-16. Defaults to 16 if not specified.
		*/
		public void set_Accuracy(String value) {
			this.setInput("Accuracy", value);	
		}
		/** 
		Set the value of the Extras input for this Choreo. 

		@param String - (optional, string) A comma-delimited list of extra information to retrieve for each returned record. See Choreo documentation for accepted values.
		*/
		public void set_Extras(String value) {
			this.setInput("Extras", value);
		}


		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The latitude whose valid range is -90 to 90. Anything more than 6 decimal places will be truncated.
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (required, decimal) The latitude whose valid range is -90 to 90. Anything more than 6 decimal places will be truncated.
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (required, decimal) The longitude whose valid range is -180 to 180. Anything more than 6 decimal places will be truncated.
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (required, decimal) The longitude whose valid range is -180 to 180. Anything more than 6 decimal places will be truncated.
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) The page of results to return. Used for paging through many results. Defaults to 1.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) The page of results to return. Used for paging through many results. Defaults to 1.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the PerPage input for this Choreo. 

		@param Integer - (optional, integer) Number of photos to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.
		*/
		public void set_PerPage(Integer value) {
			this.setInput("PerPage", value);
		}

		/** 
		Set the value of the PerPage input for this Choreo as a String. 

		@param String - (optional, integer) Number of photos to return per page. If this argument is omitted, it defaults to 100. The maximum allowed value is 500.
		*/
		public void set_PerPage(String value) {
			this.setInput("PerPage", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: xml and json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListPhotosForLocation Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListPhotosForLocationResultSet extends ResultSet {
		public ListPhotosForLocationResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Flickr.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
