package com.temboo.Library.eBay.Trading;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetCategoryFeatures

Returns information that describes the feature and value settings that apply to the set of eBay categories.
*/
public class GetCategoryFeatures extends Choreography {

	/**
	Create a new instance of the GetCategoryFeatures Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetCategoryFeatures(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/eBay/Trading/GetCategoryFeatures"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetCategoryFeaturesInputSet
	*/
	public GetCategoryFeaturesInputSet newInputSet() {
		return new GetCategoryFeaturesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetCategoryFeaturesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetCategoryFeaturesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetCategoryFeatures
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetCategoryFeaturesInputSet extends InputSet {
		/** 
		Set the value of the AllFeaturesForCategory input for this Choreo. 

		@param Boolean - (optional, boolean) A flag used to view all of the feature settings for a specific category.
		*/
		public void set_AllFeaturesForCategory(Boolean value) {
			this.setInput("AllFeaturesForCategory", value);
		}

		/** 
		Set the value of the AllFeaturesForCategory input for this Choreo as a String. 

		@param String - (optional, boolean) A flag used to view all of the feature settings for a specific category.
		*/
		public void set_AllFeaturesForCategory(String value) {
			this.setInput("AllFeaturesForCategory", value);	
		}
		/** 
		Set the value of the CategoryID input for this Choreo. 

		@param String - (optional, string) The ID of the category for which you want to retrieve the feature settings.
		*/
		public void set_CategoryID(String value) {
			this.setInput("CategoryID", value);
		}


		/** 
		Set the value of the DetailLevel input for this Choreo. 

		@param String - (optional, string) The level of detail to return in the response. Valid values are: ReturnAll and ReturnSummary.
		*/
		public void set_DetailLevel(String value) {
			this.setInput("DetailLevel", value);
		}


		/** 
		Set the value of the FeatureID input for this Choreo. 

		@param String - (optional, string) Use this field if you want to know if specific features are enabled at the site or root category level. Multiple FeatureIDs can be specified in a comma-separated list.
		*/
		public void set_FeatureID(String value) {
			this.setInput("FeatureID", value);
		}


		/** 
		Set the value of the LevelLimit input for this Choreo. 

		@param String - (optional, string) Indicates the maximum depth of the category hierarchy to retrieve, where the top-level categories (meta-categories) are at level 1. Default is 0.
		*/
		public void set_LevelLimit(String value) {
			this.setInput("LevelLimit", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SandboxMode input for this Choreo. 

		@param Boolean - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(Boolean value) {
			this.setInput("SandboxMode", value);
		}

		/** 
		Set the value of the SandboxMode input for this Choreo as a String. 

		@param String - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(String value) {
			this.setInput("SandboxMode", value);	
		}
		/** 
		Set the value of the SiteID input for this Choreo. 

		@param String - (optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
		*/
		public void set_SiteID(String value) {
			this.setInput("SiteID", value);
		}


		/** 
		Set the value of the UserToken input for this Choreo. 

		@param String - (required, string) A valid eBay Auth Token.
		*/
		public void set_UserToken(String value) {
			this.setInput("UserToken", value);
		}


		/** 
		Set the value of the ViewAllNodes input for this Choreo. 

		@param Boolean - (optional, boolean) Indicates that eBay should return the site defaults along with all the categories that override the feature settings they inherit. DetailLevel must be 'ReturnAll' when setting this parameter to true.
		*/
		public void set_ViewAllNodes(Boolean value) {
			this.setInput("ViewAllNodes", value);
		}

		/** 
		Set the value of the ViewAllNodes input for this Choreo as a String. 

		@param String - (optional, boolean) Indicates that eBay should return the site defaults along with all the categories that override the feature settings they inherit. DetailLevel must be 'ReturnAll' when setting this parameter to true.
		*/
		public void set_ViewAllNodes(String value) {
			this.setInput("ViewAllNodes", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetCategoryFeatures Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetCategoryFeaturesResultSet extends ResultSet {
		public GetCategoryFeaturesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from eBay.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
