package com.temboo.Library.eBay.Shopping;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetShippingCosts

Retrieves shipping costs for an item.
*/
public class GetShippingCosts extends Choreography {

	/**
	Create a new instance of the GetShippingCosts Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetShippingCosts(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/eBay/Shopping/GetShippingCosts"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetShippingCostsInputSet
	*/
	public GetShippingCostsInputSet newInputSet() {
		return new GetShippingCostsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetShippingCostsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetShippingCostsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetShippingCosts
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetShippingCostsInputSet extends InputSet {
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (required, string) The unique identifier for the application.
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the DestinationCountryCode input for this Choreo. 

		@param String - (conditional, string) The shipment destination country code.
		*/
		public void set_DestinationCountryCode(String value) {
			this.setInput("DestinationCountryCode", value);
		}


		/** 
		Set the value of the DestinationPostalCode input for this Choreo. 

		@param String - (conditional, string) The shipment destination postal code.
		*/
		public void set_DestinationPostalCode(String value) {
			this.setInput("DestinationPostalCode", value);
		}


		/** 
		Set the value of the IncludeDetails input for this Choreo. 

		@param Boolean - (conditional, boolean) Indicates whether to return the ShippingDetails container in the response.
		*/
		public void set_IncludeDetails(Boolean value) {
			this.setInput("IncludeDetails", value);
		}

		/** 
		Set the value of the IncludeDetails input for this Choreo as a String. 

		@param String - (conditional, boolean) Indicates whether to return the ShippingDetails container in the response.
		*/
		public void set_IncludeDetails(String value) {
			this.setInput("IncludeDetails", value);	
		}
		/** 
		Set the value of the ItemID input for this Choreo. 

		@param String - (required, string) The ID of the item to get shipping costs for.
		*/
		public void set_ItemID(String value) {
			this.setInput("ItemID", value);
		}


		/** 
		Set the value of the QuantitySold input for this Choreo. 

		@param String - (optional, string) The quantity of items being shipped.
		*/
		public void set_QuantitySold(String value) {
			this.setInput("QuantitySold", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SandboxMode input for this Choreo. 

		@param Boolean - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(Boolean value) {
			this.setInput("SandboxMode", value);
		}

		/** 
		Set the value of the SandboxMode input for this Choreo as a String. 

		@param String - (conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.
		*/
		public void set_SandboxMode(String value) {
			this.setInput("SandboxMode", value);	
		}
		/** 
		Set the value of the SiteID input for this Choreo. 

		@param String - (optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.
		*/
		public void set_SiteID(String value) {
			this.setInput("SiteID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetShippingCosts Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetShippingCostsResultSet extends ResultSet {
		public GetShippingCostsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from eBay.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
