package com.temboo.Library.Genability.TariffData;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetZipCodeDetails

Returns the details for a given zip code.
*/
public class GetZipCodeDetails extends Choreography {

	/**
	Create a new instance of the GetZipCodeDetails Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetZipCodeDetails(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Genability/TariffData/GetZipCodeDetails"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetZipCodeDetailsInputSet
	*/
	public GetZipCodeDetailsInputSet newInputSet() {
		return new GetZipCodeDetailsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetZipCodeDetailsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetZipCodeDetailsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetZipCodeDetails
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetZipCodeDetailsInputSet extends InputSet {
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (conditional, string) The App ID provided by Genability.
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the AppKey input for this Choreo. 

		@param String - (required, string) The App Key provided by Genability.
		*/
		public void set_AppKey(String value) {
			this.setInput("AppKey", value);
		}


		/** 
		Set the value of the PageCount input for this Choreo. 

		@param Integer - (optional, integer) The number of results to return. Defaults to 25.
		*/
		public void set_PageCount(Integer value) {
			this.setInput("PageCount", value);
		}

		/** 
		Set the value of the PageCount input for this Choreo as a String. 

		@param String - (optional, integer) The number of results to return. Defaults to 25.
		*/
		public void set_PageCount(String value) {
			this.setInput("PageCount", value);	
		}
		/** 
		Set the value of the PageStart input for this Choreo. 

		@param Integer - (optional, integer) The page number to begin the result set from. Defaults to 1.
		*/
		public void set_PageStart(Integer value) {
			this.setInput("PageStart", value);
		}

		/** 
		Set the value of the PageStart input for this Choreo as a String. 

		@param String - (optional, integer) The page number to begin the result set from. Defaults to 1.
		*/
		public void set_PageStart(String value) {
			this.setInput("PageStart", value);	
		}
		/** 
		Set the value of the ZipCode input for this Choreo. 

		@param String - (optional, string) A zip code to search with.
		*/
		public void set_ZipCode(String value) {
			this.setInput("ZipCode", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetZipCodeDetails Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetZipCodeDetailsResultSet extends ResultSet {
		public GetZipCodeDetailsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Genability.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
