package com.temboo.Library.USPS.DeliveryInformationAPI;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
TrackConfirmFields

Track a package sent via USPS and return tracking information with details in separate XML tags.
*/
public class TrackConfirmFields extends Choreography {

	/**
	Create a new instance of the TrackConfirmFields Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public TrackConfirmFields(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/USPS/DeliveryInformationAPI/TrackConfirmFields"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return TrackConfirmFieldsInputSet
	*/
	public TrackConfirmFieldsInputSet newInputSet() {
		return new TrackConfirmFieldsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public TrackConfirmFieldsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new TrackConfirmFieldsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the TrackConfirmFields
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class TrackConfirmFieldsInputSet extends InputSet {
		/** 
		Set the value of the Endpoint input for this Choreo. 

		@param String - (optional, string) If you are accessing the production server, set to 'production'. Defaults to 'testing' which indicates that you are using the sandbox.
		*/
		public void set_Endpoint(String value) {
			this.setInput("Endpoint", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) The password assigned by USPS
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the TrackID input for this Choreo. 

		@param String - (required, string) The tracking number.  Can be alphanumeric characters.
		*/
		public void set_TrackID(String value) {
			this.setInput("TrackID", value);
		}


		/** 
		Set the value of the UserId input for this Choreo. 

		@param String - (required, string) Alphanumeric ID assigned by USPS
		*/
		public void set_UserId(String value) {
			this.setInput("UserId", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the TrackConfirmFields Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class TrackConfirmFieldsResultSet extends ResultSet {
		public TrackConfirmFieldsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from USPS Web Service
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
